<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Deopsits_model extends CRM_Model
{
    
    function __construct()
    {
        parent::__construct();
    }

    public function get()
    {
        // echo "<pre>";

        $this->db->select('tbldeopsits.id,tbldeopsits.date,tbldeopsits.amount,tblbanks.bank,tblbankbranches.branchname,tblbanksaccount.account_number,tblbanksaccount.account_type,tblcurrencies.name as currency');
        $this->db->from('tbldeopsits');
        $this->db->join('tblbanks', 'tblbanks.bankid = tbldeopsits.bank_id');
        $this->db->join('tblbankbranches', 'tblbankbranches.bankbranchid = tbldeopsits.branch_id');
        $this->db->join('tblbanksaccount', 'tblbanksaccount.id = tbldeopsits.account_id');
        $this->db->join('tblcurrencies', 'tblcurrencies.id = tbldeopsits.currency');
        $records = $this->db->get()->result();
        // print_r($this->db->last_query());
        // print_r($records);
        // die;
        
        return $records;
    }

    public function get_banks(){
        return $this->db->order_by('bank', 'ASC')->get('tblbanks')->result();  
    }
    public function get_bank($bankid){
        return $this->db->where('bankid',$bankid)->order_by('bank','ASC')->get('tblbanks')->row(); 
    }

    public function get_branch()
    {
        $branch = $this->db->get('tblbankbranches')->result();
        return $branch;
    }
	public function get_branch_selected($bankbranchid)
    {
        return $this->db->where('bankbranchid',$bankbranchid)->get('tblbankbranches')->row(); 
    }
	public function get_account_selected($account)
    {
        return $this->db->where('id',$account)->get('tblbanksaccount')->row(); 
    }
    public function get_accounts($branch_id)
    {
        return $this->db->where('branch',$branch_id)->order_by('id','ASC')->get('tblbanksaccount')->result(); 
    }

    public function get_account()
    {
        return $this->db->order_by('id','ASC')->get('tblbanksaccount')->result(); 
    }

    function get_prev_groups2($id=0) 
    {
       
        //$this->db->where('type', 'Ledger');
        $this->db->where('parent', $id);
        $this->db->order_by('name', 'ASC');
        $tabl= $this->db->get('tblledgergroups')->result();
        $subgoups=array();
        foreach($tabl as $ta)
        {           
            
            $ta->subgroups= $this->get_prev_groups2($ta->id);
            $ta->exists=false;
            foreach($ta->subgroups as $gr )         
            if(($gr->type!="Group")||($gr->exists))
            {
                $ta->exists=true;
                break;
                
            }
            if(($ta->type!="Group")||($ta->exists))
            {
                $ta->exists=true;
                $subgoups[]=$ta;
                
            }
            
            
        }
        
        return $subgoups;
    }

    public function get_ledger_records($ledger_id)
    {
        // $this->db->select('tblvoucherlines.ledger,tblvoucherlines.id as voucherlinesid,tblvoucherlines.vchid,tblvoucher.invoiceid,tblcurrencies.name as currencies,tblvoucherlines.amount as paymentamount,tblinvoicepaymentrecords.id as paymentid,tblinvoicepaymentrecords.date,tblclients.accountname,tblinvoicepaymentsmodes.name,tblinvoicepaymentrecords.transactionid');
        $this->db->select('tblinvoicepaymentrecords.date,tblinvoicepaymentrecords.id as transactionid,tblinvoicepaymentrecords.receipt_number as receipt_number,tblinvoicepaymentsmodes.name as paymenttype,tblinvoices.currency,tblcurrencies.name as currencyname,tblinvoicepaymentrecords.amount,tblclients.accountname');
        $this->db->from('tblinvoicepaymentrecords');
        // $this->db->join('tblvoucher', 'tblvoucher.vchid = tblvoucherlines.vchid');
        $this->db->join('tblinvoices', 'tblinvoices.id = tblinvoicepaymentrecords.invoiceid');
        $this->db->join('tblclients', 'tblclients.userid = tblinvoices.clientid');
        $this->db->join('tblcurrencies', 'tblcurrencies.id = tblinvoices.currency');
        // $this->db->join('tblinvoicepaymentrecords', 'tblinvoicepaymentrecords.invoiceid = tblinvoices.id');
        // $this->db->join('tblinvoicepaymentrecords', 'tblinvoicepaymentrecords.amount = tblvoucherlines.amount');
        $this->db->join('tblinvoicepaymentsmodes', 'tblinvoicepaymentsmodes.id = tblinvoicepaymentrecords.paymentmode');
        // $this->db->where('tblvoucherlines.ledger',$ledger_id);
        $this->db->where('tblinvoicepaymentrecords.deopsits',0);
        // $this->db->group_by('paymentid');
        // $this->db->group_by('voucherlinesid');
        $this->db->order_by('transactionid','ASC');
        $records = $this->db->get()->result();
      //  $this->db->last_query();
        // die;
        return $records;
        // print_r($records);
        // die;
    }

    public function add($data)
    {
        
        // echo "<pre>";
        $this->db->select('tblbanksaccount.*');
        $this->db->from('tblbanksaccount');
        $this->db->where('tblbanksaccount.id',$data['account_id']);
        $this->db->where('tblbanksaccount.bank',$data['bank_id']);
        $this->db->where('tblbanksaccount.branch',$data['branch_id']);
        $bankaccount = $this->db->get()->row();

        $balance = $bankaccount->balance + str_replace(',','', $data['selected']);
        $available = $bankaccount->available + str_replace(',','', $data['selected']);
		
	
        $updatebankaccount =array(
                                    'balance'=>$balance,
                                    'available'=>$available,
                                );
        $this->db->where('id', $bankaccount->id);
        $this->db->update('tblbanksaccount', $updatebankaccount);

        // echo "<pre>";
        // print_r($data);
        // die;
		$amount=0;
        $adddeopsits = array();
        foreach ($data['deopsits'] as $key => $deopsit) 
        {
           
            $this->db->select('tblinvoicepaymentrecords.date as date,tblinvoicepaymentrecords.id as transactionid,tblclients.userid as customer,tblinvoicepaymentsmodes.id as payment_type,tblcurrencies.id as currency,tblinvoicepaymentrecords.amount as amount,tblinvoicepaymentrecords.voucherlines_id');
            $this->db->from('tblinvoicepaymentrecords');
            $this->db->join('tblinvoices', 'tblinvoices.id = tblinvoicepaymentrecords.invoiceid');
            $this->db->join('tblclients', 'tblclients.userid = tblinvoices.clientid');
            $this->db->join('tblcurrencies', 'tblcurrencies.id = tblinvoices.currency');
            $this->db->join('tblinvoicepaymentsmodes', 'tblinvoicepaymentsmodes.id = tblinvoicepaymentrecords.paymentmode');
            // $this->db->join('tblvoucher', 'tblvoucher.vchid = tblvoucherlines.vchid');
            // $this->db->join('tblinvoicepaymentsmodes', 'tblinvoicepaymentsmodes.id = tblinvoicepaymentrecords.paymentmode');
            // $this->db->join('tblcurrencies', 'tblcurrencies.id = tblvoucher.currency');
            // $this->db->join('tblinvoices', 'tblinvoices.id = tblvoucher.invoiceid');
            $this->db->where('tblinvoicepaymentrecords.id',$deopsit);
            // $this->db->group_by('voucherlinesid');
            $records = $this->db->get()->row();

         /*   $adddeopsits[] = array(
                            'bank_id' => $data['bank_id'],
                            'branch_id' => $data['branch_id'],
                            'account_id' => $data['account_id'],
                            'note' => $data['note'],
                            'ledger_id' => $data['ledger_id'],
                            'date' => $records->date,
                            'transactionid' => $records->transactionid,
                            'customer' => $records->customer,
                            'payment_type' => $records->payment_type,
                            'transaction_type' => 'Payment Receipt',
                            'currency' => $records->currency,
                            'amount' => $records->amount,
                            'voucherlinesid' => $records->voucherlines_id,
                            'reconciled' => 0,
                        );*/

				$amount+=  $records->amount;
				
                $updatepaymentrecords =array(
                                    'deopsits'=>1,
                                );
                $this->db->where('id', $deopsit);
                $this->db->update('tblinvoicepaymentrecords', $updatepaymentrecords);



                $this->load->model('settings_model');
                $default_options = $this->settings_model->getOptions();
                

            

            $updatevoucherlines =array(
                                    'ledger'=>$bankaccount->ledger,
                                    'description'=> 'Account Deopsit',
                                );
            $this->db->where('id', $records->voucherlines_id);
            $this->db->update('tblvoucherlines', $updatevoucherlines);
        }
		 $adddeopsits = array(
                            'bank_id' => $data['bank_id'],
                            'branch_id' => $data['branch_id'],
                            'account_id' => $data['account_id'],
                            'note' => $data['note'],
                            'ledger_id' => $data['ledger_id'],
                            'date' => $records->date,
                            'transactionid' => $records->transactionid,
                            'customer' => $records->customer,
                            'payment_type' => $records->payment_type,
                            'transaction_type' => 'Payment Receipt',
                            'currency' => $records->currency,
                            'amount' => $amount,
                            'voucherlinesid' => $records->voucherlines_id,
                            'reconciled' => 0,
                        );
        $this->db->insert('tbldeopsits',$adddeopsits);

        return true;
        // print_r($adddeopsits);
        // die;
    }

    public function get_deopsits($id)
    {
        $this->db->select('tbldeopsits.*,tblclients.accountname,tblinvoicepaymentsmodes.name as payment_type,tblcurrencies.name currency');
        $this->db->from('tbldeopsits');
        $this->db->join('tblclients', 'tblclients.userid = tbldeopsits.customer');
        $this->db->join('tblinvoicepaymentsmodes', 'tblinvoicepaymentsmodes.id = tbldeopsits.payment_type');
        $this->db->join('tblcurrencies', 'tblcurrencies.id = tbldeopsits.currency');
       
        $this->db->where('tbldeopsits.id', $id);
        $record = $this->db->get()->row();
		
        return $record;
    }

    public function update($id,$data)
    {
        // echo "<pre>";
        // print_r($data);
        // die;
        $this->db->select('tblbanksaccount.*');
        $this->db->from('tblbanksaccount');
        $this->db->where('tblbanksaccount.id',$data['account']);
        $this->db->where('tblbanksaccount.branch',$data['branch']);
        $bankaccount_reduce = $this->db->get()->row();

        $balance_reduce = $bankaccount_reduce->balance - $data['selected'];
        $available_reduce = $bankaccount_reduce->available - $data['selected'];

        $updatebankaccount_reduce =array(
                                    'balance'=>$balance_reduce,
                                    'available'=>$available_reduce,
                                );
        $this->db->where('id', $bankaccount_reduce->id);
        $this->db->update('tblbanksaccount', $updatebankaccount_reduce);


        $this->db->select('tblbanksaccount.*');
        $this->db->from('tblbanksaccount');
        $this->db->where('tblbanksaccount.id',$data['account_id']);
        $this->db->where('tblbanksaccount.bank',$data['bank_id']);
        $this->db->where('tblbanksaccount.branch',$data['branch_id']);
        $bankaccount = $this->db->get()->row();


        $balance = $bankaccount->balance + $data['selected'];
        $available = $bankaccount->available + $data['selected'];

        $updatebankaccount =array(
                                    'balance'=>$balance,
                                    'available'=>$available,
                                );
        $this->db->where('id', $bankaccount->id);
        $this->db->update('tblbanksaccount', $updatebankaccount);

        $updatevoucherlines =array(
                                    'ledger'=>$bankaccount->ledger,
                                    'description'=> 'Account Deopsit',
                                );
        $this->db->where('id', $data['voucherlinesid']);
        $this->db->update('tblvoucherlines', $updatevoucherlines);
        // print_r($this->db->last_query());
        // die;

        $updatedeopsits = array(
                            'bank_id' => $data['bank_id'],
                            'branch_id' => $data['branch_id'],
                            'account_id' => $data['account_id'],
                            'note' => $data['note'],
                        );

        $this->db->where('id', $id);
        $this->db->update('tbldeopsits', $updatedeopsits);


        
        return $id;
        // print_r($adddeopsits);
        // die;


    }
  public function delete($id)
    {
     //   do_action('before_bill_deleted', $id);

		
		
		$this->db->select('tbldeopsits.*');
        $this->db->from('tbldeopsits');
        $this->db->where('tbldeopsits.id',$id);
        $bankaccount = $this->db->get()->row();
		
		
        $this->db->select('tblbanksaccount.*');
        $this->db->from('tblbanksaccount');
        $this->db->where('tblbanksaccount.id',$bankaccount->account_id);
        $this->db->where('tblbanksaccount.bank',$bankaccount->bank_id);
        $this->db->where('tblbanksaccount.branch',$bankaccount->branch_id);
        $bankaccount1 = $this->db->get()->row();

        $balance = $bankaccount1->balance - str_replace(',','', $bankaccount->amount);
        $available = $bankaccount1->available - str_replace(',','', $bankaccount->amount);
        $updatebankaccount =array(
                                    'balance'=>$balance,
                                    'available'=>$available,
                                );
								
						
        $this->db->where('id', $bankaccount1->id);
        $this->db->update('tblbanksaccount', $updatebankaccount);
					
		$this->db->where('id', $id);
        $this->db->delete('tbldeopsits');	
		
        return true;
    }
}
