<?php ob_start();
defined('BASEPATH') OR exit('No direct script access allowed');

class Bills_model extends CRM_Model
{
    function __construct()
    {
        parent::__construct();
    }

    /**
     * Get estimate by id
     * @param  mixed $id
     * @return array
     */

    public function get_bill($id)
    {
        
        $this->db->select('tblbills.*,tblsuppliers.*,tblcountries.short_name,tblpurchaseorders.id as poid,tblpurchaseorders.number as ponumber,tblgrns.grnid,tblgrns.number as grnnumber,tblrfqsqoutes.id as rfqid,tblrfqsqoutes.number as rfqnumber');
        $this->db->from('tblbills');
        $this->db->join('tblsuppliers', 'tblsuppliers.userid = tblbills.supplierid', 'left');
        $this->db->join('tblpurchaseorders', 'tblpurchaseorders.id = tblbills.po_id', 'left');
        $this->db->join('tblgrns', 'tblgrns.po_id = tblbills.po_id', 'left');
        $this->db->join('tblrfqsqoutes', 'tblrfqsqoutes.id = tblpurchaseorders.rfq_id', 'left');
        $this->db->join('tblcountries', 'tblcountries.country_id = tblsuppliers.country', 'left');
        $this->db->where('tblbills.billid', $id);
        return $bill = $this->db->get()->row();
    }

    public function getbill_items($id)
    {
        $this->db->select('tblbillitems.*,tbltaxes.taxrate');
        $this->db->from('tblbillitems');
        $this->db->join('tbltaxes', 'tbltaxes.id = tblbillitems.taxid', 'left');
        $this->db->where('tblbillitems.bill_id', $id);
        // $this->db->order_by('item_order', 'asc');
        return $this->db->get()->result_array();
    }

    public function getsupplierbill_items($id)
    {
        $this->db->select('tblsupplierbill_item.*,tblledgergroups.name');
        $this->db->from('tblsupplierbill_item');
        $this->db->join('tblledgergroups', 'tblledgergroups.id = tblsupplierbill_item.ledger_id', 'left');
        $this->db->where('tblsupplierbill_item.bill_id', $id);
        // $this->db->order_by('item_order', 'asc');
        return $this->db->get()->result();
    }

    public function getbill_po($id)
    {
        $this->db->select('*');
        $this->db->from('tblpurchaseorders');
        $this->db->where('id', $id);
        return $this->db->get()->row();
    }

    public function getsupplier($id)
    {
        $this->db->select('tblbills.billid,tblbills.supplierid,tblbills.total,tblsuppliers.userid');
        $this->db->from('tblbills');
        $this->db->join('tblsuppliers', 'tblsuppliers.userid = tblbills.supplierid', 'left');
        
        $this->db->where('tblbills.billid', $id);
        return $bill = $this->db->get()->row();
    } 

    public function get_po_item($po_id)
    {
        $this->db->select('tblpurchaseorderitems.*');
        $this->db->from('tblpurchaseorderitems');
        $this->db->where('orderid',$po_id);
        return $items = $this->db->get()->result();
        // echo "<pre>";
        // print_r($items);
        // die;
    }

    public function get_po($po_id)
    {
        $this->db->select('tblpurchaseorders.*');
        $this->db->from('tblpurchaseorders');
        $this->db->where('id',$po_id);
        return $items = $this->db->get()->row();
        // echo "<pre>";
        // print_r($items);
        // die;
    }

    function get_prev_groups2($id=0) {
       
        //$this->db->where('type', 'Ledger');
        $this->db->where('parent', $id);
        $this->db->order_by('name', 'ASC');
        $tabl= $this->db->get('tblledgergroups')->result();
        $subgoups=array();
        foreach($tabl as $ta)
        {           
            
            $ta->subgroups= $this->get_prev_groups2($ta->id);
            $ta->exists=false;
            foreach($ta->subgroups as $gr )         
            // if(($gr->type =="Group")||($gr->exists))
            // {

            //     $ta->exists=true;
            //     break;
                
            // }
            // if(($ta->type !="Group")||($ta->exists))
            // {
                $ta->exists=true;
                $subgoups[]=$ta;
                
            // }
            
            
        }
        
        return $subgoups;
    }

    public function get($id = '',$customerid = '')
    {
        
        $this->db->select('*,tblcurrencies.id as currencyid, tblbills.billid as id, tblcurrencies.name as currency_name');
        $this->db->from('tblbills');
        $this->db->join('tblcurrencies', 'tblcurrencies.id = tblbills.currency', 'left');

        if (is_numeric($id)) {
        
            $this->db->where('tblbills.billid', $id);
            $bill = $this->db->get()->row();

            if ($bill) {

                $bill->items  = $this->get_bill_items($id);
               
            }
            return $bill;
        }
        
        return $this->db->get()->result_array();
    }
    public function get_items($id){
       return  $this->get_bill_items($id);
    }
//
    public function get_supplier(){
        $this->db->order_by('supplier', 'ASC');      
        return $this->db->get('tblsuppliers')->result();
    }
    public function get_contact($id){
        $this->db->where('userid', $id);
         return $this->db->get('tblsuppliercontacts')->row(); 
    }

    function change_quote_status($status,$id){
       $this->db->where('id', $id);
        return $this->db->update('tblestimates', array('status' => $status));
    }


    /**
     * Get all estimate items
     * @param  mixed $id estimateid
     * @return array
     */

    public function get_bill_items($id)
    {
        $this->db->select('tblbillitems.*');
        $this->db->from('tblbillitems');
        $this->db->where('tblbillitems.bill_id', $id);
        // $this->db->order_by('item_order', 'asc');
        return $this->db->get()->result();
    }

    public function get_supplier_bill_items($id)
    {
        $this->db->select('tblsupplierbill_item.*');
        $this->db->from('tblsupplierbill_item');
        $this->db->where('tblsupplierbill_item.bill_id', $id);
        // $this->db->order_by('item_order', 'asc');
        return $this->db->get()->result();
    }

    public function get_ledger($id)
    {
        $this->db->select('*');
        $this->db->from('tblledgergroups');
        $this->db->where('tblledgergroups.id', $id);
        // $this->db->order_by('item_order', 'asc');
        return $this->db->get()->row();
    }

    /**
     * Insert new estimate to database
     * @param array $data invoiec data
     * @return mixed - false if not insert, estimate ID if succes
     */
    public function add11($data = '')
    {
        // echo "<pre>";
        // print_r($data);
        // die;
        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);

        $unsetters = array(
            'currency_symbol',
            // 'ledger',
            'amount',
            'comment',
            // 'description',

        );

        foreach ($unsetters as $unseter) {
            if (isset($data[$unseter])) {
                unset($data[$unseter]);
            }
        }

        

        // $items = array();
        // if (isset($data['items'])) {
        //     $items = $data['items'];
        //     unset($data['items']);
        // }

        $newitems = array();
        if (isset($data['newitems'])) {
            $newitems = $data['newitems'];
            unset($data['newitems']);
        }



        $data['bill_date'] = to_sql_date($data['bill_date']);
        $data['due_date'] = to_sql_date($data['due_date']);
        
        $data['note']       = nl2br($data['note']);
        $data['datecreated'] = date('Y-m-d H:i:s');
        $data['addedfrom']   = get_staff_user_id();

    
        $newdata = array(
            'supplierid'=> $data['supplierid'],
            'bill_number'=> $data['bill_number'],
            'refrence'=> $data['refrence'],
            'bill_date'=> $data['bill_date'],
            'due_date'=> $data['due_date'],
            'currency'=> $data['currency'],
            'recurring_bill' => $data['recurring_bill'],
            'payment_terms'=>$data['payment_terms'],
            'contact'=>$data['contact'],
            'status'=>$data['status'],
            'total'=>$data['total'],
            'note' => $data['note'],
            'datecreated' => $data['datecreated'],
            'addedfrom' => $data['addedfrom'],
            'subtotal' => $data['subtotal'],
            'discount_total' => $data['discount_total'],
            'adjustment' => $data['adjustment'],

        );

        $bill = $this->db->insert('tblbills', $newdata);
        $bill_id = $this->db->insert_id(); 


        $bill_item = array();
        foreach ($data['sku'] as $key => $value) {

            $bill_item[] = array(
                            'sku' => $value,
                            'bill_id' => $bill_id,
                            'oursku' => $data['oursku'][$key],
                            'description' => $data['description'][$key],
                            'qty' => $data['qty'][$key],
                            'rate' => $data['rate'][$key],
                            'disc' => $data['disc'][$key],
                            'taxid' => $data['taxid'][$key],
                            'ledger'=>$data['ledger'][$key],
                            );
        }

        $this->db->insert_batch('tblbillitems',$bill_item);
        // echo "<pre>";
        // print_r($bill_item);
        // die;

        if (count($newitems) > 0) {
            foreach ($newitems as $key => $item) {
                $this->db->insert('tblbillitems',array(
                       'sku'=>$item['sku'],
                        'bill_id'=>$bill_id,
                        'ledger'=>$item['ledger'],
                        'oursku'=>$item['oursku'],
                        'description'=>$item['description'],
                        'qty'=>$item['qty'],
                        'rate'=>$item['rate'],
                        'disc'=>$item['disc'],
                        'taxid'=>$item['taxid'],
                    ));

                $new_item_added = $this->db->insert_id();
                // if ($new_item_added) {
                //     $this->log_estimate_activity($id,'added new item <b>' . $item['description'] . '</b>');
                //     $affectedRows++;
                // }
            }
        }

        $this->db->select_max('voucher');
        $this->db->where('vchtype', '8');
        $voucher = $this->db->get('tblvoucher')->row()->voucher;

        if($voucher){
            $voucher = ++$voucher;
        }else{
         $voucher ='BL0001';
        }

        $this->db->insert('tblvoucher',array(
                 
                        'voucher'=>$voucher,
                        'vchtype'=>'8',
                        'invoiceid'=>$bill_id,
                        'docdate'=>$data['bill_date'],
                        'trxdate'=>$data['due_date'],
                        'created_by'=> get_staff_user_id(),
                        'currency'=>'3',
                   
                        ));
        $voucherid = $this->db->insert_id();

        $this->load->model('settings_model');
        $default_options = $this->settings_model->getOptions();

        $this->db->insert('tblvoucherlines',array(
                            // 'ledger'=>$ledger_id, //22
                            'ledger'=>$default_options['supplier_discount'], 
                            'vchid'=>$voucherid,
                            'amount'=>$data['discount_total'],
                            'description'=> 'Supplier Discounts',
                            'refrence'=>'',
                            'invoiceid'=>$data['bill_number'],
                            'poid'=>'',
                            'item_order'=>'0',
                            'amount_type'=>1 // 0 debit ; 1 credit
                            ));

        $this->db->insert('tblvoucherlines',array(
                            // 'ledger'=>$ledger_id, //22
                            'ledger'=>$default_options['input_vat'], 
                            'vchid'=>$voucherid,
                            'amount'=>str_replace(',', '', $data['vat']),
                            'description'=> 'Vat Input',
                            'refrence'=>'',
                            'invoiceid'=>$data['bill_number'],
                            'poid'=>'',
                            'item_order'=>'0',
                            'amount_type'=>0 // 0 debit ; 1 credit
                            ));

        $this->db->insert('tblvoucherlines',array(
                            // 'ledger'=>$ledger_id, //22
                            'ledger'=>$default_options['accounts_payable'], 
                            'vchid'=>$voucherid,
                            'amount'=>$data['total'],
                            'description'=> 'Account Payable',
                            'refrence'=>'',
                            'invoiceid'=>$data['bill_number'],
                            'poid'=>'',
                            'item_order'=>'0',
                            'amount_type'=>0 // 0 debit ; 1 credit
                            ));

        return $bill_id;
    }

    public function add($data = '')
    {
        // echo "<pre>";
        // print_r($data);
        // die;
        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);

        $unsetters = array(
            'currency_symbol',
            // 'ledger',
            // 'amount',
            'comment',
            // 'description',

        );

        foreach ($unsetters as $unseter) {
            if (isset($data[$unseter])) {
                unset($data[$unseter]);
            }
        }

        

        // $items = array();
        // if (isset($data['items'])) {
        //     $items = $data['items'];
        //     unset($data['items']);
        // }

        $newitems = array();
        if (isset($data['newitems'])) {
            $newitems = $data['newitems'];
            unset($data['newitems']);
        }



        $data['bill_date'] = to_sql_date($data['bill_date']);
        $data['due_date'] = to_sql_date($data['due_date']);
        
        $data['note']       = nl2br($data['note']);
        $data['datecreated'] = date('Y-m-d H:i:s');
        $data['addedfrom']   = get_staff_user_id();

        if(!isset($data['po_id']))
        {
            $data['po_id'] = 0;
        }

        $data['bill_total'] = str_replace(",", "", $data['bill_total']);
        // echo $data['bill_total'];
        // die;
        $newdata = array(
            'supplierid'=> $data['supplierid'],
            'bill_number'=> $data['bill_number'],
            'refrence'=> $data['refrence'],
            'bill_date'=> $data['bill_date'],
            'due_date'=> $data['due_date'],
            'currency'=> $data['currency'],
            'recurring_bill' => $data['recurring_bill'],
            'payment_terms'=>$data['payment_terms'],
            'contact'=>$data['contact'],
            'status'=>$data['status'],
            'total'=>$data['total'],
            'bill_total'=>$data['bill_total'],
            'note' => $data['note'],
            'datecreated' => $data['datecreated'],
            'addedfrom' => $data['addedfrom'],
            'status' => $data['status'],
            'subtotal' => $data['subtotal'],
            'vatpaid' => $data['vatpaid'],
            'po_id' => $data['po_id'],
            'discount_total' => $data['discount_total'],
            // 'adjustment' => $data['adjustment'],

        );
        // echo "<pre>";
        // print_r($newdata);
        // die;
        $bill = $this->db->insert('tblbills', $newdata);
        $bill_id = $this->db->insert_id(); 

        foreach ($data['description'] as $key => $value) {
            
            $supplierbill_data  = array(
                            'bill_id' => $bill_id,
                            'ledger_id' => $data['ledger_id'][$key],
                            'description' => $value,
                            'amount' => str_replace(",", "", $data['amount'][$key]),
                            // 'amount' => $data['amount'][$key],
                            );

            $this->db->insert('tblsupplierbill_item', $supplierbill_data);
        }


        $this->db->select_max('voucher');
        $this->db->where('vchtype', '8');
        $voucher = $this->db->get('tblvoucher')->row()->voucher;

        if($voucher){
            $voucher = ++$voucher;
        }else{
         $voucher ='BL0001';
        }

        $this->db->insert('tblvoucher',array(
                 
                        'voucher'=>$voucher,
                        'vchtype'=>'8',
                        'invoiceid'=>$bill_id,
                        'docdate'=>$data['bill_date'],
                        'trxdate'=>$data['due_date'],
                        'created_by'=> get_staff_user_id(),
                        'currency'=>'3',
                   
                        ));
        $voucherid = $this->db->insert_id();

        $this->load->model('settings_model');
        $default_options = $this->settings_model->getOptions();

        foreach ($data['description'] as $key => $value) {
            
            if($default_options['supplier_discount'] == $data['ledger_id'][$key])
            {
                $voucher  = array(
                            'vchid' => $voucherid,
                            'ledger' => $data['ledger_id'][$key],
                            'amount_type' => 1,
                            'amount' => str_replace(",", "", $data['amount'][$key]),
                            // 'amount' => $data['amount'][$key],
                            'description' => $value,
                            'refrence'=>'',
                            'invoiceid'=>$data['bill_number'],
                            'poid'=>'',
                            'item_order'=>'0',

                            );
            }
            else
            {
                $voucher  = array(
                            'vchid' => $voucherid,
                            'ledger' => $data['ledger_id'][$key],
                            'amount_type' => 0,
                            'amount' => str_replace(",", "", $data['amount'][$key]),
                            // 'amount' => $data['amount'][$key],
                            'description' => $value,
                            'refrence'=>'',
                            'invoiceid'=>$data['bill_number'],
                            'poid'=>'',
                            'item_order'=>'0',

                            );
            }
            

            $this->db->insert('tblvoucherlines', $voucher);
        }

        
        
        $this->db->insert('tblvoucherlines',array(
                            // 'ledger'=>$ledger_id, //22
                            'ledger'=>$default_options['accounts_payable'], 
                            'vchid'=>$voucherid,
                            // 'amount'=>$data['total'],
                            'amount'=>str_replace(",", "", $data['total']),
                            'description'=> 'Account Payable',
                            'refrence'=>'',
                            'invoiceid'=>$data['bill_number'],
                            'poid'=>'',
                            'item_order'=>'0',
                            'amount_type'=>1 // 0 debit ; 1 credit
                            ));

        
        return $bill_id;
    }

    public function add1($data='')
    {
        // echo "<pre>";
        // print_r($data);
        // die;
        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);

        // $data['number'] = $data['bill_number'];
        // $data['number'] = $data['number'];
        $data['number'] = get_option('next_paybillnumber_number');
        $available =  str_replace(',','',$data['available']);
        unset($data['_number']);
        unset($data['balance']);
        unset($data['overdraft']);
        unset($data['available']);
        unset($data['payment']); 
        $ds = DateTime::createFromFormat(get_current_date_format(), $data['bill_date']);
        $billamount = str_replace(',','',$data['billamount']);
        $newdata = array(
            'number'=>$data['number'],
            'bill_date'=>$ds->format('Y-m-d'),
            'billamount'=>$billamount,
            'type'=>$data['type'],
            'supplierid'=>$data['supplierid'],
            'note'=>$data['note'],
        );
      
        $res = $this->db->insert('tblpaidbills', $newdata);
        $payid = $this->db->insert_id(); 
        $data['paidbillid']=$payid;
        if($payid){
        if($billamount > $available){
            $overdraft = $available - $billamount;
            $this->db->where('id', $data['account_number']);
            $this->db->set('balance', '0.00', FALSE);
            $this->db->set('available', '0.00', FALSE);
            $this->db->set('overdraft', $overdraft, FALSE);
            $this->db->update('tblbanksaccount');  
        }else{
            $this->db->where('id', $data['account_number']);
            $this->db->set('balance', 'balance-'.$billamount, FALSE);
            $this->db->set('available', 'available-'.$billamount, FALSE);
            $this->db->update('tblbanksaccount');
        }
            
        $this->db->where('name', 'next_paybillnumber_number');
        $this->db->set('value', 'value+1', FALSE);
        $this->db->update('tbloptions');
            
        unset($data['supplierid']);
        if($data['type'] == 'supplier'){
        unset($data['ledger']);        
        unset($data['amount']);
        unset($data['description']);
        unset($data['payment_refrence']);
        unset($data['invoiceid']);
        }
        unset($data['type']);
        unset($data['number']);
        unset($data['note']);
         
        
        $d = DateTime::createFromFormat(get_current_date_format(), $data['bill_date']);
        $data['date']  = $d->format('Y-m-d');
        unset($data['bill_date']);
        $paymentamount = str_replace(',','',$data['billamount']);
        if($data['type'] =='supplier'){
        $applyamount =$data['applyamount'];
 
                 
              foreach ($data['billids'] as $key => $value) {
                $data['billid'] = $value;
          
                if ($paymentamount > 0) { 
                    if ($paymentamount < str_replace(',','',$applyamount[$key]))
                       $data['amount'] = $paymentamount;
                    else
                       $data['amount'] =  str_replace(',','',$applyamount[$key]);
                    
                 $data['daterecorded'] = date('Y-m-d H:i:s');
                
                
                // unset($data['billids']);
                unset($data['billamount']);
                // unset($data['applyamount']);
             

                $data = do_action('before_payment_recorded', $data);
                $this->db->insert('tblbillpaymentrecords', $data);
               
                $insert_id = $this->db->insert_id();            

                if ($insert_id) {
                            $paymentamount = ($paymentamount - $value->total);
                            $bill = $this->get($data['billid']);

                            update_paybill_status($bill->billid);

                            logActivity('Payment Recorded [ID:' . $insert_id . ', Bill Number: ' . $bill->bill_number . ', Total: ' . format_money($data['amount'], '$') . ']');
                        }
                    } else {
                        return true;
                    }
       
              }
              return true;
        }else{
            
            $items = $data['newitems'];
         
              if (count($items) > 0) {
                foreach ($items as $key => $item) {
                    if ($paymentamount > 0) { 
                    if ($paymentamount <= str_replace(',','',$item['amount']))
                       $item['amount'] = $paymentamount;
                    else
                       $item['amount'] =  str_replace(',','',$item['amount']);
                    
                        $item['daterecorded'] = date('Y-m-d H:i:s');
                        
                        $this->db->insert('tblbillpaymentrecords', array(
                            'ledgerid' => $item['ledger'],
                            'paidbillid' => $payid,
                            'amount' => $item['amount'],
                            'description' => $item['description'],
                            'refrence' => $item['refrence'],
                            'invoiceid' => $item['invoiceid'],
                            'bank' => $data['bank'],
                            'bank' => $data['bank'],
                            'branch' => $data['branch'],
                            'account_number' => $data['account_number'],
                            'cheque_number' => $data['cheque_number'],
                            'bank' => $data['bank'],
                            'daterecorded' => $item['daterecorded'],
                            'date' => $data['date'],
                        ));
                       
                    }
                }
                return true;
                }
            }
        }
    }

     public function get_bill_item($id)
    {
        $this->db->where('billid', $id);
        return $this->db->get('tblbillitems')->row();
    }
    public function get_bill_payments($id){
        $this->db->where('billid', $id);
        return $this->db->get('tblbillpaymentrecords')->result_array(); 
    }

    public function get_term($id){
       $this->db->select('payment_term');
       $this->db->where('userid', $id);
       return $this->db->get('tblclients')->row(); 
    }
    /**
     * Update estimate data
     * @param  array $data estimate data
     * @param  mixed $id   estimateid
     * @return boolean
     */
    public function update($data, $id)
    {
       unset($data['action']);
      unset($data['save']);
      unset($data['cancel']);
      unset($data['snew']);
      unset($data['slist']);
      unset($data['isedit']);

  

        $unsetters = array(
            'currency_symbol',
            'ledger',
            'amount',
            'comment',
            'description',

        );

        foreach ($unsetters as $unseter) {
            if (isset($data[$unseter])) {
                unset($data[$unseter]);
            }
        }

        

        $items = array();
        if (isset($data['items'])) {
            $items = $data['items'];
            unset($data['items']);
        }

        $newitems = array();
        if (isset($data['newitems'])) {
            $newitems = $data['newitems'];
            unset($data['newitems']);
        }



        $data['bill_date'] = to_sql_date($data['bill_date']);
        $data['due_date'] = to_sql_date($data['due_date']);
        
        $data['note']       = nl2br($data['note']);
        $data['datecreated'] = date('Y-m-d H:i:s');
        $data['addedfrom']   = get_staff_user_id();


        $action_data = array(
            'data' => $data,
            'newitems' => $newitems,
            'items' => $items,
            'id' => $id,
            'removed_items' => array()
        );

        if (isset($data['removed_items'])) {
            $action_data['removed_items'] = $data['removed_items'];
        }

        $_data                 = do_action('before_bill_updated', $action_data);
        $data['removed_items'] = $_data['removed_items'];
        $newitems              = $_data['newitems'];
        $items                 = $_data['items'];
        $data                  = $_data['data'];

        // Delete items checked to be removed from database
        if (isset($data['removed_items'])) {
            foreach ($data['removed_items'] as $remove_item_id) {
                foreach ($data['removed_items'] as $remove_item_id) {
                    $this->db->where('billid', $id);
                    $this->db->where('id', $remove_item_id);
                    $this->db->delete('tblbillitems');
                 
                }
            }
            unset($data['removed_items']);
        }
        unset($data['items']);
        $this->db->where('billid', $id);
        $this->db->update('tblbills', $data);

        $this->load->model('taxes_model');
        if (count($items) > 0) {

            foreach ($items as $key => $item) {
                $bill_item_id = $item['itemid'];

                $original_item = $this->get_bill_item($bill_item_id);

                $this->db->where('id',$bill_item_id);
                $this->db->update('tblbillitems', array(
                      'item_order'=>$item['order'],
                ));

                if ($this->db->affected_rows() > 0) {
                     $affectedRows++;
                }
                // Check for invoice item short description change
                $this->db->where('id', $bill_item_id);
                $this->db->update('tblbillitems', array(
                    'description'=>$item['description'],
                ));

                if ($this->db->affected_rows() > 0) {
                    $this->log_estimate_activity($id,'updated item short description from ' . $original_item->description . ' to ' . $item['description']);
                    $affectedRows++;
                }

                // Check for item long description change
                $this->db->where('id', $bill_item_id);
                $this->db->update('tblbillitems', array(
                    'ledger'=>$item['ledger'],
                ));


                if ($this->db->affected_rows() > 0) {
                    $this->log_estimate_activity($id,'updated item ledger from ' . $original_item->ledger . ' to ' . $item['ledger']);
                    $affectedRows++;
                }
            

                // Check for item rate change
                $this->db->where('id', $bill_item_id);
                $this->db->update('tblbillitems', array(
                    'comment'=>$item['comment'],
                ));
                if ($this->db->affected_rows() > 0) {
                    $this->log_estimate_activity($id,'updated comment rate from ' . $original_item->comment . ' to ' . $item['comment']);
                    $affectedRows++;
                }
                // CHeck for invoice quantity change
                $this->db->where('id', $bill_item_id);
                $this->db->update('tblbillitems', array(
                    'amount' => str_replace(',','',$item['amount'])
                ));

                if ($this->db->affected_rows() > 0) {
                    $this->log_estimate_activity($id,'updated amount on item <b>' . $item['amount'] . '</b> from ' . $original_item->amount . ' to ' . $item['amount']);
                    $affectedRows++;
                }
            }
        }
  

        if (count($newitems) > 0) {
            foreach ($newitems as $key => $item) {
                $this->db->insert('tblbillitems',array(
                       'ledger'=>$item['ledger'],
                        'description'=>$item['description'],
                        'comment'=>$item['comment'],
                        'amount'=>str_replace(',','',$item['amount']),
                        'billid'=>$id,
                        'item_order'=>$item['order'],
                    ));

                $new_item_added = $this->db->insert_id();
                if ($new_item_added) {
                    $this->log_estimate_activity($id,'added new item <b>' . $item['description'] . '</b>');
                    $affectedRows++;
                }
            }
        }
 
        if ($affectedRows > 0) {
            do_action('after_bill_updated', $id);
            return true;
        }

        return false;
    }

    public function client_estimate_action($action, $id)
    {
        $this->db->where('id', $id);
        $this->db->update('tblestimates', array(
            'status' => $action
        ));

        if ($this->db->affected_rows() > 0) {
            $this->load->model('staff_model');
            $staff    = $this->staff_model->get('', 1);
            $estimate = $this->get($id);
            $invoiceid = false;
            $invoiced = false;
            if ($action == 4) {
                if (get_option('estimate_auto_convert_to_invoice_on_client_accept') == 1) {
                    $invoiceid = $this->convert_to_invoice($id, true);
                    $this->load->model('invoices_model');
                    if ($invoiceid) {
                        $invoiced = true;
                        $invoice = $this->invoices_model->get($invoiceid);
                        $this->log_estimate_activity($id, 'Client accepted this estimate. Estimate is converted to invoice with number <a href="' . admin_url('invoices/list_invoices/' . $invoiceid) . '">' . format_invoice_number($invoice->number) . '</a>', false, true);
                    }

                } else {
                    $this->log_estimate_activity($id, 'Client accepted this estimate.', false, true);
                }

                // add notifications for all users which have permissions manageSales
                foreach ($staff as $member) {
                    if (has_permission('manageSales', $member['staffid'])) {
                        add_notification(array(
                            'fromcompany' => true,
                            'touserid' => $member['staffid'],
                            'description' => 'Congratiolations! Client accepted estimate with number ' . format_estimate_number($estimate->number),
                            'link'=>'estimates/list_estimates/'.$id
                        ));
                    }
                }

                 return array(
                            'invoiced' => $invoiced,
                            'invoiceid' => $invoiceid
                        );

            } else if ($action == 3) {
                // add notifications for all users which have permissions manageSales
                foreach ($staff as $member) {
                    if (has_permission('manageSales', $member['staffod'])) {
                        add_notification(array(
                            'fromcompany' => true,
                            'touserid' => $member['staffid'],
                            'description' => 'Client declined estimate with number ' . format_estimate_number($estimate->number),
                            'link'=>'estimates/list_estimates/'.$id
                        ));
                    }
                }
                $this->log_estimate_activity($id, 'Client declined this estimate.', false, true);
                return true;
            }

        }

        return false;
    }
    /**
     * Delete estimate items and all connections
     * @param  mixed $id estimateid
     * @return boolean
     */
    public function delete($id)
    {
        do_action('before_bill_deleted', $id);
        $this->db->where('billid', $id);
        $this->db->delete('tblbills');

        // if ($this->db->affected_rows() > 0) {
        //     $this->db->where('billid', $id);
        //     $this->db->delete('tblbillitems');
        //     return true;
        // }

        $this->db->select('*');
        $this->db->from('tblvoucher');
        $this->db->like('voucher', 'BL');
        $this->db->where('invoiceid', $id);
        $vchid = $this->db->get()->row();

        $this->db->where('vchid', $vchid->vchid);
        $this->db->delete('tblvoucher');

        $this->db->where('vchid', $vchid->vchid);
        $this->db->delete('tblvoucherlines');


        if ($this->db->affected_rows() > 0) {
            $this->db->where('bill_id', $id);
            $this->db->delete('tblsupplierbill_item');
            return true;
        }

        return false;
    }
    /**
     * Set estimate to sent when email is successfuly sended to client
     * @param mixed $id estimateid
     */
    public function set_estimate_sent($id)
    {
        $this->db->where('id', $id);
        $this->db->update('tblestimates', array(
            'sent' => 1,
            'datesend' => date('Y-m-d H:i:s')
        ));

        $description = 'sent estimate to client';
        $this->log_estimate_activity($id, $description);

        // Update estimate status to sent
        $this->db->where('id', $id);
        $this->db->update('tblestimates', array(
            'status' => 2
        ));
    }

    /**
     * Sent estimate to client
     * @param  mixed  $id        estimateid
     * @param  string  $template  email template to sent
     * @param  boolean $attachpdf attach estimate pdf or not
     * @return boolean
     */
    public function sent_estimate_to_client($id, $template = '', $attachpdf = true)
    {

        $this->load->model('emails_model');
        $estimate = $this->get($id);
        if ($template == '') {
            if ($estimate->sent == 0) {
                $template = 'estimate-send-to-client';
            } else {
                $template = 'estimate-already-send';
            }
        }

        $estimate_number = format_estimate_number($estimate->number);
        $pdf             = estimate_pdf($estimate);

        if ($attachpdf) {
            $attach = $pdf->Output($estimate_number . '.pdf', 'S');
            $this->emails_model->add_attachment($attach, $estimate_number . '.pdf', 'application/pdf');
        }

        $send = $this->emails_model->send_email_template($template, $estimate->client->email, $estimate->clientid, false,false,false,$id);
        if ($send) {
            $this->set_estimate_sent($id);
            return true;
        }

        return false;
    }
    /**
     * All estimate activity
     * @param  mixed $id estimateid
     * @return array
     */
    public function get_estimate_activity($id)
    {
        $this->db->where('estimateid', $id);
        $this->db->order_by('date', 'asc');
        return $this->db->get('tblestimateactivity')->result_array();
    }
    /**
     * Log estimate activity to database
     * @param  mixed $id   estimateid
     * @param  string $description activity description
     */
    public function log_estimate_activity($id, $description = '', $cron = false, $client = false)
    {
        $staffid = get_staff_user_id();

        if ($cron == true) {
            $staffid = 'Cron Job';
        } else if ($client == true) {
            $staffid = NULL;
        }

        $this->db->insert('tblestimateactivity', array(
            'description' => $description,
            'date' => date('Y-m-d H:i:s'),
            'estimateid' => $id,
            'staffid' => $staffid
        ));
    }
 function get_prev($id){
   return $this->db->query("select id,clientid from tblestimates where id = (select max(id) from tblestimates where id < $id)")->row();
}
function get_next($id){
  return  $this->db->query("select id,clientid from tblestimates where id = (select min(id) from tblestimates where id > $id)")->row();
}
    public function mark_action_status($action, $id, $client = false)
    {
        $this->db->where('id', $id);
        $this->db->update('tblquotes', array(
            'status' => $action
        ));

        if ($this->db->affected_rows() > 0) {

            $quote  = $this->get($id);

            if($client == true){
                $this->db->where('staffid',$quote->addedfrom);
                $this->db->or_where('staffid',$quote->sale_agent);
                $staff_quote = $this->db->get('tblstaff')->result_array();

               
                $orderid = false;
                $orderd  = false;
                if ($action == 4) {
                    if (get_option('estimate_auto_convert_to_invoice_on_client_accept') == 1) {
                        $orderid = $this->convert_to_order($id, true);
                        $this->load->model('orders_model');
                        if ($orderid) {
                            $orderd = true;
                            $invoice  = $this->orders_model->get($orderid);
                            $this->log_estimate_activity($id, 'Client accepted this quote. Quote is converted to order with number <a href="' . admin_url('orders/list_orders/' . $orderid) . '">' . format_order_number($orderid->id) . '</a>', false, true);
                        }
                    } else {
                        $this->log_estimate_activity($id, 'Client accepted this quote.', false, true);
                    }

                    // Send thank you email
                    $this->emails_model->send_email_template('quote-thank-you-to-customer', $quote->client->email, $quote->clientid, false, false, false, $id);

                    // add notifications for all users which have permissions manageSales
                    foreach ($staff_quote as $member) {
                        if (has_permission('manageSales', $member['staffid'])) {
                            add_notification(array(
                                'fromcompany' => true,
                                'touserid' => $member['staffid'],
                                'description' => 'Congratiolations! Client accepted quote with number ' . format_estimate_number($quote->id),
                                'link' => 'estimates/list_estimates/' . $id
                            ));
                          // Send staff email notification that customer accepted quote
                          $this->emails_model->send_email_template('quote-accepted-to-staff', $member['email'], $quote->clientid, false, false, false, $id);
                        }
                    }

                    return array(
                        'orderd' => $orderd,
                        'orderid' => $orderid
                    );

                } else if ($action == 3) {
                    // add notifications for all users which have permissions manageSales
                    foreach ($staff_quote as $member) {
                        if (has_permission('manageSales', $member['staffid'])) {

                            add_notification(array(
                                'fromcompany' => true,
                                'touserid' => $member['staffid'],
                                'description' => 'Client declined quote with number ' . format_quote_number($quote->id),
                                'link' => 'quotes/list_quotes/' . $id
                            ));

                            // Send staff email notification that customer declined quote
                            $this->emails_model->send_email_template('quote-declined-to-staff', $member['email'], $quote->clientid, false, false, false, $id);

                        }
                    }
                    $this->log_estimate_activity($id, 'Client declined this quote.', false, true);
                    return array(
                        'invoiced' => $invoiced,
                        'invoiceid' => $invoiceid
                    );
                }
            } else {
                // Admin marked quote
                $this->log_estimate_activity($id,'marked quote as '.format_quote_status($status,'',false));
                return true;
            }
        }
        return false;
    }
        public function mark_action_status_order($action, $id, $client = false)
    {
        $this->db->where('id', $id);
        $this->db->update('tblestimates', array(
            'status' => $action
        ));

        if ($this->db->affected_rows() > 0) {

            $quote  = $this->get($id);

            if($client == true){
                $this->db->where('staffid',$quote->addedfrom);
                $this->db->or_where('staffid',$quote->sale_agent);
                $staff_quote = $this->db->get('tblstaff')->result_array();

                $orderid = false;
                $orderd  = false;
                if ($action == 4) {
                    if (get_option('estimate_auto_convert_to_invoice_on_client_accept') == 1) {
                        $orderid = $this->convert_to_order($id, true);
                        $this->load->model('orders_model');
                        if ($orderid) {
                            $orderd = true;
                            $invoice  = $this->orders_model->get($orderid);
                            $this->log_estimate_activity($id, 'Client accepted this quote. Quote is converted to order with number <a href="' . admin_url('orders/list_orders/' . $orderid) . '">' . format_order_number($orderid->id) . '</a>', false, true);
                        }
                    } else {
                        $this->log_estimate_activity($id, 'Client accepted this quote.', false, true);
                    }

                    // Send thank you email
                    $this->emails_model->send_email_template('quote-thank-you-to-customer', $quote->client->email, $quote->clientid, false, false, false, $id);

                    // add notifications for all users which have permissions manageSales
                    foreach ($staff_quote as $member) {
                        if (has_permission('manageSales', $member['staffid'])) {
                            add_notification(array(
                                'fromcompany' => true,
                                'touserid' => $member['staffid'],
                                'description' => 'Congratiolations! Client accepted quote with number ' . format_estimate_number($quote->id),
                                'link' => 'estimates/list_estimates/' . $id
                            ));
                          // Send staff email notification that customer accepted quote
                          $this->emails_model->send_email_template('quote-accepted-to-staff', $member['email'], $quote->clientid, false, false, false, $id);
                        }
                    }

                    return array(
                        'orderd' => $orderd,
                        'orderid' => $orderid
                    );

                } else if ($action == 3) {
                    // add notifications for all users which have permissions manageSales
                    foreach ($staff_quote as $member) {
                        if (has_permission('manageSales', $member['staffid'])) {

                            add_notification(array(
                                'fromcompany' => true,
                                'touserid' => $member['staffid'],
                                'description' => 'Client declined quote with number ' . format_estimate_number($quote->id),
                                'link' => 'estimates/list_estimates/' . $id
                            ));

                            // Send staff email notification that customer declined quote
                            $this->emails_model->send_email_template('quote-declined-to-staff', $member['email'], $quote->clientid, false, false, false, $id);

                        }
                    }
                    $this->log_estimate_activity($id, 'Client declined this quote.', false, true);
                     return array(
                        'orderd' => $orderd,
                        'orderid' => $orderid
                    );
                }
            } else {
                // Admin marked quote
                $this->log_estimate_activity($id,'marked quote as '.format_quote_status($status,'',false));
                return true;
            }
        }
        return false;
    }
      public function get_contacts($id){
       return $this->db->where('userid',$id)->get('tblsuppliercontacts')->result();
    }
      public function get_where_contacts($id){
      
       return $this->db->where('userid',$id)->get('tblsuppliercontacts')->result();
    }
      public function get_bill_total($data)
    {

        $statuses = array(
            1,
            2,
            3
        );
        $this->load->model('currencies_model');

        if ((is_using_multiple_currencies() && !isset($data['currency'])) || !isset($data['currency'])) {
            $currencyid = $this->currencies_model->get_base_currency()->id;
        } else if (isset($data['currency'])) {
            $currencyid = $data['currency'];
        }


        $symbol = $this->currencies_model->get_currency_symbol($currencyid);
        $sql    = 'SELECT';
        foreach ($statuses as $invoice_status) {
            $sql .= '(SELECT SUM(total) FROM tblbills WHERE status=' . $invoice_status;
            $sql .= ' AND currency =' . $currencyid;
            $sql .= ') as "' . $invoice_status . '",';
        }

        $sql     = substr($sql, 0, -1);
        $result  = $this->db->query($sql)->result_array();
        $_result = array();
        $i       = 0;
        foreach ($result as $key => $val) {
            foreach ($val as $total) {
                $_result[$i]['total']  = $total;
                $_result[$i]['symbol'] = $symbol;
                $i++;
            }
        }

        return $_result;
    }
    public function getbalance($id){
        $this->db->select_sum('amount');
        $this->db->where('billid', $id);
        $res = $this->db->get('tblbillpaymentrecords')->row();
        if(isset($res)){
          return $res->amount;
       }else{
           return '0';
       }
    }

    public function getsupplier_paymentterms($id)
    {
        $this->db->select('*');
        $this->db->from('tblsuppliers');
        $this->db->where('userid',$id);
        return $this->db->get()->row();
    }

}

