<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class CRM_Controller extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->check_installation();
        if ($this->config->item('installed') == true) {
            $this->db->reconnect();
            $timezone = get_option('default_timezone');
            date_default_timezone_set($timezone);
        }
    }
    private function check_installation()
    {
        if ($this->uri->segment(1) !== 'install') {
            $this->load->config('migration');
            if ($this->config->item('installed') == false && $this->config->item('migration_enabled') == false) {
                redirect(site_url('install/make'));
            } else {
                if (is_dir(APPPATH . 'controllers/install')) {
                    echo '<h3>Delete the install folder from application/controllers/install</h3>';
                    die;
                }
            }
        }
    }
}
