<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Warehouse extends Admin_controller {

    function __construct() {
        parent::__construct();
        $this->load->model('warehouse_model');
    }

    /* List all available items */

    public function index() {
        if ($this->input->is_ajax_request()) {
            $aColumns = array(                
                'warehouse_name',
                'tblcountries.short_name',
                'address',
                'city',
            );
            $sIndexColumn = "ware_id";
            $sTable = 'tblwarehouse';
            $join = array(
                'LEFT JOIN tblcountries ON tblcountries.country_id = tblwarehouse.country'
            );
            $additionalSelect = array(
                'ware_id'
            );
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, array(), $additionalSelect);
            $output = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                     $_data = $aRow[$aColumns[$i]];
                    if ($aColumns[$i] == 'warehouse_name') {
                         $_data ='<a href="'.admin_url('warehouse/warehouse/'.$aRow['ware_id']).'">'.$_data.'</a>';
                    }                    
                    $row[] = $_data;
                }
                $options = icon_btn('admin/warehouse/warehouse/' . $aRow['ware_id'], 'pencil-square-o', 'edit-locations', array('data-toggle' => 'tooltip', 'title' => _l('warehouse_edit_tooltip')));
                
                
                $row[] = $options .= icon_btn('admin/warehouse/delete/' . $aRow['ware_id'], 'remove', '',array('onClick' => 'return deleteconf();'));

                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        $data['title'] = _l('Warehouse');
        $this->load->view('admin/warehouse/manage', $data);
    }

    public function warehouse($id = '') {
        if ($this->input->post() && !$this->input->is_ajax_request()) {
            if ($id == '') {
                    $id = $this->warehouse_model->add($this->input->post());
                    if ($id) {
                        set_alert('success', _l('warehouse_added_successfully', _l('warehouse_added')));
                        if (trim($this->input->post('action')) == 'save') {
                            redirect(admin_url('warehouse/warehouse/'.$id));
                            exit;
                           }
                        if (trim($this->input->post('action')) == 'snew') {
                            redirect(admin_url('warehouse/warehouse'));
                            exit;
                        }

                        if (trim($this->input->post('action')) == 'slist') {
                             redirect(admin_url('warehouse'));
                              exit;
                        }
                        
                    }
            } else {
                $success = $this->warehouse_model->update($this->input->post(), $id);
  
                if ($success) {
                  
                    set_alert('success', _l('warehouse_updated_successfully', _l('warehouse_updated')));
                    if (trim($this->input->post('action')) == 'save') {
                            redirect(admin_url('warehouse/warehouse/'.$id));
                            exit;
                           }
                        if (trim($this->input->post('action')) == 'snew') {
                            redirect(admin_url('warehouse/warehouse'));
                            exit;
                        }

                        if (trim($this->input->post('action')) == 'slist') {
                             redirect(admin_url('warehouse'));
                              exit;
                        }
                }
                
            }
        }

        if ($id == '') {
            $title = _l('add_new', _l('warehouse_table_heading'));
        } else {     
           
            $warehouse = $this->warehouse_model->get_where_single_tbl('tblwarehouse','ware_id',$id);
            
            $location   = $this->warehouse_model->get_where_single_tbl_result('tbllocations','ware_id',$id);
            $bin   = $this->warehouse_model->get_where_single_tbl('tblbins','ware_id',$id);
            $item   = $this->warehouse_model->get_where_single_tbl('tblinvoiceitemslist','ware_id',$id);
             $contact   = $this->warehouse_model->get_contact_warehouse($id);
             $data['receiving']   = $this->warehouse_model->get_receiving_warehouse($id);
             $data['available']   = $this->warehouse_model->get_available_warehouse($id);
             $data['customer_rma']   = $this->warehouse_model->get_customer_rma_warehouse($id);
             $data['supplier_rtv']   = $this->warehouse_model->get_supplier_rtv_warehouse($id);
             $data['scrapt']   = $this->warehouse_model->get_scrapt_warehouse($id);
             
             
            $this->load->model('clients_model');
            $data['department'] = $this->clients_model->get_departments();
            $data['warehouse'] = $warehouse;
            $data['warehouse_locations'] = $location;
            $data['location_bin'] = $location;
            $data['bin'] = $bin;
            $data['item'] = $item;
            $data['contact'] = $contact;
            $data['members'] = $this->staff_model->get('',1);
            $title = $warehouse->warehouse_name; 
        }
        $data['country'] = $this->warehouse_model->get_countries();
        $data['locations'] = $this->warehouse_model->get_locations();
        $data['title'] = $title;
        $this->load->view('admin/warehouse/warehouse', $data);
    }

   

    /* Delete item */

    public function delete($id) {
        if (!$id) {
            redirect(admin_url('warehouse'));
        }

        $response = $this->warehouse_model->delete($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('warehouse_lowercase')));
        } else if ($response == true) {
            set_alert('success', _l('deleted', _l('warehouse')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('warehouse_lowercase')));
        }
        redirect(admin_url('warehouse'));
    }
    
    /*delete warehouse contact*/
    public function deletecontactwarehouse()
    {
        $id=  $this->input->post('id');
        $response = $this->warehouse_model->deletecontact($id);
    }
    
    public function delete_items()
    {
        $id=  $this->input->post('id');
        $response = $this->warehouse_model->deleteitems($id);
        echo $response;
    }

    



    public function get_warehouse_reminders($id){
		if($this->input->is_ajax_request()){

			$aColumns = array( 'description', 'date', 'staff', 'isnotified');
			$sIndexColumn = "id";
			$sTable = 'tbladminwarehousereminders';

			$where = array('AND ware_id='.$id);
			$join = array(
				'JOIN tblstaff ON tblstaff.staffid = tbladminwarehousereminders.staff'
				);
			$result = data_tables_init($aColumns,$sIndexColumn,$sTable,$join,$where,array('firstname','lastname','id','creator'));
			$output = $result['output'];
			$rResult = $result['rResult'];

			foreach ( $rResult as $aRow )
			{
				$row = array();
				for ( $i=0 ; $i<count($aColumns) ; $i++ )
				{
					$_data = $aRow[ $aColumns[$i] ];
					if($aColumns[$i] == 'staff'){
						$_data = '<a href="'.admin_url('staff/profile/'.$aRow['staff']).'">'.staff_profile_image($aRow['staff'], array(
							'staff-profile-image-small'
							)) . ' ' . $aRow['firstname'] . ' ' . $aRow['lastname'] .'</a>';
					} else if($aColumns[$i] == 'staff'){
						$_data = _d($_data);
					} else if($aColumns[$i] == 'isnotified'){
						if($_data == 1){
							$_data = _l('client_reminder_is_notified_boolean_yes');
						} else {
							$_data = _l('client_reminder_is_notified_boolean_no');
						}
					}
					$row[] = $_data;
				}

				if($aRow['creator'] == get_staff_user_id()){
					//$row[] = icon_btn('admin/warehouse/delete_reminder/'.$id . '/'. $aRow['id'], 'remove', '');
				       $row[]  =  icon_btn('#', 'remove', ' delete-reminders', array('data-id'=>$aRow['id']));
                
                                        
                                } else {
					$row[] = '';
				}


				$output['aaData'][] = $row;
			}

			echo json_encode( $output );
			die();
		}
	}
        
        /* Since version 1.0.2 add client reminder */
	public function add_warehouse_reminder($id){
		if(!has_permission('manageClients')){
			access_denied('manageClients');
		}

		if($this->input->post()){
			$success = $this->warehouse_model->add_reminder($this->input->post(),$id);
			if($success){
				set_alert('success',_l('warehouse_reminder_added_successfuly'));
			}
		}

		redirect(admin_url('warehouse/warehouse/'.$id));
	}

	/* Since version 1.0.2 delete client reminder */
	public function delete_reminders(){
		$id=  $this->input->post('id');
		$success = $this->warehouse_model->delete_reminder($id);
                echo $success;
	}

    /* Get item by id / ajax */

    public function get_item_by_id($id) {
        if ($this->input->is_ajax_request()) {
            echo json_encode($this->warehouse_model->get($id));
        }
    }

    /* Get all items */

    public function get_all_items_ajax() {
        if ($this->input->is_ajax_request()) {
            echo json_encode($this->warehouse_model->get_all_items_ajax());
        }
    }
    
    /*Warehouse Id Exist or Not*/
    public function check_warehouse()
    {
        $warehouse_id=  $this->input->post('warehouse_id');
        $check_warehouse=  $this->warehouse_model->get_where_single_tbl('tblwarehouse', 'warehouse_id', $warehouse_id);
        if(empty($check_warehouse))
        {
           echo '1';
        }
        else {
            echo '0';
        }
    }
          public function manage()
    {
        if ($this->input->post()) {
            $data = $this->input->post();
            if ($data['contactid'] == '') {
                $message = '';
                $success = $this->warehouse_model->addcontact($data);
                if($success) {
                    $message = _l('added_successfuly','Contact');
                }
                echo json_encode(array(
                    'success' => $success,
                    'message'=>$message
                ));
            } else {
                $message = '';
                $success = $this->warehouse_model->updateContacts($data);
                if($success){
                    $message = _l('updated_successfuly','Contact');
                }
                echo json_encode(array(
                    'success' => $success,
                    'message'=>$message
                ));
            }
        }
    }
    public function getcontact(){
       echo json_encode($this->warehouse_model->getcontact($this->input->post('id')));
    }
}
