<?php



defined('BASEPATH') OR exit('No direct script access allowed');



class Vehicles extends Admin_controller {



    function __construct() {

        parent::__construct();

        $this->load->model('vehicles_model');

    }



    /* List all available items */



    public function index()  {

		

		

		$data['vehicles'] = $this->vehicles_model->get('','',$this->input->post());

		

		$data['maker'] = $this->vehicles_model->getmakers();



        $data['title'] = _l('vehicles');

		

		

		

		

		$this->load->model('make_model');

		$data['makers']=$this->make_model->get();

		

		if($this->input->post()){

		$data['formdata'] = $this->input->post();

		$formdata = $data['formdata'];

		$data['engines']=$this->vehicles_model->get_engines($formdata['engines_id']);

		}

        $this->load->view('admin/vehicles/manage', $data);

    }

	
    public function show_engines($engines_id='')  {

		

		
		if($engines_id !=''){
			
		$data['vehicles'] = $this->vehicles_model->get('','',$this->input->post(),$engines_id);
		$data['engines_id']=$engines_id;
		}else{
			
		$data['vehicles'] = $this->vehicles_model->get('','',$this->input->post());
		}
		

		$data['maker'] = $this->vehicles_model->getmakers();



        $data['title'] = _l('vehicles');

		

		$this->load->model('make_model');

		$data['makers']=$this->make_model->get();

		

		if($this->input->post()){

		$data['formdata'] = $this->input->post();

		$formdata = $data['formdata'];

		$data['engines']=$this->vehicles_model->get_engines($formdata['engines_id']);

		}

        $this->load->view('admin/vehicles/manage', $data);

    }

	



    public function vehicles($clientid= '',$id = '') {

        if ($this->input->post() && !$this->input->is_ajax_request()) {

			

			

			$data['vehicles_data']= $this->input->post();

			$usersid = $data['vehicles_data']['users_id'];

			//echo'<pre>';

			//print_r($usersid);

			//exit;

			

			

            if ($id == '') {

                    $id = $this->vehicles_model->add($this->input->post());

                    if ($id) {

                        set_alert('success', _l('vehicles_added_successfully', _l('vehicles_added ')));

						

						if (trim($this->input->post('action')) == 'svehicle') {

							if($clientid){

								$a = 'latest';

                            redirect(admin_url('clients/view/'.$clientid.'/'.$a));

                            

							}else{

								$a = 'latest';

								redirect(admin_url('clients/view/'.$usersid.'/'.$a));

								exit;

							}

                           }

                        if (trim($this->input->post('action')) == 'save') {

                            redirect(admin_url('vehicles/vehicles/'.$id));

							// redirect(admin_url('engines'));



                            exit;

                           }

                        if (trim($this->input->post('action')) == 'snew') {

							 redirect(admin_url('vehicles'));

                            exit;

                        }



                        if (trim($this->input->post('action')) == 'slist') {

                             redirect(admin_url('vehicles'));

                              exit;

                        }

                        

                    }

            } else {

				

					if (trim($this->input->post('action')) == 'save') {

							 

                            $success = $this->vehicles_model->update($this->input->post(), $id);

							

                           }elseif (trim($this->input->post('action')) == 'snew') {

                            $success = $this->vehicles_model->add($this->input->post());

                        }elseif (trim($this->input->post('action')) == 'svehicle') {

							$success = $this->vehicles_model->update($this->input->post(), $id);

                            redirect(admin_url('clients/view/'.$clientid));

                            exit;

                           }

                

  

                if ($success) {

                  

                    set_alert('success', _l('vehicles_updated_successfully', _l('vehicles_updated')));

                    if (trim($this->input->post('action')) == 'save') {

                            redirect(admin_url('vehicles/vehicles/'.$id));

                            exit;

                           }

                        if (trim($this->input->post('action')) == 'snew') {

							$id = $success;

                            redirect(admin_url('vehicles/vehicles'));

                            exit;

                        }



                        if (trim($this->input->post('action')) == 'slist') {

                             redirect(admin_url('vehicles'));

                              exit;

                        }

                }

                

            }

        }



        if ($id == '') {

            $title = _l('add_new', _l('vehicles'));

        } else {     

           

            $vehicles = $this->vehicles_model->get_where_single_tbl('vehicles','id',$id);

			$data['vehicles'] = $this->vehicles_model->get($id);

            $title = _l('edit', _l('vehicles'));

        }

		$data['client_id'] = $clientid;

		$data['vehicle_char'] = $this->vehicles_model->getvehicles_char();

		$this->load->model('clients_model');

		$data['users']=$this->clients_model->get();

		$data['engines']=$this->vehicles_model->get_engines($data['vehicles']->engines_id);

        $data['title'] = $title;

        $this->load->view('admin/vehicles/vehicles', $data);

    }



   



    /* Delete item */



     public function delete($id) {

        if (!$id) {

            redirect(admin_url('vehicles'));

        }



        $response = $this->vehicles_model->delete($id);

        if (is_array($response) && isset($response['referenced'])) {

            set_alert('warning', _l('is_referenced', _l('vehicles_lowercase')));

        } else if ($response == true) {

            set_alert('success', _l('deleted', _l('vehicles')));

        } else {

            set_alert('warning', _l('problem_deleting', _l('vehicles_lowercase')));

        }

        redirect(admin_url('vehicles'));

    }

    

    /*delete warehouse contact*/

    public function deletecontactwarehouse()

    {

        $id=  $this->input->post('id');

        $response = $this->vehicles_model->deletecontact($id);

    }

    

    public function delete_items()

    {

        $id=  $this->input->post('id');

        $response = $this->vehicles_model->deleteitems($id);

        echo $response;

    }



    







    public function get_warehouse_reminders($id){

		if($this->input->is_ajax_request()){



			$aColumns = array( 'description', 'date', 'staff', 'isnotified');

			$sIndexColumn = "id";

			$sTable = 'tbladminwarehousereminders';



			$where = array('AND ware_id='.$id);

			$join = array(

				'JOIN tblstaff ON tblstaff.staffid = tbladminwarehousereminders.staff'

				);

			$result = data_tables_init($aColumns,$sIndexColumn,$sTable,$join,$where,array('firstname','lastname','id','creator'));

			$output = $result['output'];

			$rResult = $result['rResult'];



			foreach ( $rResult as $aRow )

			{

				$row = array();

				for ( $i=0 ; $i<count($aColumns) ; $i++ )

				{

					$_data = $aRow[ $aColumns[$i] ];

					if($aColumns[$i] == 'staff'){

						$_data = '<a href="'.admin_url('staff/profile/'.$aRow['staff']).'">'.staff_profile_image($aRow['staff'], array(

							'staff-profile-image-small'

							)) . ' ' . $aRow['firstname'] . ' ' . $aRow['lastname'] .'</a>';

					} else if($aColumns[$i] == 'staff'){

						$_data = _d($_data);

					} else if($aColumns[$i] == 'isnotified'){

						if($_data == 1){

							$_data = _l('client_reminder_is_notified_boolean_yes');

						} else {

							$_data = _l('client_reminder_is_notified_boolean_no');

						}

					}

					$row[] = $_data;

				}



				if($aRow['creator'] == get_staff_user_id()){

					//$row[] = icon_btn('admin/warehouse/delete_reminder/'.$id . '/'. $aRow['id'], 'remove', '');

				       $row[]  =  icon_btn('#', 'remove', ' delete-reminders', array('data-id'=>$aRow['id']));

                

                                        

                                } else {

					$row[] = '';

				}





				$output['aaData'][] = $row;

			}



			echo json_encode( $output );

			die();

		}

	}

        

        /* Since version 1.0.2 add client reminder */

	public function add_warehouse_reminder($id){

		if(!has_permission('manageClients')){

			access_denied('manageClients');

		}



		if($this->input->post()){

			$success = $this->vehicles_model->add_reminder($this->input->post(),$id);

			if($success){

				set_alert('success',_l('warehouse_reminder_added_successfuly'));

			}

		}



		redirect(admin_url('vehicles/warehouse/'.$id));

	}



	/* Since version 1.0.2 delete client reminder */

	public function delete_reminders(){

		$id=  $this->input->post('id');

		$success = $this->vehicles_model->delete_reminder($id);

                echo $success;

	}



    /* Get item by id / ajax */



    public function get_item_by_id($id) {

        if ($this->input->is_ajax_request()) {

            echo json_encode($this->vehicles_model->get($id));

        }

    }



    /* Get all items */



    public function get_all_items_ajax() {

        if ($this->input->is_ajax_request()) {

            echo json_encode($this->vehicles_model->get_all_items_ajax());

        }

    }

    

    /*Warehouse Id Exist or Not*/

    public function check_warehouse()

    {

        $warehouse_id=  $this->input->post('warehouse_id');

        $check_warehouse=  $this->vehicles_model->get_where_single_tbl('tblwarehouse', 'warehouse_id', $warehouse_id);

        if(empty($check_warehouse))

        {

           echo '1';

        }

        else {

            echo '0';

        }

    }

          public function manage()

    {

        if ($this->input->post()) {

            $data = $this->input->post();

            if ($data['vehicle_id'] == '') {

                $message = '';

                $success = $this->vehicles_model->add($data);

                if($success) {

                    $message = _l('added_successfuly','Customer Vehicle');

                }

                echo json_encode(array(

                    'success' => $success,

                    'message'=>$message

                ));

            } else {

                $message = '';

                $success = $this->vehicles_model->update($data);

                if($success){

                    $message = _l('updated_successfuly','Customer Vehicle');

                }

                echo json_encode(array(

                    'success' => $success,

                    'message'=>$message

                ));

            }

        }

    }

    public function getcontact(){

       echo json_encode($this->vehicles_model->getcontact($this->input->post('id')));

    }

	

	public function get_engines(){

		//print_r($this->input->post());

		//exit;

		$this->load->model('engines_model');

       echo json_encode($this->engines_model->get_engines($this->input->post('q')));

    }

}

