<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Todo extends Admin_controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('todo_model');
    }

    /* Get all staff todo items */
    public function index()
    {

        if ($this->input->is_ajax_request()) {
            echo json_encode($this->todo_model->get_todo_items($this->input->post('finished'), $this->input->post('todo_page')));
            exit;
        }

        $data['bodyclass']              = 'main_todo_page';
        $data['total_pages_finished']   = ceil(total_rows('tbltodoitems', array(
            'finished' => 1
        )) / get_option('tables_pagination_limit'));
        $data['total_pages_unfinished'] = ceil(total_rows('tbltodoitems', array(
            'finished' => 0
        )) / get_option('tables_pagination_limit'));
        $data['title']                  = _l('my_todos');
        $this->load->view('admin/todos/all', $data);
    }
    /* Add new todo item */
    public function add()
    {
        if ($this->input->post()) {
            $id = $this->todo_model->add($this->input->post());
            if ($id) {
                set_alert('success', _l('added_successfuly',_l('todo')));
            }
            redirect(admin_url('todo'));
        }
    }
    /* Change todo status */
    public function change_todo_status($id, $status, $home = 0)
    {
        $success = $this->todo_model->change_todo_status($id, $status);
        if ($success) {
            set_alert('success', _l('todo_status_changed'));
        }
        if ($home == 1) {
            redirect(site_url('admin'));
        }
        redirect(admin_url('todo'));
    }
    /* Update todo order / ajax */
    public function update_todo_items_order()
    {
        if ($this->input->post()) {
            $this->todo_model->update_todo_items_order($this->input->post());
        }
    }
    /* Delete todo item from databse */
    public function delete_todo_item($id)
    {
        if ($this->input->is_ajax_request()) {
            echo json_encode(array(
                'success' => $this->todo_model->delete_todo_item($id)
            ));
        }
        die();
    }
}
