<?php ob_start();
defined('BASEPATH') OR exit('No direct script access allowed');

class Suppliers extends Admin_controller {

	function __construct(){
		parent::__construct();
		$this->load->model('clients_model');
        $this->load->model('suppliers_model');
        $this->load->model('purchaseorders_model');
	}

	/* List all clients */
	public function index()
	{

		if($this->input->is_ajax_request())
    {
			$aColumns = array(
                    'account_number',
                    'supplier',
                    'country',
                    'email',
                    'phonenumber',
                    // 'userid',
                    'amount',
                    'active',
                    
                  );

			$sIndexColumn = "userid";
			$sTable = 'tblsuppliers';
      $this->load->model('currencies_model');
      $base_currency_symbol = $this->currencies_model->get_base_currency()->symbol;
			$result = data_tables_init($aColumns,$sIndexColumn,$sTable,array(),array(),array('supplier','userid'));
			$output = $result['output'];
			$rResult = $result['rResult'];

			foreach ( $rResult as $aRow )
			{
				$row = array();
				for ( $i=0 ; $i<count($aColumns) ; $i++ )
				{
					$_data = $aRow[ $aColumns[$i] ];
					if ($aColumns[$i] == 'last_login')
          {
						if($_data != NULL){
							$_data = time_ago($_data);
						} else {
							$_data = 'Never';
						}
					} 
          else if ($aColumns[$i] == 'active') 
          {
						$checked = '';
						if($aRow['active'] == 1){
							$checked = 'checked';
						}
						$_data = '<input type="checkbox" class="switch-box input-xs" data-size="mini" data-id="'.$aRow['userid'].'" data-switch-url="admin/suppliers/change_supplier_status" '.$checked.'>';
						// For exporting
						$_data .=  '<span class="hide">' . ($checked == 'checked' ? _l('is_active_export') : _l('is_not_active_export')) .'</span>';
          }
          else if($aColumns[$i] == 'account_number')
          {
            $_data = '<a href="'.admin_url('suppliers/view/'.$aRow['userid']).'">'.$_data.'</a>';  
          }
          else if ($aColumns[$i] == 'supplier')
          {
						$_data =  $aRow['supplier'];
						
						$_data = '<a href="'.admin_url('suppliers/view/'.$aRow['userid']).'">'.$_data.'</a>';
					}
          // else if ($aColumns[$i] == 'amount')
          // {
          //   $_data =  $aRow['amount'];
            
          //   // $_data = '<a href="'.admin_url('suppliers/supplier/'.$aRow['userid']).'">'.$_data.'</a>';
          // }
          else if ($aColumns[$i] == 'country')
          {
             $res =$this->clients_model->get_country($aRow['country']);
             if(isset($res)){
                $_data = $res->short_name;
             }else{
                  $_data ='';
             }
             
          }
          else if ($aColumns[$i] == 'amount'){
            // $this->clients_model->get_balance($aRow['userid']);
            $balance = $aRow['amount'];
          
            $_data =format_money($balance, $base_currency_symbol);
          }

					$row[] = $_data;
				}
				$options = icon_btn('admin/suppliers/view/'.$aRow['userid'],'eye');
				
				$options .= icon_btn('admin/suppliers/supplier/'.$aRow['userid'],'pencil-square-o');
				$row[]  = $options .= icon_btn('admin/suppliers/delete/'.$aRow['userid'],'remove','',array('data-toggle'=>'tooltip','onClick' => 'return deleteconf();','title'=>_l('supplier_delete_tooltip')));

				$output['aaData'][] = $row;
			}

			echo json_encode( $output );
			die();
		}







		$data['title'] = _l('supplier');
		$this->load->view('admin/supplier/manage',$data);
	}
	/* Edit client or add new client*/
	public function supplier($id = ''){
	if(!has_permission('manageClients')){
				access_denied('manageClients');
			}
			
			echo $this->input->is_ajax_request();
			//if(($google_api_key)
			
		if($this->input->post() && !$this->input->is_ajax_request()){
			

			if($id == ''){
				
				if($_POST["longitude"]=="")
				{
					$coordinate=getCoordinates(get_option("google_api_key"),$_POST["address"],countryName($_POST["country"]),$_POST["state"],$_POST["city"],$_POST["address"],$_POST["supplier"]);
					if(isset($coordinate['location']['lat']))
					{
						$_POST["longitude"]=$coordinate['location']['lng'];
						$_POST["latitude"]=$coordinate['location']['lat'];
					}
					
				}
				$id = $this->suppliers_model->add($this->input->post());
				if($id){
					 set_alert('success', _l('added_successfuly',_l('supplier')));
					 handle_supplier_upload($id);
				 redirect(admin_url('suppliers/view/'.$id));
				exit;                            
         
					
				}
			} else {
				
				if($_POST["longitude"]=="")
				{
					$coordinate=getCoordinates(get_option("google_api_key"),$_POST["address"],$coutry,$_POST["state"],$_POST["city"],$_POST["address"],$_POST["supplier"]);
					if(isset($coordinate['location']['lat']))
					{
						$_POST["longitude"]=$coordinate['location']['lng'];
						$_POST["latitude"]=$coordinate['location']['lat'];
					}
					
				}
				$success = $this->suppliers_model->update($this->input->post(),$id);
				
				if($success){
					 set_alert('success', _l('updated_successfuly',_l('supplier')));
					 
					handle_supplier_upload($id);
          		 redirect(admin_url('suppliers/view/'.$id));
				exit;  

				}
				
			}
		}
		if($this->input->is_ajax_request()){
			
			if($id == ''){
				
				$id = $this->suppliers_model->add($this->input->post());
				if($id){
				//set_alert('success',_l('supplier_reminder_added_successfuly'));
					// handle_supplier_upload($id);
				 redirect(admin_url('bills/bill/'));
				exit;                            
         
					
				}
			} 
		}
		if($id == ''){
			$title = _l('add_new',_l('supplier_lowercase'));
		} else {
			$this->load->model('tickets_model');
			$supplier = $this->suppliers_model->get($id);
                        $contact   = $this->suppliers_model->get_contact($id);
			$this->load->model('payment_modes_model');
			$data['payment_modes'] = $this->payment_modes_model->get();
			$data['supplier'] = $supplier;
      $data['contact'] = $contact;
      $data['prev_supplier'] = $this->suppliers_model->get_prev($id);
      $data['next'] = $this->suppliers_model->get_next($id);

      $data['supplier_groups'] = $this->suppliers_model->get_supplier_groups($id);
	  
			$title = $supplier->supplier;
			// Get all active staff members (used to add reminder)
			$this->load->model('staff_model');
			$data['members'] = $this->staff_model->get('',1);
                        
			if($this->input->is_ajax_request()){
				AdminTicketsTable(array('userid'=>$id));
			}

            
		}

      $data['groups'] = $this->suppliers_model->get_groups();
      $this->load->model('currencies_model');
      $data['currencies'] = $this->currencies_model->get();
      $data['liabilities_prev'] = $this->suppliers_model->get_prev_groups(2);
      $data['expenses_prev'] = $this->suppliers_model->get_prev_groups(5);


      $this->load->model('settings_model');
      $default_options = $this->settings_model->getOptions();
      $data['default_options'] = $default_options;
      $data['prev'] = $this->suppliers_model->get_prev_groups2();
      $data['ledgers'] = $this->suppliers_model->get_ledgers();
		$data['user_notes'] = $this->misc_model->get_supplier_notes($id,0);
      	$data['title'] = $title;
		$this->load->view('admin/supplier/supplier',$data);
	}
	public function view($id = ''){

		if($this->input->post() && !$this->input->is_ajax_request()){
			if(!has_permission('manageClients')){
				access_denied('manageClients');
			}

			if($id == ''){
				$id = $this->suppliers_model->add($this->input->post());
				if($id){
					// set_alert('success', _l('added_successfuly',_l('supplier')));
                                        
          if (trim($this->input->post('action')) == 'save') {
            set_alert('success', _l('added_successfuly',_l('supplier')));
            redirect(admin_url('suppliers/supplier/'.$id));
            exit;
          }
          if (trim($this->input->post('action')) == 'snew') {
            set_alert('success', _l('added_successfuly',_l('supplier')));
            redirect(admin_url('suppliers/supplier'));
            exit;
          }

          if (trim($this->input->post('action')) == 'slist') {
            set_alert('success', _l('added_successfuly',_l('supplier')));
            redirect(admin_url('suppliers'));

          }
          if (trim($this->input->post('action')) == 'cancel') {
            redirect(admin_url());
            exit;
          }
					
				}
			} else {
				$success = $this->suppliers_model->update($this->input->post(),$id);
				if($success){
					// set_alert('success', _l('updated_successfuly',_l('supplier')));
          if (trim($this->input->post('action')) == 'save') {
            set_alert('success', _l('updated_successfuly',_l('supplier')));
            redirect(admin_url('suppliers/supplier/'.$id));
            exit;
          }
          if (trim($this->input->post('action')) == 'snew') {
            set_alert('success', _l('updated_successfuly',_l('supplier')));
            redirect(admin_url('suppliers/supplier'));
            exit;
          }

          if (trim($this->input->post('action')) == 'slist') {
            set_alert('success', _l('updated_successfuly',_l('supplier')));
            redirect(admin_url('suppliers'));

          }
          if (trim($this->input->post('action')) == 'cancel') {
            redirect(admin_url());
            exit;
          }

				}
				
			}
		}

		if($id == ''){
			$title = _l('add_new',_l('supplier_lowercase'));
		} else {
			$this->load->model('tickets_model');
			$supplier = $this->suppliers_model->get($id);
                        $contact   = $this->suppliers_model->get_contact($id);
			$this->load->model('payment_modes_model');
			$data['payment_modes'] = $this->payment_modes_model->get();
			$data['supplier'] = $supplier;
      $data['contact'] = $contact;
      $data['prev_supplier'] = $this->suppliers_model->get_prev($id);
      $data['next'] = $this->suppliers_model->get_next($id);

      $data['supplier_groups'] = $this->suppliers_model->get_supplier_groups($id);

			$title = $supplier->supplier;
			// Get all active staff members (used to add reminder)
			$this->load->model('staff_model');
			$data['members'] = $this->staff_model->get('',1);
                        
			if($this->input->is_ajax_request()){
				
				AdminTicketsTable(array('userid'=>$id));
			}

            
		}

      $data['groups'] = $this->suppliers_model->get_groups();
      $this->load->model('currencies_model');
      $data['currencies'] = $this->currencies_model->get();
	  $data['currency_symbol'] = $this->currencies_model->get_base_currency()->symbol;
      $data['liabilities_prev'] = $this->suppliers_model->get_prev_groups(2);
      $data['expenses_prev'] = $this->suppliers_model->get_prev_groups(5);

	  
	   
	    $this->db->select('sum(tblpurchaseorders.total) as tot ,tblpurchaseorders.supplierid, count(id) as nb');
        $this->db->from('tblpurchaseorders'); 
		$this->db->join('tblgrns', 'tblgrns.po_id = tblpurchaseorders.id AND tblgrns.supplierid = tblpurchaseorders.supplierid', 'left outer');
        $this->db->where('tblpurchaseorders.supplierid',$id);
        $this->db->where('tblgrns.`po_id`',NULL);
	   
	   		
		
        $pur_orders = $this->db->get()->result();
		$data["total_purchase_orders"]=$pur_orders[0]->tot;
		$data['nb_purchase_orders']=$pur_orders[0]->nb;
	
		$this->db->select('sum(total) as tot');
        $this->db->from('tblbills');       
        $this->db->where('supplierid',$id);
        $pur_orders = $this->db->get()->result();
		$data["total_bills"]=$pur_orders[0]->tot;
		// current bills
		$this->db->select('sum(total) as tot , count(billid) as nb ');
        $this->db->from('tblbills');       
        $this->db->where('supplierid',$id);
        $this->db->where('status','1');
        $bill_orders = $this->db->get()->result();
		$data["total_bills_current"]=$bill_orders[0]->tot;
		$data['nb_bills_current']=$bill_orders[0]->nb;
		// over due bils
 		$this->db->select('sum(total) as tot, count(billid) as nb');
        $this->db->from('tblbills');       
        $this->db->where('supplierid',$id);
        $this->db->where('status','3');
        $bill_orders1 = $this->db->get()->result();
		$data["total_bills_overdue"]=$bill_orders1[0]->tot;
		$data['nb_bills_overdue']=$bill_orders1[0]->nb;	
		// active grns
	    $this->db->select('sum(tblpurchaseorders.total) as tot ,tblpurchaseorders.supplierid, count(id) as nb');
        $this->db->from('tblpurchaseorders'); 
		$this->db->join('tblbills', 'tblbills.po_id = tblpurchaseorders.id AND tblbills.supplierid = tblpurchaseorders.supplierid', 'left outer');
        $this->db->where('tblpurchaseorders.supplierid',$id);
        $this->db->where('tblbills`.`po_id`',NULL);
        $grn_bills = $this->db->get()->result();
		$data["total_grn_amount"]=$grn_bills[0]->tot;
		$data['nb_grn_active']=$grn_bills[0]->nb;
/*echo '<pre>';
print_r($this->db->last_query());
echo '</pre>';*/
		// '<pre>';
		//print_r($grn_bills);
	
	
	
	
	
		$data["total_bills_overdue"]=$bill_orders1[0]->tot;
		$data['nb_bills_overdue']=$bill_orders1[0]->nb;	
		
		
		

      $this->load->model('settings_model');
      $default_options = $this->settings_model->getOptions();
      $data['default_options'] = $default_options;
      $data['prev'] = $this->suppliers_model->get_prev_groups2();
      $data['ledgers'] = $this->suppliers_model->get_ledgers();
		$data['user_notes'] = $this->misc_model->get_supplier_notes($id,0);
      	$data['title'] = $title;
		
		$this->load->view('admin/supplier/view',$data);
	}

  public function filldata(){
    echo json_encode($this->suppliers_model->filldata($this->input->post('id')));
  }
        
    /*get Contact*/
    function getContactDetails()
    {
       $id=$_REQUEST['id'];
       $contact = $this->clients_model->getSingleRecord('tblclientcontacts', array('id' => $id));
       echo json_encode($contact);
    }
        
     /*get Contact*/
    function getContactDetailsById($id)
    {
       $contact = $this->clients_model->getSingleRecord('tblclientcontacts', array('id' => $id));
       return $contact;
    }
        
        
    /*Update Contacts*/
    function updateContacts()
    {
         $data_contact=array('salutation' => $_REQUEST['salutation'],
        'firstname' => $_REQUEST['firstname'],
        'lastname'  => $_REQUEST['lastname'],
        'country'  => $_REQUEST['country'],
        'address'  => $_REQUEST['address'],
        'city'     => $_REQUEST['city'],
        'state'    => $_REQUEST['state'],
        'zip'      => $_REQUEST['zip'],
        'phoneno'  => $_REQUEST['phoneno'],
        'mobileno' => $_REQUEST['mobileno'],
        'fax'      => $_REQUEST['fax'],
        'email'    => $_REQUEST['email'],
        'skypeid'  => $_REQUEST['skypeid'],
        'position' => $_REQUEST['position'],
        'status'   => $_REQUEST['status'],
        'userid'   => $_REQUEST['userid']);
        
        $contactid=  $_REQUEST['contactid'];
        $id = $this->clients_model->updateContacts($data_contact,$contactid);
        if($id=='1')
        {
           set_alert('success',_l('client_contact_update_success_action',_l('client_lowercase'))); 
        }
        else
        {
           set_alert('warning',_l('client_contact_update_error_action',_l('client_lowercase'))); 
        }
        echo $id;
    }
        
    /*Delete Contact*/
    function deletecontact()
    {
        $id=$_REQUEST['id'];
        $res = $this->suppliers_model->DeleteContacts($id);
        if($res=='1')
        {
            set_alert('success', _l('client_contact_delete_success_action',_l('client')));
        }
        else
        {
           set_alert('success', _l('client_contact_delete_error_action',_l('client')));
        }
        echo $res;
    }
        
       /* add contact */
    public function insert_contact(){    
        $data_contact=array('salutation' => $_REQUEST['salutation'],
        'firstname' => $_REQUEST['firstname'],
        'lastname'  => $_REQUEST['lastname'],
        'country'  => $_REQUEST['country'],
        'address'  => $_REQUEST['address'],
        'city'     => $_REQUEST['city'],
        'state'    => $_REQUEST['state'],
        'zip'      => $_REQUEST['zip'],
        'phoneno'  => $_REQUEST['phoneno'],
        'mobileno' => $_REQUEST['mobileno'],
        'fax'      => $_REQUEST['fax'],
        'email'    => $_REQUEST['email'],
        'skypeid'  => $_REQUEST['skypeid'],
        'position' => $_REQUEST['position'],
        'status'   => $_REQUEST['status'],
        'userid'   => $_REQUEST['userid']);
		    $id = $this->clients_model->addcontact($data_contact);
        if($id=='1')
        {
           set_alert('success',_l('client_contact_insert_success_action',_l('client_lowercase'))); 
        }
        else
        {
           set_alert('warning',_l('client_contact_insert_error_action',_l('client_lowercase'))); 
        }
        echo $id;
    }
	

	/* Delete client */
	public function delete($id){

		if(!has_permission('manageClients')){
			access_denied('manageClients');
		}

		if(!$id){
			redirect(admin_url('suppliers'));
		}

		$response = $this->suppliers_model->delete($id);

		if(is_array($response) && isset($response['referenced'])){
			set_alert('warning',_l('is_referenced',_l('supplier_lowercase')));
		} else if($response == true){
			set_alert('success', _l('deleted',_l('supplier')));
		} else {
			set_alert('warning', _l('problem_deleting',_l('supplier_lowercase')));
		}

		redirect(admin_url('suppliers'));
	}

    function billdelete($id)
    {
        $id=$_REQUEST['id'];
        $res = $this->suppliers_model->deletebill($id);
        if($res=='1')
        {
            set_alert('success', _l('bill'));
        }
        else
        {
           set_alert('success', _l('bill'));
        }
        echo $res;
    }

	/* Change client status / active / inactive */
	public function change_supplier_status($id,$status){

		if(!has_permission('manageClients')){
			access_denied('manageClients');
		}

		if($this->input->is_ajax_request()){
			$this->suppliers_model->change_supplier_status($id,$status);
		}
	}
	/* Get client by id - used in ajax request */
	public function get_client_by_id_ajax($id){

		if(!$id){
			redirect(admin_url('clients'));
		}

		if(!has_permission('manageClients')){
			access_denied('manageClients');
		}
		if($this->input->is_ajax_request()){
			echo json_encode($this->clients_model->get($id));
		}
	}
	/* Since version 1.0.2 add client reminder */
	public function add_supplier_reminder($id){
		if(!has_permission('manageClients')){
			access_denied('manageClients');
		}

		if($this->input->post()){
			$success = $this->suppliers_model->add_reminder($this->input->post(),$id);
			if($success){
				set_alert('success',_l('supplier_reminder_added_successfuly'));
			}
		}

		redirect(admin_url('suppliers/supplier/'.$id));
	}

	public function get_client_reminders($id){
		if($this->input->is_ajax_request()){

			$aColumns = array( 'description', 'date', 'staff', 'isnotified');
			$sIndexColumn = "id";
			$sTable = 'tbladminsupplierreminders';

			$where = array('AND clientid='.$id);
			$join = array(
				'JOIN tblstaff ON tblstaff.staffid = tbladminsupplierreminders.staff'
				);
			$result = data_tables_init($aColumns,$sIndexColumn,$sTable,$join,$where,array('firstname','lastname','id','creator'));
			$output = $result['output'];
			$rResult = $result['rResult'];

			foreach ( $rResult as $aRow )
			{
				$row = array();
				for ( $i=0 ; $i<count($aColumns) ; $i++ )
				{
					$_data = $aRow[ $aColumns[$i] ];
					if($aColumns[$i] == 'staff'){
						$_data = '<a href="'.admin_url('staff/profile/'.$aRow['staff']).'">'.staff_profile_image($aRow['staff'], array(
							'staff-profile-image-small'
							)) . ' ' . $aRow['firstname'] . ' ' . $aRow['lastname'] .'</a>';
					} else if($aColumns[$i] == 'staff'){
						$_data = _d($_data);
					} else if($aColumns[$i] == 'isnotified'){
						if($_data == 1){
							$_data = _l('client_reminder_is_notified_boolean_yes');
						} else {
							$_data = _l('client_reminder_is_notified_boolean_no');
						}
					}
					$row[] = $_data;
				}

				if($aRow['creator'] == get_staff_user_id()){
					$row[] = icon_btn('admin/suppliers/delete_reminder/'.$id . '/'. $aRow['id'], 'remove', '');
				} else {
					$row[] = '';
				}


				$output['aaData'][] = $row;
			}

			echo json_encode( $output );
			die();
		}
	}

	public function get_purchasegrn($id){
		if ($this->input->is_ajax_request()) {
            // From client profile
            // if(is_numeric($clientid)){
            //     if(!$has_permission){
            //         echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
            //         die;
            //     }
            // }

            $aColumns = array(
                'number',
                'date',
                'supplierid',
                'refrence',
             );

            $join = array(
                'LEFT JOIN tblsuppliers ON tblsuppliers.userid = tblgrns.supplierid',
                // 'LEFT JOIN tblcurrencies ON tblcurrencies.id = tblinvoices.currency'
            );

            $where = array('AND supplierid='.$id);

            // if (is_numeric($clientid)) {
            //     $where                    = array(
            //         'AND clientid=' . $clientid
            //     );

            // }

            // if ($this->input->post('status')) {
            //     array_push($where, 'AND status=' . $this->input->post('status'));
            // }

          

            $sIndexColumn = "grnid";
            $sTable       = 'tblgrns';
            $result       = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array('grnid','supplier'));
            $output       = $result['output'];
            $rResult      = $result['rResult'];
  			// echo "<pre>";
  			// print_r($rResult);
  			// die;
            foreach ($rResult as $aRow) {
                $row = array();

                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data                    = $aRow[$aColumns[$i]];
                      if ($aColumns[$i] == 'number') {
                          // $_data =format_grn_number($aRow['number']);
                          $_data = '<a href="' . admin_url('grns/list_grns/' . $aRow['grnid']) . '">' . format_grn_number($aRow['number']) . '</a><br />';
                      }
                      if ($aColumns[$i] == 'supplierid') {
                          $_data ='<a href="' . admin_url('suppliers/supplier/' . $aRow['supplierid']) . '">' . $aRow['supplier'] . '</a>';
                      }
                      if ($aColumns[$i] == 'date') {
                          $_data =_d($aRow['date']);
                      }
                    $row[] = $_data;
                }
                
                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }
	}

	/* Since version 1.0.2 delete client reminder */
	public function delete_reminder($clientid,$id){
		if(!$id && !$clientid){
			die('No reminder found');
		}
		$success = $this->suppliers_model->delete_reminder($id);

		if($success) {
			set_alert('success',_l('supplier_reminder_deleted'));
		} else {
			set_alert('warning',_l('supplier_reminder_failed_to_delete'));
		}

		redirect(admin_url('suppliers/supplier/'.$clientid));
	}
	
    public function list_contacts($id = false, $clientid = false) {
        $has_permission = has_permission('manageSales');

        if (!$has_permission && !$this->input->is_ajax_request()) {
            access_denied('manageSales');
        }


        if ($this->input->is_ajax_request()) {
            // From client profile
            if (is_numeric($clientid)) {
                if (!$has_permission) {
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                'firstname',
                'lastname',
                'email',
                'mobileno',
                'phoneno',
                'id'
            );

            $where = array();
            if (is_numeric($clientid)) {
                $where = array(
                    'where userid=' . $clientid
                        //'userid' => $clientid
                );
            }
            //print_r($where);
            $sIndexColumn = "id";
            $sTable = 'tblsuppliercontacts';
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $where,array(),array('userid'));
            $output = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();
                // $company .= '<small class="text-muted"> ' . $aRow['firstname'] . ' ' . $aRow['lastname'] . '</small>';
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];

                    if ($aColumns[$i] == 'firstname') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'firstname') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'lastname') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'email') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'mobileno') {
                        $__data = ($aRow['mobileno']!= '0') ? $aRow['mobileno'] : '';
                    } else if ($aColumns[$i] == 'phoneno') {
                        $__data = ($aRow['phoneno']!= '0') ? $aRow['phoneno'] : '';
                    } else if ($aColumns[$i] == 'id') {
                        //$__data ='<a href="javascript:void(0);" class="editcontact" data-id="'.$aRow['id'].'">Edit</a> | <a href="' . admin_url('clients/deletecontact/' . $aRow['id']) . '" class="editcontact" data-id="'.$aRow['id'].'">Delete</a><br />';
                        $options = icon_btn('#' . $aRow['id'], 'pencil-square-o', 'btn-default editcontact', array(
                            'data-toggle' => 'modal',
                            'data-target' => '#supplier_contact_modal',
                            'title' =>'Edit Contact',
                            'data-id' => $aRow['id'],
                            'data-client' => $aRow['userid']
                        ));
						//                        $options = icon_btn('admin/suppliers/contact/'.$aRow['userid'].'/'.$aRow['id'], 'pencil-square-o', 'editcontact', array('data-id' => $aRow['id']));
                        $row[] = $options .= icon_btn('admin/suppliers/deletecontact/' . $aRow['id'], 'remove', ' deletecontact', array('data-id' => $aRow['id']));
                    }


                    $row[] = $__data;
                }
                $output['aaData'][] = $row;
            }
            echo json_encode($output);
            die();
        }

        $data['invoiceid'] = '';
        if (is_numeric($id)) {
            $data['invoiceid'] = $id;
        }

        $data['custom_view'] = $_custom_view;
        $data['status'] = $_status;

        $data['bodyclass'] = 'small-table';
        $data['title'] = _l('invoices');
        $this->load->view('admin/invoices/manage', $data);
    }

    public function contact($customerid = '',$id = '') {
        $this->load->model('suppliers_model');
        $data['clients'] = $this->suppliers_model->get();
        /* add contact */
        if ($this->input->post()) {
          if ($id == '') {
                $id = $this->suppliers_model->addcontact($customerid);
                if ($id) {
                    set_alert('success', _l('supplier_contact_insert_success_action', _l('client_lowercase')));
                    redirect(admin_url('suppliers/contact/'.$customerid .'/'.$id));
                }
            } else {
                $success = $this->suppliers_model->updateContacts($id);
                if ($success) {
                    set_alert('success', _l('updated_successfuly', _l('contact')));
                }
               redirect(admin_url('suppliers/contact/'.$customerid .'/'.$id));
            }
        }
        
        if ($id == '') {
            $title = _l('add_new',_l('contact'));
        } else {
            $data['contact'] = $this->suppliers_model->get_where_record('tblsuppliercontacts',$id);
           $title = _l('edit',_l('contact'));
        }
        
        if(isset($data['contact'])){
            $customerid = $data['contact']->userid;
        }
        $data['customerdetails'] = $this->suppliers_model->get_client($customerid);
		       // $data['department'] = $this->suppliers_model->get_departments();
        $data['id']=$id;
        $data['customerid']=$customerid;
        $data['title'] = $title;
        $this->load->view('admin/supplier/contact', $data);
    }


    public function manage()
    {
        if ($this->input->post()) {
            $data = $this->input->post();
            if ($data['contactid'] == '') {
                $message = '';
                $success = $this->suppliers_model->addcontact($data);
                if($success) {
                    $message = _l('added_successfuly','Contact');
                }
                echo json_encode(array(
                    'success' => $success,
                    'message'=>$message
                ));
            } else {
                $message = '';
                $success = $this->suppliers_model->updateContacts($data);
                if($success){
                    $message = _l('updated_successfuly','Contact');
                }
                echo json_encode(array(
                    'success' => $success,
                    'message'=>$message
                ));
            }
        }
    }

    public function getcontact(){
      echo json_encode($this->suppliers_model->getcontact($this->input->post('id')));
    }
    public function purchaseorders($id = false, $clientid = false)
    {
      
      $has_permission = has_permission('manageSales');

      if(!$has_permission && !$this->input->is_ajax_request()){
        access_denied('manageSales');
      }

         $_status = '';

        if($this->input->get('status')){
          $_status = $this->input->get('status');
        }

        if ($this->input->is_ajax_request()) {
            // From client profile
            if(is_numeric($clientid)){
                if(!$has_permission){
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                'number',
                'podate',
                'total',
                'tblcurrencies.name',
                'expecteddate',
                'status'
            );

            $join = array(
                'LEFT JOIN tblsuppliers ON tblsuppliers.userid = tblpurchaseorders.supplierid',
                'LEFT JOIN tblcurrencies ON tblcurrencies.id = tblpurchaseorders.currency'
            );

            $where                    = array();

            if (is_numeric($id)) {
                $where= array(
                    'AND supplierid=' . $id
                );
            }


            if ($this->input->post('status')) {
                array_push($where, 'AND status=' . $this->input->post('status'));
            }

            if($this->input->post('custom_view')){
                $custom_view = $this->input->post('custom_view');
                if($custom_view == 'not_sent'){
                     array_push($where,'AND sent=0');
                 }
            }
 
            $sIndexColumn = "id";
            $sTable       = 'tblpurchaseorders';
            $result       = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array(
                'tblpurchaseorders.id',
                'invoiceid',
                'hash',
                'supplier',
                'symbol',
                'tblcurrencies.name',
                'total',
                'status'
            ));
            $output       = $result['output'];
            $rResult      = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();

                
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data                    = $aRow[$aColumns[$i]];

                    if ($aColumns[$i] == 'number') {
                        // If is from client area table
                    // if (is_numeric($clientid)) {
                        $__data = '<a href="' . admin_url('purchaseorders/list_purchaseorders/' . $aRow['id']) . '">' . format_purchaseorder_number($_data) . '</a><br />';
                    // } else {
                    //        $__data = '<a href="#" onclick="init_purchaseorder(' . $aRow['id'] . '); return false;">' . format_purchaseorder_number($_data) . '</a><br />';
                    // }
                    } else if ($aColumns[$i] == 'podate') {
                        $__data = _d($_data);
                    }else if ($aColumns[$i] == 'expecteddate') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'expirydate') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'total') {
                        $__data = format_money($_data, $aRow['symbol']);
                    }else if ($aColumns[$i] == 'tblcurrencies.name') {
                         $__data = $aRow['tblcurrencies.name'];
                    } else if($aColumns[$i] == 'status') {
                        $__data = format_purchaseorder_status($aRow['status']);
                        // Status
                    }
                    $row[] = $__data;
                }
              //  $options='';

              //  $options .= icon_btn('#','print','printorder',array('data-toggle' => 'tooltip', 'title' =>'Print Purchase Order','data-id'=>$aRow['id'],'data-hash'=>$aRow['hash']));
              // $options .= icon_btn('admin/purchaseorders/pdf/' . $aRow['id'],'download','',array('data-toggle' => 'tooltip', 'title' =>'Download Purchase Order'));
              //   $options .= icon_btn('#', 'eye','',array('data-toggle' => 'tooltip', 'title' =>_l('view_order'), 'onclick'=>'init_purchaseorder('.$aRow['id'].'); return false;'));
              //  if($aRow['status'] != 5){
              //   $options .= icon_btn('admin/purchaseorders/delete/' . $aRow['id'], 'remove', ' btn-delete-customer', array('data-toggle' => 'tooltip', 'title' =>'Delete Purchase Order'));
              //  }
              //   $row[] =$options;
                 $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }
    }
    public function notes($id) {
        if ($this->input->is_ajax_request()) {

            $aColumns = array('description', 'staff','dateadded');
            $sIndexColumn = "usernoteid";
            $sTable = 'tblsupplieradminnotes';

            $where = array('AND userid=' . $id);
            $join = array(
                'JOIN tblstaff ON tblstaff.staffid = tblsupplieradminnotes.addedfrom'
            );
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array('firstname','lastname','usernoteid'));
            $output = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];
                    if ($aColumns[$i]== 'staff') {
                          $_data = '<a href="'.admin_url( 'profile/'.$aRow[ 'addedfrom']). '">'.$aRow[ 'firstname'] . ' ' . $aRow[ 'lastname'] . '</a>';
                    }
                    $row[] = $_data;
                }
                
                    $row[] = icon_btn('admin/misc/remove_supplier_note/'. $aRow['usernoteid'] . '/' . $id .'/0', 'remove', '');

                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }
    }

    public function groups() {
        if ($this->input->is_ajax_request()) {
            $aColumns = array('name','class_is_active');

            $sIndexColumn = "id";
            $sTable = 'tblsuppliersgroups';

            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, array(), array(), array('id'));
            $output = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];
                    if ($aColumns[$i] == 'class_is_active') {
                        if ($aRow['class_is_active'] == '0') {
                            $_data = '<input class="ischeckbox"  data-rowid="' . $aRow['id'] . '" value="' . $aRow['class_is_active'] . '" type="checkbox"/>';
                        } else {
                            $_data = '<input class="ischeckbox"  data-rowid="' . $aRow['id'] . '" checked="checked" value="' . $aRow['class_is_active'] . '" type="checkbox"/>';
                        }
                    }
                    $row[] = $_data;
                }
                $options = icon_btn('#', 'pencil-square-o', 'btn-default', array('data-toggle' => 'modal', 'data-target' => '#supplier_group_modal', 'data-id' => $aRow['id']));
                $row[] = $options .= icon_btn('admin/suppliers/delete_group/' . $aRow['id'], 'remove', '',array('onClick' => 'return deleteconf();'));

                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        // $this->load->model('settings_model');
        // $default_options = $this->settings_model->getOptions();
        // // $data['default_options'] = $default_options;
        
        // $data['option'] = $default_options['account_receivable'];


         $this->load->model('staff_model');
         $data['suppliers'] = $this->suppliers_model->get();
         $data['staff'] = $this->staff_model->get('', 1);
         $data['liabilities_prev'] = $this->suppliers_model->get_prev_groups(2);
         $data['expenses_prev'] = $this->suppliers_model->get_prev_groups(5);

         // echo "<pre>";
         // print_r($data['prev']);
         // die;

        


         $data['ledgers'] = $this->suppliers_model->get_ledgers();
         $this->load->model('currencies_model');
         $data['currencies'] = $this->currencies_model->get();

        // $this->load->model('settings_model');
        // $default_options = $this->settings_model->getOptions();
        // $data['default_options'] = $default_options;


        
         $data['title'] = _l('suppliers_groups');
         $this->load->view('admin/supplier/groups_manage', $data);
    }

    public function group() {
        if ($this->input->is_ajax_request()) {
            $data = $this->input->post();
            
            // print_r($data);
            // die;
            if ($data['id'] == '') {
                $success = $this->suppliers_model->add_group($data);
                $message = '';
                if ($success == true) {
                    $message = _l('added_successfuly', _l('suppliers_groups'));
                }
                echo json_encode(array('success' => $success, 'message' => $message));
            } else {
        
                $success = $this->suppliers_model->edit_group($data);
                $message = '';
                if ($success == true) {
                    $message = _l('updated_successfuly', _l('suppliers_groups'));
                }
                echo json_encode(array('success' => $success, 'message' => $message));
            }
        }
    }

    public function add_update_group() {
        if ($this->input->is_ajax_request()) {
            $data = $this->input->post();
            
            // print_r($data);
            // die;
            if ($data['id'] == '') {
                $success = $this->suppliers_model->add_group($data);
                $message = '';
                if ($success == true) {
                    $message = _l('added_successfuly', _l('suppliers_groups'));
                }
                echo json_encode(array('success' => $success, 'message' => $message));
            } else {
        
                $success = $this->suppliers_model->edit_group($data);
                $message = '';
                if ($success == true) {
                    $message = _l('updated_successfuly', _l('suppliers_groups'));
                }
                echo json_encode(array('success' => $success, 'message' => $message));
            }
        }
    }

    public function changestatus() {
        echo $this->suppliers_model->changestatus();
    }

    public function getclass(){
      echo  json_encode($this->suppliers_model->getclass());
    }

    public function delete_group($id) {

        if (!$id) {
            redirect(admin_url('suppliers/groups'));
        }

        $response = $this->suppliers_model->delete_group($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('supplires_groups_lowercase')));
        } else if ($response == true) {
            set_alert('success', _l('deleted', _l('suppliers_groups')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('supplires_groups_lowercase')));
        }

        redirect(admin_url('suppliers/groups'));
    }

}