<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Reports extends Admin_controller {

	
	public $list_groups;
	public $specialIDs_Total;
	public $removedLedgers;
	public $totalDebit=0;
	public $totalCredit=0;
	public $ledgers=array();
    function __construct() {
        parent::__construct();
        if (!has_permission('watchReports')) {
            access_denied('watchReports');
        }
        $this->load->model('reports_model');
    }

    function search_tree_by_column($tree, $column, $column_value) {
        global $_column, $_column_value;
        $_column = $column;
        $_column_value = $column_value;
        $filter_array = array_filter($tree, function($a) {
            global $_column, $_column_value;
            return (strtolower($a[$_column]) == strtolower($_column_value));
        });
        return $filter_array;
    }

    function get_total($id, $from = '', $to = '') {
        $this->db->select_sum('tblvoucherlines.amount');
        $this->db->from('tblvoucherlines');
        $this->db->join('tblvoucher', 'tblvoucher.vchid=tblvoucherlines.vchid');
        if ($from != '' && $to != '') {
            $this->db->where('tblvoucher.trxdate >=', $from);
            $this->db->where('tblvoucher.trxdate <=', $to);
        }
        $this->db->where('ledger', $id);
        return $this->db->get()->result_array();
    }
	function get_all_subgroups($id)
	{
		$sql = "SELECT id FROM tblledgergroups where id='".$id."' or parent =".$id;
		$array1 = $this->db->query($sql)->result_array();
		$tab=array();
		foreach($array1 as $a)
		{
			$tab[]=$a["id"];
		}
		$list_str="(" . implode(',', array_map('intval', $tab)) . ")";
		return ($list_str);
	}
	function get_report_group($ind,$id=0,$from,$to)
	{

		if($from == "")
		{
			$from = date('Y-m-01');
		}

		if($to == "")
		{
			$to = date('Y-m-d');
		}


		if($id==0)
			$main_id=$this->list_groups[$ind]["id"];
		else
			$main_id=$id;
		
		$credit_or_debit=$this->list_groups[$ind]["credit_or_debit"];
		
		$sql = "SELECT * FROM tblledgergroups where id =".$main_id;
		$groupes = $this->db->query($sql)->result_array();
		$groupe=$groupes[0];

		
		
		if($groupe["parent"]==0)
		{
			$data='"amount": ""';
			$this->list_groups[$ind]["title"]=$groupe["name"];
		}
		else
		{

			// "select sum(a.amount) as amount from  tblvoucherlines a JOIN tblvoucher b ON a.vchid=b.vchid where (b.trxdate BETWEEN '2016-01-01' AND '2017-07-25') and  (a.amount_type = 1) and (a.ledger = 47)"

			// echo $groupe['id'];
			// echo "<br>";
			
			
			
			$in=$this->get_all_subgroups($groupe['id']);
			
			if(isset($this->specialIDs_Total[$groupe['id']]))
			{
				$val=$this->specialIDs_Total[$groupe['id']];
				$credit_amount[0]['amount']=0;
				$debit_amount[0]['amount']=0;
				
					
						if($val>0)
							$debit_amount[0]['amount']=$val; 
						else
							$credit_amount[0]['amount']=$val;
				
			}
			else
			{
			$credit_amount = $this->db->query("select sum(a.amount) as amount from  tblvoucherlines a , tblvoucher b where a.vchid=b.vchid and (b.trxdate BETWEEN '".$from."' AND '".$to."') and  a.amount_type = 1 and ledger = ".$groupe['id'])->result_array();
			
				
			// $debit_amount = $this->db->query("select sum(a.amount) as amount from  tblvoucherlines a , tblvoucher b where a.vchid=b.vchid and and (b.trxdate BETWEEN '".$from."' AND '".$to."') and a.amount_type = 0 and ledger = ".$groupe['id'])->result_array();
			$debit_amount = $this->db->query("select sum(a.amount) as amount from  tblvoucherlines a , tblvoucher b where a.vchid=b.vchid and (b.trxdate BETWEEN '".$from."' AND '".$to."') and  a.amount_type = 0 and ledger = ".$groupe['id'])->result_array();
			
			}
			$this->list_groups[$ind]["debit_amount"] += $debit_amount[0]['amount'];
			$this->list_groups[$ind]["credit_amount"] +=  $credit_amount[0]['amount'];
			
			
			
			if($this->list_groups[$ind]["credit_or_debit"]=="debit")
			{
				if((($debit_amount[0]['amount']==0)&&($credit_amount[0]['amount']==0))||($debit_amount[0]['amount']==$credit_amount[0]['amount']))
				$data='"debit": "" ,"credit": ""'; 
				else
				{
					
					
					if($debit_amount[0]['amount']>$credit_amount[0]['amount'])
					{
						$t1 = $debit_amount[0]['amount']-$credit_amount[0]['amount'];
						
						$data='"debit": "'.number_format($t1,2).'" ,"credit": ""'; 
					}
					else
					{
						$t1 = $credit_amount[0]['amount']-$debit_amount[0]['amount'];
						$data='"debit": "" ,"credit": "'.number_format($t1,2).'"'; 
					}
				}
			}
			else
			{
				$t1 = abs($credit_amount[0]['amount']-$debit_amount[0]['amount']);
				if(isset($this->specialIDs_Total[$groupe['id']]))
					$t1	=$this->specialIDs_Total[$groupe['id']];
				if($t1==0)	
					$data='"amount": ""'; 
				else
					$data='"amount": "'.number_format($t1,2).'"';
			}
			
		
			
		}
		$json = $json . 
			'
			{
			"id": "'.$main_id.'",
			"name": "'.$groupe["name"].'",
			"path": "'.$groupe["path"].'",
			"text": "'.$groupe["name"].'",
			"parent_id": "'.$groupe["parent"].'",
			"type": "'.$groupe["type"].'",
			"data": {'.$data.'},
			';
	
		$json = $json . '"children": [';
		$sql = "SELECT * FROM tblledgergroups where parent = ".$main_id;
		$array2 = $this->db->query($sql)->result_array();
		$i=0;
		
		foreach ( $array2 as $row2)
		{
			if(isset($this->removedLedgers[$row2["id"]]))
			continue;
			$i++;
			if($i>1)
				$json.=",";
				
			$json.=$this->get_report_group($ind,$row2["id"],$from,$to);
		}
		
		$json = $json . ']}';		  
		return $json;
	}
	function display_total_group($ind)
	{
		
		if($this->list_groups[$ind]["credit_or_debit"]=="debit")
		{
			if($this->list_groups[$ind]["debit_amount"] > $this->list_groups[$ind]["credit_amount"])
			{
				$t1 = $this->list_groups[$ind]["debit_amount"]-$this->list_groups[$ind]["credit_amount"];
				
				$data='"debit": "'.number_format($t1,2).'" ,"credit": ""'; 
			}
			else
			{
				$t1 = $this->list_groups[$ind]["credit_amount"]-$this->list_groups[$ind]["debit_amount"];
				$data='"debit": "" ,"credit": "'.number_format($t1,2).'"'; 
			}
		}
		else
		{
			$t1 = abs($this->list_groups[$ind]["credit_amount"]-$this->list_groups[$ind]["debit_amount"]);
				
			$data='"amount": "'.number_format($t1,2).'"'; 
		}
		
		$json = '
			,{
			"id": "total_'.$this->list_groups[$ind]["id"].'",
			"name": "Total '.$this->list_groups[$ind]["title"].'",
			"path": "Total '.$this->list_groups[$ind]["title"].'",
			"text": "Total '.$this->list_groups[$ind]["title"].'",
			"parent_id": 0,
			"type": "Group",
			"data": {
				'.$data.'
			}
		}';
		return $json;
			
	}
	function _test_2($parent_id = 0, $from, $to) {

		$json ='';
		$json = $json . '[';
		$sql = "SELECT * FROM tblledgergroups where parent = 0";
		$array2 = $this->db->query($sql)->result_array();
		$i=0;
		$listInd=array();
		$debit=0;
		$credit=0;
		foreach ( $array2 as $row2)
		{	
			$i++;
			if($i>1)
				$json.=",";
			$json.=$this->create_one_group($row2["id"],"debit",$from, $to); 

			if($this->list_groups[$row2["id"]]["debit_amount"]>$this->list_groups[$row2["id"]]["credit_amount"])
			{
				$debit+=$this->list_groups[$row2["id"]]["debit_amount"]-$this->list_groups[$row2["id"]]["credit_amount"];
				
				
			}
			else
			{
				$credit+=$this->list_groups[$row2["id"]]["credit_amount"]-$this->list_groups[$row2["id"]]["debit_amount"];
				
			}

			// $debit+=$this->list_groups[$row2["id"]]["debit_amount"];
			// $credit+=$this->list_groups[$row2["id"]]["credit_amount"];
			$listInd[]=$row2["id"];
		}
		
		$eq_liab_credit=$this->list_groups[2]["credit_amount"]+$this->list_groups[4]["credit_amount"];
		$eq_liab_debit=$this->list_groups[2]["debit_amount"]+$this->list_groups[4]["debit_amount"];
		if($eq_liab_credit>$eq_liab_debit)
		{
			$t4 = $eq_liab_credit-$eq_liab_debit;
			$data='"debit": "" ,"credit": "'.number_format($t4,2).'"';
		}
		else
		{
			$t4 = $eq_liab_debit-$eq_liab_credit;
			$data='"credit": "" ,"debit": "'.number_format($t4,2).'"';
		}
		$json.=',{
		"id": "total_liabilities_equity",
		"name": "Total Liabilities and Equity",
		"path": "Total Liabilities and Equity",
		"text": "Total Liabilities and Equity",
		"parent_id": 0,
		"type": "Group",
		"data": {'.$data.'
			
		}
	},{
		"id": "total_debit_credit",
		"name": "Total",
		"path": "Total",
		"text": "Total",
		"parent_id": 0,
		"type": "Group",
		"data": {
			"debit": "'.number_format($debit,2).'" ,"credit": "'.number_format($credit,2).'"
		}
	}';
	
		$json = $json . ']';
		
		return $json;
	}
	function create_one_group($id,$credit_or_debit,$from = null, $to = null)
	{
		$this->list_groups[$id]=array("id"=>$id,"credit_or_debit"=>$credit_or_debit,"title"=>"","credit_amount"=>0,"debit_amount"=>0);
		$json.=$this->get_report_group($id,0,$from,$to);		
		$json.",";	
		$json.=$this->display_total_group($id)	;
		return $json;
	}
	
    function _test_($parent_id = 0, $from, $to) {
		 
	   require_once("trialData.php");
	  
    }
	//require_once("balancesheetData.php");
   function _test_balance($parent_id = 0, $from, $to, $addtotal = false) 
   {
	   require_once("balancesheetData.php");
	  // get_data_balancesheet($parent_id, $from, $to, $addtotal);
   }

    function get_subledgers_total($id, $from = '', $to = '') {

        $subledgers = $this->db->select('GROUP_CONCAT(id) as ids')->where('parent', $id)->get('tblledgergroups')->result_array();
          
        $inarray = explode(',', $subledgers[0]['ids'].','.$id);

        $this->db->select_sum('tblvoucherlines.amount');
        $this->db->from('tblvoucherlines');
        $this->db->join('tblvoucher', 'tblvoucher.vchid=tblvoucherlines.vchid');
        if ($from != '' && $to != '') {
            $this->db->where('tblvoucher.trxdate >=', $from);
            $this->db->where('tblvoucher.trxdate <=', $to);
        }
        if ($inarray) {
            $this->db->where_in('ledger', $inarray);
        } else {
            $this->db->where('ledger', $id);
        }
        return $this->db->get()->result_array();
    }

    function _test_profit($parent_id = 0, $from, $to) {

        $this->load->model('currencies_model');
        $base_currency_symbol = $this->currencies_model->get_base_currency()->symbol;
        $sql = "SELECT id, name, name as text,parent as parent_id ,type FROM `tblledgergroups` where parent != '13' and id !='13' and parent !='1' and id !='1' and id !='2' and id !='4' order by path asc";
        $Array = $this->db->query($sql)->result_array();

        $user_tree = array();
        $filter_tree = $this->search_tree_by_column($Array, 'parent_id', $parent_id);
        // print_r($filter_tree);
        // die;
        if (!empty($filter_tree)) {
            foreach ($filter_tree as $key => $value) {

                if ($value['type'] == 'Ledger') {
                    $res = $this->get_total($value['id'], $from, $to);
                   // if ($res[0]['amount'] < 0) {
                   //     $value['data'] = array('debit' => '', 'credit' => format_money($res[0]['amount'], $base_currency_symbol));
                   // } else {
                        $value['data'] = array('amount' => format_money($res[0]['amount'], $base_currency_symbol), 'credit' => '');
                   // }
                } else {
                    $value['data'] = array('amount' => '');
                }
                $value['children'] = $this->_test_profit($value['id'], $from, $to);
                $user_tree[] = $value;
            }

        //      
        }
        
        return $user_tree ? $user_tree : array();
    }



    public function getdata($from = '', $to = '') {

    	if($from == "")
    	{
    		$from = get_period('Open')->fromdate;
    	}

    	if($to == "")
    	{
    		$to = date('Y-m-d');
    	}

        $_test_ = $this->_test_($parent_id = 0, $from, $to);
 		$json = $json .$_test_ ;
        //$json = $json . json_encode($_test_, JSON_PRETTY_PRINT);
      
    }

    public function getbalancedata($from = '', $to = '') {

    	
    	if($from == "" || $from == 0)
    	{
    		$from = get_period('Open')->fromdate;
    	}
    	if($to == "")
    	{
    		$to = date('Y-m-d');
    	}
    	
        $_test_ = $this->_test_balance($parent_id = 0, $from, $to);
		$json = $json .$_test_ ;
        //$json = $json . json_encode($_test_, JSON_PRETTY_PRINT);
    }

    public function getprofitdata($from = '', $to = '') {
		 require_once("profitData.php");
    	
    }
    public function calRetainEarning($earn_retain)
    {
    	// print_r($earn_retain);
    	// die;
    	$expenses = 0;
    	foreach ($earn_retain as $key => $value) {
    		// print_r($value);
    		// echo "<br>";
    		if($value['data']['amount'] != "")
    		{
    			$expenses = $expenses + str_replace(",", "",str_replace("$", "", $value['data']['amount']));
    		}
    		if(!empty($value['children']))
    		{	    			
    			$expenses = $expenses + $this->calRetainEarning($value['children']);
    		}
    	}
    	return $expenses;
    }

    public function fetchCategoryTree() {



        $sql = "SELECT id, name, name as text,parent as parent_id ,type FROM `tblledgergroups` order by path asc";
        $res = $this->db->query($sql)->result_array();

        foreach ($res as $row) {
            $data[] = $row;
        }
        $itemsByReference = array();

// Build array of item references:
        foreach ($data as $key => &$item) {
            $itemsByReference[$item['id']] = &$item;
            // Children array:
            $itemsByReference[$item['id']]['children'] = array();
            // Empty data class (so that json_encode adds "data: {}" )    
            if ($item['type'] == 'Group')
                $itemsByReference[$item['id']]['data'];
            else {
                $itemsByReference[$item['id']]['data'] = array('price' => '12', 'size' => '30');
            }
        }

// Set items as children of the relevant parent item.
        foreach ($data as $key => &$item)
            if ($item['parent_id'] && isset($itemsByReference[$item['parent_id']]))
                $itemsByReference [$item['parent_id']]['children'][] = &$item;

// Remove items that were added to parents elsewhere:
        foreach ($data as $key => &$item) {
            if ($item['parent_id'] && isset($itemsByReference[$item['parent_id']]))
                unset($data[$key]);
        }
// Encode:
        $json = $json . json_encode($data, JSON_PRETTY_PRINT);
    }

    function trial_balance($fromdate = '', $todate = '') {
       
	  	if($fromdate=="")
		{
			$str = explode('|', get_option("dateformat"));

			$sfromdate = (isset($fromdate) && !empty($fromdate) ? _d($fromdate) : date($str[0], strtotime(get_period('Open')->fromdate)));
			$stodate = (isset($todate) && !empty($todate) ? _d($todate) : date($str[0], time()));
			
			$tab=explode("/",$sfromdate); //Array ( [0] => 01 [1] => 08 [2] => 2017 ) 					
			$fromdate=$tab[2]."-".$tab[1]."-".$tab[0];
			
			$tab=explode("/",$stodate); 					
			$todate=$tab[2]."-".$tab[1]."-".$tab[0];
		}
		
		$data['fromdate'] = $fromdate;
        $data['todate'] = $todate;
        if ($this->input->post()) {
            $fd = DateTime::createFromFormat(get_current_date_format(), $this->input->post('fromdate'));
            $fromdate = $fd->format('Y-m-d');
            $td = DateTime::createFromFormat(get_current_date_format(), $this->input->post('todate'));
            $todate = $td->format('Y-m-d');
            redirect(admin_url() . 'reports/trial_balance/' . $fromdate . '/' . $todate);
        }
		
		
        $title = _l('trail_balance');
        $data['title'] = $title;
		
        $this->load->view('admin/reports/trial_balance', $data);
		/*
	   $data['fromdate'] = $fromdate;
        $data['todate'] = $todate;
        if ($this->input->post()) {
            $fd = DateTime::createFromFormat(get_current_date_format(), $this->input->post('fromdate'));
            $fromdate = $fd->format('Y-m-d');
            $td = DateTime::createFromFormat(get_current_date_format(), $this->input->post('todate'));
            $todate = $td->format('Y-m-d');
            redirect(admin_url() . 'reports/trial_balance/' . $fromdate . '/' . $todate);
        }
        $title = _l('trail_balance');
        $data['title'] = $title;
        $this->load->view('admin/reports/trial_balance', $data);*/
    }
	
	
    function profitlossaccount($fromdate = '', $todate = '') {
			/*
					Some accounting software will use minus signs or parentheses to indicate credit balances, while positive numbers indicate debit balances.
					*/
		if($fromdate=="")
		{
			$str = explode('|', get_option("dateformat"));

			$sfromdate = (isset($fromdate) && !empty($fromdate) ? _d($fromdate) : date($str[0], strtotime(get_period('Open')->fromdate)));
			$stodate = (isset($todate) && !empty($todate) ? _d($todate) : date($str[0], time()));
			
			$tab=explode("/",$sfromdate); //Array ( [0] => 01 [1] => 08 [2] => 2017 ) 					
			$fromdate=$tab[2]."-".$tab[1]."-".$tab[0];
			
			$tab=explode("/",$stodate); 					
			$todate=$tab[2]."-".$tab[1]."-".$tab[0];
		}
		
		$data['fromdate'] = $fromdate;
        $data['todate'] = $todate;
        if ($this->input->post()) {
            $fd = DateTime::createFromFormat(get_current_date_format(), $this->input->post('fromdate'));
            $fromdate = $fd->format('Y-m-d');
            $td = DateTime::createFromFormat(get_current_date_format(), $this->input->post('todate'));
            $todate = $td->format('Y-m-d');
            redirect(admin_url() . 'reports/profitlossaccount/' . $fromdate . '/' . $todate);
        }
		
		
        $title = _l('profitloss');
        $data['title'] = $title;
		
        $this->load->view('admin/reports/profitlossaccount', $data);
		
		/*
        $data['fromdate'] = $fromdate;
        $data['todate'] = $todate;
        if ($this->input->post()) {
            $fd = DateTime::createFromFormat(get_current_date_format(), $this->input->post('fromdate'));
            $fromdate = $fd->format('Y-m-d');
            $td = DateTime::createFromFormat(get_current_date_format(), $this->input->post('todate'));
            $todate = $td->format('Y-m-d');
            redirect(admin_url() . 'reports/profitlossaccount/' . $fromdate . '/' . $todate);
        }
        $title = _l('profitloss');
        $data['title'] = $title;
        $this->load->view('admin/reports/profitlossaccount', $data);*/
    }

    function balancesheet($todate = '',$fromdate = '') {
        // $data['fromdate'] = $fromdate;
        $data['todate'] = $todate;
        if ($this->input->post()) {
            // $fd = DateTime::createFromFormat(get_current_date_format(), $this->input->post('fromdate'));
            // $fromdate = $fd->format('Y-m-d');
            $td = DateTime::createFromFormat(get_current_date_format(), $this->input->post('todate'));
            $todate = $td->format('Y-m-d');
            // redirect(admin_url() . 'reports/balancesheet/' . $fromdate . '/' . $todate);
            redirect(admin_url() . 'reports/balancesheet/' . $todate);
        }
        $data['todate'] = $todate;
        $title = _l('balancsheet');
        $data['title'] = $title;
        $this->load->view('admin/reports/balancesheet', $data);
    }

    function ledgerview($id = '', $fromdate = '', $todate = '') {
        $data['fromdate'] = $fromdate;
        $data['todate'] = $todate;
        if ($this->input->post()) {
            $fd = DateTime::createFromFormat(get_current_date_format(), $this->input->post('fromdate'));
            $fromdate = $fd->format('Y-m-d');
            $td = DateTime::createFromFormat(get_current_date_format(), $this->input->post('todate'));
            $todate = $td->format('Y-m-d');
            if ($id != '') {
                redirect(admin_url() . 'reports/ledgerview/' . $id . '/' . $fromdate . '/' . $todate);
            } else {
                redirect(admin_url() . 'reports/ledgerview/0/' . $fromdate . '/' . $todate);
            }
        }


        $title = _l('ledger_view');
        $data['title'] = $title;
        $data['id'] = $id;
        $this->load->view('admin/reports/ledgerview', $data);
    }

    function ageing() {
    	$clientid = "";
        if ($this->input->post()) {
            $clientid = $this->input->post('clientid');
            $sort = $this->input->post('sort');
        }
        $data['user_id'] = $clientid;
        $data['customers'] = $this->reports_model->get_customers($clientid, $sort);
        $this->load->model('clients_model');
        $data['clients'] = $this->clients_model->get();
        $title = _l('customers_accounts');
        $data['title'] = $title;
        $data['id'] = $id;
        $this->load->view('admin/reports/ageing', $data);
    }

    public function supplier_ageing($value='')
    {
    	$supplierid = "";
        if ($this->input->post()) {
            $supplierid = $this->input->post('supplierid');
            $sort = $this->input->post('sort');
        }
        $data['user_id'] = $supplierid;
        $data['suppliers_report'] = $this->reports_model->get_supplier($supplierid, $sort);
        $this->load->model('suppliers_model');
        $data['suppliers'] = $this->suppliers_model->get();
        $title = 'Supplier_accounts';
        $data['title'] = $title;
        $data['id'] = $id;
        $this->load->view('admin/reports/supplier_ageing', $data);
    }

    function statement() {
        $clientid = $fromdate = $todate = '';
        if ($this->input->post()) {
            $clientid = $this->input->post('clientid');
            if ($this->input->post('option') == 'Period') {
                $postfdate = $this->input->post('fdate');
                $posttdate = $this->input->post('tdate');
            } else {
                $postfdate = $this->input->post('fromdate');
                $posttdate = $this->input->post('todate');
            }

            $fd = DateTime::createFromFormat(get_current_date_format(), $postfdate);
            $fromdate = $fd->format('Y-m-d');
            $td = DateTime::createFromFormat(get_current_date_format(), $posttdate);
            $todate = $td->format('Y-m-d');
        }
        $data['fromdate'] = $fromdate;
        $data['user_id'] = $clientid;
        $data['todate'] = $todate;
        $data['postfdate'] = $postfdate;
        $data['posttdate'] = $posttdate;
        $this->load->model('currencies_model');
        $base_currency_symbol = $this->currencies_model->get_base_currency()->symbol;
        $data['base_currency_symbol'] = $base_currency_symbol;

        //out standing invoice total
        $totaloutstanding = $this->reports_model->getUnpaidInvoices($clientid, $fromdate);
        $data['totaloutstanding'] = $totaloutstanding->total;

        //get all invoice between date
        
        $data['invoicesin'] = $this->reports_model->betweenDateInvoice($clientid, $fromdate, $todate);
        $data['priods'] = $this->reports_model->getPeriod();
        $this->load->model('clients_model');
        $data['clients'] = $this->clients_model->get();
        
        $title = _l('customers_statement');
        $data['fromdate_payment'] = $fromdate;
        $data['todate_payment'] = $todate;
        $data['title'] = $title;
        $data['id'] = $id;
        $this->load->view('admin/reports/statement', $data);
    }

    function statementprint() {
        $clientid = $fromdate = $todate = '';

//        if($this->input->post()){
//          $clientid = $this->input->post('clientid');
//          if($this->input->post('option')=='Period'){
//            $postfdate = $this->input->post('fdate');
//            $posttdate =$this->input->post('tdate');
//            }else{
//                $postfdate = $this->input->post('fromdate');
//               $posttdate =$this->input->post('todate');
//           }

        $clientid = 1;
        $postfdate = '01/06/2016';
        $posttdate = '30/06/2016';

        $fd = DateTime::createFromFormat(get_current_date_format(), $postfdate);
        $fromdate = $fd->format('Y-m-d');
        $td = DateTime::createFromFormat(get_current_date_format(), $posttdate);
        $todate = $td->format('Y-m-d');

//        }

        $data['postfdate'] = $postfdate;
        $data['posttdate'] = $posttdate;
        $this->load->model('currencies_model');
        $base_currency_symbol = $this->currencies_model->get_base_currency()->symbol;
        $data['base_currency_symbol'] = $base_currency_symbol;

        //out standing invoice total
        $totaloutstanding = $this->reports_model->getUnpaidInvoices($clientid, $fromdate);
        $data['totaloutstanding'] = $totaloutstanding->total;

        //get all invoice between date
        $data['invoicesin'] = $this->reports_model->betweenDateInvoice($clientid, $fromdate, $todate);
        $data['priods'] = $this->reports_model->getPeriod();
        $this->load->model('clients_model');
        $data['clients'] = $this->clients_model->get();
        $title = _l('customers_accounts');
        $data['title'] = $title;
        $data['id'] = $id;
        $this->load->view('admin/reports/statementprint', $data);
    }

    function sample() {

        return array('january', 'february', 'March', 'April', 'May', 'Jun', 'Jully', 'August', 'September', 'October', 'November', 'December');
    }

    public function getleadgerdata() {
        $_test_ = $this->sample();
        $json = $json . json_encode($_test_, JSON_PRETTY_PRINT);
    }

    /* No access on this url */

    public function index() {
        redirect(site_url('admin'));
    }

    /* See knowledge base article reports */

    public function knowledge_base_articles() {
        if (get_option('use_knowledge_base') == 0) {
            redirect(site_url('admin'));
        }

        $this->load->model('knowledge_base_model');
        $data['groups'] = $this->knowledge_base_model->get_kbg();
        $data['title'] = _l('kb_reports');
        $this->load->view('admin/reports/knowledge_base_articles', $data);
    }

    /* Rerport leads conversions */

    public function leads() {
        $this->load->model('leads_model');
        $data['statuses'] = $this->leads_model->get_status();
        $this->load->view('admin/reports/leads', $data);
    }

    public function redirectledgerview() {
    //    $json = $json . $this->reports_model->get_id($this->input->get('id'));
		 $json = $json . $this->reports_model->get_id($_REQUEST['id']);
		echo $json;
    }

    /* Sales reportts */

    public function sales() {
        if (is_using_multiple_currencies()) {
            $this->load->model('currencies_model');
            $data['currencies'] = $this->currencies_model->get();
        }

        $data['title'] = _l('sales_reports');
        $this->load->view('admin/reports/sales', $data);
    }

    /* Customer report */

    public function customers_report() {
        if ($this->input->is_ajax_request()) {
            $this->load->model('currencies_model');
            $months_report = $this->input->post('report_months');
            $select = array(
                'company',
                '(SELECT COUNT(clientid) FROM tblinvoices WHERE tblinvoices.clientid = tblclients.userid)',
                '(SELECT SUM(subtotal) FROM tblinvoices WHERE tblinvoices.clientid = tblclients.userid)',
                '(SELECT SUM(total) FROM tblinvoices WHERE tblinvoices.clientid = tblclients.userid)'
            );

            if ($months_report != '') {
                $custom_date_select = '';
                if (is_numeric($months_report)) {
                    $custom_date_select = 'AND date > DATE_SUB(now(), INTERVAL ' . $months_report . ' MONTH)';
                } else if ($months_report == 'custom') {
                    $from_date = to_sql_date($this->input->post('report_from'));
                    $to_date = to_sql_date($this->input->post('report_to'));

                    if ($from_date == $to_date) {
                        $custom_date_select = 'AND date ="' . $from_date . '"';
                    } else {
                        $custom_date_select = 'AND (date BETWEEN "' . $from_date . '" AND "' . $to_date . '")';
                    }
                }
                if ($custom_date_select != '') {
                    $i = 0;
                    foreach ($select as $_select) {
                        if ($i !== 0) {
                            $_temp = substr($_select, 0, -1);
                            $_temp .= ' ' . $custom_date_select . ')';
                            $select[$i] = $_temp;
                        }
                        $i++;
                    }
                }
            }

            $by_currency = $this->input->post('report_currency');
            $currency = $this->currencies_model->get_base_currency();
            $currency_symbol = $this->currencies_model->get_currency_symbol($currency->id);
            if ($by_currency) {
                $i = 0;
                foreach ($select as $_select) {
                    if ($i !== 0) {
                        $_temp = substr($_select, 0, -1);
                        $_temp .= ' AND currency =' . $by_currency . ')';
                        $select[$i] = $_temp;
                    }
                    $i++;
                }

                $currency = $this->currencies_model->get($by_currency);
                $currency_symbol = $this->currencies_model->get_currency_symbol($currency->id);
            }


            $aColumns = $select;
            $sIndexColumn = "userid";
            $sTable = 'tblclients';

            $where = array();
            $i = 0;
            foreach ($select as $_select) {
                if ($i > 0) {
                    if ($i == 1) {
                        $where[] = 'WHERE ' . $_select . '' . ' !=0';
                    } else {
                        $where[] = 'AND ' . $_select . '' . ' !=0';
                    }
                }
                $i++;
            }

            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, array(), $where, array(
                'firstname',
                'lastname',
                'userid'
            ));
            $output = $result['output'];
            $rResult = $result['rResult'];

            $x = 0;
            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {

                    $_data = $aRow[$aColumns[$i]];
                    if ($aColumns[$i] == 'company') {
                        $company = $aRow['company'];
                        if ($company != '') {
                            $company .= '<small class="text-muted"> ' . $aRow['firstname'] . ' ' . $aRow['lastname'] . '</small>';
                        } else {
                            $company = $aRow['firstname'] . ' ' . $aRow['lastname'];
                        }

                        $_data = '<a href="' . admin_url('clients/client/' . $aRow['userid']) . '">' . $company . '</a>';
                    } else if ($aColumns[$i] == $select[2] || $aColumns[$i] == $select[3]) {

                        if ($_data == null) {
                            $_data = 0;
                        }

                        $_data = format_money($_data, $currency_symbol);
                    }
                    $row[] = $_data;
                }

                $output['aaData'][] = $row;
                $x++;
            }

            $json = $json . json_encode($output);
            die();
        }
    }

    public function expenses($current_year = '') {
        $data['current_year'] = $current_year;
        if ($current_year == '') {
            $data['current_year'] = date('Y');
        }

        $data['expense_years'] = $this->reports_model->get_distinct_expense_years();
        $this->load->model('currencies_model');
        $data['base_currency'] = $this->currencies_model->get_base_currency();
        $this->load->model('expenses_model');
        $data['categories'] = $this->expenses_model->get_category();
        $data['title'] = 'Expenses Report';
        $this->load->view('admin/reports/expenses', $data);
    }

    public function expenses_vs_income() {
        $data['chart_expenses_vs_income_values'] = json_encode($this->reports_model->get_expenses_vs_income_report());
        $data['title'] = 'Expense vs Income';
        $this->load->view('admin/reports/expenses_vs_income', $data);
    }

    /* Total income report / ajax chart */

    public function total_income_report() {
        $json = $json . json_encode($this->reports_model->total_income_report());
    }

    public function report_by_customer_groups() {
        $json = $json . json_encode($this->reports_model->report_by_customer_groups());
    }

    /* Leads conversion monthly report / ajax chart */

    public function leads_monthly_report($month) {
        $json = $json . json_encode($this->reports_model->leads_monthly_report($month));
    }

    /* Leads conversion current week / ajax chart */

    public function leads_this_week_report() {
        $json = $json . json_encode($this->reports_model->leads_this_week_report());
    }

    /* Leads conversion by source / ajax chart */

    public function leads_sources_report() {
        $json = $json . json_encode($this->reports_model->leads_sources_report());
    }

    /* expot trail balance */

    public function export($file) {


        $srnoname = array('Ledgers', 'Debit', 'Credit');
        $snames = array();
        $marks_of_studs = array();
        $sunames = array();

        $this->load->library('excel');
        $this->excel->setActiveSheetIndex(0);
        $this->excel->getActiveSheet()->setTitle('Trail Balance');

        $this->excel->getActiveSheet()->fromArray($srnoname, null, 'A1');
        $col = 3;
        $row = 2;
        $sql = "SELECT id,name,type FROM `tblledgergroups` where type='Ledger' order by path asc";
        $res = $this->db->query($sql)->result();


        for ($i = 0; $i < count($res); $i++) {
            $this->excel->getActiveSheet()->setCellValueByColumnAndRow($col - 3, $row, $res[$i]->name);
            $sql = "SELECT SUM(amount) as amount FROM `tblvoucherlines` where ledger=" . $res[$i]->id;
            $amount = $this->db->query($sql)->result_array();
            if ($amount[0]['amount'] < 0) {
                $this->excel->getActiveSheet()->setCellValueByColumnAndRow($col - 2, $row, '');
                $this->excel->getActiveSheet()->setCellValueByColumnAndRow($col - 1, $row, $amount[0]['amount']);
            } else {
                $this->excel->getActiveSheet()->setCellValueByColumnAndRow($col - 2, $row, $amount[0]['amount']);
                $this->excel->getActiveSheet()->setCellValueByColumnAndRow($col - 1, $row, '');
            }
            $row++;
        }
        $c = $this->excel->getActiveSheet()->getHighestDataColumn();
        $r = $this->excel->getActiveSheet()->getHighestDataRow();
        //$this->excel->getActiveSheet()->getProtection()->setSheet(true);
        for ($col = 'A'; $col !== $c; $col++) {
            $this->excel->getActiveSheet()
                    ->getColumnDimension($col)
                    ->setAutoSize(true);
        }
        // $this->excel->getActiveSheet()->getStyle("D1:$c$r")->getProtection()->setLocked(PHPExcel_Style_Protection::PROTECTION_UNPROTECTED);
        $filename = 'Trail Balance' . '.xls'; //save our workbook as this file name
        header('Content-Type: application/vnd.ms-excel'); //mime type
        header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache
        $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
        $objWriter->save('php://output');
    }

    public function pdf($id = 0, $fromdate = '', $todate = '') {
        $pdf = ledger_pdf($id, $fromdate, $todate);
        if ($id == 0) {
            $pdf->Output(' Ledgerreport.pdf', 'D');
        } else {
            $pdf->Output($id . $fromdate . $todate . '.pdf', 'D');
        }
    }

    /* expot ledger view excel */

    public function download($id = 0, $fromdate = '', $todate = '') {


        $srnoname = array('Date', 'Voucher Number', 'Ledger code', 'Ledger name', 'Debit', 'Credit', 'Running balance');
        $snames = array();
        $marks_of_studs = array();
        $sunames = array();

        $this->load->library('excel');
        $this->excel->setActiveSheetIndex(0);
        $this->excel->getActiveSheet()->setTitle('Ledger Report');
        $this->excel->getActiveSheet()->mergeCells('C1:E1');
        $this->excel->getActiveSheet()->setCellValue('C1', 'Ledger Report');
        $this->excel->getActiveSheet()->getStyle('C1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $this->excel->getActiveSheet()->fromArray($srnoname, null, 'A2');
        $this->excel->getActiveSheet()->getStyle('C1:E1')->getFont()->setSize(20);
        $this->excel->getActiveSheet()->getStyle('A2:G2')->getFont()->setSize(12);

        $col = 0;
        $row = 3;
        $res = $this->reports_model->getledgerdetails($id, $fromdate, $todate);

        $this->load->model('currencies_model');
        $base_currency_symbol = $this->currencies_model->get_base_currency()->symbol;

        $this->excel->getActiveSheet()->getStyle('A2:G2')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFF5DA81');

        foreach (range('A', 'G') as $columnID) {
            $this->excel->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
        }

        $totaldebit = $totalcredit = 0;
        for ($i = 0; $i < count($res); $i++) {
            $this->excel->getActiveSheet()->setCellValueByColumnAndRow($col, $row, date('d-M-y', strtotime($res[$i]->trxdate)));
            $this->excel->getActiveSheet()->setCellValueByColumnAndRow($col + 1, $row, $res[$i]->voucher);
            $this->excel->getActiveSheet()->setCellValueByColumnAndRow($col + 2, $row, $res[$i]->accountid);
            $this->excel->getActiveSheet()->setCellValueByColumnAndRow($col + 3, $row, $res[$i]->name);
            if ($res[$i]->amount < 0) {
                $totaldebit += $res[$i]->amount;
                $this->excel->getActiveSheet()->setCellValueByColumnAndRow($col + 4, $row, format_money($res[$i]->amount, $base_currency_symbol));
                $this->excel->getActiveSheet()->setCellValueByColumnAndRow($col + 5, $row, '');
            } else {
                $totalcredit += $res[$i]->amount;
                $this->excel->getActiveSheet()->setCellValueByColumnAndRow($col + 4, $row, '');
                $this->excel->getActiveSheet()->setCellValueByColumnAndRow($col + 5, $row, format_money($res[$i]->amount, $base_currency_symbol));
            }
            $this->excel->getActiveSheet()->setCellValueByColumnAndRow($col + 6, $row, format_money($res[$i]->amount, $base_currency_symbol));

            $row++;
        }
        $this->excel->getActiveSheet()->setCellValueByColumnAndRow(3, $row, 'Closing Balance');
        $this->excel->getActiveSheet()->setCellValueByColumnAndRow(4, $row, format_money($totaldebit, $base_currency_symbol));
        $this->excel->getActiveSheet()->setCellValueByColumnAndRow(5, $row, format_money($totalcredit, $base_currency_symbol));

        $this->excel->getActiveSheet()->getStyle('A' . $row . ':G' . $row)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('FFF5DA81');
        $this->excel->getActiveSheet()->getStyle('A' . $row . ':G' . $row)->getFont()->setSize(12);
        $c = $this->excel->getActiveSheet()->getHighestDataColumn();
        $r = $this->excel->getActiveSheet()->getHighestDataRow();
        //$this->excel->getActiveSheet()->getProtection()->setSheet(true);
        for ($col = 'A'; $col !== $c; $col++) {
            $this->excel->getActiveSheet()
                    ->getColumnDimension($col)
                    ->setAutoSize(true);
        }
        // $this->excel->getActiveSheet()->getStyle("D1:$c$r")->getProtection()->setLocked(PHPExcel_Style_Protection::PROTECTION_UNPROTECTED);
        $filename = 'Ledgers Report' . '.xls'; //save our workbook as this file name
        header('Content-Type: application/vnd.ms-excel'); //mime type
        header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache
        $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
        $objWriter->save('php://output');
    }

}
