<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Reconcile extends Admin_controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('reconcile_model');
        $this->load->model('Banksaccounts_model');
        if(!has_permission('manageReconcile')){
            access_denied('manageReconcile');
        }
    }

    // /* List all peyment modes*/
    public function index()
    {
        if ($this->input->is_ajax_request()) {
            // From client profile
            if(is_numeric($clientid)){
                if(!$has_permission){
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                'tblreconcilations.date',
                'tblbanks.bank',
                'tblbankbranches.branchname',
                'tblbanksaccount.account_number',
                'tblbanksaccount.account_type',
                'tblcurrencies.name',
                'tblreconcilations.startbalance',
                'tblreconcilations.endbalance',
            );

            $join = array(
                'LEFT JOIN tblbanks ON tblbanks.bankid = tblreconcilations.bank_id',
                'LEFT JOIN tblbankbranches ON tblbankbranches.bankbranchid = tblreconcilations.branch_id',
                'LEFT JOIN tblbanksaccount ON tblbanksaccount.id = tblreconcilations.account_id',
                'LEFT JOIN tblcurrencies ON tblcurrencies.id = tblbanksaccount.currency'
            );

            $where = array();
            
            // if($id != "")
            // {
            //     $where = array(

            //         'where tbldeopsits.account_id=' . $id,
            //     );
            // }
                
            
            $sIndexColumn = 'id';
            $sTable       = 'tblreconcilations';
            $result       = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array());
            $output       = $result['output'];
            $rResult      = $result['rResult'];
           
            
            foreach ($rResult as $aRow) {
                $row = array();

                
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];


                    if ($aColumns[$i] == 'tblreconcilations.date') {
                        $__data = _d(date('d/m/Y'),$_data);
                    }
                    if ($aColumns[$i] == 'tblbanks.bank') {
                        $__data = _d($_data);
                    }
                    if ($aColumns[$i] == 'tblbankbranches.branchname') {
                        $__data = _d($_data);
                    }
                    if ($aColumns[$i] == 'tblbanksaccount.account_number') {
                        $__data = _d($_data);
                    }
                    if ($aColumns[$i] == 'tblbanksaccount.account_type') {
                        $__data = _d($_data);
                    }
                    if ($aColumns[$i] == 'tblcurrencies.name') {
                        $__data = _d($_data);
                    }
                    if ($aColumns[$i] == 'tblreconcilations.startbalance') {
                        $__data = format_money($_data);
                    }
                    if ($aColumns[$i] == 'tblreconcilations.endbalance') {
                        $__data = format_money($_data);
                    }

                   
                    $row[] = $__data;
                }
               
                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        // $data['deopsits'] = $this->deopsits_model->get();
        $data['title'] = _l('reconcile');
        $this->load->view('admin/reconcile/manage', $data);
    }
    

    public function reconcile($bankid = '',$branch = '',$account = '',$id = '')
    {
        // echo "JDh";
        // die;
        if ($this->input->post()) 
        {
            if ($id == '') 
            {
                
                $id = $this->reconcile_model->add($this->input->post());
                if ($id == 1) 
                {
                    set_alert('success', _l('added_successfuly',_l('reconcile')));
                    if (trim($this->input->post('action')) == 'save') {
                          redirect(admin_url('reconcile'));
                        exit;
                    }
                    if (trim($this->input->post('action')) == 'snew') {
                        redirect(admin_url('reconcile/reconcile'));
                        exit;
                    }
                 
                    if (trim($this->input->post('action')) == 'slist') {
                         redirect(admin_url('reconcile'));
                         
                    }
                    if (trim($this->input->post('action')) == 'cancel') {
                        redirect(admin_url());
                        exit;
                    }
                    //redirect(admin_url('bill/list_bill/' . $id));
                }
            }

            else 
            {
                $success = $this->bills_model->update($this->input->post(), $id);
                if ($success) {
                   set_alert('success', _l('updated_successfuly',_l('bill')));
                }
               if (trim($this->input->post('action')) == 'save') {
                          redirect(admin_url('bills/bill/'. $id));
                        exit;
                    }
                    if (trim($this->input->post('action')) == 'snew') {
                        redirect(admin_url('bills/bill'));
                        exit;
                    }
                 
                    if (trim($this->input->post('action')) == 'slist') {
                         redirect(admin_url('bills/'));
                         
                    }
                    if (trim($this->input->post('action')) == 'cancel') {
                        redirect(admin_url());
                        exit;
                    }
            }
        }

        if ($id == '') {
            $title = _l('create_new_reconcile');
            // $data['last_reconcile'] = $this->reconcile_model->get_last_reconcile();

        } else {     
           
            // $baksaccount = $this->banksaccounts_model->get_where_single_tbl('tblbanksaccount','id',$id);

            // $data['branches'] = $this->banksaccounts_model->branches_by_bank($baksaccount->bank);

            // $data['baksaccount'] = $baksaccount;
            // // $title = _l('bank_account'); 
        }

        // $data['last_reconcile'] = $this->reconcile_model->get_last_reconcile();
		            $this->load->model('deopsits_model');

		    $data['bank'] = $this->deopsits_model->get_bank($bankid);
			$data['branch'] = $this->deopsits_model->get_branch_selected($branch);
			$data['account'] = $this->deopsits_model->get_account_selected($account);
       
        $data['banks'] = $this->reconcile_model->get_banks();
        
        $data['title']     = $title;
        $this->load->view('admin/reconcile/reconcile', $data);
    }

    public function get_account_number()
    {
        $branch_id =  $this->input->post('id');
        $account_number = $this->reconcile_model->get_accounts($branch_id);

        $options ='<option value=""></option>';
          if(isset($account_number)){
              foreach ($account_number as $value) {
               $options .='<option value="'.$value->id.'">'.$value->account_number.'</option>';   
              }
          }
          echo json_encode(array('options'=>$options));

        // echo json_encode($account_number);
    }

    public function get_deopsits()
    {
        $account_id =  $this->input->post('id');
        $bank_deopsits = $this->reconcile_model->get_deopsits($account_id);

        echo json_encode($bank_deopsits);
    }
  public function get_payments()
    {
        $account_id =  $this->input->post('id');
        $bank_deopsits = $this->reconcile_model->get_payments($account_id);

        echo json_encode($bank_deopsits);
    }
    public function get_endbalance()
    {
        $account_id =  $this->input->post('id');
        $bank_deopsits = $this->reconcile_model->get_last_reconcile($account_id);
        echo $bank_deopsits->endbalance;
        // echo json_encode($bank_deopsits->endbalance);
    }

}
