<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Race extends Admin_controller {

    function __construct() {
        parent::__construct();
        $this->load->model('race_model');
    }

    public function index() 
    {    
      $data['race'] = $this->race_model->get_list();
      $data['title'] = _l('race');
      $this->load->view('admin/race/manage', $data);
    }

    public function race() {
        if ($this->input->is_ajax_request()) {
            $data = $this->input->post();

            if ($data['id'] == '') {
                $success = $this->race_model->add($data);
                $message = '';
                if ($success == true) {
                    $message = _l('added_successfuly', _l('race'));
                }
                echo json_encode(array('success' => $success, 'message' => $message));
            } else {
				
                $success = $this->race_model->edit($data);
                $message = '';
                if ($success == true) {
                    $message = _l('updated_successfuly', _l('race'));
                }
                echo json_encode(array('success' => $success, 'message' => $message));
            }
        }
    }

    public function getrace(){
		echo  json_encode($this->race_model->getrace());
	}

	public function delete($id)
	{
		$response = $this->race_model->delete($id);
		
		if ($response == true) {
            set_alert('success', _l('deleted', _l('race')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('race')));
        }

        redirect(admin_url('race'));
	}
}