<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Quotes extends Admin_controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('quotes_model');
    }

    /* Get all quotes in case user go on index page */
    public function index($id = false, $clientid = false)
    {
        $this->list_quotes($id, $clientid);
    }

    /* List all quotes datatables */
    public function list_quotes($id = false, $clientid = false)
    {
        $has_permission = has_permission('manageSales');

         if(!$has_permission && !$this->input->is_ajax_request()){
            access_denied('manageSales');
         }

         $_status = '';

         if($this->input->get('status')){
            $_status = $this->input->get('status');
         }

        if ($this->input->is_ajax_request()) {
            // From client profile
            if(is_numeric($clientid)){
                if(!$has_permission){
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                'number',
                'date',
                'reference_no',
                'company',
                'expirydate',
                'total',
                'status'
            );

            $join = array(
                'LEFT JOIN tblclients ON tblclients.userid = tblquotes.clientid',
                'LEFT JOIN tblcurrencies ON tblcurrencies.id = tblquotes.currency'
            );

             $custom_fields = get_custom_fields('quote',array('show_on_table'=>1));

            $i = 0;
            foreach($custom_fields as $field){
                    array_push($aColumns,'ctable_'.$i.'.value as cvalue_'.$i);
                    array_push($join,'LEFT JOIN tblcustomfieldsvalues as ctable_'.$i . ' ON tblquotes.id = ctable_'.$i . '.relid AND ctable_'.$i . '.fieldto="'.$field['fieldto'].'" AND ctable_'.$i . '.fieldid='.$field['id']);
                    $i++;
            }



            $where                    = array();

            if (is_numeric($clientid)) {
                $where                    = array(
                    'AND clientid=' . $clientid
                );
            }


            if ($this->input->post('status')) {
                array_push($where, 'AND status=' . $this->input->post('status'));
            }

            if($this->input->post('custom_view')){
                $custom_view = $this->input->post('custom_view');
                if($custom_view == 'not_sent'){
                     array_push($where,'AND sent=0');
                 }
            }

            $sIndexColumn = "id";
            $sTable       = 'tblquotes';
            $result       = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array(
                'firstname',
                'tblquotes.id',
                'lastname',
                'company',
                'clientid',
                'symbol',
                'total',
                'status'
            ));
            $output       = $result['output'];
            $rResult      = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();

                $company = $aRow['company'];
                if ($company != '') {
                    $company .= '<small class="text-muted"> ' . $aRow['firstname'] . ' ' . $aRow['lastname'] . '</small>';
                } else {
                    $company = $aRow['firstname'] . ' ' . $aRow['lastname'];
                }
                for ($i = 0; $i < count($aColumns); $i++) {

                    if(strpos($aColumns[$i],'as') !== false && !isset($aRow[ $aColumns[$i] ])){
                        $_data = $aRow[ strafter($aColumns[$i],'as ')];
                    } else {
                        $_data = $aRow[ $aColumns[$i] ];
                    }

                    if ($aColumns[$i] == 'number') {
                        // If is from client area table
                    if (is_numeric($clientid)) {
                        $__data = '<a href="' . admin_url('quotes/list_quotes/' . $aRow['id']) . '" target="_blank">' . format_quote_number($aRow['id']) . '</a><br />';
                    } else {
                           $__data = '<a href="#" onclick="init_quote(' . $aRow['id'] . '); return false;">' . format_quote_number($aRow['id']) . '</a><br />';
                    }
                    } else if ($aColumns[$i] == 'date') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'company') {
                        $__data = '<a href="' . admin_url('clients/client/' . $aRow['clientid']) . '">' . $company . '</a><br />';
                    } else if ($aColumns[$i] == 'expirydate') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'total') {
                        $__data = format_money($_data, $aRow['symbol']);
                    } else if($aColumns[$i] == 'status') {
                        $__data = format_quote_status($aRow['status']);
                        // Status
                    } else if($aColumns[$i] == 'reference_no') {
                        // is quote reference
                         $__data = $aRow[$aColumns[$i]];
                    } else {
                        $__data = $_data;
                    }
                    $row[] = $__data;
                }

                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        $data['quoteid'] = '';
        if (is_numeric($id)) {
            $data['quoteid'] = $id;
        }


        $data['status'] = $_status;
        $data['bodyclass'] = 'small-table';
        $data['title']     = _l('quotes');
        $this->load->view('admin/quotes/manage', $data);
    }

    /* Add new quote or update existing */
    public function quote($customerid = '',$id = '')
    {
         if(!has_permission('manageSales')){
            access_denied('manageSales');
         }

        if ($this->input->post()) {
            if ($id == '') {
                $id = $this->quotes_model->add($this->input->post());
                if ($id) {
                    $quotes = $this->quotes_model->get($id);
                    if ($quotes->number != $this->input->post('_number')) {
                        set_alert('warning', _l('quote_number_changed'));
                    } else {
                       set_alert('success', _l('added_successfuly',_l('quote')));
                    }

                    redirect(admin_url('quotes/list_quotes/' . $id));
                }
            } else {
                $success = $this->quotes_model->update($this->input->post(), $id);
                if ($success) {
                   set_alert('success', _l('updated_successfuly',_l('quote')));
                }
                redirect(admin_url('quotes/list_quotes/' . $id));
            }
        }

        if ($id == '') {
            $title = _l('create_new_quote');
        } else {
            $quotes = $this->quotes_model->get($id);
            $quotes->date    = _d($quotes->date);
            $quotes->expirydate = _d($quotes->expirydate);
            $this->load->model('emails_model');
            if ($quotes->sent == 0) {
                $data['template'] = $this->emails_model->parse_template('quote-send-to-client', $quotes->clientid, false,false,false,$id);
            } else {
                $data['template'] = $this->emails_model->parse_template('quote-already-send', $quotes->clientid, false,false,false,$id);
            }
            $data['quote']  = $quotes;
            $data['edit'] = true;
            $title           = _l('edit',_l('quote_lowercase'));
        }
         if(isset($data['quote'])){
            $customerid = $data['quote']->clientid;
        }
     
        $this->load->model('clients_model');
        $data['customerdetails'] = $this->clients_model->get_client($customerid);

        $this->load->model('taxes_model');
        $data['taxes'] = $this->taxes_model->get();

        $this->load->model('currencies_model');
        $data['currencies'] = $this->currencies_model->get();

        $this->load->model('invoice_items_model');
        $data['items'] = $this->invoice_items_model->get();

        $this->load->model('clients_model');
        $data['clients'] = $this->clients_model->get();

        $this->load->model('staff_model');
        $data['staff'] = $this->staff_model->get('',1);

        $data['title']     = $title;
        $this->load->view('admin/quotes/quote', $data);
    }

    public function init_quote_items_ajax($id){
        echo json_encode($this->quotes_model->get_quote_items($id));
    }
    /* Get all quote data used when user click on quote number in a datatable left side*/
    public function get_quote_data_ajax($id)
    {
        if(!has_permission('manageSales')){
            access_denied('manageSales');
        }

        if (!$id) {
            die('No quote found');
        }

        $quote = $this->quotes_model->get($id);
        if(!$quote){
            echo 'Quote Not Found';
            die;
        }
        $quote->date    = _d($quote->date);
        $quote->expirydate = _d($quote->expirydate);

        if($quote->invoiceid !== NULL){
            $this->load->model('invoices_model');
            $quote->invoice = $this->invoices_model->get($quote->invoiceid);
        }

        $this->load->model('emails_model');

        if ($quote->sent == 0) {
            $data['template'] = $this->emails_model->parse_template('quote-send-to-client', $quote->clientid, false,false,false,$id);
        } else {
            $data['template'] = $this->emails_model->parse_template('quote-already-send', $quote->clientid, false,false,false,$id);
        }

        $data['activity'] = $this->quotes_model->get_quote_activity($id);
        $data['quote']  = $quote;
        $this->load->view('admin/quotes/quote_preview_template', $data);
    }

    public function get_quotes_total(){
        if(!has_permission('manageSales')){
            access_denied('manageSales');
        }
        if($this->input->post()){
            $data['totals'] = $this->quotes_model->get_quotes_total($this->input->post());
            $this->load->model('currencies_model');
            $base_currency = $this->currencies_model->get_base_currency()->id;
            if(is_using_multiple_currencies('tblquotes') || (total_rows('tblquotes',array('currency'=>$base_currency)) == 0) && total_rows('tblquotes') > 0){
                $this->load->model('currencies_model');
                $data['currencies'] = $this->currencies_model->get();
            }
            $this->load->view('admin/quotes/quotes_total_template',$data);
        }
    }

    public function mark_action_status($status, $id)
    {
        $success = $this->quotes_model->mark_action_status($status, $id);
        if ($success) {
            set_alert('success', _l('quote_status_changed_success'));
        } else {
            set_alert('danger', _l('quote_status_changed_fail'));
        }
        redirect(admin_url('quotes/list_quotes/' . $id));
    }

    /* Send quote to email */
    public function send_to_email($id)
    {
         if(!has_permission('manageSales')){
            access_denied('manageSales');
         }
        $success = $this->quotes_model->sent_quote_to_client($id,'',$this->input->post('attach_pdf'));
        if ($success) {
            set_alert('success', _l('quote_sent_to_client_success'));

        } else {
            set_alert('danger', _l('quote_sent_to_client_fail'));
        }
        redirect(admin_url('quotes/list_quotes/' . $id));
    }

    /* Convert quote to invoice */
    public function convert_to_invoice($id){

        if(!has_permission('manageSales')){
            access_denied('manageSales');
         }

        if(!$id){
            die('No quote found');
        }

        $invoiceid = $this->quotes_model->convert_to_invoice($id);
        if($invoiceid){
            set_alert('success',_l('quote_convert_to_invoice_successfuly'));
            redirect(admin_url('invoices/list_invoices/'.$invoiceid));
        } else {
            redirect(admin_url('invoices/list_quotes/'.$id));
        }
    }

    /* Delete quote */
    public function delete($id)
    {
        if(!has_permission('manageSales')){
            access_denied('manageSales');
        }
        if (!$id) {
            redirect(admin_url('quotes/list_quotes'));
        }

        $success = $this->quotes_model->delete($id);

        if(is_array($success)){
            set_alert('warning',_l('is_invoiced_quote_delete_error'));
        } else if ($success == true) {
           set_alert('success', _l('deleted',_l('quote')));
        } else {
            set_alert('warning', _l('problem_deleting',_l('quote_lowercase')));
        }

        redirect(admin_url('quotes/list_quotes'));
    }

    /* Generates quote PDF and senting to email of $send_to_email = true is passed */
    public function pdf($id, $send_to_email = false)
    {
        if(!has_permission('manageSales')){
            access_denied('manageSales');
        }

        if (!$id) {
            redirect(admin_url('quotes/list_quotes'));
        }

        $quote        = $this->quotes_model->get($id);
        $quote_number = format_quote_number($quote->id);
        $pdf              =   quote_pdf($quote);
        $pdf->Output($quote_number . '.pdf', 'D');
        //redirect(admin_url('quotes/list_quotes'));
    }
}
