<?php ob_start();
defined('BASEPATH') OR exit('No direct script access allowed');

class Purchaseorders extends Admin_controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('purchaseorders_model');
    }

    /* Get all purchaseorders in case user go on index page */
    public function index($id = false, $clientid = false)
    {
      
         // $has_permission = has_permission('manageSales');
         $has_permission = has_permission('PurchaseOrder');

         if(!$has_permission && !$this->input->is_ajax_request()){
            access_denied('PurchaseOrder');
         }

         $_status = '';

         if($this->input->get('status')){
            $_status = $this->input->get('status');
         }

        if ($this->input->is_ajax_request()) {
            // From client profile
            if(is_numeric($clientid)){
                if(!$has_permission){
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                'number',
                'podate',
                'supplierid',
                'total',
                'tblcurrencies.name',
                'expecteddate',
                'status'
            );

            $join = array(
                'LEFT JOIN tblsuppliers ON tblsuppliers.userid = tblpurchaseorders.supplierid',
                'LEFT JOIN tblcurrencies ON tblcurrencies.id = tblpurchaseorders.currency'
            );

            $where                    = array();

            if (is_numeric($clientid)) {
                $where                    = array(
                    'AND supplierid=' . $clientid
                );
            }


            if ($this->input->post('status')) {
                array_push($where, 'AND status=' . $this->input->post('status'));
            }

            if($this->input->post('custom_view')){
                $custom_view = $this->input->post('custom_view');
                if($custom_view == 'not_sent'){
                     array_push($where,'AND sent=0');
                 }
            }
 
            $sIndexColumn = "id";
            $sTable       = 'tblpurchaseorders';
            $result       = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array(
                'tblpurchaseorders.id',
                'invoiceid',
                'hash',
                'supplierid',
                'supplier',
                'symbol',
                'tblcurrencies.name',
                'total',
                'status'
            ));
            $output       = $result['output'];
            $rResult      = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();

                
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data                    = $aRow[$aColumns[$i]];

                    if ($aColumns[$i] == 'number') {
                        // If is from client area table
                    if (is_numeric($clientid)) {
                        $__data = '<a href="' . admin_url('purchaseorders/list_purchaseorders/' . $aRow['id']) . '">' . format_purchaseorder_number($_data) . '</a><br />';
                    } else {
                           $__data = '<a href="#" onclick="init_purchaseorder(' . $aRow['id'] . '); return false;">' . format_purchaseorder_number($_data) . '</a><br />';
                    }
                    } else if ($aColumns[$i] == 'podate') {
                        $__data = _d($_data);
                    }else if ($aColumns[$i] == 'expecteddate') {
                        $__data = _d($_data);
                    }
                    else if ($aColumns[$i] == 'supplierid') {
                        $__data = '<a href="' . admin_url('suppliers/supplier/' . $aRow['supplierid']) . '">' . $aRow['supplier'] . '</a>';
                    } else if ($aColumns[$i] == 'expirydate') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'total') {
                        $__data = format_money($_data, $aRow['symbol']);
                    }else if ($aColumns[$i] == 'tblcurrencies.name') {
                         $__data = $aRow['tblcurrencies.name'];
                    } else if($aColumns[$i] == 'status') {
                        $__data = format_purchaseorder_status($aRow['status']);
                        // Status
                    }
                    $row[] = $__data;
                }
                $options='';

                $options .= icon_btn('#','print','printorder',array('data-toggle' => 'tooltip', 'title' =>'Print Purchase Order','data-id'=>$aRow['id'],'data-hash'=>$aRow['hash']));
               $options .= icon_btn('admin/purchaseorders/pdf/' . $aRow['id'],'download','',array('data-toggle' => 'tooltip', 'title' =>'Download Purchase Order', 'download' =>'admin/purchaseorders/pdf/' . $aRow['id']));
                 $options .= icon_btn('#', 'eye','',array('data-toggle' => 'tooltip', 'title' =>_l('view_order'), 'onclick'=>'init_purchaseorder('.$aRow['id'].'); return false;'));
                if (has_permission('PurchaseOrder_delete')) { 
                    if($aRow['status'] != 5){
                     $options .= icon_btn('admin/purchaseorders/delete/' . $aRow['id'], 'remove', ' btn-delete-customer', array('data-toggle' => 'tooltip', 'title' =>'Delete Purchase Order'));
                    }
                }
                 $row[] =$options;
                 $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        $data['orderid'] = '';
        if (is_numeric($id)) {
            $data['orderid'] = $id;
        }


        $data['status'] = $_status;
        $data['bodyclass'] = 'small-table';
        $data['title']     = _l('purchaseorders');
        $this->load->view('admin/purchaseorders/manage', $data);
    }

    /* List all purchaseorders datatables */
    public function list_purchaseorders($id = false, $clientid = false)
    {
          $has_permission = has_permission('PurchaseOrder');

         if(!$has_permission && !$this->input->is_ajax_request()){
            access_denied('PurchaseOrder');
         }

         $_status = '';

         if($this->input->get('status')){
            $_status = $this->input->get('status');
         }

        if ($this->input->is_ajax_request()) {
            // From client profile
            if(is_numeric($clientid)){
                if(!$has_permission){
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                'number',
                'podate',
                'supplierid',
                'total',
                'tblcurrencies.name',
                'expecteddate',
                'status'
            );

            $join = array(
                'LEFT JOIN tblsuppliers ON tblsuppliers.userid = tblpurchaseorders.supplierid',
                'LEFT JOIN tblcurrencies ON tblcurrencies.id = tblpurchaseorders.currency'
            );

            $where                    = array();

            if (is_numeric($clientid)) {
                $where                    = array(
                    'AND supplierid=' . $clientid
                );
            }


            if ($this->input->post('status')) {
                array_push($where, 'AND status=' . $this->input->post('status'));
            }

            if($this->input->post('custom_view')){
                $custom_view = $this->input->post('custom_view');
                if($custom_view == 'not_sent'){
                     array_push($where,'AND sent=0');
                 }
            }
 
            $sIndexColumn = "id";
            $sTable       = 'tblpurchaseorders';
            $result       = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array(
                'tblpurchaseorders.id',
                'invoiceid',
                'hash',
                'supplierid',
                'supplier',
                'symbol',
                'tblcurrencies.name',
                'total',
                // 'status'
            ));
            $output       = $result['output'];
            $rResult      = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();

                
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data                    = $aRow[$aColumns[$i]];

                    if ($aColumns[$i] == 'number') {
                        // If is from client area table
                    if (is_numeric($clientid)) {
                        $__data = '<a href="' . admin_url('purchaseorders/list_purchaseorders/' . $aRow['id']) . '">' . format_purchaseorder_number($_data) . '</a><br />';
                    } else {
                           $__data = '<a href="#" onclick="init_purchaseorder(' . $aRow['id'] . '); return false;">' . format_purchaseorder_number($_data) . '</a><br />';
                    }
                    } else if ($aColumns[$i] == 'podate') {
                        $__data = _d($_data);
                    }else if ($aColumns[$i] == 'expecteddate') {
                        $__data = _d($_data);
                    }
                    else if ($aColumns[$i] == 'supplierid') {
                        $__data = '<a href="' . admin_url('suppliers/supplier/' . $aRow['supplierid']) . '">' . $aRow['supplier'] . '</a><br />';
                    } else if ($aColumns[$i] == 'expirydate') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'total') {
                        $__data = format_money($_data, $aRow['symbol']);
                    }else if ($aColumns[$i] == 'tblcurrencies.name') {
                         $__data = $aRow['tblcurrencies.name'];
                    } else if($aColumns[$i] == 'status') {
                        $__data = format_purchaseorder_status($aRow['status']);
                        // Status
                    }
                    $row[] = $__data;
                }
                $options='';
//                 if($aRow['invoiceid'] == NULL){
//                if($aRow['status'] == 4){
//                    $options = icon_btn('admin/purchaseorders/convert_to_invoice/' . $aRow['id'],'share','',array('data-toggle' => 'tooltip', 'title' =>_l('convert_invoice'),'status'=>$aRow['status']));
//                    }
//                }else{
//                   $options = icon_btn('admin/invoices/list_invoices/' . $aRow['invoiceid'], 'eye','',array('data-toggle' => 'tooltip', 'title' =>_l('view_invoice'). ' : ' .format_invoice_number($aRow['invoiceid']))); 
//                }
                $options .= icon_btn('#','print','printorder',array('data-toggle' => 'tooltip', 'title' =>'Print Purchase Order','data-id'=>$aRow['id'],'data-hash'=>$aRow['hash']));
               $options .= icon_btn('admin/purchaseorders/pdf/' . $aRow['id'],'download','',array('data-toggle' => 'tooltip', 'title' =>'Download Purchase Order', 'download' =>'admin/purchaseorders/pdf/' . $aRow['id']));
                 $options .= icon_btn('#', 'eye','',array('data-toggle' => 'tooltip', 'title' =>_l('view_order'), 'onclick'=>'init_purchaseorder('.$aRow['id'].'); return false;'));
                if (has_permission('PurchaseOrder_delete')) { 
                    if($aRow['status'] != 5){
                     $options .= icon_btn('admin/purchaseorders/delete/' . $aRow['id'], 'remove', ' btn-delete-customer', array('data-toggle' => 'tooltip', 'title' =>'Delete Purchase Order'));
                    }
                }
                 $row[] =$options;
                 $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        $data['orderid'] = '';
        if (is_numeric($id)) {
            $data['orderid'] = $id;
        }

        $data['status'] = $_status;
        $data['bodyclass'] = 'small-table';
        $data['title']     = _l('purchaseorders');
        $this->load->view('admin/purchaseorders/manage', $data);
    }

    /* Add new order or update existing */
    public function purchaseorder($customerid = '',$id = '')
    {
         if(!has_permission('PurchaseOrder')){
            access_denied('PurchaseOrder');
         }
        $this->load->model('clients_model');
        if (($this->input->post())&&(!isset($_POST["itemID"]))) {

            if ($id == '') {
               
                if(!has_permission('PurchaseOrder_add')){
                    access_denied('PurchaseOrder_add');
                }

                
                // echo "<pre>";
                // print_r($_POST['vatpaid']);
                // die;
                $id = $this->purchaseorders_model->add($this->input->post());
                if ($id) {
                    $purchaseorders = $this->purchaseorders_model->get($id);
                    if ($purchaseorders->number != $this->input->post('_number')) {
                        set_alert('warning', _l('purchaseorder_number_changed'));
                    } else {
                       set_alert('success', _l('added_successfuly',_l('purchaseorder')));
                    }
                    
                    if (trim($this->input->post('action')) == 'save') {
                          redirect(admin_url('purchaseorders/purchaseorder/'.$this->input->post('supplierid').'/'. $id));
                        exit;
                    }
                    if (trim($this->input->post('action')) == 'snew') {
                        redirect(admin_url('purchaseorders/purchaseorder'));
                        exit;
                    }
                 
                    if (trim($this->input->post('action')) == 'slist') {
                         redirect(admin_url('purchaseorders/list_purchaseorders/' . $id));
                         
                    }
                    if (trim($this->input->post('action')) == 'cancel') {
                        redirect(admin_url());
                        exit;
                    }
//                    redirect(admin_url('purchaseorders/list_purchaseorders/' . $id));
                }
            } else {

                if(!has_permission('PurchaseOrder_edit')){
                    access_denied('PurchaseOrder_edit');
                }
                $success = $this->purchaseorders_model->update($this->input->post(), $id);
                if ($success) {
                   set_alert('success', _l('updated_successfuly',_l('rfqsorder')));
                }
               if (trim($this->input->post('action')) == 'save') {
                          redirect(admin_url('purchaseorders/purchaseorder/'.$this->input->post('supplierid').'/'. $id));
                        exit;
                    }
                    if (trim($this->input->post('action')) == 'snew') {
                        redirect(admin_url('purchaseorders/purchaseorder'));
                        exit;
                    }
                 
                    if (trim($this->input->post('action')) == 'slist') {
                         redirect(admin_url('purchaseorders/list_purchaseorders/' . $id));
                         
                    }
                    if (trim($this->input->post('action')) == 'cancel') {
                        redirect(admin_url());
                        exit;
                    }
            }
        }

        if ($id == '') {
            $title = _l('create_new_purchaseorder');
        } else {
            $purchaseorders = $this->purchaseorders_model->get($id);

           if($purchaseorders->status =='5'){
                access_denied('managePurchaseorder');
                die();
           }
           $data['contacts'] = $this->purchaseorders_model->get_where_contacts($purchaseorders->supplierid);
            $purchaseorders->date    = _d($purchaseorders->date);
            $purchaseorders->expirydate = _d($purchaseorders->expirydate);
            $this->load->model('emails_model');
            if ($purchaseorders->sent == 0) {
                $data['template'] = $this->emails_model->parse_template('order-send-to-client', $purchaseorders->clientid, false,false,false,$id);
            } else {
                $data['template'] = $this->emails_model->parse_template('order-already-send', $purchaseorders->clientid, false,false,false,$id);
            }

             $data['purchaseorders'] = $this->clients_model->get_where_record('tblpurchaseorders',$id);
           if(isset($data['purchaseorders'])){
            $customerid = $data['purchaseorders']->clientid;
         }
           
		  // $data['customerdetails'] = $this->clients_model->get_client($customerid);

            $data['prev'] = $this->purchaseorders_model->get_prev($id);
          $data['next'] = $this->purchaseorders_model->get_next($id);
            $data['purchaseorder']  = $purchaseorders;
            $data['edit'] = true;
            $title           = _l('edit',_l('purchaseorder_lowercase'));
        }
        

//        $data['customerdetails'] = $this->clients_model->get_client($customerid);
        
        $this->load->model('taxes_model');
        $data['taxes'] = $this->taxes_model->get();

        $this->load->model('currencies_model');
        $data['currencies'] = $this->currencies_model->get();

        $this->load->model('suppliers_model');
        $data['suppliers'] = $this->suppliers_model->get(); 
        $data['supplierdetails'] = $this->suppliers_model->get_client($customerid);

         $this->load->model('discount_model');
        $data['discount'] = $this->discount_model->get_discounts();
   
        
          $data['copy'] ='';
        if($this->input->get('copyid')){
            $data['copy'] =$this->input->get('copyid');
           $data['purchaseorders']['items'] =   $this->purchaseorders_model->get_items($this->input->get('copyid'));
        }

        
		 $this->load->model('rfqs_model');
        $rfqs = $this->rfqs_model->get_rfqs_by_status(3);
		$listRFQ=array();
		foreach($rfqs as $rfq)
		{
			$rfq["items"]= $this->rfqs_model->get_rfqs_items($rfq["id"]);
			$listRFQ[]=$rfq;
		}
		$this->load->model('warehouse_model');
		$warehouses=$this->warehouse_model->get();
		
			
			$listWarhouses=array();
			foreach($warehouses as $w)
			{
				$listWarhouses[$w['ware_id']]=$w['warehouse_name'];
			}
		$data['listWarhouses'] =	$listWarhouses;
		
		 $data['rfqs']=$listRFQ;
        $data['title']     = $title;
        $this->load->view('admin/purchaseorders/purchaseorder', $data);
    }

    public function init_order_items_ajax($id){
        echo json_encode($this->purchaseorders_model->get_purchaseorder_items($id));
    }
    
    public function get_term() {
       
 $terms = $this->purchaseorders_model->get_term($this->input->post('id'));
 $account_repy = $this->purchaseorders_model->get_sales_agent($this->input->post('id'));
  echo json_encode(array('payment_term'=>$terms,'account_rep'=>$account_repy));

    }
    
    /* Get all order data used when user click on order number in a datatable left side*/
    public function get_order_data_ajax($id)
    {
        // if(!has_permission('manageSales')){
        //     access_denied('manageSales');
        // }
        if(!has_permission('PurchaseOrder')){
            access_denied('PurchaseOrder');
        }

        if (!$id) {
            die('No order found');
        }

        $order = $this->purchaseorders_model->get($id);
        $data['grn_number'] = $this->purchaseorders_model->get_grn($id);
        $data['purchase_request'] = $this->purchaseorders_model->get_request($id);

        $order->podate    = _d($order->podate);
        $order->expecteddate = _d($order->expecteddate);

//        if($order->invoiceid !== NULL){
//            $this->load->model('invoices_model');
//            $order->invoice = $this->invoices_model->get($order->invoiceid);
//        }

        $this->load->model('emails_model');

        if ($order->sent == 0) {
            $data['template'] = $this->emails_model->parse_template('purchaseorder_send_to_client', $order->supplierid, false,false,false,$id);
        } else {
            $data['template'] = $this->emails_model->parse_template('purchaseorder_send_to_client', $order->supplierid, false,false,false,$id);
        }

        $data['activity'] = $this->purchaseorders_model->get_order_activity($id);
        $data['order']  = $order;
        $this->load->view('admin/purchaseorders/purchaseorder_preview_template', $data);
    }

    public function get_purchaseorders_total(){
        if(!has_permission('PurchaseOrder')){
            access_denied('PurchaseOrder');
        }
        if($this->input->post()){
            $data['totals'] = $this->purchaseorders_model->get_purchaseorders_total($this->input->post());
            $this->load->model('currencies_model');
            $base_currency = $this->currencies_model->get_base_currency()->id;
            if(is_using_multiple_currencies('tblpurchaseorders') || (total_rows('tblpurchaseorders',array('currency'=>$base_currency)) == 0) && total_rows('tblpurchaseorders') > 0){
                $this->load->model('currencies_model');
                $data['currencies'] = $this->currencies_model->get();
            }
            $this->load->view('admin/purchaseorders/purchaseorders_total_template',$data);
        }
    }

    /* Send order to email */
    public function send_to_email($id)
    {
         if(!has_permission('PurchaseOrder')){
            access_denied('PurchaseOrder');
         }
        $success = $this->purchaseorders_model->sent_order_to_client($id,'',$this->input->post('attach_pdf'));
        if ($success) {
            set_alert('success', _l('order_sent_to_client_success'));

        } else {
            set_alert('danger', _l('order_sent_to_client_fail'));
        }
        redirect(admin_url('purchaseorders/list_purchaseorders/' . $id));
    }

    /* Convert order to invoice */
    public function convert_to_invoice($id){

        if(!has_permission('PurchaseOrder')){
            access_denied('PurchaseOrder');
         }

        if(!$id){
            die('No order found');
        }

        $invoiceid = $this->purchaseorders_model->convert_to_invoice($id);

        if($invoiceid){
            set_alert('success',_l('order_convert_to_invoice_successfuly'));
            redirect(admin_url('invoices/list_invoices/'.$invoiceid));
        } else {
            redirect(admin_url('purchaseorders/list_purchaseorders/'.$id));
        }
    }

    /* Delete order */
    public function delete($id)
    {
         if(!has_permission('PurchaseOrder_delete')){
            access_denied('PurchaseOrder_delete');
         }

        if (!$id) {
            redirect(admin_url('purchaseorders/list_purchaseorders'));
        }

        $success = $this->purchaseorders_model->delete($id);

        if ($success) {
           set_alert('success', _l('deleted',_l('purchaseorder')));
        } else {
            set_alert('warning', _l('problem_deleting',_l('purchaseorder_lowercase')));
        }

        redirect(admin_url('purchaseorders/list_purchaseorders'));
    }

    /* Generates order PDF and senting to email of $send_to_email = true is passed */
    public function pdf($id, $send_to_email = false)
    {
        if(!has_permission('PurchaseOrder')){
            access_denied('PurchaseOrder');
        }

        if (!$id) {
            redirect(admin_url('purchaseorders/list_purchaseorders'));
        }

        $order        = $this->purchaseorders_model->get($id);
        $order_number = format_purchaseorder_number($order->number);
        $pdf              =   purchaseorder_pdf($order);
        $pdf->Output($order_number . '.pdf', 'D');
    }
     public function change_order_status($status,$id){
		 
          echo $this->purchaseorders_model->change_order_status($status,$id);
    }
    public function checkcreadit(){
        $invoice =  $this->purchaseorders_model->getinvoices($this->input->post('clientid'));
        $purchaseorders =  $this->purchaseorders_model->getpurchaseorders($this->input->post('clientid'));
        if($this->input->post('credit')){
            $this->purchaseorders_model->update_credit($this->input->post('credit'),$this->input->post('clientid'));
         }
        $client=  $this->purchaseorders_model->getcredit($this->input->post('clientid'));
        $creditbalance = $client->credit_limit-($purchaseorders->total+$invoice->total);
      
        if( $this->input->post('amount') > $creditbalance){
            echo json_encode(array('status'=>'0','creditbalance'=>$creditbalance));
        }else{
             echo  json_encode(array('status'=>'1','creditbalance'=>$creditbalance));
        }
        
        
        
    }
    public function get_contacts(){
       $contacts =  $this->purchaseorders_model->get_contacts($this->input->post('id'));
       $html = "<option value=''></option>";
       foreach ($contacts as $value) {
          $html .= "<option value='$value->id'>$value->firstname $value->lastname</opyion>"; 
       }
       echo json_encode(array('contacts'=>$html));
    }

    public function get_paymentterms(){
       $payment_term =  $this->purchaseorders_model->get_paymentterms($this->input->post('supplierid'));
       echo $payment_term->payment_term;
       // $html = "<option value=''></option>";
       // foreach ($contacts as $value) {
       //    $html .= "<option value='$value->id'>$value->firstname $value->lastname</opyion>"; 
       // }
       // echo json_encode(array('contacts'=>$html));
    }

     public function get_orders_total(){
        // if(!has_permission('managePurchaseorder')){
        //     access_denied('managePurchaseorder');
        // }
        if(!has_permission('PurchaseOrder_add')){
            access_denied('PurchaseOrder_add');
        }
        if($this->input->post()){
            $data['totals'] = $this->purchaseorders_model->get_orders_total($this->input->post());
            $this->load->model('currencies_model');
            $base_currency = $this->currencies_model->get_base_currency()->id;
            if(is_using_multiple_currencies('tblpurchaseorders') || (total_rows('tblpurchaseorders',array('currency'=>$base_currency)) == 0) && total_rows('tblpurchaseorders') > 0){
                $this->load->model('currencies_model');
                $data['currencies'] = $this->currencies_model->get();
            }
            $this->load->view('admin/purchaseorders/purchaseorder_total_template',$data);
        }
    }

}
