<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Product_services extends Admin_controller {

    function __construct() {
        parent::__construct();
        $this->load->model('services_model');
    }

    /* List all available items */

    public function index() {
		
        if ($this->input->is_ajax_request()) {
			
			
            $aColumns = array(                
                'name'  
            );
            $sIndexColumn = "id";
            $sTable = 'product_services';
            $join = array(
            );
            $additionalSelect = array(
                'id'
            );
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, array(), $additionalSelect);
            $output = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                     $_data = $aRow[$aColumns[$i]];
                    if ($aColumns[$i] == 'name') {
						
                         $_data = $_data;
                    }
					     
                    $row[] = $_data;
                }
                $options = icon_btn('admin/product_services/services/' . $aRow['id'], 'pencil-square-o', 'edit-locations', array('data-toggle' => 'tooltip', 'title' => _l('services_edit_tooltip')));
                
                
                $row[] = $options .= icon_btn('admin/product_services/delete/' . $aRow['id'], 'remove', '',array('onClick' => 'return deleteconf();'));

                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        $data['title'] = _l('product_services');
        $this->load->view('admin/services/manage', $data);
    }

    public function services($id = '') {
        if ($this->input->post() && !$this->input->is_ajax_request()) {
			
			
			//print_r($this->input->post());
			
            if ($id == '') {
                    $id = $this->services_model->add($this->input->post());
                    if ($id) {
                        set_alert('success', _l('services_added_successfully', _l('services_added')));
						
						
                        if (trim($this->input->post('action')) == 'save') {
                            redirect(admin_url('product_services/services/'.$id));
							// redirect(admin_url('engines'));

                            exit;
                           }
                        if (trim($this->input->post('action')) == 'snew') {
							 redirect(admin_url('product_services/services/'.$id));
                            exit;
                        }

                        if (trim($this->input->post('action')) == 'slist') {
                             redirect(admin_url('product_services'));
                              exit;
                        }
                        
                    }
            } else {
				if (trim($this->input->post('action')) == 'save') {
                            $success = $this->services_model->update($this->input->post(), $id);
							
                           }
						   else if (trim($this->input->post('action')) == 'snew') {
                            $success = $this->services_model->add($this->input->post());
                        }
                
  
                if ($success) {
                  
                    set_alert('success', _l('services_updated_successfully', _l('services_updated')));
                    if (trim($this->input->post('action')) == 'save') {
                            redirect(admin_url('product_services/services/'.$id));
                            exit;
                           }
                        if (trim($this->input->post('action')) == 'snew')
						 {
							 $id = $success;
                            redirect(admin_url('product_services/services/'.$id));
                            exit;
                        }

                        if (trim($this->input->post('action')) == 'slist') {
                             redirect(admin_url('product_services'));
                              exit;
                        }
                }
                
            }
        }

        if ($id == '') {
            $title = _l('add_new', _l('warehouse_table_heading'));
        } else {     
           
           // $services = $this->services_model->get_where_single_tbl('product_services','id',$id);
			$data['services'] = $this->services_model->get($id);
			
            $data['product_to_services'] = $this->services_model->get_where_single_tbl_result('product_to_services','service_id',$id);
            $title = _l('edit', _l('warehouse_table_heading'));
        }
		
		$this->load->model('products_model');
		$data['products']=$this->products_model->get();
	
		//echo $this->db->last_query();;
		
        $data['title'] = $title;
        $this->load->view('admin/services/services', $data);
    }

   

    /* Delete item */

    public function delete($id) {
        if (!$id) {
            redirect(admin_url('product_services'));
        }

        $response = $this->services_model->delete($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('services_lowercase')));
        } else if ($response == true) {
            set_alert('success', _l('deleted', _l('services')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('services_lowercase')));
        }
        redirect(admin_url('product_services'));
    }
    
    /*delete warehouse contact*/
    public function deletecontactwarehouse()
    {
        $id=  $this->input->post('id');
        $response = $this->make_model->deletecontact($id);
    }
    
    public function delete_items()
    {
        $id=  $this->input->post('id');
        $response = $this->make_model->deleteitems($id);
        echo $response;
    }

    



    public function get_warehouse_reminders($id){
		if($this->input->is_ajax_request()){

			$aColumns = array( 'description', 'date', 'staff', 'isnotified');
			$sIndexColumn = "id";
			$sTable = 'tbladminwarehousereminders';

			$where = array('AND ware_id='.$id);
			$join = array(
				'JOIN tblstaff ON tblstaff.staffid = tbladminwarehousereminders.staff'
				);
			$result = data_tables_init($aColumns,$sIndexColumn,$sTable,$join,$where,array('firstname','lastname','id','creator'));
			$output = $result['output'];
			$rResult = $result['rResult'];

			foreach ( $rResult as $aRow )
			{
				$row = array();
				for ( $i=0 ; $i<count($aColumns) ; $i++ )
				{
					$_data = $aRow[ $aColumns[$i] ];
					if($aColumns[$i] == 'staff'){
						$_data = '<a href="'.admin_url('staff/profile/'.$aRow['staff']).'">'.staff_profile_image($aRow['staff'], array(
							'staff-profile-image-small'
							)) . ' ' . $aRow['firstname'] . ' ' . $aRow['lastname'] .'</a>';
					} else if($aColumns[$i] == 'staff'){
						$_data = _d($_data);
					} else if($aColumns[$i] == 'isnotified'){
						if($_data == 1){
							$_data = _l('client_reminder_is_notified_boolean_yes');
						} else {
							$_data = _l('client_reminder_is_notified_boolean_no');
						}
					}
					$row[] = $_data;
				}

				if($aRow['creator'] == get_staff_user_id()){
					//$row[] = icon_btn('admin/warehouse/delete_reminder/'.$id . '/'. $aRow['id'], 'remove', '');
				       $row[]  =  icon_btn('#', 'remove', ' delete-reminders', array('data-id'=>$aRow['id']));
                
                                        
                                } else {
					$row[] = '';
				}


				$output['aaData'][] = $row;
			}

			echo json_encode( $output );
			die();
		}
	}
        
        /* Since version 1.0.2 add client reminder */
	public function add_warehouse_reminder($id){
		if(!has_permission('manageClients')){
			access_denied('manageClients');
		}

		if($this->input->post()){
			$success = $this->make_model->add_reminder($this->input->post(),$id);
			if($success){
				set_alert('success',_l('warehouse_reminder_added_successfuly'));
			}
		}

		redirect(admin_url('make/warehouse/'.$id));
	}

	/* Since version 1.0.2 delete client reminder */
	public function delete_reminders(){
		$id=  $this->input->post('id');
		$success = $this->make_model->delete_reminder($id);
                echo $success;
	}

    /* Get item by id / ajax */

    public function get_item_by_id($id) {
        if ($this->input->is_ajax_request()) {
            echo json_encode($this->make_model->get($id));
        }
    }

    /* Get all items */

    public function get_all_items_ajax() {
        if ($this->input->is_ajax_request()) {
            echo json_encode($this->make_model->get_all_items_ajax());
        }
    }
    
    /*Warehouse Id Exist or Not*/
    public function check_warehouse()
    {
        $warehouse_id=  $this->input->post('warehouse_id');
        $check_warehouse=  $this->make_model->get_where_single_tbl('tblwarehouse', 'warehouse_id', $warehouse_id);
        if(empty($check_warehouse))
        {
           echo '1';
        }
        else {
            echo '0';
        }
    }
          public function manage()
    {
        if ($this->input->post()) {
            $data = $this->input->post();
            if ($data['contactid'] == '') {
                $message = '';
                $success = $this->make_model->addcontact($data);
                if($success) {
                    $message = _l('added_successfuly','Contact');
                }
                echo json_encode(array(
                    'success' => $success,
                    'message'=>$message
                ));
            } else {
                $message = '';
                $success = $this->make_model->updateContacts($data);
                if($success){
                    $message = _l('updated_successfuly','Contact');
                }
                echo json_encode(array(
                    'success' => $success,
                    'message'=>$message
                ));
            }
        }
    }
    public function getcontact(){
       echo json_encode($this->make_model->getcontact($this->input->post('id')));
    }
}
