<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Periods extends Admin_controller {

    function __construct() {
        parent::__construct();
        $this->load->model('periods_model');
    }

    /* List all clients */

    public function index() {

        if ($this->input->is_ajax_request()) {
            $aColumns = array('fromdate', 'todate', 'description', 'status');
            $sIndexColumn = "id";
            $sTable = 'tblperiod';
   
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, array(),  array(), array('id'));
            $output = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];
                     if ($aColumns[$i] == 'fromdate') {
                        $_data = _d($_data);
                    }
                     if ($aColumns[$i] == 'todate') {
                        $_data = _d($_data);
                    }
                    $row[] = $_data;
                }

                $options = icon_btn('admin/periods/period/' . $aRow['id'], 'pencil-square-o');
                $row[] = $options .= icon_btn('admin/periods/delete/' . $aRow['id'], 'remove', '', array('data-toggle' => 'tooltip', 'onClick' => 'return deleteconf();','title' => _l('period_delete_tooltip')));

                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }


        $data['title'] = _l('Periods');
        $this->load->view('admin/periods/manage', $data);
    }



    public function period($id = '') {
        

        if ($this->input->post() && !$this->input->is_ajax_request()) {
            if (!has_permission('managePeriods')) {
                access_denied('managePeriods');
            }

            if ($id == '') {
                $id = $this->periods_model->add($this->input->post());
     
                if ($id) {
                    set_alert('success', _l('added_successfuly', _l('periods')));
                    if (trim($this->input->post('action')) == 'save') {
                        redirect(admin_url('periods/period/' . $id));
                        exit;
                    }
                    if (trim($this->input->post('action')) == 'snew') {
                        redirect(admin_url('periods/period'));
                        exit;
                    }
                    if (trim($this->input->post('action')) == 'sexit') {
                        redirect(admin_url('periods'));
                    }
                }
            } else {
                $success = $this->periods_model->update($this->input->post(), $id);
                if ($success) {
                    set_alert('success', _l('updated_successfuly', _l('periods')));
                }
                if (trim($this->input->post('action')) == 'save') {
                    redirect(admin_url('periods/period/' . $id));
                    exit;
                }
                if (trim($this->input->post('action')) == 'snew') {
                    redirect(admin_url('periods/period'));
                    exit;
                }
                if (trim($this->input->post('action')) == 'sexit') {
                    redirect(admin_url('periods'));
                }
            }
        }

        if ($id == '') {
            $title = _l('Period');
        } else {

            $period = $this->periods_model->get($id);

              $data['period'] = $period;
            $title =  _l('Period');
        }


      
        $data['id'] = $id;
        $data['title'] = $title;
        $this->load->view('admin/periods/periods', $data);
    }

    /* Delete client */

    public function delete($id) {

        if (!has_permission('manageperiods')) {
            access_denied('manageperiods');
        }

        if (!$id) {
            redirect(admin_url('periods'));
        }

        $response = $this->periods_model->delete($id);

        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('period')));
        } else if ($response == true) {
            set_alert('success', _l('deleted', _l('period')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('period')));
        }

        redirect(admin_url('periods'));
    }

    /* Change client status / active / inactive */

    public function change_subgroup_status($id, $status) {

        if (!has_permission('manageBanks')) {
            access_denied('manageBanks');
        }

        if ($this->input->is_ajax_request()) {
            $this->periods_model->change_subgroup_status($id, $status);
        }
    }

    /* Get client by id - used in ajax request */

    public function get_client_by_id_ajax($id) {

        if (!$id) {
            redirect(admin_url('clients'));
        }

        if (!has_permission('manageClients')) {
            access_denied('manageClients');
        }
        if ($this->input->is_ajax_request()) {
            echo json_encode($this->clients_model->get($id));
        }
    }

   
}
