<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Payments extends Admin_controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('payments_model');
    }

    /* In case if user go only on /payments*/
    public function index($clientid = false)
    {
        $this->list_payments($clientid);
    }
    /* List all invoice paments */
    public function list_payments($clientid = false)
    {

         // $has_permission = has_permission('manageSales');

         // if(!$has_permission && !$this->input->is_ajax_request()){
         //    access_denied('manageSales');
         // }

        $has_permission = has_permission('child-payments');

        if(!$has_permission && !$this->input->is_ajax_request()){
            access_denied('child-payments');
        }

         $_custom_view = '';

         if($this->input->get('custom_view')){
            $_custom_view = $this->input->get('custom_view');
         }

        if ($this->input->is_ajax_request()) {
            // From client profile
            if(is_numeric($clientid)){
                if(!$has_permission){
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                'tblinvoicepaymentrecords.id',
                'tblinvoicepaymentrecords.date',
                'invoiceid',
                'paymentmode',
                'company',
                'tblinvoicepaymentrecords.amount',
                
            );

            $join = array(
                'LEFT JOIN tblinvoices ON tblinvoices.id = tblinvoicepaymentrecords.invoiceid',
                'LEFT JOIN tblclients ON tblclients.userid = tblinvoices.clientid',
                'LEFT JOIN tblcurrencies ON tblcurrencies.id = tblinvoices.currency',
                'LEFT JOIN tblinvoicepaymentsmodes ON tblinvoicepaymentsmodes.id = tblinvoicepaymentrecords.paymentmode'

            );


            $where = array();
            if(is_numeric($clientid)){
                array_push($where,'AND tblclients.userid='.$clientid);
                
            }

            if($this->input->post('custom_view')){
                $custom_view = $this->input->post('custom_view');
                if($custom_view == 'today'){
                    array_push($where,'AND DATE(tblinvoicepaymentrecords.date) = "'.date('Y-m-d').'"');
                }
            }

            $sIndexColumn = "id";
            $sTable       = 'tblinvoicepaymentrecords';
            $result       = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array(
                'tblinvoices.id',
                'tblinvoicepaymentrecords.date',
                // 'tblinvoicepaymentrecords.amount',
                'tblinvoicepaymentrecords.receipt_number',
                'firstname',
                'lastname',
                'accountname',
                'company',
                'clientid',
                'symbol',
                'total',
                'tblinvoices.number',
                'tblinvoicepaymentsmodes.name',
                'tblinvoicepaymentsmodes.id as paymentmodeid'
            ));
            $output       = $result['output'];
            $rResult      = $result['rResult'];



             $this->load->model('payment_modes_model');
             $online_modes = $this->payment_modes_model->get_online_payment_modes();

            

            foreach ($rResult as $aRow) {
                $row = array();

                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];
                    if ($aColumns[$i] == 'paymentmode') {
                         $_data = $aRow['name'];
                         // Since version 1.0.1
                        if (is_null($aRow['paymentmodeid'])) {
                            foreach ($online_modes as $online_mode) {
                                if ($aRow['paymentmode'] == $online_mode['id']) {
                                    $_data = $online_mode['name'];
                                }
                            }
                        }
                    } else if ($aColumns[$i] == 'tblinvoicepaymentrecords.id') {
                        $_data = '<a href="' . admin_url('payments/payment/' . $_data) . '">' . $aRow['receipt_number'] . '</a>';
                    } else if ($aColumns[$i] == 'tblinvoicepaymentrecords.date') {
                        $_data = _d($_data);
                    } else if ($aColumns[$i] == 'invoiceid') {
                                          
                        $_data = '<a href="' . admin_url('invoices/list_invoices/' . $aRow[$aColumns[$i]]) . '">' . format_invoice_number( $this->payment_modes_model->get_invoicid($aRow['invoiceid'])) . '</a>';
                    } else if ($aColumns[$i] == 'company') {
                        $company = $aRow['company'];
                        if ($company != '') {
                            $company .= '<small class="text-muted"> ' . $aRow['accountname'] . '</small>';
                        } else {
                            $company = $aRow['accountname'];
                        }

                        $_data = '<a href="' . admin_url('clients/client/' . $aRow['clientid']) . '">' . $company . '</a>';
                    } else if ($aColumns[$i] == 'amount') {
                        $_data = format_money($_data,$aRow['symbol']);
                    }

                    $row[] = $_data;
                }

                $options            = icon_btn('admin/payments/payment/' . $aRow['tblinvoicepaymentrecords.id'], 'pencil-square-o');
                $row[]              = $options .= icon_btn('admin/payments/delete/' . $aRow['tblinvoicepaymentrecords.id'], 'remove','',array('onClick' => 'return deleteconf();'));
                $output['aaData'][] = $row;
            }
            echo json_encode($output);
            die();
        }

        $data['custom_view'] = $_custom_view;
        $data['title'] = _l('payments');
        $this->load->view('admin/payments/manage', $data);
    }

    /* Update payment data */
    public function payment($id = '')
    {

        if (!$id) {
            redirect(admin_url('payments'));
        }

        if ($this->input->post()) {
            // print_r($this->input->post());
            // die;
            $success = $this->payments_model->update($this->input->post(), $id);
            if ($success) {
               set_alert('success', _l('updated_successfuly',_l('payment')));
            }
            redirect(admin_url('payments/payment/' . $id));
        }

        $data['payment'] = $this->payments_model->get($id);
        if (!$data['payment']) {
            blank_page(_l('payment_not_exists'));
        }

        $this->load->model('invoices_model');
        $data['invoice'] = $this->invoices_model->get($data['payment']->invoiceid);

        $this->load->model('payment_modes_model');
        $data['payment_modes'] = $this->payment_modes_model->get();
           $data['banks'] = $this->invoices_model->get_bank();
        $data['title'] = _l('edit',_l('payment_lowercase'));


        $receipt = $this->payments_model->get_last_payment();
        if($receipt){
          $res = explode('-',$receipt->receipt_number);
        }else{
           $res = array();
        }
        if ($receipt->receipt_number) {
            if(get_option('next_receipt') >  $res[1] - 1) {
        
                $ac = get_option('receipt_prefix') . get_option('receipt_separator') . get_option('next_receipt');
                $data['receipt_number'] = $ac;
            }else{
             $data['receipt_number'] = ++$receipt->receipt_number;
            }
        } else {
            $ac = get_option('receipt_prefix') . get_option('receipt_separator') . get_option('receipt_startnumber');
            $data['receipt_number'] = $ac;
        }


        $this->load->view('admin/payments/payment', $data);
    }

    public function newpayment($clientid ='',$id = ''){
        if($this->input->post() && !$this->input->is_ajax_request()){
			// if(!has_permission('managePayments')){
                // access_denied('managePayments');
            // }
            if(!has_permission('child-payments_add')){
				access_denied('child-payments_add');
			}

			if($id == ''){
                // echo "<pre>";
                // print_r($this->input->post());
                // die;
				$id = $this->payments_model->makepayments($this->input->post());
                if ($id) {
                   set_alert('success', _l('invoice_payment_recorded'));
                   redirect(admin_url('payments/newpayment/'.$clientid));
               } else {
                   set_alert('danger', _l('invoice_payment_record_failed'));
               }
                               
                               
			}
		}

		if($id == ''){
			$title = _l('add_new',_l('new_payment'));
		} 

        $receipt = $this->payments_model->get_last_payment();
        if($receipt){
          $res = explode('-',$receipt->receipt_number);
        }else{
           $res = array();
        }
        if ($receipt->receipt_number) {
            if(get_option('next_receipt') >  $res[1] - 1) {
        
                $ac = get_option('receipt_prefix') . get_option('receipt_separator') . get_option('next_receipt');
                $data['receipt_number'] = $ac;
            }else{
             $data['receipt_number'] = ++$receipt->receipt_number;
            }
        } else {
            $ac = get_option('receipt_prefix') . get_option('receipt_separator') . get_option('receipt_startnumber');
            $data['receipt_number'] = $ac;
        }

	        $this->load->model('clients_model');
                $data['clients'] = $this->clients_model->get();
                $client = $this->clients_model->get($clientid);
                
                $data['invoices'] = $this->payments_model->get_userinvoice($clientid);
             
                
                $outstanding=$overdue= 0;
                if($data['invoices']){
                foreach ($data['invoices']  as $key => $value) {
                      $paidamount =  $this->getbalance($value->id);
                    $outstanding = $outstanding+$value->total - $paidamount;
                    if($value->status =='4'){
                       $overdue =$overdue +$value->total - $paidamount;
                    }
                }
                }
                $data['outstanding'] =$outstanding;
                $data['overdue'] =$overdue;
                $data['credit'] =$client->credit;
                $data['banks'] = $this->invoices_model->get_bank();
      		$data['title'] = $title;
      		$data['client'] = $clientid;
		$this->load->view('admin/payments/multipayment',$data);
    }
    public function list_invoices($clientid = false)
    {
        // $has_permission = has_permission('managePayments');
        $has_permission = has_permission('child-payments_add');

        //  if(!$has_permission && !$this->input->is_ajax_request()){
        //     access_denied('managePayments');
        //  }

        if(!has_permission('child-payments_add')){
            access_denied('child-payments_add');
        }


        $this->load->model('payment_modes_model');

        $data['payment_modes'] = $this->payment_modes_model->get('',true);
        $_custom_view = '';
        $_status = '';

        if($this->input->get('custom_view')){
            $_custom_view = $this->input->get('custom_view');
        } else if($this->input->get('status')){
             $_status = $this->input->get('status');
        }

        if ($this->input->is_ajax_request()) {
            // From client profile
            if(is_numeric($clientid)){
                if(!$has_permission){
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                'tblinvoices.id',
                'date',
                'currency',
                'number',
                'total',
                'duedate',
                'subtotal',
                'status',
                'clientnote'
                
            );

            $join = array(
                'LEFT JOIN tblclients ON tblclients.userid = tblinvoices.clientid',
                'LEFT JOIN tblcurrencies ON tblcurrencies.id = tblinvoices.currency'
            );

            $where                    = array();

            if (is_numeric($clientid)) {
                $where                    = array(
                    'AND clientid=' . $clientid
                );

            }

            if ($this->input->post('status')) {
                array_push($where, 'AND status=' . $this->input->post('status'));
               
            }
             array_push($where,'AND  tblinvoices.status !=2');
        
            if($this->input->post('custom_view')){
                $custom_view = $this->input->post('custom_view');
                if($custom_view == 'not_sent'){
                   array_push($where,'AND sent=0');
               } else if ($custom_view == 'not_have_payment'){
                   array_push($where,'AND tblinvoices.id NOT IN(SELECT invoiceid FROM tblinvoicepaymentrecords)');
               } else if($custom_view == 'recurring'){
                   array_push($where,'AND recurring > 0');
               } else {
                // Made payment mode
                foreach($data['payment_modes'] as $mode){
                    if($mode['id'] == $custom_view){
                        array_push($where,'AND tblinvoices.id IN (SELECT invoiceid FROM tblinvoicepaymentrecords WHERE paymentmode="'.$mode['id'].'")');
                        break;
                    }
                }
            }
        }

            $sIndexColumn = "id";
            $sTable       = 'tblinvoices';
            $result       = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array(
                'firstname',
                'tblinvoices.id',
                'lastname',
                'accountname',
                'company',
                'clientid',
                'symbol',
                'total',
                'status'
            ),$orderby = 'ORDER BY `tblinvoices`.`status` DESC');
            $output       = $result['output'];
            $rResult      = $result['rResult'];
  
            foreach ($rResult as $aRow) {
                $row = array();

                $company = $aRow['company'];
                if ($company != '') {
                    $company .= '<small class="text-muted"> ' . $aRow['firstname'] . ' ' . $aRow['lastname'] . '</small>';
                } else {
                    $company = $aRow['accountname'];
                }
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data                    = $aRow[$aColumns[$i]];

                    if ($aColumns[$i] == 'number') {
                        // If is from client area table
                    if (is_numeric($clientid)) {
                        $__data = '<a href="' . admin_url('invoices/list_invoices/' . $aRow['id']) . '">' . format_invoice_number($_data) . '</a><br />';
                    } else {
                           $__data = '<a href="#" onclick="init_invoice(' . $aRow['id'] . '); return false;">' . format_invoice_number($_data) . '</a><br />';
                    }
                    } else if ($aColumns[$i] == 'date') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'tblinvoices.id') {
                        $__data = '<input type="checkbox"  class="invoiceid" name="invoiceids[]" value="'. $aRow['id'].'" />' ;
                    }  else if ($aColumns[$i] == 'currency') {
                        $__data = 'Invoice' ;
                        
                    } else if ($aColumns[$i] == 'company') {
                        $__data = '<a href="' . admin_url('clients/client/' . $aRow['clientid']) . '">' . $company . '</a><br />';
                    } else if ($aColumns[$i] == 'duedate') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'total') {
                        $__data = format_money($_data, $aRow['symbol']);
                    } else if ($aColumns[$i] == 'clientnote') {
                        $apply=$aRow["total"]- $paidamount;
                        $__data = '<input type="text" style="width:100px" name="applyamount[]" value="" data-text="'.format_money($apply).'" onkeyup="cat_credit(this)" class="applyamount"/>';
                    }
                    else if ($aColumns[$i] == 'subtotal') {
                       $paidamount = $this->getbalance($aRow['id']);
                       $balance = $aRow['total']- $paidamount;
                        $__data = '<input type="hidden" data-id="'.$aRow['id'].'" value="'.$balance.'"  class="balance"/>'.format_money($aRow['total']- $paidamount, $aRow['symbol']);
                    }else {
                        $__data = format_invoice_status($aRow['status']);
                        // Status
                    }
                    $row[] = $__data;
                }

                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }


    }
     function getbalance($id){
        $this->load->model('invoices_model');
       $res = $this->invoices_model->getbalance($id);
       if(isset($res)){
          return $res->amount;
       }else{
           return '0';
       }
    }
    /**
     * Generate payment pdf
     * @since  Version 1.0.1
     * @param  mixed $id Payment id
     */
    public function pdf($id){
        $payment = $this->payments_model->get($id);
        $this->load->model('invoices_model');
        $payment->invoice_data = $this->invoices_model->get($payment->invoiceid);
        $paymentpdf = payment_pdf($payment);
        $paymentpdf->Output(_l('payment') . '-' . $payment->paymentid . '.pdf', 'D');
		redirect(admin_url('payments'));
    }

    /* Delete payment */
    public function delete($id)
    {
        if (!$id) {
            redirect(admin_url('payments'));
        }

        $response = $this->payments_model->delete($id);

        if($response == true){
            set_alert('success', _l('deleted',_l('payment')));
        } else {
            set_alert('warning', _l('problem_deleting',_l('payment_lowercase')));
        }

       // redirect(admin_url('payments'));
    }
}
