<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Paymentmodes extends Admin_controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('payment_modes_model');
        if(!has_permission('manageSales')){
            access_denied('manageSales');
        }
    }

    /* List all peyment modes*/
    public function index()
    {
        if ($this->input->is_ajax_request()) {
            $aColumns     = array(
                'name',
                'dueDays',
                'interestRate',
                'description',
                'active',
            );
            $sIndexColumn = "id";
            $sTable       = 'tblinvoicepaymentsmodes';

            $result  = data_tables_init($aColumns, $sIndexColumn, $sTable, array(), array(), array(
                'id',
                'deleted'
            ));
            $output  = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];

                    if($aColumns[$i] == 'active'){
                        $checked = '';
                        if($aRow['active'] == 1){
                            $checked = 'checked';
                        }
                        $_data = '<input type="checkbox" class="switch-box input-xs" data-size="mini" data-id="'.$aRow['id'].'" data-switch-url="admin/paymentmodes/change_payment_mode_status" '.$checked.'>';
                        // For exporting
                        $_data .=  '<span class="hide">' . ($checked == 'checked' ? _l('is_active_export') : _l('is_not_active_export')) .'</span>';
                    }

                    $row[] = $_data;
                }

               $options = icon_btn('#' . $aRow['id'], 'pencil-square-o', 'btn-default', array(
                    'data-toggle' => 'modal',
                    'data-target' => '#payment_mode_modal',
                    'data-id' => $aRow['id']
                ));
              if($aRow['deleted'] == 0){
                $row[]   = $options .= icon_btn('admin/paymentmodes/delete/' . $aRow['id'], 'remove', '',array('onClick' => 'return deleteconf();'));
                }else{
                 $row[]   = $options;
                }
                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }
        $this->load->model('clients_model');
       $data['ledgers'] = $this->clients_model->get_ledgers();

       $data['prev'] = $this->payment_modes_model->get_prev_groups2();
       
        $data['title'] = _l('payment_modes');
        $this->load->model('settings_model');
        $default_options = $this->settings_model->getOptions();
        $data['default_options'] = $default_options;
        $this->load->view('admin/paymentmodes/manage', $data);
    }
    /* Add or update payment mode / ajax */
    public function manage()
    {
        if ($this->input->post()) {
            $data = $this->input->post();
            if ($data['paymentmodeid'] == '') {
                $message = '';
                $success = $this->payment_modes_model->add($data);
                if($success) {
                    $message = _l('added_successfuly',_l('payment_mode'));
                }
                echo json_encode(array(
                    'success' => $success,
                    'message'=>$message
                ));
            } else {
                $message = '';
                $success = $this->payment_modes_model->edit($data);
                if($success){
                    $message = _l('updated_successfuly',_l('payment_mode'));
                }
                echo json_encode(array(
                    'success' => $success,
                    'message'=>$message
                ));
            }
        }
    }

    public function add_update_manage()
    {
        if ($this->input->post()) {
            $data = $this->input->post();
            if ($data['paymentmodeid'] == '') {
                $message = '';
                $success = $this->payment_modes_model->add($data);
                if($success) {
                    $message = _l('added_successfuly',_l('payment_mode'));
                }
                echo json_encode(array(
                    'success' => $success,
                    'message'=>$message
                ));
            } else {
                $message = '';
                $success = $this->payment_modes_model->edit($data);
                if($success){
                    $message = _l('updated_successfuly',_l('payment_mode'));
                }
                echo json_encode(array(
                    'success' => $success,
                    'message'=>$message
                ));
            }
        }
    }
    public function getpaymentmode(){
        echo json_encode($this->payment_modes_model->getpaymentmode($this->input->post('id')));
    }

    /* Delete payment mode */
    public function delete($id)
    {
        if (!$id) {
            redirect(admin_url('paymentmodes'));
        }

        $response = $this->payment_modes_model->delete($id);
       if(is_array($response) && isset($response['referenced'])){
            set_alert('warning',_l('is_referenced',_l('payment_mode_lowercase')));
        } else if($response == true){
            set_alert('success', _l('deleted',_l('payment_mode')));
        } else {
            set_alert('warning', _l('problem_deleting',_l('payment_mode_lowercase')));
        }

        redirect(admin_url('paymentmodes'));
    }
    // Since version 1.0.1
    // Change payment mode active or inactive
    public function change_payment_mode_status($id,$status){

        if(!has_permission('manageSales')){
            access_denied('manageSales');
        }
        if($this->input->is_ajax_request()){
            $this->payment_modes_model->change_payment_mode_status($id,$status);
        }
    }
     // Since version 1.0.1
    // Change to show this mode to client or not
    public function change_payment_mode_show_to_client_status($id,$status){

        if(!has_permission('manageSales')){
            access_denied('manageSales');
        }
        if($this->input->is_ajax_request()){
            $this->payment_modes_model->change_payment_mode_show_to_client_status($id,$status);
        }
    }
        
	/* Edit paymentterm or add new paymentterm*/
	public function paymentterm($id = ''){

		if($this->input->post() && !$this->input->is_ajax_request()){
			if(!has_permission('manageSales')){
				access_denied('manageSales');
			}

			if($id == ''){
				$id = $this->payment_modes_model->add($this->input->post());
				if($id){
					set_alert('success', _l('added_successfuly',_l('paymene_terms')));
                                        if (trim($this->input->post('action')) == 'save') {
                                             redirect(admin_url('paymentmodes/paymentterm/'.$id));
                                           exit;
                                       }
                                       if (trim($this->input->post('action')) == 'snew') {
                                           redirect(admin_url('paymentmodes/paymentterm'));
                                           exit;
                                       }
                                      if (trim($this->input->post('action')) == 'sexit') {
                                            redirect(admin_url('paymentmodes'));

                                       }
                                       
					
				}
			} else {
				$success = $this->payment_modes_model->edit($this->input->post(),$id);
				if($success){
					set_alert('success', _l('updated_successfuly',_l('paymene_terms')));
				}
				            if (trim($this->input->post('action')) == 'save') {
                                             redirect(admin_url('paymentmodes/paymentterm/'.$id));
                                           exit;
                                       }
                                       if (trim($this->input->post('action')) == 'snew') {
                                           redirect(admin_url('paymentmodes/paymentterm'));
                                           exit;
                                       }
                                      if (trim($this->input->post('action')) == 'sexit') {
                                            redirect(admin_url('paymentmodes'));

                                       }
			}
		}

		if($id == ''){
			$title = _l('payment_term');
		} else {
	
			$terms= $this->payment_modes_model->get($id);
             
			$data['term'] = $terms;
                        $title = $terms->name;
            
		}

	
      		$data['title'] = $title;
		$this->load->view('admin/paymentmodes/terms',$data);
	}
        
}
