<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Orders_rep extends Admin_controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('orders_model');
    }

    public function index() 
    {    
    	$clientid = "";
    	$status = "";
    	$from = "";
    	$to = "";
    	$filter_by = "";
    	$orders = "";
		if ($this->input->post()) {
	       // echo "<pre>";
	       // print_r($this->input->post());
	       // die;

	       $filter_by = $this->input->post('filter_by');
	       if($this->input->post('filter_by') == "customer")
	       {
		       $clientid = $this->input->post('clientid');
	       }

	       if($this->input->post('filter_by') == "status")
	       {
		       $status = $this->input->post('status');
	       }
	       // echo $from_dt = $this->input->post('from');

	        if($this->input->post('from') != "")
	        {
		        $from_var = $this->input->post('from');
	        	$from_dt = str_replace('/', '-', $from_var);
		        $from = date('Y-m-d',strtotime($from_dt));
		    }

		    if($this->input->post('to') != "")
		    {
		       	$var = $this->input->post('to');
	        	$to_dt = str_replace('/', '-', $var);
		       	$to = date('Y-m-d',strtotime($to_dt));
		    }
			$orders = $this->orders_model->get_list($clientid,$status,$from,$to);
	       
	    }
	    $data['user_id'] = $clientid;
	    $data['status'] = $status;
	    $data['filter_by'] = $filter_by;
	    $data['orders'] = $orders;

		$this->load->model('clients_model');
		$data['clients'] = $this->clients_model->get();
		$data['title'] = _l('order_report');
		$this->load->view('admin/reports/orders_report', $data);
    }

    public function pdf($from_date = "",$to_date = "")
    {	
    	$orders = "";
    	if($from_date != "" || $to_date != "")
    	{
    		$orders = $this->orders_model->get_orderpdf($from_date,$to_date);
    	}

        $pdf = order_report_pdf($orders,$from_date,$to_date);
        $pdf->Output('order_report.pdf', 'D');
    }

    public function excel($from_date,$to_date)
    {
    	$orders = "";
    	if($from_date != "" || $to_date != "")
    	{

    		$orders = $this->orders_model->get_orderpdf($from_date,$to_date);
    	}

       $this->load->library('excel');
		//activate worksheet number 1
		$this->excel->setActiveSheetIndex(0);
		//name the worksheet
		$this->excel->getActiveSheet()->setTitle('Order Report');
		//set cell A1 content with some text
		
		$this->excel->getActiveSheet()->setCellValue('A2', get_option('invoice_company_name'));
		$this->excel->getActiveSheet()->getStyle('A2')->getFont()->setBold(true);
		// $this->excel->getActiveSheet()->getStyle('A2')->getFont()->setBold(true)->setName('freesans');
		$this->excel->getActiveSheet()->getStyle('A2')->getFont()->setSize(14);

		$this->excel->getActiveSheet()->setCellValue('A3', get_option('invoice_company_address'));
		$this->excel->getActiveSheet()->getStyle('A3')->getAlignment()->setWrapText(true);

		$this->excel->getActiveSheet()->setCellValue('A4', get_option('invoice_company_city').','.get_option('invoice_company_state').",".get_option('invoice_company_postal_code'));
		$this->excel->getActiveSheet()->setCellValue('A5', get_country_name(get_option('invoice_company_country_code')));
		if(get_option('invoice_company_phonenumber') != '')
		{
			$this->excel->getActiveSheet()->setCellValue('A6', 'P:'.get_option('invoice_company_phonenumber'));
		}

		$this->excel->getActiveSheet()->setCellValue('F2', _l('order_report'));
		$this->excel->getActiveSheet()->getStyle('F2')->getFont()->setBold(true);
		$this->excel->getActiveSheet()->getStyle('F2')->getFont()->setSize(14);

		$this->excel->getActiveSheet()->setCellValue('F3', _l('run_date').': '._d(date('Y-m-d')));
		if (!empty($from_date)) 
		{
			$this->excel->getActiveSheet()->setCellValue('F4', _l('order_from_date').': '._d($from_date));
		}

		if (!empty($to_date)) 
		{
			$this->excel->getActiveSheet()->setCellValue('F5', _l('order_to_date').': '._d($to_date));
		}

		if($orders == "")
        {
            $count_orders = 0;
        }
        else
        {
            $count_orders = count($orders);
        }

		$this->excel->getActiveSheet()->setCellValue('F6', _l('order_count').': '.$count_orders);

		$this->excel->getActiveSheet()->setCellValue('A9', _l('order_dt_table_heading_number'));
		$this->excel->getActiveSheet()->setCellValue('B9', _l('invoice_dt_table_heading_client'));
		$this->excel->getActiveSheet()->setCellValue('C9', _l('order_dt_table_heading_date'));
		$this->excel->getActiveSheet()->setCellValue('D9', _l('order_dt_table_heading_expirydate'));
		$this->excel->getActiveSheet()->setCellValue('E9', _l('order_dt_table_heading_amount'));
		$this->excel->getActiveSheet()->setCellValue('F9', _l('order_dt_table_heading_status'));

		$i = 10;
		if($orders != "")
		{
			foreach ($orders as $key => $order) 
			{
				$this->excel->getActiveSheet()->setCellValue('A'.$i, format_order_number($order->number));
				$this->excel->getActiveSheet()->setCellValue('B'.$i, $order->accountname);
				$this->excel->getActiveSheet()->setCellValue('C'.$i, date('d/m/Y',strtotime($order->date)));
				$this->excel->getActiveSheet()->setCellValue('D'.$i, date('d/m/Y',strtotime($order->expirydate)));
				$this->excel->getActiveSheet()->setCellValue('E'.$i, format_money($order->total,$order->symbol));
				$this->excel->getActiveSheet()->setCellValue('F'.$i, $this->format_orderstatus($order->status));
				$i++;
			}
		}
		// $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
		$this->excel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
		$this->excel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
		$this->excel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
		$this->excel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
		$this->excel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
		$this->excel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);

		$styleArray = array(
		    'font'  => array(
		        'bold'  => true,
		        'color' => array('rgb' => 'ffffff'),
		        'size'  => 15,
		        // 'name'  => 'Verdana'
		    ),
		    // 'alignment' => array(
	     //        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
	     //    )

		);

		$this->excel->getActiveSheet()->getStyle('A9:F9')->applyFromArray($styleArray);

		$this->excel->getActiveSheet()->getStyle('A9:F9')
		->applyFromArray(
	        array(
	            'fill' => array(
	                'type' => PHPExcel_Style_Fill::FILL_SOLID,
	                'color' => array('rgb' => '3A4656')
	            )
	        )
   		);

		//change the font size
		//make the font become bold
		//merge cell A1 until D1
		// $this->excel->getActiveSheet()->mergeCells('A1:D1');
		//set aligment to center for that merged cell (A1 to D1)
		// $this->excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

		// PHPExcel_Shared_Font::setAutoSizeMethod(PHPExcel_Shared_Font::AUTOSIZE_METHOD_EXACT);

		$filename='Order Report.xls'; //save our workbook as this file name
		header('Content-Type: application/vnd.ms-excel'); //mime type
		header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
		header('Cache-Control: max-age=0'); //no cache
		             
		//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
		//if you want to save it as .XLSX Excel 2007 format
		$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
		//force user to download the Excel file without writing it to server's HD
		$objWriter->save('php://output');
	}

	function format_orderstatus($status)
	{

	    $orderstatus = "";
	    
	    if ($status == 1) {
	        $orderstatus      = _l('order_status_new');
	        // $label_class = 'default';
	    } else if ($status == 2) {
	        $orderstatus      = _l('order_status_planning');
	        // $label_class = 'info';
	    } else if ($status == 3) {
	        $orderstatus      = _l('order_status_inprocess');
	        // $label_class = 'info';
	    } else if ($status == 4) {
	        $orderstatus      = _l('order_status_completed');
	        // $label_class = 'info';
	    }
	     else if ($status == 5) {
	        $orderstatus      = _l('order_status_fulfilled');
	        // $label_class = 'success';
	    } else {
	        // status 5
	        $orderstatus      = _l('order_status_expired');
	        // $label_class = 'danger';
	    }

	    return $orderstatus;
	}
}