<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Nationality extends Admin_controller {

    function __construct() {
        parent::__construct();
        $this->load->model('nationality_model');
    }

    public function index() 
    {    
      $data['nationality'] = $this->nationality_model->get_list();
      $data['title'] = _l('nationality');
      $this->load->view('admin/nationality/manage', $data);
    }

    public function nationality() {
        if ($this->input->is_ajax_request()) {
            $data = $this->input->post();

            if ($data['id'] == '') {
                $success = $this->nationality_model->add($data);
                $message = '';
                if ($success == true) {
                    $message = _l('added_successfuly', _l('nationality'));
                }
                echo json_encode(array('success' => $success, 'message' => $message));
            } else {
				
                $success = $this->nationality_model->edit($data);
                $message = '';
                if ($success == true) {
                    $message = _l('updated_successfuly', _l('nationality'));
                }
                echo json_encode(array('success' => $success, 'message' => $message));
            }
        }
    }

    public function getnationality(){
		echo  json_encode($this->nationality_model->getnationality());
	}

	public function delete($id)
	{
		$response = $this->nationality_model->delete($id);
		
		if ($response == true) {
            set_alert('success', _l('deleted', _l('nationality')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('nationality')));
        }

        redirect(admin_url('nationality'));
	}
}