<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Manufacturers extends Admin_controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Manufacturers_model');
    }

    /* List all clients */

    public function index() {

        if ($this->input->is_ajax_request()) {
            $aColumns = array('name', 'country', 'website', 'email',  'active');
            $sIndexColumn = "mfid";
            $sTable = 'tblmanufacturers';
            $this->load->model('currencies_model');
            $base_currency_symbol = $this->currencies_model->get_base_currency()->symbol;
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, array(), array(), array('mfid'));
            $output = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];
                 if ($aColumns[$i] == 'active') {
                        $checked = '';
                        if ($aRow['active'] == 1) {
                            $checked = 'checked';
                        }
                        $_data = '<input type="checkbox" class="switch-box input-xs" data-size="mini" data-id="' . $aRow['mfid'] . '" data-switch-url="admin/manufacturers/change_manufacturer_status" ' . $checked . '>';
                        // For exporting
                        $_data .= '<span class="hide">' . ($checked == 'checked' ? _l('is_active_export') : _l('is_not_active_export')) . '</span>';
                    } else if ($aColumns[$i] == 'supplier') {
                        $_data = $aRow['supplier'];

                        $_data = '<a href="' . admin_url('manufacturers/manufacturer/' . $aRow['mfid']) . '">' . $_data . '</a>';
                    } else if ($aColumns[$i] == 'country') {
                        $res = $this->Manufacturers_model->get_country($aRow['country']);
                        if (isset($res)) {
                            $_data = $res->short_name;
                        } else {
                            $_data = '';
                        }
                    }
                    $row[] = $_data;
                }

                $options = icon_btn('admin/manufacturers/manufacturer/' . $aRow['mfid'], 'pencil-square-o');
                $row[] = $options .= icon_btn('admin/manufacturers/delete/' . $aRow['mfid'], 'remove', '', array('data-toggle' => 'tooltip','onClick' => 'return deleteconf();','title' => _l('manufacturer_delete_tooltip')));
                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }
        $data['title'] = _l('mf_title_big');
        $this->load->view('admin/manufacturer/manage', $data);
    }

    public function manufacturer($id = '') {

        if ($this->input->post() && !$this->input->is_ajax_request()) {
            if (!has_permission('manageinventory')) {
                access_denied('manageinventory');
            }
            if ($id == '') {
                $id = $this->Manufacturers_model->add($this->input->post());

                if (trim($this->input->post('action')) == 'save') {
                    set_alert('success', _l('added_successfuly', _l('mf_title_big')));
                    redirect(admin_url('manufacturers/manufacturer/' . $id));
                    exit;
                }
                if (trim($this->input->post('action')) == 'snew') {
                    set_alert('success', _l('added_successfuly', _l('mf_title_big')));
                    redirect(admin_url('manufacturers/manufacturer'));
                    exit;
                }
               
                if (trim($this->input->post('action')) == 'slist') {
                    set_alert('success', _l('added_successfuly', _l('mf_title_big')));
                    redirect(admin_url('manufacturers'));
                       
                }
                if (trim($this->input->post('action')) == 'cancel') {
                    redirect(admin_url());
                    exit;
                }


                // if ($id) {
                //     set_alert('success', _l('added_successfuly', _l('mf_title_big')));
                //     redirect(admin_url('manufacturers/manufacturer/' . $id));
                // }
            } else {
                $success = $this->Manufacturers_model->update($this->input->post(), $id);
                if ($success) {
                    set_alert('success', _l('updated_successfuly', _l('mf_title_big')));
                }

                if (trim($this->input->post('action')) == 'save') {
                    set_alert('success', _l('added_successfuly', _l('mf_title_big')));
                    redirect(admin_url('manufacturers/manufacturer/' . $id));
                    exit;
                }
                if (trim($this->input->post('action')) == 'snew') {
                    set_alert('success', _l('added_successfuly', _l('mf_title_big')));
                    redirect(admin_url('manufacturers/manufacturer'));
                    exit;
                }
               
                if (trim($this->input->post('action')) == 'slist') {
                    set_alert('success', _l('added_successfuly', _l('mf_title_big')));
                    redirect(admin_url('manufacturers'));
                       
                }
                if (trim($this->input->post('action')) == 'cancel') {
                    redirect(admin_url());
                    exit;
                }

                // redirect(admin_url('manufacturers/manufacturer/' . $id));
            }
        }

        if ($id == '') {
             $title = _l('mf_title_big');
        } else {
             $mfr = $this->Manufacturers_model->get($id);
             $data['mfr'] = $mfr;
             $title = _l('mf_title_big');
         }
        $data['user_notes'] = $this->misc_model->get_manufacturer_notes($id, 0);
        $data['title'] = $title;
        $this->load->view('admin/manufacturer/manufacturer', $data);
    }

	public function change_manufacturer_status($id,$status){

		if(!has_permission('manageinventory')){
			access_denied('manageinventory');
		}

		if($this->input->is_ajax_request()){
			$this->Manufacturers_model->change_manufacturer_status($id,$status);
		}
	}
        public function delete($id){

		if(!has_permission('manageinventory')){
			access_denied('manageinventory');
		}

		if(!$id){
			redirect(admin_url('manufacturers'));
		}

		$response = $this->Manufacturers_model->delete($id);

		if(is_array($response) && isset($response['referenced'])){
			set_alert('warning',_l('is_referenced',_l('mf_title_small')));
		} else if($response == true){
			set_alert('success', _l('deleted',_l('mf_title_big')));
		} else {
			set_alert('warning', _l('problem_deleting',_l('mf_title_small')));
		}

		redirect(admin_url('manufacturers'));
	}

}
