<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Ledgers extends Admin_controller {

    function __construct() {
        parent::__construct();
        $this->load->model('ledgers_model');
    }

    /* List all clients */

    public function index1() {

        if ($this->input->is_ajax_request()) {


            $aColumns = array('accountid', 'name', 'description', 'parent','parent');
            $sIndexColumn = "id";
            $sTable = 'tblledgergroups';
            $where = array('WHERE type="Ledger"');
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, array(), $where, array('id'));
            $output = $result['output'];
            $rResult = $result['rResult'];
             echo "<pre>";
            
            foreach ($rResult as $aRow) {
                if($this->ledgers_model->get_parent($aRow['parent']))
                {

                    $row = array();
                    for ($i = 0; $i < count($aColumns)-1; $i++) {
                        $_data = $aRow[$aColumns[$i]];

                        if ($i == 3) {
                            $_data = $this->ledgers_model->get_parent($_data);
                        }

                        $row[] = $_data;
                    }
                    
                    $options = icon_btn('admin/ledgers/ledger/' . $aRow['id'], 'pencil-square-o');
                    $row[] = $options .= icon_btn('admin/ledgers/delete/' . $aRow['id'], 'remove', '', array('data-toggle' => 'tooltip', 'title' => _l('ledger_delete_tooltip')));

                    $_data = $aRow[$aColumns[4]];
                   
                    if($_data>6){
                        while($_data>6)
                        {
                            $_data = $this->ledgers_model->get_parent_id($_data);
                        }
                    }
                    $_data = $this->ledgers_model->get_parent($_data);
                    $row[] = $_data;

                    $output['aaData'][] = $row;
                    

                }
            }
             print_r($output);
                    die;
            die;
            usort($output['aaData'],function ($a, $b){return strcmp($a[5], $b[5]);});
            echo json_encode($output);
            die();
        }


        $data['title'] = _l('list_ledgers');
        $this->load->view('admin/ledgers/manage', $data);
    }


    public function index2() {

        if ($this->input->is_ajax_request()) {
            $aColumns = array('accountid', 'name', 'description', 'parent','parent');
            $sIndexColumn = "id";
            $sTable = 'tblledgergroups';
            $where = array('WHERE type="Ledger"');
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, array(), $where, array('id'));
            $output = $result['output'];
            $rResult = $result['rResult'];
            foreach ($rResult as $aRow) {
                if($this->ledgers_model->get_parent($aRow['parent']))
                {
                    $row = array();
                    for ($i = 0; $i < count($aColumns)-1; $i++) {
                        $_data = $aRow[$aColumns[$i]];

                        if ($i == 3) {
                            $_data = $this->ledgers_model->get_parent($_data);
                        }

                        $row[] = $_data;
                    }

                    $options = icon_btn('admin/ledgers/ledger/' . $aRow['id'], 'pencil-square-o');
                    $row[] = $options .= icon_btn('admin/ledgers/delete/' . $aRow['id'], 'remove', '', array('data-toggle' => 'tooltip',  'onclick' => "return confirm('Are You sure you wish to delete this ledger Permanently?');",'title' => _l('ledger_delete_tooltip')));

                    $_data = $aRow[$aColumns[4]];
                   
                    
                    if($_data>6){
                        while($_data>6)
                        {
                            $_data = $this->ledgers_model->get_parent_id($_data);
                        }
                    }
                    $_data = $this->ledgers_model->get_parent($_data);
                    $row[] = $_data;

                    $output['aaData'][] = $row;
                }
            }
            // usort($output['aaData'],function ($a, $b){return strcmp($a[5], $b[5]);});
            echo json_encode($output);
            die();
        }


        $data['title'] = _l('list_ledgers');
        $this->load->view('admin/ledgers/manage', $data);
    }

    public function index($value='')
    {
        $data['ledgers'] = $this->ledgers_model->get_all_ledgers();
        $data['title'] = _l('list_ledgers');
        $this->load->view('admin/ledgers/manage', $data);
    }
    
    function cmp($a, $b)
    {
        return strcmp($a[3], $b[3]);
    }

public function ledgercustomers($id=''){
    if ($this->input->is_ajax_request()) {

            // echo $id;
            // die;
             $aColumns = array('account_number','accountname','userid');
            $sIndexColumn = "userid";
            $sTable = 'tblclients';
            $where = array();
            if(isset($id)){
               array_push($where, 'AND ledger='.$id);
            }


            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, array(), $where, array('userid'));
            $output = $result['output'];
            $rResult = $result['rResult'];
            // echo "<pre>";
            // print_r($rResult);
            // die;
                foreach ($rResult as $aRow) {

                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];
                    if ($aColumns[$i] == 'userid') {
                        $_data ='Customer';
                    }
                    if ($aColumns[$i] == 'account_number') {
                          $_data = '<a href="' . admin_url('clients/client/' . $aRow['userid']) . '">' . $_data . '</a>';
                    }
                       $row[] = $_data;
                }
                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }
}
    /* Edit ledger or add new ledger */
public function createpath(){
    
        $array = $this->db->query("SELECT * from tblledgergroups")->result_array();
        $array2 = array();
        foreach ($array as $key => $value) {
            $array2[$value['id']] = $value;
        }
        foreach ($array2 as $key => $a) {

            if ($a['parent'] == 0) {
                $data['path']= $a['name'];
                 $this->db->where('id', $a['id']);
                 $this->db->update('tblledgergroups', $data);
                 } else {
                $b = $a;
                $_a = array($b['name']);
                while ($b['parent'] != 0) {
                    $b = $array2[$b['parent']];
                    $_a[] = $b['name'];
                }
                
               
                $data['path']= implode('/', array_reverse($_a));
                 $this->db->where('id', $a['id']);
                 $this->db->update('tblledgergroups', $data);
            }
        }
}
    public function ledger($id = '') {
        

        if ($this->input->post() && !$this->input->is_ajax_request()) {
			 
            if (!has_permission('manageGroups')) {
                access_denied('manageGroups');
            }

            if ($id == '') { 
                $id = $this->ledgers_model->add($this->input->post());
           		 
                if ($id) {
                         //$this->createpath();
                    set_alert('success', _l('added_successfuly', _l('ledgers')));
                    if (trim($this->input->post('action')) == 'save') {
                        redirect(admin_url('ledgers/ledger/' . $id));
                        exit;
                    }
                    if (trim($this->input->post('action')) == 'snew') {
                        redirect(admin_url('ledgers/ledger'));
                        exit;
                    }
                    if (trim($this->input->post('action')) == 'sexit') {
                        redirect(admin_url('ledgers'));
                    }
                }
            } else { 
                $success = $this->ledgers_model->update($this->input->post(), $id);
                if ($success) {
                      $this->createpath();
                    set_alert('success', _l('updated_successfuly', _l('ledgers')));
                }
                if (trim($this->input->post('action')) == 'save') {
                    redirect(admin_url('ledgers/ledger/' . $id));
                    exit;
                }
                if (trim($this->input->post('action')) == 'snew') {
                    redirect(admin_url('ledgers/ledger'));
                    exit;
                }
                if (trim($this->input->post('action')) == 'sexit') {
                    redirect(admin_url('ledgers'));
                }
            }
        }

        if ($id == '') {
			 
            $title = _l('ledgers');
        } else {

            $ledger = $this->ledgers_model->get($id);

            $data['ledgerReord'] = $ledger;
			//echo "<pre>";print_r($data['ledger']);echo "</pre>";exit;
            $title = $ledger->name;
        }


        $res = $this->ledgers_model->get_last_accountno();
		
        $data['all'] = $this->ledgers_model->get_prev_groups();
//echo "<pre>";print_r($data['all']);echo "</pre>";exit; 
		
        if ($res->accountid != '') {
            $accountid = str_replace('-', '', $res->accountid);
            $accountid = ++$accountid;
            $accountid = sprintf('%016d', $accountid);

            $accountid = implode("-", str_split($accountid, 4));
        } else {
            $accountid = '0000-0000-0000-0001';
        }
//                  echo  implode("-", str_split($accountid, 4));
        $data['accountid'] = $accountid;
        // $ledger = fetchLedgerTree();
         $ledger 	= $this->ledgers_model->getLedgersTree();
		 $data['ledger'] = $ledger;
		 
        $data['title'] = $title;
        $this->load->view('admin/ledgers/ledgers', $data);
    }

    /* Delete client */

    public function delete($id) {

        if (!has_permission('manageGroups')) {
            access_denied('manageGroups');
        }

        if (!$id) {
            redirect(admin_url('ledgers'));
        }
         if (is_reference_in_table('ledger', 'tbltaxes', $id)) {
            set_alert('warning', _l('ledger_delete_warning'));
            redirect(admin_url('ledgers/ledger/' . $id),'refresh');
        }
        $response = $this->ledgers_model->delete($id);

        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('ledgers')));
        } else if ($response == true) {
                 $this->createpath();
            set_alert('success', _l('deleted', _l('ledgers')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('ledgers')));
        }

        redirect(admin_url('ledgers'));
    }

    /* Change client status / active / inactive */

    public function change_subgroup_status($id, $status) {

        if (!has_permission('manageBanks')) {
            access_denied('manageBanks');
        }

        if ($this->input->is_ajax_request()) {
            $this->ledgers_model->change_subgroup_status($id, $status);
        }
    }

    /* Get client by id - used in ajax request */

    public function get_client_by_id_ajax($id) {

        if (!$id) {
            redirect(admin_url('clients'));
        }

        if (!has_permission('manageClients')) {
            access_denied('manageClients');
        }
        if ($this->input->is_ajax_request()) {
            echo json_encode($this->clients_model->get($id));
        }
    }

    /* Since version 1.0.2 add client reminder */

    public function add_subgroup_reminder($id) {
        if (!has_permission('manageClients')) {
            access_denied('manageClients');
        }

        if ($this->input->post()) {
            $success = $this->ledgers_model->add_reminder($this->input->post(), $id);
            if ($success) {
                set_alert('success', _l('subgroup_reminder_added_successfuly'));
            }
        }

        redirect(admin_url('ledgers/subgroup/' . $id));
    }

}
