<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Invoices_rep extends Admin_controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('invoices_model');
    }

    public function index() 
    {    
    	$clientid = "";
    	$status = "";
    	$from = "";
    	$to = "";
    	$filter_by = "";
    	$invoices = "";

		if ($this->input->post()) {
	       // echo "<pre>";
	       // print_r($this->input->post());
	       // die;

	       $filter_by = $this->input->post('filter_by');
	       if($this->input->post('filter_by') == "customer")
	       {
		       $clientid = $this->input->post('clientid');
	       }

	       if($this->input->post('filter_by') == "status")
	       {
		       $status = $this->input->post('status');
	       }
	       // echo $from_dt = $this->input->post('from');

	        if($this->input->post('from') != "")
	        {
		        $from_var = $this->input->post('from');
	        	$from_dt = str_replace('/', '-', $from_var);
		        $from = date('Y-m-d',strtotime($from_dt));
		    }

		    if($this->input->post('to') != "")
		    {
		       	$var = $this->input->post('to');
	        	$to_dt = str_replace('/', '-', $var);
		       	$to = date('Y-m-d',strtotime($to_dt));
		    }
	       
			$invoices = $this->invoices_model->get_list($clientid,$status,$from,$to);
	    }
	    $data['user_id'] = $clientid;
	    $data['status'] = $status;
	    $data['filter_by'] = $filter_by;
	    $data['invoices'] = $invoices;

		$this->load->model('clients_model');
		$data['clients'] = $this->clients_model->get();
		$data['title'] = _l('invoice_report');
		$this->load->view('admin/reports/invoices_report', $data);
    }

    public function pdf($from_date = "",$to_date = "")
    {	
    	$invoices = "";
    	if($from_date != "" || $to_date != "")
    	{
    		
    		$invoices = $this->invoices_model->get_invoicepdf($from_date,$to_date);

    	}
    	
        $pdf = invoices_report_pdf($invoices,$from_date,$to_date);
        $pdf->Output('invoices_report.pdf', 'D');
    }

    public function excel($from_date = "",$to_date = "")
    {

    	$invoices = "";
    	if($from_date != "" || $to_date != "")
    	{
    		
    		$invoices = $this->invoices_model->get_invoicepdf($from_date,$to_date);
    		
    	}

       $this->load->library('excel');
		//activate worksheet number 1
		$this->excel->setActiveSheetIndex(0);
		//name the worksheet
		$this->excel->getActiveSheet()->setTitle('Invoices Report');
		//set cell A1 content with some text
		
		$this->excel->getActiveSheet()->setCellValue('A2', get_option('invoice_company_name'));
		$this->excel->getActiveSheet()->getStyle('A2')->getFont()->setBold(true);
		// $this->excel->getActiveSheet()->getStyle('A2')->getFont()->setBold(true)->setName('freesans');
		$this->excel->getActiveSheet()->getStyle('A2')->getFont()->setSize(14);

		// $this->excel->getActiveSheet()->setCellValue('A3', nl2br(get_option('invoice_company_address')));

		$this->excel->getActiveSheet()->setCellValue('A3', get_option('invoice_company_address'));
		$this->excel->getActiveSheet()->getStyle('A3')->getAlignment()->setWrapText(true);
		
		$this->excel->getActiveSheet()->setCellValue('A4', get_option('invoice_company_city').','.get_option('invoice_company_state').",".get_option('invoice_company_postal_code'));
		$this->excel->getActiveSheet()->setCellValue('A5', get_country_name(get_option('invoice_company_country_code')));
		if(get_option('invoice_company_phonenumber') != '')
		{
			$this->excel->getActiveSheet()->setCellValue('A6', 'P:'.get_option('invoice_company_phonenumber'));
		}

		$this->excel->getActiveSheet()->setCellValue('F2', _l('invoices_report'));
		$this->excel->getActiveSheet()->getStyle('F2')->getFont()->setBold(true);
		$this->excel->getActiveSheet()->getStyle('F2')->getFont()->setSize(14);

		$this->excel->getActiveSheet()->setCellValue('F3', _l('run_date').': '._d(date('Y-m-d')));
		if (!empty($from_date)) 
		{
			$this->excel->getActiveSheet()->setCellValue('F4', _l('invoices_from_date').': '._d($from_date));
		}

		if (!empty($to_date)) 
		{
			$this->excel->getActiveSheet()->setCellValue('F5', _l('invoices_to_date').': '._d($to_date));
		}

		if($invoices == "")
		{
		    $count_invoices = 0;
		}
		else
		{
		    $count_invoices = count($invoices);
		}

		$this->excel->getActiveSheet()->setCellValue('F6', _l('invoices_count').': '.$count_invoices);

		$this->excel->getActiveSheet()->setCellValue('A9', _l('invoice_dt_table_heading_number'));
		$this->excel->getActiveSheet()->setCellValue('B9', _l('invoice_dt_table_heading_date'));
		$this->excel->getActiveSheet()->setCellValue('C9', _l('invoice_dt_table_heading_client'));
		$this->excel->getActiveSheet()->setCellValue('D9', _l('invoice_dt_table_heading_amount'));
		$this->excel->getActiveSheet()->setCellValue('E9', _l('invoice_dt_table_heading_duedate'));
		$this->excel->getActiveSheet()->setCellValue('F9', _l('invoice_dt_table_heading_status'));

		$i = 10;
		if($invoices != "")
		{
			foreach ($invoices as $key => $invoice) 
			{
				$this->excel->getActiveSheet()->setCellValue('A'.$i, format_invoice_number($invoice->number));
				$this->excel->getActiveSheet()->setCellValue('B'.$i, date('d/m/Y',strtotime($invoice->date)));
				$this->excel->getActiveSheet()->setCellValue('C'.$i, $invoice->accountname);
				$this->excel->getActiveSheet()->setCellValue('D'.$i, format_money($invoice->total,$invoice->symbol));
				$this->excel->getActiveSheet()->setCellValue('E'.$i, date('d/m/Y',strtotime($invoice->duedate)));
				$this->excel->getActiveSheet()->setCellValue('F'.$i, $this->format_invoicestatus($invoice->status));
				$i++;
			}
		}

		// $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
		$this->excel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
		$this->excel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
		$this->excel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
		$this->excel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
		$this->excel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
		$this->excel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);

		$styleArray = array(
		    'font'  => array(
		        'bold'  => true,
		        'color' => array('rgb' => 'ffffff'),
		        'size'  => 15,
		        // 'name'  => 'Verdana'
		    ),
		    // 'alignment' => array(
	     //        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
	     //    )

		);

		$this->excel->getActiveSheet()->getStyle('A9:F9')->applyFromArray($styleArray);

		$this->excel->getActiveSheet()->getStyle('A9:F9')
		->applyFromArray(
	        array(
	            'fill' => array(
	                'type' => PHPExcel_Style_Fill::FILL_SOLID,
	                'color' => array('rgb' => '3A4656')
	            )
	        )
   		);

		//change the font size
		//make the font become bold
		//merge cell A1 until D1
		// $this->excel->getActiveSheet()->mergeCells('A1:D1');
		//set aligment to center for that merged cell (A1 to D1)
		// $this->excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

		// PHPExcel_Shared_Font::setAutoSizeMethod(PHPExcel_Shared_Font::AUTOSIZE_METHOD_EXACT);

		$filename='Invoices Report.xls'; //save our workbook as this file name
		header('Content-Type: application/vnd.ms-excel'); //mime type
		header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
		header('Cache-Control: max-age=0'); //no cache
		             
		//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
		//if you want to save it as .XLSX Excel 2007 format
		$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
		//force user to download the Excel file without writing it to server's HD
		$objWriter->save('php://output');
	}

	function format_invoicestatus($status, $classes = '', $label = true)
	{
	    $invoicestatus ="";

	    if ($status == 1) {
	        $invoicestatus      = _l('invoice_status_unpaid');
	    } else if ($status == 2) {
	        $invoicestatus      = _l('invoice_status_paid');
	        // $label_class = 'success';
	    } else if ($status == 3) {
	        $invoicestatus      = _l('invoice_status_not_paid_completely');
	        // $label_class = 'warning';
	    } else {
	        // status 4
	        $invoicestatus      = _l('invoice_status_overdue');
	        // $label_class = 'warning';
	    }

	    return $invoicestatus;
	}
}