<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Grades extends Admin_controller {

    function __construct() {
        parent::__construct();
        $this->load->model('grades_model');
    }

    public function index() 
    {    
      $data['grades'] = $this->grades_model->get_list();
      $data['title'] = _l('grades');
      $this->load->view('admin/grades/manage', $data);
    }

    public function grades() {
        if ($this->input->is_ajax_request()) {
            $data = $this->input->post();

            if ($data['id'] == '') {
                $success = $this->grades_model->add($data);
                $message = '';
                if ($success == true) {
                    $message = _l('added_successfuly', _l('grades'));
                }
                echo json_encode(array('success' => $success, 'message' => $message));
            } else {
				
                $success = $this->grades_model->edit($data);
                $message = '';
                if ($success == true) {
                    $message = _l('updated_successfuly', _l('grades'));
                }
                echo json_encode(array('success' => $success, 'message' => $message));
            }
        }
    }

    public function getgrades(){
		echo  json_encode($this->grades_model->getgrades());
	}

	public function delete($id)
	{
		$response = $this->grades_model->delete($id);
		
		if ($response == true) {
            set_alert('success', _l('deleted', _l('grades')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('grades')));
        }

        redirect(admin_url('grades'));
	}
}