<?php ob_start();
defined('BASEPATH') OR exit('No direct script access allowed');

class Fullfillments extends Admin_controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('Fullfillments_model');
		
    }

    /* Get all orders in case user go on index page */
    public function index($id = false, $clientid = false)
    {
      
         $has_permission =check_access("child-orders","",false);

         if(!$has_permission && !$this->input->is_ajax_request()){
            access_denied('child-orders');
         }

         $_status = '';

         if($this->input->get('status')){
            $_status = $this->input->get('status');
         }

        if ($this->input->is_ajax_request()) {
            // From client profile
            if(is_numeric($clientid)){
                if(!$has_permission){
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                'tblorderfulfillments.number',
                'company',
//                'reference_no',
               'tblorderfulfillments.date',
                'tblorderfulfillments.expirydate',
                'tblorderfulfillments.clientnote',
                'tblorderfulfillments.adminnote',
                'tblorderfulfillments.status'
            );

            $join = array(
                'LEFT JOIN tblclients ON tblclients.userid = tblorderfulfillments.clientid',
                'LEFT JOIN tblemployee ON tblemployee.staffid = tblorderfulfillments.sale_agent',
                'LEFT JOIN tblorders ON tblorders.id = tblorderfulfillments.order_id',
                'LEFT JOIN tblcurrencies ON tblcurrencies.id = tblorderfulfillments.currency'
            );

            $where                    = array();
			
			/*$where                    = array(
                    'AND tblorders.status=4' 
                );*/
          /*  if (is_numeric($clientid)) {
                $where                    = array(
                    'AND clientid=' . $clientid
                );
            }*/


            if ($this->input->post('status')) {
                array_push($where, 'AND status=' . $this->input->post('status'));
            }

            if($this->input->post('custom_view')){
                $custom_view = $this->input->post('custom_view');
                if($custom_view == 'not_sent'){
                     array_push($where,'AND sent=0');
                 }
            }
 
            $sIndexColumn = "id";
            $sTable       = 'tblorderfulfillments';
            $result       = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array(
                'tblclients.firstname',
				'tblclients.lastname',
				'tblemployee.firstname as salrepfirstname',
				'tblemployee.lastname as  salreplastname',
                'tblorderfulfillments.id',
                'accountname',
                'tblorders.number as ordernumber',
                'company',
                'tblorderfulfillments.invoiceid',
                'tblorderfulfillments.hash',
                'tblorderfulfillments.clientid',
                'staffid',
                'symbol',
                'tblorderfulfillments.total',
                'tblorderfulfillments.order_id',
                'tblorderfulfillments.status'
            ));
            $output       = $result['output'];
            $rResult      = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();

                $company = $aRow['company'];
                if ($company != '') {
                    $company .= '<small class="text-muted"> ' . $aRow['firstname'] . ' ' . $aRow['lastname'] . '</small>';
                } else {
                    $company = $aRow['firstname'] . ' ' . $aRow['lastname'];
                }
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data    = $aRow[$aColumns[$i]];

                    if ($aColumns[$i] == 'tblorderfulfillments.number') {
                        $__data = '<a href="' . admin_url('orders/list_orders/' . $aRow['order_id']) . '">' . format_order_number($aRow['ordernumber']) . '</a><br />';
                    } 
                    
                    else if ($aColumns[$i] == 'company') {
                        $__data = '<a href="' . admin_url('clients/view/' . $aRow['clientid']) . '">' . $aRow['accountname'] . '</a><br />';
                    }else if ($aColumns[$i] == 'tblorderfulfillments.date') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'tblorderfulfillments.expirydate') {
                        $__data = _d($_data);
                    }  else if($aColumns[$i] == 'tblorderfulfillments.clientnote') {
                        $__data =$aRow['salrepfirstname'] . ' ' . $aRow['salreplastname'];
                        // Status
                    } else if($aColumns[$i] == 'tblorderfulfillments.adminnote') {
						
						if($aRow['tblorderfulfillments.status']=='4')
						 {
						 $__data = 'Shipped';
						}
						else if(strtotime(date("Y-m-d")) < strtotime($aRow['tblorderfulfillments.expirydate']))
						{
                        $__data ='On time';
						}
						else if(strtotime(date("Y-m-d")) > strtotime($aRow['tblorderfulfillments.expirydate']))
						{
                         $__data ='Delayed';
						}
						
						
						// Status
                    } else if($aColumns[$i] == 'tblorderfulfillments.status') {
                        $__data = format_orderfulfillment_status($aRow['tblorderfulfillments.status']);
                        // Status
                    }
                    $row[] = $__data;
                }
                $options='';
                 if($aRow['invoiceid'] == NULL){
					 
                if($aRow['status'] == 4){
					//if(check_access("child-invoices","add",false))
                   // $options = icon_btn('admin/fullfillments/convert_to_invoice/' . $aRow['id'],'share','',array('data-toggle' => 'tooltip', 'title' =>_l('convert_invoice'),'status'=>$aRow['status']));
                    }
                }else{
					//if(check_access("child-invoices","",false))
                 //  $options = icon_btn('admin/invoices/list_invoices/' . $aRow['invoiceid'], 'eye','',array('data-toggle' => 'tooltip', 'title' =>_l('view_invoice'). ' : ' .format_invoice_number($aRow['invoiceid']))); 
                }
               // $options = icon_btn('#','print','printorder',array('data-toggle' => 'tooltip', 'title' =>'Print Order','data-id'=>$aRow['id'],'data-hash'=>$aRow['hash']));
               $options = icon_btn('admin/fullfillments/pdf/' . $aRow['id'],'download','',array('data-toggle' => 'tooltip', 'title' =>'Download Order', 'download' =>'admin/fullfillments/pdf/' . $aRow['id']));
                 $options .= icon_btn('#', 'eye','',array('data-toggle' => 'tooltip', 'title' =>_l('view_order'), 'onclick'=>'init_order('.$aRow['order_id'].'); return false;'));
                 $options .= icon_btn('admin/fullfillments/fullfillment/'.$aRow['clientid'].'/' . $aRow['id'], 'edit', ' btn-edit-customer', array('data-toggle' => 'tooltip', 'title' =>'Edit Order Fullfillment'));


                 $row[] =$options;
                 $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        $data['orderid'] = '';
        if (is_numeric($id)) {
            $data['orderid'] = $id;
        }


        $data['status'] = $_status;
        $data['bodyclass'] = 'small-table';
        $data['title']     = _l('orders');
        $this->load->view('admin/fullfillments/manage', $data);
    }

    /* List all orders datatables */
    public function list_orders($id = false, $clientid = false)
    {
        
        $has_permission = check_access("child-orders","",false);

         if(!$has_permission && !$this->input->is_ajax_request()){
            access_denied('manageSales');
         }

         $_status = '';

         if($this->input->get('status')){
            $_status = $this->input->get('status');
         }

        if ($this->input->is_ajax_request()) {
            // From client profile
            if(is_numeric($clientid)){
                if(!$has_permission){
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                 'number',
                'company',
//                'reference_no',
               'date',
                'expirydate',
                'total',
                'status'
            );

            $join = array(
                'LEFT JOIN tblclients ON tblclients.userid = tblorders.clientid',
                'LEFT JOIN tblcurrencies ON tblcurrencies.id = tblorders.currency'
            );

            $where                    = array();

            if (is_numeric($clientid)) {
                $where                    = array(
                    'AND clientid=' . $clientid
                );
            }


            if ($this->input->post('status')) {
                array_push($where, 'AND status=' . $this->input->post('status'));
            }

            if($this->input->post('custom_view')){
                $custom_view = $this->input->post('custom_view');
                if($custom_view == 'not_sent'){
                     array_push($where,'AND sent=0');
                 }
            }

            $sIndexColumn = "id";
            $sTable       = 'tblorders';
            $result       = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array(
                'firstname',
                'tblorders.id',
                'lastname',
                'accountname',
                'company',
                'clientid',
                'symbol',
                'total',
                'status'
            ));
            $output       = $result['output'];
            $rResult      = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();

                $company = $aRow['company'];
                if ($company != '') {
                    $company .= '<small class="text-muted"> ' . $aRow['firstname'] . ' ' . $aRow['lastname'] . '</small>';
                } else {
                    $company = $aRow['firstname'] . ' ' . $aRow['lastname'];
                }
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data                    = $aRow[$aColumns[$i]];

                    if ($aColumns[$i] == 'number') {
                        // If is from client area table
                    if (is_numeric($clientid)) {
                        $__data = '<a href="' . admin_url('orders/list_orders/' . $aRow['id']) . '">' . format_order_number($_data) . '</a><br />';
                    } else {
                           $__data = '<a href="#" onclick="init_order(' . $aRow['id'] . '); return false;">' . format_order_number($_data) . '</a><br />';
                    }
                    } else if ($aColumns[$i] == 'date') {
                        $__data = _d($_data);
                    }
                     else if ($aColumns[$i] == 'reference_no') {
                        $__data = $aRow['reference_no'];
                    }
                    else if ($aColumns[$i] == 'company') {
                        
                        $__data = '<a href="' . admin_url('clients/view/' . $aRow['clientid']) . '">' . $aRow['accountname'] . '</a><br />';
                    } else if ($aColumns[$i] == 'expirydate') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'total') {
                        $__data = format_money($_data, $aRow['symbol']);
                    } else if($aColumns[$i] == 'status') {
                    
                        $__data = format_order_status($aRow['status']);
                        // Status
                    }
                    $row[] = $__data;
                }
                   $options = icon_btn('admin/fullfillments/pdf/' . $aRow['id'],'download','',array('data-toggle' => 'tooltip', 'title' =>'Download Order','download' =>'admin/fullfillments/pdf/' . $aRow['id']));
                 $options .= icon_btn('#', 'eye','',array('data-toggle' => 'tooltip', 'title' =>'View Order', 'onclick'=>'init_order('.$aRow['id'].'); return false;'));
				 if(check_access("child-orders","delete",false))
                $options .= icon_btn('admin/fullfillments/delete/' . $aRow['id'], 'remove', ' btn-delete-customer', array('data-toggle' => 'tooltip', 'title' =>'Delete Order'));
				 $row[] = $options;
                 $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        $data['orderid'] = '';
        if (is_numeric($id)) {
            $data['orderid'] = $id;
        }


        $data['status'] = $_status;
        $data['bodyclass'] = 'small-table';
        $data['title']     = _l('orders');
        $this->load->view('admin/fullfilliments/manage', $data);
    }

    /* Add new order or update existing */
    public function fullfillment($customerid = '',$id = '')
    {
          if ($id == '')
        	check_access("child-orders","add");
		else
			check_access("child-orders","edit");
                   $this->load->model('clients_model');
         if (($this->input->post())&&(!isset($_POST["itemID"]))) {
            if ($id == '') {
                $id = $this->Fullfillments_model->add($this->input->post());
                if ($id) {
                    $orders = $this->Fullfillments_model->get($id);
                    if ($orders->number != $this->input->post('_number')) {
                        set_alert('warning', _l('order_number_changed'));
                    } else {
                       set_alert('success', _l('added_successfuly',_l('order')));
                    }
                    
                    if (trim($this->input->post('action')) == 'save') {
                          redirect(admin_url('orders/order/'.$this->input->post('clientid').'/'. $id));
                        exit;
                    }
                    if (trim($this->input->post('action')) == 'snew') {
                        redirect(admin_url('orders/order'));
                        exit;
                    }
                 
                    if (trim($this->input->post('action')) == 'slist') {
                         redirect(admin_url('orders/list_orders/' . $id));
                         
                    }
                    if (trim($this->input->post('action')) == 'cancel') {
                        redirect(admin_url());
                        exit;
                    }
//                    redirect(admin_url('orders/list_orders/' . $id));
                }
            } else {
                $success = $this->Fullfillments_model->update($this->input->post(), $id);
                if ($success) {
                   set_alert('success', _l('updated_successfuly',_l('order')));
                }
               if (trim($this->input->post('action')) == 'save') {
                          redirect(admin_url('fullfillments/fullfillment/'.$this->input->post('clientid').'/'. $id));
                        exit;
                    }
                    /*if (trim($this->input->post('action')) == 'snew') {
                        redirect(admin_url('orders/order'));
                        exit;
                    }*/
                 
                    if (trim($this->input->post('action')) == 'slist') {
                          redirect(admin_url('fullfillments/fullfillment/'.$this->input->post('clientid').'/'. $id));
                         
                    }
                    if (trim($this->input->post('action')) == 'cancel') {
                        redirect(admin_url());
                        exit;
                    }
            }
        }

        if ($id == '') {
            $title = _l('create_new_order');
        } else {
            $orders = $this->Fullfillments_model->get($id);
           if($orders->status =='5'){
                access_denied('manageSales');
                die();
           }
		   
		
            $orders->date    = _d($orders->date);
            $orders->expirydate = _d($orders->expirydate);
            $this->load->model('emails_model');
            if ($orders->sent == 0) {
                $data['template'] = $this->emails_model->parse_template('order-send-to-client', $orders->clientid, false,false,false,$id);
            } else {
                $data['template'] = $this->emails_model->parse_template('order-already-send', $orders->clientid, false,false,false,$id);
            }

             $data['orders'] = $this->clients_model->get_where_record('tblorderfulfillmentsitems',$id);
           if(isset($data['orders'])){
            $customerid = $data['orders']->clientid;
         }
             
            $data['prev'] = $this->Fullfillments_model->get_prev($id);
          $data['next'] = $this->Fullfillments_model->get_next($id);
            $data['order']  = $orders;
            $data['edit'] = true;
            $title           = _l('edit',_l('order_lowercase'));
        }
        

        $data['customerdetails'] = $this->clients_model->get_client($customerid);
        
        $this->load->model('taxes_model');
        $data['taxes'] = $this->taxes_model->get();

        $this->load->model('currencies_model');
        $data['currencies'] = $this->currencies_model->get();


       
		
		
        $this->load->model('clients_model');
        $data['clients'] = $this->clients_model->get();

        $this->load->model('staff_model');
        $data['staff'] = $this->staff_model->get('',1);
         $this->load->model('discount_model');
        $data['discount'] = $this->discount_model->get_discounts();
   
           $data['copy'] ='';
        if($this->input->get('copyid')){
            $data['copy'] =$this->input->get('copyid');
           $data['orders']['items'] =   $this->Fullfillments_model->get_items($this->input->get('copyid'));
        }
 		$this->load->model('invoice_items_model');
        $data['warehouse'] = $this->invoice_items_model->get_where_tbl('tblwarehouse','active');
		
	//	print_r($data['warehouse']);
        
        $data['title']     = $title;
        $this->load->view('admin/fullfillments/fullfillment', $data);
    }

    public function init_order_items_ajax($id){
        echo json_encode($this->orders_model->get_order_items($id));
    }
    
    public function get_term() {
       
 $terms = $this->orders_model->get_term($this->input->post('id'));
 $account_repy = $this->orders_model->get_sales_agent($this->input->post('id'));
  echo json_encode(array('payment_term'=>$terms,'account_rep'=>$account_repy));

    }
    
    /* Get all order data used when user click on order number in a datatable left side*/
    public function get_order_data_ajax($id)
    {
        check_access("child-orders","");

        if (!$id) {
            die('No order found');
        }

        $order = $this->orders_model->get($id);

        $order->date    = _d($order->date);
        $order->expirydate = _d($order->expirydate);

        $data['estimates_number'] = $this->orders_model->get_estimates($id);
        $data['invoice_number'] = $this->orders_model->get_invoice($id);

        if($order->invoiceid !== NULL){
            $this->load->model('invoices_model');
            $order->invoice = $this->invoices_model->get($order->invoiceid);
        }

        $this->load->model('emails_model');

        if ($order->sent == 0) {
            $data['template'] = $this->emails_model->parse_template('order-send-to-client', $order->clientid, false,false,false,false,false,false,false,$id);
            //  echo "<pre>";
            // print_r($data['template']);
            // die;
            
        } else {
            $data['template'] = $this->emails_model->parse_template('order-already-send', $order->clientid, false,false,false,false,false,false,false,$id);

            // echo "<pre>";
            // print_r($data['template']);
            // die;
        }

        $data['activity'] = $this->orders_model->get_order_activity($id);
        $data['order']  = $order;
        $this->load->view('admin/fullfillments/order_preview_template', $data);
    }

    public function get_orders_total(){
        check_access("child-orders","");
        if($this->input->post()){
            $data['totals'] = $this->orders_model->get_orders_total($this->input->post());
            $this->load->model('currencies_model');
            $base_currency = $this->currencies_model->get_base_currency()->id;
            if(is_using_multiple_currencies('tblorders') || (total_rows('tblorders',array('currency'=>$base_currency)) == 0) && total_rows('tblorders') > 0){
                $this->load->model('currencies_model');
                $data['currencies'] = $this->currencies_model->get();
            }
            $this->load->view('admin/fullfillments/orders_total_template',$data);
        }
    }

    /* Send order to email */
    public function send_to_email($id)
    {
         check_access("child-orders","edit");
        $success = $this->orders_model->sent_order_to_client($id,'',$this->input->post('attach_pdf'));
        if ($success) {
            set_alert('success', _l('order_sent_to_client_success'));

        } else {
            set_alert('danger', _l('order_sent_to_client_fail'));
        }
        redirect(admin_url('orders/list_orders/' . $id));
    }

    /* Convert order to invoice */
    public function convert_to_invoice($id){

        check_access("child-invoices","add");
        if(!$id){
            die('No order found');
        }

        $invoiceid = $this->orders_model->convert_to_invoice($id);

        if($invoiceid){
            set_alert('success',_l('order_convert_to_invoice_successfuly'));
            redirect(admin_url('invoices/list_invoices/'.$invoiceid));
        } else {
            redirect(admin_url('orders/list_orders/'.$id));
        }
    }

    /* Delete order */
    public function delete($id)
    {
         check_access("child-orders","delete");
        if (!$id) {
            redirect(admin_url('orders/list_orders'));
        }

        $success = $this->orders_model->delete($id);

        if ($success) {
           set_alert('success', _l('deleted',_l('order')));
        } else {
            set_alert('warning', _l('problem_deleting',_l('order_lowercase')));
        }

        redirect(admin_url('orders/list_orders'));
    }

    /* Generates order PDF and senting to email of $send_to_email = true is passed */
    public function pdf($id, $send_to_email = false)
    {
        

        if (!$id) {
            redirect(admin_url('orders/list_orders'));
        }

        $order        = $this->Fullfillments_model->get($id);
        $order_number = format_orderfullfillment_number($order->number);
        $this->load->model('orders_model');
		$original_order_number =  $this->orders_model->get($order->order_id);
        $pdf          = orderfullfillment_pdf($order,$original_order_number->number);
        $pdf->Output($order_number . '.pdf', 'D');
           // redirect(admin_url('orders/list_orders'));
    }
     public function change_order_status($status,$id){
          echo $this->orders_model->change_order_status($status,$id);
    }
    public function checkcreadit(){
        $invoice =  $this->orders_model->getinvoices($this->input->post('clientid'));
        $orders =  $this->orders_model->getorders($this->input->post('clientid'));
        if($this->input->post('credit')){
            $this->orders_model->update_credit($this->input->post('credit'),$this->input->post('clientid'));
         }
        $client=  $this->orders_model->getcredit($this->input->post('clientid'));
        $creditbalance = $client->credit_limit-($orders->total+$invoice->total);
      
        if( $this->input->post('amount') > $creditbalance){
            echo json_encode(array('status'=>'0','creditbalance'=>$creditbalance));
        }else{
             echo  json_encode(array('status'=>'1','creditbalance'=>$creditbalance));
        }
        
        
        
    }

}
