<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Engines extends Admin_controller {

    function __construct() {
        parent::__construct();
        $this->load->model('engines_model');
    }

    /* List all available items */

    public function index() {
		
        if ($this->input->is_ajax_request()) {
			
			
            $aColumns = array(                
                'make',
                'cc',
                'kw',
                'ps',
				'hp',
				'nm',
				'cylinders',
				'engine_code',
				'ecu_type',
				'fuel',
            );
            $sIndexColumn = "id";
            $sTable = 'engines';
            $join = array(
            );
            $additionalSelect = array(
                'id', 'model','year'
            );
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, array(), $additionalSelect);
            $output = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                     $_data = $aRow[$aColumns[$i]];
                    if ($aColumns[$i] == 'make') {
                         $_data ='<a href="'.admin_url('engines/engines/'.$aRow['id']).'">'. $aRow['make'].' '.$aRow['model']. ''.$aRow['year']. '</a>';
                    }else if ($aColumns[$i] == 'cc') { 
                          $_data =  $_data;
                    }else if ($aColumns[$i] == 'year') {
                        $_data =  $_data;
                    } else if ($aColumns[$i] == 'kw') {
                        $_data = $_data;
					
					}
					else if ($aColumns[$i] == 'ps') {
                        $_data = $_data;
					
					}
					else if ($aColumns[$i] == 'hp') {
                        $_data = $_data;
					
					}
					else if ($aColumns[$i] == 'nm') {
                        $_data = $_data;
					
					}
					else if ($aColumns[$i] == 'cylinders') {
                        $_data = $_data;
					
					}
					else if ($aColumns[$i] == 'engine_code') {
                        $_data = $_data;
					
					}
					else if ($aColumns[$i] == 'ecu_type') {
                        $_data = $_data;
					
					}
					else if ($aColumns[$i] == 'fuel') {
                        $_data = $_data;
					
					}                   
                    $row[] = $_data;
                }
                $options = icon_btn('admin/engines/engines/' . $aRow['id'], 'pencil-square-o', 'edit-locations', array('data-toggle' => 'tooltip', 'title' => _l('engines_edit_tooltip')));
                
                
                $row[] = $options .= icon_btn('admin/engines/delete/' . $aRow['id'], 'remove', '',array('onClick' => 'return deleteconf();'));

                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        $data['title'] = _l('engines');
        $this->load->view('admin/engines/manage', $data);
    }

    public function engines($id = '') {
        if ($this->input->post() && !$this->input->is_ajax_request()) {
			
			
			//print_r($this->input->post());
			
            if ($id == '') {
                    $id = $this->engines_model->add($this->input->post());
                    if ($id) {
                        set_alert('success', _l('engines_added_successfully', _l('engines_added')));
						
						
                        if (trim($this->input->post('action')) == 'save') {
                          //  redirect(admin_url('make/make/'.$id));
							 redirect(admin_url('engines'));

                            exit;
                           }
                        if (trim($this->input->post('action')) == 'snew') {
							 redirect(admin_url('engines'));
                            exit;
                        }

                        if (trim($this->input->post('action')) == 'slist') {
                             redirect(admin_url('engines'));
                              exit;
                        }
                        
                    }
            } else {
                $success = $this->engines_model->update($this->input->post(), $id);
  
                if ($success) {
                  
                    set_alert('success', _l('engines_updated_successfully', _l('engines_updated')));
                    if (trim($this->input->post('action')) == 'save') {
                            redirect(admin_url('engines/engines/'.$id));
                            exit;
                           }
                        if (trim($this->input->post('action')) == 'snew') {
                            redirect(admin_url('engines/engines'));
                            exit;
                        }

                        if (trim($this->input->post('action')) == 'slist') {
                             redirect(admin_url('engines'));
                              exit;
                        }
                }
                
            }
        }

        if ($id == '') {
            $title = _l('add_new', _l('warehouse_table_heading'));
        } else {     
           
            $engines = $this->engines_model->get_where_single_tbl('engines','id',$id);
			$data['client'] = $this->engines_model->get($id);
            $title = _l('edit', _l('warehouse_table_heading'));
        }
		$this->load->model('make_model');
		$data['makers']=$this->make_model->get();
        $data['title'] = $title;
        $this->load->view('admin/engines/engines', $data);
    }

   

    /* Delete item */

    public function delete($id) {
        if (!$id) {
            redirect(admin_url('engines'));
        }

        $response = $this->engines_model->delete($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('engine_lowercase')));
        } else if ($response == true) {
            set_alert('success', _l('deleted', _l('engines')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('engine_lowercase')));
        }
        redirect(admin_url('engines'));
    }
    
    /*delete warehouse contact*/
    public function deletecontactwarehouse()
    {
        $id=  $this->input->post('id');
        $response = $this->engines_model->deletecontact($id);
    }
    
    public function delete_items()
    {
        $id=  $this->input->post('id');
        $response = $this->engines_model->deleteitems($id);
        echo $response;
    }

    



    public function get_warehouse_reminders($id){
		if($this->input->is_ajax_request()){

			$aColumns = array( 'description', 'date', 'staff', 'isnotified');
			$sIndexColumn = "id";
			$sTable = 'tbladminwarehousereminders';

			$where = array('AND ware_id='.$id);
			$join = array(
				'JOIN tblstaff ON tblstaff.staffid = tbladminwarehousereminders.staff'
				);
			$result = data_tables_init($aColumns,$sIndexColumn,$sTable,$join,$where,array('firstname','lastname','id','creator'));
			$output = $result['output'];
			$rResult = $result['rResult'];

			foreach ( $rResult as $aRow )
			{
				$row = array();
				for ( $i=0 ; $i<count($aColumns) ; $i++ )
				{
					$_data = $aRow[ $aColumns[$i] ];
					if($aColumns[$i] == 'staff'){
						$_data = '<a href="'.admin_url('staff/profile/'.$aRow['staff']).'">'.staff_profile_image($aRow['staff'], array(
							'staff-profile-image-small'
							)) . ' ' . $aRow['firstname'] . ' ' . $aRow['lastname'] .'</a>';
					} else if($aColumns[$i] == 'staff'){
						$_data = _d($_data);
					} else if($aColumns[$i] == 'isnotified'){
						if($_data == 1){
							$_data = _l('client_reminder_is_notified_boolean_yes');
						} else {
							$_data = _l('client_reminder_is_notified_boolean_no');
						}
					}
					$row[] = $_data;
				}

				if($aRow['creator'] == get_staff_user_id()){
					//$row[] = icon_btn('admin/warehouse/delete_reminder/'.$id . '/'. $aRow['id'], 'remove', '');
				       $row[]  =  icon_btn('#', 'remove', ' delete-reminders', array('data-id'=>$aRow['id']));
                
                                        
                                } else {
					$row[] = '';
				}


				$output['aaData'][] = $row;
			}

			echo json_encode( $output );
			die();
		}
	}
        
        /* Since version 1.0.2 add client reminder */
	public function add_warehouse_reminder($id){
		if(!has_permission('manageClients')){
			access_denied('manageClients');
		}

		if($this->input->post()){
			$success = $this->engines_model->add_reminder($this->input->post(),$id);
			if($success){
				set_alert('success',_l('warehouse_reminder_added_successfuly'));
			}
		}

		redirect(admin_url('make/warehouse/'.$id));
	}

	/* Since version 1.0.2 delete client reminder */
	public function delete_reminders(){
		$id=  $this->input->post('id');
		$success = $this->engines_model->delete_reminder($id);
                echo $success;
	}

    /* Get item by id / ajax */

    public function get_item_by_id($id) {
        if ($this->input->is_ajax_request()) {
            echo json_encode($this->engines_model->get($id));
        }
    }

    /* Get all items */

    public function get_all_items_ajax() {
        if ($this->input->is_ajax_request()) {
            echo json_encode($this->engines_model->get_all_items_ajax());
        }
    }
    
    /*Warehouse Id Exist or Not*/
    public function check_warehouse()
    {
        $warehouse_id=  $this->input->post('warehouse_id');
        $check_warehouse=  $this->engines_model->get_where_single_tbl('tblwarehouse', 'warehouse_id', $warehouse_id);
        if(empty($check_warehouse))
        {
           echo '1';
        }
        else {
            echo '0';
        }
    }
          public function manage()
    {
        if ($this->input->post()) {
            $data = $this->input->post();
            if ($data['contactid'] == '') {
                $message = '';
                $success = $this->engines_model->addcontact($data);
                if($success) {
                    $message = _l('added_successfuly','Contact');
                }
                echo json_encode(array(
                    'success' => $success,
                    'message'=>$message
                ));
            } else {
                $message = '';
                $success = $this->engines_model->updateContacts($data);
                if($success){
                    $message = _l('updated_successfuly','Contact');
                }
                echo json_encode(array(
                    'success' => $success,
                    'message'=>$message
                ));
            }
        }
    }
    public function getcontact(){
       echo json_encode($this->engines_model->getcontact($this->input->post('id')));
    }
}
