<?php



defined('BASEPATH') OR exit('No direct script access allowed');



class Engines extends Admin_controller {



    function __construct() {

        parent::__construct();

        $this->load->model('engines_model');

		// load Pagination library

        $this->load->library('pagination');

         

        // load URL helper

        $this->load->helper('url');



    }



    /* List all available items */



    public function index() { 

	

		 

		$data['engines'] = $this->engines_model->getallenginesdata();

		/*echo '<pre>';

        print_r($data['engines']);

		exit;*/

        $data['title']     = _l('engines');

        $this->load->view('admin/engines/manage', $data);

		}

		 public function get_engine_list($makeid) { 

	

		 

		$data['engines'] = $this->engines_model->getallenginesdata();

		$data['makeid'] = $makeid;

		/*echo '<pre>';

        print_r($data['engines']);

		exit;*/

        $data['title']     = _l('engines');

        $this->load->view('admin/engines/manage', $data);

		}

		

	  public function getallenginesdata($makeid) { 

		//$search = $this->input->get("search[value]");

		$total_books = $this->engines_model->getallenginesdatatotal($makeid);

		//`echo $makeid;

		

          // Datatables Variables

          $draw = intval($this->input->get("draw"));

          $start = intval($this->input->get("start"));

		  $length = intval($this->input->get("length"));

		  $search = $this->input->get("search[value]");





        $order = $this->input->get("order");



        $col = 0;

        $dir = "";

        if(!empty($order)) {

            foreach($order as $o) {

                $col = $o['column'];

                $dir= $o['dir'];

            }

        }



        if($dir != "asc" && $dir != "desc") {

            $dir = "asc";

        }

		

		 $columns_valid = array(

            "vehiclemodelyear.make",

            "vehiclemodelyear.model",

            "vehiclemodelyear.year",

        );



        if(!isset($columns_valid[$col])) {

            $order = null;

        } else {

            $order = $columns_valid[$col];

        }

		//print_r($order);

          $engines = $this->engines_model->getallenginesdata($start, $length, $order, $dir, $search, $makeid);

			

			//print_r($engines);

          $data = array();



          foreach($engines->result() as $r) {
			
			
			

			if($r->image_make != '' && file_exists('uploads/make_img/'.$r->image_make))

					{

						$image = $r->image_make;

					}

					else

					{

						$image = 'noimage.png'; 

					}

			

			

			$fromyear = str_replace("(","",$r->year);

			$fromyear = str_replace(")","",$fromyear);

			$fromyear = str_replace("→...","",$fromyear);

			if (strpos($fromyear, '→') !== false) {

			$fromyear = substr($fromyear, 0, strpos($fromyear, "→"));

			}

			

			if($r->fuel == 'Petrol'){

				$color = 'blue';

			}elseif($r->fuel == 'Diesel'){

				$color = 'black';

			}else{

				$color = 'green';

				

			}

			

			if($r->fuel == 'Hybird'){

			 $r->fuel ='Hybrid';

			}

			

			if($r->id){

			$vehicle_data =  $this->engines_model->get_num_row($r->id);

			}

			

			if($vehicle_data == '0'){

				$colornum = '#FF0000';

				$font = 'bold';
				$link='<span style="color:'.$colornum.'; font-weight:'.$font.';">'.$vehicle_data.'</span>';
				

			}else{

				$colornum = '';
				$font = '';
				$link='<a href="'.base_url() . 'admin/vehicles/show_engines/'.$r->id.'" target="_blank"><span style="color:'.$colornum.'; font-weight:'.$font.';">'.$vehicle_data.'</span></a>';
			}

			

               $data[] = array(

				'<div class="col-lg-12" id="alerts_'.$r->id.'" style="display:none;position: absolute;z-index: 1000000;">
					<div class="alert alert-success">
						Engine Updated Successfully
					</div>
				</div>
<img class="img-rounded"  src="'.site_url('uploads/make_img/' .$image).'"  title="'.$r->make.'" alt="Change Image"  style="cursor:pointer; height: 40px; width: 40px; margin-right: 5px; ">'.$r->make,

                    $r->model,

                    $fromyear,

'<input type="text" class="form-control typecode" id="type_'.$r->id.'" name="stage1_hp" value="'.$r->type.'"/>',

'<input type="text" class="form-control" id="cc_'.$r->id.'" name="stage1_hp" value="'.$r->cc.'"/>',

					$r->cylinders,

'<input type="text" class="form-control" id="kw_'.$r->id.'" name="stage1_hp" value="'.$r->kw.'"/>',

'<input type="text" class="form-control" id="ps_'.$r->id.'" name="stage1_hp" value="'.$r->ps.'"/>',

'<input type="text" class="form-control" id="hp_'.$r->id.'" name="stage1_hp" value="'.$r->hp.'"/>',

'<input type="text" class="form-control" id="nm_'.$r->id.'" name="stage1_hp" value="'.$r->nm.'" />',

'<input type="text" class="form-control typecode" id="engine_code_'.$r->id.'" name="stage1_hp" value="'.$r->engine_code.'"/>',

'<input type="text" class="form-control typecode" id="ecu_type_'.$r->id.'" name="stage1_hp" value="'.$r->ecu_type.'"/>',

'<span style="color:'.$color.'">'.$r->fuel.'</span>',

'<input type="text" class="form-control" id="stage1_hp_'.$r->id.'" name="stage1_hp" value="'.$r->stage1_hp.'"/>',

'<input type="text" class="form-control" id="stage1_nm_'.$r->id.'" name="stage1_hp" value="'.$r->stage1_nm.'"/>',

'<input type="text" class="form-control" id="stage2_hp_'.$r->id.'" name="stage1_hp" value="'.$r->stage2_hp.'"/>',

'<input type="text" class="form-control" id="stage2_nm_'.$r->id.'" name="stage1_hp" value="'.$r->stage2_nm.'"/>',

$link,

'<a class="btn edit-locations btn-icon" data-toggle="tooltip" title="Save Engine" onclick="save_engine_data(\''.$r->id.'\')"> <i class="fa fa-save"></i></a> 

<a href="engines/engines/'. $r->id.'" class="btn edit-locations btn-icon" data-toggle="tooltip" title="" data-original-title="Edit Engine"><i class="fa fa-pencil-square-o"></i></a><a href="engines/delete/'.$r->id.'" class="btn edit-locations btn-icon" data-toggle="tooltip" title="" 

data-original-title="Delete Engine"><i class="fa fa-remove"></i></a>



'

               );

          }



          $output = array(

               "draw" => $draw,

                 "recordsTotal" => $total_books,

                 "recordsFiltered" => $total_books,

                 "data" => $data

            );

          echo json_encode($output);

          exit();

		}

	

	

    public function index_old_version() {

		

		

		

	 // init params

        $params = array();

        $limit_per_page = 100;

        $page = ($this->uri->segment(4)) ? ($this->uri->segment(4) - 1) : 0;

        $total_records = $this->engines_model->record_count();

        if ($total_records > 0) 

        {

             // get current page records

            $data["makers"] = $this->engines_model->getmakemodelyears($limit_per_page, $page);

                 

            $config['base_url'] = base_url() . 'admin/engines/index';

            $config['total_rows'] = $total_records;

            $config['per_page'] = $limit_per_page;

            $config["uri_segment"] = 4;

             

            // custom paging configuration

            $config['full_tag_open'] = "<ul class='pagination'>";

			$config['full_tag_close'] ="</ul>";

			$config['num_tag_open'] = '<li>';

			$config['num_tag_close'] = '</li>';

			$config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";

			$config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";

			$config['next_tag_open'] = "<li>";

			$config['next_tagl_close'] = "</li>";

			$config['prev_tag_open'] = "<li>";

			$config['prev_tagl_close'] = "</li>";

			$config['first_tag_open'] = "<li>";

			$config['first_tagl_close'] = "</li>";

			$config['last_tag_open'] = "<li>";

			$config['last_tagl_close'] = "</li>";

            $this->pagination->initialize($config);

                 

            // build paging links

            $str= $this->pagination->create_links();

        }

        	

		

		$data["links"] = explode('&nbsp;',$str );

		//$data['makers']=$this->engines_model->getmakemodelyears();

		

		 

        $data['title'] = _l('engines');

        $this->load->view('admin/engines/manage', $data);

    }

	

	

    public function getengineslistajax() {

		

		

		if ($this->input->is_ajax_request()) {

			

		$searchterm = $this->input->post('searchterm');

		//echo $searchterm;

        $params = array();

        $limit_per_page = 20;

        $page = ($this->uri->segment(4)) ? ($this->uri->segment(4) - 1) : 0;

        $total_records = $this->engines_model->record_count_search($searchterm);

        if ($total_records > 0) 

        {

             // get current page records

            $data["makers"] = $this->engines_model->getmakemodelyears_search($limit_per_page, $page , $searchterm);

                 

            $config['base_url'] = base_url() . 'admin/engines/getengineslistajax/'.$searchterm;

            $config['total_rows'] = $total_records;

            $config['per_page'] = $limit_per_page;

            $config["uri_segment"] = 4;

             

            // custom paging configuration

            $config['full_tag_open'] = "<ul class='pagination'>";

			$config['full_tag_close'] ="</ul>";

			$config['num_tag_open'] = '<li>';

			$config['num_tag_close'] = '</li>';

			$config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";

			$config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";

			$config['next_tag_open'] = "<li>";

			$config['next_tagl_close'] = "</li>";

			$config['prev_tag_open'] = "<li>";

			$config['prev_tagl_close'] = "</li>";

			$config['first_tag_open'] = "<li>";

			$config['first_tagl_close'] = "</li>";

			$config['last_tag_open'] = "<li>";

			$config['last_tagl_close'] = "</li>";

            $this->pagination->initialize($config);

                 

            // build paging links

            $str= $this->pagination->create_links();

        }

        	

		

		$data["links"] = explode('&nbsp;',$str );

		//$data['makers']=$this->engines_model->getmakemodelyears();

		

		 

        $data['title'] = _l('engines');

       

	   

	   

	   $html = '<div class="table-responsive" id="engineslistdisplay"><table class="table table-striped table-bordered table-advance table-hover">';

	   				foreach ($data["makers"] as $makerdata){

							$engines = getengines($makerdata->id);

			

			

			$html .= '<tr><td colspan="15">';

            

			if($makerdata->image_make != '' && file_exists('uploads/make_img/'.$makerdata->image_make))

					{

						$image = $makerdata->image_make;

					}

					else

					{

						$image = 'noimage.png'; 

					}

					

					

					

				$html.= '<h4 style="font-weight:bold"><img class="img-rounded"  src="'.site_url("uploads/make_img/" .$image).'"  title="Change Image" alt="Change Image"  style="cursor:pointer; height: 50px; width: 50px; margin-right: 5px; ">'.$makerdata->make." ".$makerdata->model." ".$makerdata->year.'</h4></td>

                </tr>

               

				<tr>

                  <th width="13%" class="text-left" style="font-weight:bold"> '._l('type').' </th>

                  <th width="2%" class="text-left" style="font-weight:bold"> '._l('engine_cc').'  </th>

                  <th width="2%" class="text-left" style="font-weight:bold"> '._l('engine_kw').' </th>

                  <th width="2%" class="text-left" style="font-weight:bold"> '._l('engine_ps').' </th>

                  <th width="2%" class="text-left" style="font-weight:bold"> '._l('engine_hp').' </th>

                  <th width="2%" class="text-left" style="font-weight:bold"> '._l('engine_nm').' </th>

                  <th width="8%" class="text-left" style="font-weight:bold"> '._l('engine_code').' </th>

                  <th width="8%" class="text-left" style="font-weight:bold"> '._l('ecu_type').' </th>

                  <th width="2%" class="text-left" style="font-weight:bold"> '._l('fuel_type').' </th>

                  <th width="5%" class="text-left" style="font-weight:bold; color: red !important; "> '._l('engine1_hp').'</th>

                  <th width="5%" class="text-left" style="font-weight:bold; color: red !important; "> '._l('engine1_nm').'</th>

                  <th width="5%" class="text-left" style="font-weight:bold; color: red !important; "> '._l('engine2_hp').'</th>

                  <th width="5%" class="text-left" style="font-weight:bold; color: red !important; "> '._l('engine2_nm').'</th>

                  <th width="6%" class="text-left" style="font-weight:bold"> '._l('options').'</th>

                </tr>';		

					

					foreach ($engines as $enginesdata){

								

				

                

           $html.= '<tbody>

                  <tr class="main">

                    <td><input type="text" class="form-control" id="type_'.$enginesdata['id'].'" name="type" value="'.$enginesdata['type'].'"/></td>

                    <td><input type="text" class="form-control" id="cc_'.$enginesdata['id'].'" name="cc" value="'.$enginesdata['cc'].'"  /></td>

           <td><input type="text" class="form-control" id="kw_'.$enginesdata['id'].'" name="kw" value="'.$enginesdata['kw'].'" onblur="change_engine_data'.($enginesdata['id']).'" /></td>

                    <td>'.$enginesdata['ps'].'</td>

 <td><input type="text" class="form-control" id="hp_'.$enginesdata['id'].'" name="hp" value="'.$enginesdata['hp'].'" /></td>

                    <td><input type="text" class="form-control" id="nm_'.$enginesdata['id'].'" name="nm" value="'.$enginesdata['nm'].'" /></td>

                    <td><input type="text" class="form-control" id="engine_code_'.$enginesdata['id'].'" name="engine_code" value="'.$enginesdata['engine_code'].'"/></td>

                    <td><input type="text" class="form-control" id="ecu_type_'.$enginesdata['id'].'" name="ecu_type" value="'.$enginesdata['ecu_type'].'"  /></td>';

                    

					if($enginesdata['fuel'] == 'Petrol')

					{

                    	$color = "red";

					}elseif($enginesdata['fuel'] == 'Hybrid' || $enginesdata['fuel'] == 'Other' )

					{

						$color = "orange";

					}elseif($enginesdata['fuel'] == 'Diesel'){

						

						$color = "green";

					}

					

                 $html.='   <td style="color: '.$color.' !important">'. $enginesdata['fuel'].'</td>

                    <td><input type="text" class="form-control" id="stage1_hp_'.$enginesdata['id'].'" name="stage1_hp" value="'.$enginesdata['stage1_hp'].'"  /></td>

                    <td><input type="text" class="form-control" id="stage1_nm_'.$enginesdata['id'].'" name="stage1_nm" value="'.$enginesdata['stage1_nm'].'"  /></td>

                    <td><input type="text" class="form-control" id="stage2_hp_'.$enginesdata['id'].'" name="stage2_hp" value="'.$enginesdata['stage2_hp'].'"  /></td>

                    <td><input type="text" class="form-control" id="stage2_nm_'.$enginesdata['id'].'" name="stage2_nm" value="'. $enginesdata['stage2_nm'].'"  /></td>

                    <td><a class="btn edit-locations btn-icon" data-toggle="tooltip" title="" data-original-title="Edit Make" 

                    onclick="save_engine_data'.($enginesdata['id']).'"> <i class="fa fa-save"></i></a>

                    <a href="engines/engines/'.$enginesdata['id'].'" class="btn edit-locations btn-icon" data-toggle="tooltip" title="" data-original-title="Edit Make"> <i class="fa fa-pencil-square-o"></i></a>

                    <a href="engines/delete/'.$enginesdata['id'].'" class="btn edit-locations btn-icon" data-toggle="tooltip" title="" data-original-title="Edit Make"> <i class="fa fa-remove"></i></a></td>

                    

                  </tr>

                </tbody>';

               

							

							

						}

              

						}// end outer loop

						

						

             $html.=' </table> 

			 <div id="pagination">

				<ul class="tsc_pagination">';

				 foreach ($data['links'] as $link) {

					 

				$html.= '<li>'. $link.'</li>';

				

				} 

				

				$html.='  </ul>

				</div>

			 

			 </div>';

	   

	   echo $html;

    }

	

	else{

		

		

		

		

	 // init params

        $params = array();

        $limit_per_page = 20;

		

        $page = ($this->uri->segment(5)) ? ($this->uri->segment(5) - 1) : 0;

      	$searchterm = $this->uri->segment(4);

		$searchterm = str_replace('%20',' ',$searchterm);

        $total_records = $this->engines_model->record_count_search($searchterm);

        if ($total_records > 0) 

        {

             // get current page records

            $data["makers"] = $this->engines_model->getmakemodelyears_search($limit_per_page, $page , $searchterm);

                 

            $config['base_url'] = base_url() . 'admin/engines/getengineslistajax/'.$searchterm;

            $config['total_rows'] = $total_records;

            $config['per_page'] = $limit_per_page;

            $config["uri_segment"] = 5;

             

            // custom paging configuration

            $config['full_tag_open'] = "<ul class='pagination'>";

			$config['full_tag_close'] ="</ul>";

			$config['num_tag_open'] = '<li>';

			$config['num_tag_close'] = '</li>';

			$config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";

			$config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";

			$config['next_tag_open'] = "<li>";

			$config['next_tagl_close'] = "</li>";

			$config['prev_tag_open'] = "<li>";

			$config['prev_tagl_close'] = "</li>";

			$config['first_tag_open'] = "<li>";

			$config['first_tagl_close'] = "</li>";

			$config['last_tag_open'] = "<li>";

			$config['last_tagl_close'] = "</li>";

            $this->pagination->initialize($config);

                 

            // build paging links

            $str= $this->pagination->create_links();

        }

        	

		

		$data["links"] = explode('&nbsp;',$str );

		//$data['makers']=$this->engines_model->getmakemodelyears();

		

		 

        $data['title'] = _l('engines');

        $this->load->view('admin/engines/manage', $data);

    

		

	}



	}

	

	

	

    public function index_old() {

		

        if ($this->input->is_ajax_request()) {

			

			

            $aColumns = array(                

                'make',

                'cc',

                'kw',

                'ps',

				'hp',

				'nm',

				'cylinders',

				'engine_code',

				'ecu_type',

				'fuel',

				'stage1_hp',

				'stage1_nm',

				'stage2_hp',

				'stage2_nm',

            );

            $sIndexColumn = "id";

            $sTable = 'engines';

            $join = array(

            );

            $additionalSelect = array(

                'id', 'model','year'

            );

            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, array(), $additionalSelect);

            $output = $result['output'];

            $rResult = $result['rResult'];



            foreach ($rResult as $aRow) {

                $row = array();

                for ($i = 0; $i < count($aColumns); $i++) {

                     $_data = $aRow[$aColumns[$i]];

                    if ($aColumns[$i] == 'make') {

                         $_data ='<a href="'.admin_url('engines/engines/'.$aRow['id']).'">'. $aRow['make'].' '.$aRow['model']. ''.$aRow['year']. '</a>';

                    }else if ($aColumns[$i] == 'cc') { 

                          $_data =  $_data;

                    }else if ($aColumns[$i] == 'year') {

                        $_data =  $_data;

                    } else if ($aColumns[$i] == 'kw') {

                        $_data = $_data;

					

					}

					else if ($aColumns[$i] == 'ps') {

                        $_data = $_data;

					

					}

					else if ($aColumns[$i] == 'hp') {

                        $_data = $_data;

					

					}

					else if ($aColumns[$i] == 'nm') {

                        $_data = $_data;

					

					}

					else if ($aColumns[$i] == 'cylinders') {

                        $_data = $_data;

					

					}

					else if ($aColumns[$i] == 'engine_code') {

                        $_data = $_data;

					

					}

					else if ($aColumns[$i] == 'ecu_type') {

                        $_data = $_data;

					

					}

					else if ($aColumns[$i] == 'fuel') {

                        $_data = $_data;

					

					}

					else if ($aColumns[$i] == 'stage1_hp') {

                        $_data = $_data;

					

					} 

					else if ($aColumns[$i] == 'stage1_nm') {

                        $_data = $_data;

					

					} 

					else if ($aColumns[$i] == 'stage2_hp') {

                        $_data = $_data;

					

					} 

					else if ($aColumns[$i] == 'stage2_nm') {

                        $_data = $_data;

					

					}                    

                    $row[] = $_data;

                }

                $options = icon_btn('admin/engines/engines/' . $aRow['id'], 'pencil-square-o', 'edit-locations', array('data-toggle' => 'tooltip', 'title' => _l('engines_edit_tooltip')));

				

                

                

                $row[] = $options .= icon_btn('admin/engines/delete/' . $aRow['id'], 'remove', '',array('onClick' => 'return deleteconf();'));



                $output['aaData'][] = $row;

            }



            echo json_encode($output);

            die();

        }



        $data['title'] = _l('engines');

        $this->load->view('admin/engines/manage', $data);

    }

	

	

	

    public function engines($id = '') {

        if ($this->input->post() && !$this->input->is_ajax_request()) {

			

			

			//print_r($this->input->post());

			

            if ($id == '') {

                    $id = $this->engines_model->add($this->input->post());

                    if ($id) {

                        set_alert('success', _l('engines_added_successfully', _l('engines_added')));

						

						

                        if (trim($this->input->post('action')) == 'save') {

                            redirect(admin_url('engines/engines/'.$id));

							// redirect(admin_url('engines'));



                            exit;

                           }

                        if (trim($this->input->post('action')) == 'snew') {

							 redirect(admin_url('engines/engines/'.$id));

                            exit;

                        }



                        if (trim($this->input->post('action')) == 'slist') {

                             redirect(admin_url('engines'));

                              exit;

                        }

                        

                    }

            } else {

				if (trim($this->input->post('action')) == 'save') {

							

                            $success = $this->engines_model->update($this->input->post(), $id);

							

                           }

						   else if (trim($this->input->post('action')) == 'snew') {

                            $success = $this->engines_model->add($this->input->post());

                        }

                

  

                if ($success) {

                  

                    set_alert('success', _l('engines_updated_successfully', _l('engines_updated')));

                    if (trim($this->input->post('action')) == 'save') {

                            redirect(admin_url('engines/engines/'.$id));

                            exit;

                           }

                        if (trim($this->input->post('action')) == 'snew')

						 {

							 $id = $success;

                            redirect(admin_url('engines/engines/'.$id));

                            exit;

                        }



                        if (trim($this->input->post('action')) == 'slist') {

                             redirect(admin_url('engines'));

                              exit;

                        }

                }

                

            }

        }



        if ($id == '') {

            $title = _l('add_new', _l('warehouse_table_heading'));

        } else {     

           

            $engines = $this->engines_model->get_where_single_tbl('engines','id',$id);

			$data['client'] = $this->engines_model->get($id);

            $title = _l('edit', _l('warehouse_table_heading'));

        }

		$this->load->model('make_model');

		$data['makers']=$this->make_model->get();

        $data['title'] = $title;

        $this->load->view('admin/engines/engines', $data);

    }



   



    /* Delete item */



    public function delete($id) {

        if (!$id) {

            redirect(admin_url('engines'));

        }



        $response = $this->engines_model->delete($id);

        if (is_array($response) && isset($response['referenced'])) {

            set_alert('warning', _l('is_referenced', _l('engine_lowercase')));

        } else if ($response == true) {

            set_alert('success', _l('deleted', _l('engines')));

        } else {

            set_alert('warning', _l('problem_deleting', _l('engine_lowercase')));

        }

        redirect(admin_url('engines'));

    }

    

    /*delete warehouse contact*/

    public function deletecontactwarehouse()

    {

        $id=  $this->input->post('id');

        $response = $this->engines_model->deletecontact($id);

    }

    

    public function delete_items()

    {

        $id=  $this->input->post('id');

        $response = $this->engines_model->deleteitems($id);

        echo $response;

    }



    







    public function get_warehouse_reminders($id){

		if($this->input->is_ajax_request()){



			$aColumns = array( 'description', 'date', 'staff', 'isnotified');

			$sIndexColumn = "id";

			$sTable = 'tbladminwarehousereminders';



			$where = array('AND ware_id='.$id);

			$join = array(

				'JOIN tblstaff ON tblstaff.staffid = tbladminwarehousereminders.staff'

				);

			$result = data_tables_init($aColumns,$sIndexColumn,$sTable,$join,$where,array('firstname','lastname','id','creator'));

			$output = $result['output'];

			$rResult = $result['rResult'];



			foreach ( $rResult as $aRow )

			{

				$row = array();

				for ( $i=0 ; $i<count($aColumns) ; $i++ )

				{

					$_data = $aRow[ $aColumns[$i] ];

					if($aColumns[$i] == 'staff'){

						$_data = '<a href="'.admin_url('staff/profile/'.$aRow['staff']).'">'.staff_profile_image($aRow['staff'], array(

							'staff-profile-image-small'

							)) . ' ' . $aRow['firstname'] . ' ' . $aRow['lastname'] .'</a>';

					} else if($aColumns[$i] == 'staff'){

						$_data = _d($_data);

					} else if($aColumns[$i] == 'isnotified'){

						if($_data == 1){

							$_data = _l('client_reminder_is_notified_boolean_yes');

						} else {

							$_data = _l('client_reminder_is_notified_boolean_no');

						}

					}

					$row[] = $_data;

				}



				if($aRow['creator'] == get_staff_user_id()){

					//$row[] = icon_btn('admin/warehouse/delete_reminder/'.$id . '/'. $aRow['id'], 'remove', '');

				       $row[]  =  icon_btn('#', 'remove', ' delete-reminders', array('data-id'=>$aRow['id']));

                

                                        

                                } else {

					$row[] = '';

				}





				$output['aaData'][] = $row;

			}



			echo json_encode( $output );

			die();

		}

	}

        

        /* Since version 1.0.2 add client reminder */

	public function add_warehouse_reminder($id){

		if(!has_permission('manageClients')){

			access_denied('manageClients');

		}



		if($this->input->post()){

			$success = $this->engines_model->add_reminder($this->input->post(),$id);

			if($success){

				set_alert('success',_l('warehouse_reminder_added_successfuly'));

			}

		}



		redirect(admin_url('make/warehouse/'.$id));

	}



	/* Since version 1.0.2 delete client reminder */

	public function delete_reminders(){

		$id=  $this->input->post('id');

		$success = $this->engines_model->delete_reminder($id);

                echo $success;

	}



    /* Get item by id / ajax */



    public function get_item_by_id($id) {

        if ($this->input->is_ajax_request()) {

            echo json_encode($this->engines_model->get($id));

        }

    }



    /* Get all items */



    public function get_all_items_ajax() {

        if ($this->input->is_ajax_request()) {

            echo json_encode($this->engines_model->get_all_items_ajax());

        }

    }

    

    /*Warehouse Id Exist or Not*/

    public function check_warehouse()

    {

        $warehouse_id=  $this->input->post('warehouse_id');

        $check_warehouse=  $this->engines_model->get_where_single_tbl('tblwarehouse', 'warehouse_id', $warehouse_id);

        if(empty($check_warehouse))

        {

           echo '1';

        }

        else {

            echo '0';

        }

    }

          public function manage()

    {

        if ($this->input->post()) {

            $data = $this->input->post();

            if ($data['contactid'] == '') {

                $message = '';

                $success = $this->engines_model->addcontact($data);

                if($success) {

                    $message = _l('added_successfuly','Contact');

                }

                echo json_encode(array(

                    'success' => $success,

                    'message'=>$message

                ));

            } else {

                $message = '';

                $success = $this->engines_model->updateContacts($data);

                if($success){

                    $message = _l('updated_successfuly','Contact');

                }

                echo json_encode(array(

                    'success' => $success,

                    'message'=>$message

                ));

            }

        }

    }

    public function getcontact(){

       echo json_encode($this->engines_model->getcontact($this->input->post('id')));

    }

	

	public function save_enginedata($id = '') {

      echo $success = $this->engines_model->update($this->input->post(), $id);

	  //echo $this->db->last_query();

    }



	

}

