<?php

header('Content-Type: text/html; charset=utf-8');
defined('BASEPATH') OR exit('No direct script access allowed');

class Contacts extends Admin_controller {

    function __construct() {
        parent::__construct();
        $this->load->model('clients_model');
    }

    /* Get all invoices in case user go on index page */

    public function index($id = false) {
        $this->list_contacts($id);
    }

    /* List all invoices datatables */

    public function list_contacts($id = false, $clientid = false) {
        $has_permission = has_permission('manageSales');

        if (!$has_permission && !$this->input->is_ajax_request()) {
            access_denied('manageSales');
        }


        if ($this->input->is_ajax_request()) {
            // From client profile
            if (is_numeric($clientid)) {
                if (!$has_permission) {
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                'firstname',
                'lastname',
                'email',
                'mobileno',
                'phoneno',
                'id'
            );

            $where = array();
            if (is_numeric($clientid)) {
                $where = array(
                    'where userid=' . $clientid
                        //'userid' => $clientid
                );
            }
            //print_r($where);
            $sIndexColumn = "id";
            $sTable = 'tblclientcontacts';
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $where,array(),array('userid'));
            $output = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();
                // $company .= '<small class="text-muted"> ' . $aRow['firstname'] . ' ' . $aRow['lastname'] . '</small>';
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];

                    if ($aColumns[$i] == 'firstname') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'firstname') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'lastname') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'email') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'mobileno') {
                        $__data = ($aRow['mobileno']!= '0') ? $aRow['mobileno'] : '';
                    } else if ($aColumns[$i] == 'phoneno') {
                        $__data = ($aRow['phoneno']!= '0') ? $aRow['phoneno'] : '';
                    } else if ($aColumns[$i] == 'id') {
                        //$__data ='<a href="javascript:void(0);" class="editcontact" data-id="'.$aRow['id'].'">Edit</a> | <a href="' . admin_url('clients/deletecontact/' . $aRow['id']) . '" class="editcontact" data-id="'.$aRow['id'].'">Delete</a><br />';

//                        $options = icon_btn('admin/contacts/contact/'.$aRow['userid'].'/'.$aRow['id'], 'pencil-square-o', 'editcontact', array('data-id' => $aRow['id']));
                         $options = icon_btn('#' . $aRow['id'], 'pencil-square-o', 'btn-default editcontact', array(
                            'data-toggle' => 'modal',
                            'data-target' => '#client_contact_modal',
                            'title' =>'Edit Contact',
                            'data-id' => $aRow['id'],
                            'data-client' => $aRow['userid']
                        ));
                        $row[] = $options .= icon_btn('admin/clients/deletecontact/' . $aRow['id'], 'remove', ' deletecontact', array('data-id' => $aRow['id']));
                    }


                    $row[] = $__data;
                }
                $output['aaData'][] = $row;
            }
            echo json_encode($output);
            die();
        }

        $data['invoiceid'] = '';
        if (is_numeric($id)) {
            $data['invoiceid'] = $id;
        }

        $data['custom_view'] = $_custom_view;
        $data['status'] = $_status;

        $data['bodyclass'] = 'small-table';
        $data['title'] = _l('invoices');
        $this->load->view('admin/invoices/manage', $data);
    }

    public function contact($customerid = '',$id = '') {
        $this->load->model('clients_model');
        $data['clients'] = $this->clients_model->get();
        /* add contact */
  
        if ($this->input->post()) {


            if ($id == '') {
                $id = $this->clients_model->addcontact();
                if ($id) {
                    set_alert('success', _l('client_contact_insert_success_action', _l('client_lowercase')));
                    redirect(admin_url('contacts/contact/'.$this->input->post('clientid') .'/'.$id));
                }
            } else {
                $success = $this->clients_model->updateContacts($id);
                if ($success) {
                    set_alert('success', _l('updated_successfuly', _l('contact')));
                }

                redirect(admin_url('contacts/contact/'.$this->input->post('clientid') .'/'.$id));
            }
        }
        
        if ($id == '') {
            $title = _l('add_new',_l('contact'));
        } else {
            $data['contact'] = $this->clients_model->get_where_record('tblclientcontacts',$id);
           $title = _l('edit',_l('contact'));
        }
        
        if(isset($data['contact'])){
            $customerid = $data['contact']->userid;
        }
             
        $data['customerdetails'] = $this->clients_model->get_client($customerid);
  
        $data['department'] = $this->clients_model->get_departments();
        $data['id']=$id;
        $data['customerid']=$customerid;
        
        $data['title'] = $title;
        $this->load->view('admin/contacts/contact', $data);
    }
    
      public function manage()
    {
        if ($this->input->post()) {
            $data = $this->input->post();
            if ($data['contactid'] == '') {
                $message = '';
                $success = $this->clients_model->addcontact($data);
                if($success) {
                    $message = _l('added_successfuly','Contact');
                }
                echo json_encode(array(
                    'success' => $success,
                    'message'=>$message
                ));
            } else {
                $message = '';
                $success = $this->clients_model->updateContacts($data);
                if($success){
                    $message = _l('updated_successfuly','Contact');
                }
                echo json_encode(array(
                    'success' => $success,
                    'message'=>$message
                ));
            }
        }
    }
    
     public function list_contacts_warehouse($id = false, $ware_id = false) {
        $has_permission = has_permission('manageSales');

        if (!$has_permission && !$this->input->is_ajax_request()) {
            access_denied('manageSales');
        }


        if ($this->input->is_ajax_request()) {
            // From client profile
            if (is_numeric($ware_id)) {
                if (!$has_permission) {
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                'firstname',
                'lastname',
                'email',
                'mobileno',
                'phoneno',
                'contact_id'
            );

            $where = array();
            if (is_numeric($ware_id)) {
                $where = array(
                    'where ware_id=' . $ware_id
                        //'userid' => $clientid
                );
            }
            //print_r($where);
            $sIndexColumn = "contact_id";
            $sTable = 'tblwarehousecontacts';
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $where,array(),array('ware_id'));
            $output = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();
                // $company .= '<small class="text-muted"> ' . $aRow['firstname'] . ' ' . $aRow['lastname'] . '</small>';
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];

                    if ($aColumns[$i] == 'firstname') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'firstname') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'lastname') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'email') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'mobileno') {
                        $__data = ($aRow['mobileno']!='0') ? $aRow['mobileno'] : '';
                    } else if ($aColumns[$i] == 'phoneno') {
                        $__data = ($aRow['phoneno']!='0') ? $aRow['phoneno'] : '';
                    } else if ($aColumns[$i] == 'contact_id') {
                        //$__data ='<a href="javascript:void(0);" class="editcontact" data-id="'.$aRow['id'].'">Edit</a> | <a href="' . admin_url('clients/deletecontact/' . $aRow['id']) . '" class="editcontact" data-id="'.$aRow['id'].'">Delete</a><br />';

//                        $options = icon_btn('admin/contacts/warehouse_contact/'.$aRow['ware_id'].'/'.$aRow['contact_id'], 'pencil-square-o', 'editcontact', array('data-id' => $aRow['contact_id']));
                         $options = icon_btn('#' . $aRow['id'], 'pencil-square-o', 'btn-default editcontact', array(
                            'data-toggle' => 'modal',
                            'data-target' => '#warehouse_contact_modal',
                            'title' =>'Edit Contact',
                            'data-id' => $aRow['contact_id'],
                        ));
                        $row[] = $options .= icon_btn('#', 'remove', ' deletecontactwarehouse', array('data-id' => $aRow['contact_id']));
                    }


                    $row[] = $__data;
                }
                $output['aaData'][] = $row;
            }
            echo json_encode($output);
            die();
        }

        $data['invoiceid'] = '';
        if (is_numeric($id)) {
            $data['invoiceid'] = $id;
        }

        $data['custom_view'] = $_custom_view;
        $data['status'] = $_status;

        $data['bodyclass'] = 'small-table';
        $data['title'] = _l('invoices');
        $this->load->view('admin/invoices/manage', $data);
    }
    
    public function warehouse_contact($ware_id = '',$id = '') {
        $this->load->model('warehouse_model');
        $data['warehouse'] = $this->warehouse_model->get();
        /* add contact */
        if ($this->input->post()) {


            if ($id == '') {
                $id = $this->warehouse_model->addcontact();
                if ($id) {
                    set_alert('success', _l('warehouse_contact_insert_success_action', _l('warehouse_lowercase')));
                    redirect(admin_url('contacts/warehouse_contact/'.$this->input->post('ware_id') .'/'.$id));
                }
            } else {
                $success = $this->warehouse_model->updateContacts($id);
                if ($success) {
                    set_alert('success', _l('updated_successfuly', _l('contact')));
                }

                redirect(admin_url('contacts/warehouse_contact/'.$this->input->post('ware_id') .'/'.$id));
            }
        }
        
        if ($id == '') {
            $title = _l('add_new',_l('contact'));
        } else {
            $data['contact'] = $this->warehouse_model->get_where_record('tblwarehousecontacts',$id);
           $title = _l('edit',_l('contact'));
        }
        
        if(isset($data['contact'])){
            $ware_id = $data['contact']->ware_id;
        }
        $data['warehousedeatils'] = $this->warehouse_model->get_client($ware_id);
        $data['department'] = $this->warehouse_model->get_departments();
        $data['contact_id']=$id;
        $data['ware_id']=$ware_id;
        $data['title'] = $title;
        $this->load->view('admin/contacts/warehouse_contact', $data);
    }

}
