<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Companies extends Admin_controller {

    function __construct() { 
        parent::__construct();
        $this->load->model('companies_model');
    }

    /* List all available items */

    public function index() {
      
			
            $aColumns = array(                
                'name',
				'secret',
				'company_id',
				'tax_registration',
                'tblcountries.short_name as short_name',
                'email',
                'website',
				'active'
            );
            $sIndexColumn = "id";
            $sTable = 'tblcompanies';
            $join = array(
                'LEFT JOIN tblcountries ON tblcountries.country_id = tblcompanies.country'
            );
            $additionalSelect = array(
                'id'
            );
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, array(), $additionalSelect);
           
            $data["companies"] = $result['rResult'];
		
        $data['title'] = 'Companies';
        $this->load->view('admin/companies/manage', $data);
    }
	public function types() {
      
			
        $this->db->select('*');
        $this->db->from('tblcompaniestypes');
        
        $types = $this->db->get()->result_array();

         $data["company_types"] = $types;
		
        $data['title'] = 'Company Types';
        $this->load->view('admin/companies/types', $data);
    }
	
	function generate_menu($menu,$listSelected)
	{
		$menu_active = get_option($menu);
		
    	$menu_active = json_decode($menu_active);
		
		$new_menu=$this->getSelected($menu_active->$menu,$listSelected);
		if($new_menu==0)
			return array();
		else
			return $new_menu;
		
	}
	function getSelected($items,$listSelected)
	{
		
		foreach($items as $item){
			
			if(preg_match('|dashboard|i', $item->id, $row))			
			{
				
				$new_items[]=$item;
				continue;
			}
			if(in_array($item->id,$listSelected))
			{
				
				$new_item=$item;

				if(isset($item->children))
				{
					
					$tt=$this->getSelected($item->children,$listSelected);
					
					unset($new_item->children);
					if($tt!=0)
						$new_item->children=$tt;
				}
				$new_items[]= $new_item;
			}			
		}
		if(isset($new_items))
			return $new_items;
		else
			return 0;
	}
	public function type($id = '') {
        if ($this->input->post() && !$this->input->is_ajax_request()) {
			if(isset($_POST["client_menu"]))
			$menu["aside_menu_active"]=$this->generate_menu("aside_menu_active",$_POST["client_menu"]);
			else
				$menu["aside_menu_active"]=array();
			$_POST["main_menu"]=json_encode($menu);
			unset($menu);
			if(isset($_POST["admin_menu"]))
				$menu["setup_menu_active"]=$this->generate_menu("setup_menu_active",$_POST["admin_menu"]);
			else
				$menu["setup_menu_active"]=array();
			$_POST["admin_menu"]=json_encode($menu);
			
				
			
            if ($id == '') {
				
					$this->db->insert('tblcompaniestypes', array("title" => $_POST["title"],"main_menu" => $_POST["main_menu"],"admin_menu" => $_POST["admin_menu"]) );
                     $id = $this->db->insert_id();
                    if ($id) {
                        set_alert('success', 'Company Type Added Successfully');
                        if (trim($this->input->post('action')) == 'save') {
                            redirect(admin_url('companies/type/'.$id));
                            exit;
                           }
                        if (trim($this->input->post('action')) == 'snew') {
                            redirect(admin_url('companies/type'));
                            exit;
                        }

                        if (trim($this->input->post('action')) == 'slist') {
                             redirect(admin_url('companies/types'));
                              exit;
                        }
                        
                    }
            } else {
                $this->db->where('id', $id)->update('tblcompaniestypes', array("title" => $_POST["title"],"main_menu" => $_POST["main_menu"],"admin_menu" => $_POST["admin_menu"]) );
  				
                
				set_alert('success', 'Company Type updated Successfully');
				if (trim($this->input->post('action')) == 'save') {
						redirect(admin_url('companies/type/'.$id));
						exit;
					   }
					if (trim($this->input->post('action')) == 'snew') {
						redirect(admin_url('companies/type'));
						exit;
					}

					if (trim($this->input->post('action')) == 'slist') {
						 redirect(admin_url('companies/types'));
						  exit;
					}
			}
                
           
        }
		
		
        if ($id == '') {
            $title = _l('add_new', 'Company Type');
        } else {     
           $this->db->select('id,title,main_menu,admin_menu ');
        	$this->db->from('tblcompaniestypes');
			$this->db->where('id', $id);
        
        	$type = $this->db->get()->row();
            
            
            $title = $type->title; 
			$data['company'] = $type;
        }
        
       
        $data['title'] = $title;
        $this->load->view('admin/companies/type', $data);
    }
    public function company($id = '') {
        if ($this->input->post() && !$this->input->is_ajax_request()) {
            if ($id == '') {
				
                    $id = $this->companies_model->add($this->input->post());
                    if ($id) {
                        set_alert('success', 'Company Added Successfully');
                        if (trim($this->input->post('action')) == 'save') {
                            redirect(admin_url('companies/company/'.$id));
                            exit;
                           }
                        if (trim($this->input->post('action')) == 'snew') {
                            redirect(admin_url('companies/company'));
                            exit;
                        }

                        if (trim($this->input->post('action')) == 'slist') {
                             redirect(admin_url('companies'));
                              exit;
                        }
                        
                    }
            } else {
                $success = $this->companies_model->update($this->input->post(), $id);
  
                if ($success) {
                  
                    set_alert('success', 'Company updated Successfully');
                    if (trim($this->input->post('action')) == 'save') {
                            redirect(admin_url('companies/company/'.$id));
                            exit;
                           }
                        if (trim($this->input->post('action')) == 'snew') {
                            redirect(admin_url('companies/company'));
                            exit;
                        }

                        if (trim($this->input->post('action')) == 'slist') {
                             redirect(admin_url('companies'));
                              exit;
                        }
                }
                
            }
        }

        if ($id == '') {
            $title = _l('add_new', 'Company');
        } else {     
           
            $company = $this->companies_model->get($id);
            
            
            $title = $company->name; 
        }
		$this->db->select('id,title ');
		$this->db->from('tblcompaniestypes');
		$data['compay_types']= $this->db->get()->result_array();
		
        $data['country'] = $this->companies_model->get_countries();
       $data['company'] = $company;
        $data['title'] = $title;
        $this->load->view('admin/companies/company', $data);
    }

   

    /* Delete item */
	public function delete_type($id) {
        if (!$id) {
            redirect(admin_url('companies/types'));
        }
		$this->db->query("delete from tblcompaniestypes where id='".$id."'");
       
        redirect(admin_url('companies/types'));
    }

    public function delete($id) {
        if (!$id) {
            redirect(admin_url('companies'));
        }

        $response = $this->companies_model->delete($id);
    	if ($response == true) {
            set_alert('success', "Company Deleted");
        } 
        redirect(admin_url('companies'));
    }
    public function change_company_status($id,$status){

		

		if($this->input->is_ajax_request()){
			$this->companies_model->change_company_status($id,$status);
		}
	}
   
    
}
