<?php



defined('BASEPATH') OR exit('No direct script access allowed');



class Clients extends Admin_controller {



    private $not_importable_clients_fields = array('userid', 'password', 'datecreated', 'last_ip', 'last_login', 'last_password_change', 'active', 'new_pass_key', 'new_pass_key_requested', 'leadid', 'default_currency');

    public $pdf_zip,$is_view=false;



    function __construct() {

        parent::__construct();

        $this->load->model('clients_model');

    }



    /* List all clients */



    public function index() {

		

		check_access("customers","");

        if ($this->input->is_ajax_request()) {



            $custom_fields = get_custom_fields('customers', array('show_on_table' => 1));



            $aColumns = array(

                            'first_name',

                            'phone_work',

                            'city',

                            'phone_mobile',

                            'phone_home',

                            'status',

                            'date_entered'
                        );
            $join = array();

            $i = 0;

            

            $sIndexColumn = "id";

            $sTable = 'sanetz_users';



            $where = array();



            if ($this->input->post('custom_view')) {

                $custom_view = $this->input->post('custom_view');

                // view by goups

                if (is_numeric($custom_view)) {

                    array_push($where, 'AND userid IN (SELECT customer_id FROM tblcustomergroups_in WHERE groupid = ' . $custom_view . ')');

                }

            } else if ($this->input->post('invoices_by_status')) {

                $status = $this->input->post('invoices_by_status');

                array_push($where, 'AND userid IN (SELECT clientid FROM tblinvoices WHERE status = ' . $status . ')');

            } else if ($this->input->post('quotes_by_status')) {

                $status = $this->input->post('quotes_by_status');

                array_push($where, 'AND userid IN (SELECT clientid FROM tblquotes WHERE status = ' . $status . ')');

            } else if ($this->input->post('contracts_by_type')) {

                $type = $this->input->post('contracts_by_type');

                array_push($where, 'AND userid IN (SELECT client FROM tblcontracts WHERE contract_type = ' . $type . ')');

            }



		

            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array('last_name','id'));

            $output = $result['output'];

            $rResult = $result['rResult'];

			
					
 			  foreach ($rResult as $aRow) {
				 $total_outstanding = 0;
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {

                 $_data = $aRow[ $aColumns[$i] ];


                    if ($aColumns[$i] == 'first_name') {
					
						$vehicles = $this->clients_model->get_vehicles_data($aRow['id']);
						$outstanding_amount=0;
						if(!empty($vehicles)){
						foreach($vehicles as $vehicles_data){
						$jobcards  =  $this->clients_model->get_vehiclejc($vehicles_data->id);
						if(!empty($jobcards)){
							foreach($jobcards as $jobcard_data){
							$totalamount=0;
						$jobcard_items =  $this->clients_model->get_jobcard_items($jobcard_data->id);
						foreach($jobcard_items as $jobcard_items_data){
						$totalamount+=  $jobcard_items_data->estimate_cost*$jobcard_items_data->qty;	
						}
						$payment = $this->clients_model->get_jobcard_payments($jobcard_data->id);
						if(!empty($payment)){
						foreach($payment as $payment_data){
						$sum_amount = $payment_data->amount+$payment_data->amount_1+$payment_data->amount_2;
						}
						$outstanding_amount += $totalamount - $sum_amount;
						}
						else{
							$outstanding_amount += $totalamount;
						}
						}
						}
						}
						}
						if($outstanding_amount != 0){
							$color = '#FF0000';
						}
						else{
							$color = '#000';
						}
   					$_data = '<a href="' . admin_url('clients/view/' . $aRow['id']) . '" target="_blank" style="color:'.$color.'">' . $aRow['first_name'].' '.$aRow['last_name']. '</a>';

                    }else if ($aColumns[$i] == 'phone_work') { 

                          $_data =  $_data;

                    }else if ($aColumns[$i] == 'city') {

                        $_data =  $_data;

                    } else if ($aColumns[$i] == 'phone_mobile') {

                        $total_vehicles = $this->clients_model->countrow($aRow['id']);

						$_data = $total_vehicles;

					} else if ($aColumns[$i] == 'phone_home') {
						
						$_data = '<div style="color:'.$color.'">'.$outstanding_amount.'<div>';
					
					}else if ($aColumns[$i] == 'status'){

                       $_data = $_data;

                 	}else if ($aColumns[$i] == 'date_entered'){

                       $_data = $_data;

                    }

                      $row[] = $_data;

                }

                $result = $this->clients_model->get_current_period();

                $fromdate = date('Y-m-01');

                $todate = date('Y-m-t');

				$options="";

				

				

				if(check_access("customers","edit",false))

                $options .= icon_btn('admin/clients/client/' . $aRow['id'], 'pencil-square-o','',array('data-toggle' => 'tooltip', 'title' =>'Edit Customer'));

	   			if(check_access("customers","view",false))

                $options .= icon_btn('admin/clients/view/' . $aRow['id'], 'eye','',array('data-toggle' => 'tooltip', 'title' =>'View Customer','target' => '_blank'));

	   

				if(check_access("customers","delete",false))

                $options .= icon_btn('admin/clients/delete/' . $aRow['id'], 'remove', ' btn-delete-customer', array('data-toggle' => 'tooltip', 'title' => _l('client_delete_tooltip')));

				

				

				$row[] = $options;

                $output['aaData'][] = $row;

            }



            echo json_encode($output);

            die();

        }

		
        $this->load->model('contracts_model');

        $data['contract_types'] = $this->contracts_model->get_contract_types();

        $data['groups'] = $this->clients_model->get_groups();

        $data['title'] = _l('clients');
		
        $this->load->view('admin/clients/manage', $data);exit;

		

    }

	 public function list_vehicles($customerid = false, $a='')

    {
		if($a == ''){
		$col = 'vehiclemodelyear.make';	
		}else{
		$col = 'vehicles.date_entered';	
		}
			$aColumns = array(
                $col,
				'engines_id',
				
            );



            $join = array(
						'LEFT JOIN engines ON engines.id = vehicles.engines_id',
						'LEFT JOIN vehiclemodelyear ON vehiclemodelyear.id = engines.vehiclemodelyear',
            );

            $where = array();

            if(($customerid)){

                array_push($where,'AND vehicles.users_id="'.$customerid.'"');
            }

            $sIndexColumn = "id";

            $sTable       = 'vehicles';
			if($a != ''){ 
			  $order = 'ORDER BY DATE(vehicles.date_entered) DESC,`vehiclemodelyear`.`make` ASC,`vehiclemodelyear`.`model` ASC,`vehiclemodelyear`.`year` ASC'; 
			}else{
				  $order = 'ORDER BY `vehiclemodelyear`.`make` ASC,`vehiclemodelyear`.`model` ASC,`vehiclemodelyear`.`year` ASC,`vehicles`.`registration_number` ASC';
				 }
			

            $result       = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array(

			'vehiclemodelyear.model','registration_number','vehicles.id','users_id', 'vehicles.date_entered'

            ), $order);
			

            $output       = $result['output'];

            $rResult      = $result['rResult'];


            foreach ($rResult as $aRow) {
				

                $row = array();

                for ($i = 1; $i < count($aColumns); $i++) {

                     $_data = $aRow[$aColumns[$i]];
					
                    if ($aColumns[$i] == 'engines_id') {

						if(!empty($aRow['engines_id'])){

						$engines_data =  $this->clients_model->get_where_single_tbl('engines', 'id', $aRow['engines_id']);

						$make_model_year_data  =  $this->clients_model->get_where_single_tbl('vehiclemodelyear', 'id', $engines_data->vehiclemodelyear);

						//echo '<br>'. site_url('uploads/make_img/'.$make_model_year_data->image_make);

						

				if(!empty($make_model_year_data->image_make) || file_exists (site_url('uploads/make_img/'.$make_model_year_data->image_make))){

						

						$image = $make_model_year_data->image_make;	

						

						}

						else{

							$image = 'noimage.png';

						}
	$engine = ' <img class="img-rounded"  src="'.site_url('uploads/make_img/'.$image).'" height="100px" " width="100px" ">'.' '.'' .'<strong style="font-size:18px;">'. $make_model_year_data->make .'&nbsp;&nbsp;'.$make_model_year_data->model .'</strong>'.'&nbsp;&nbsp; '.'<strong style="background:#F3565D;color:white; padding:5px; border-radius:5px; font-size: 16px; font-weight: 700!important;">' .$aRow['registration_number'] .'</strong>' .'<br><br>' .$make_model_year_data->year  .'<br><span onmouseover="tooltipfunc()" class="popovers" data-container="body" data-trigger="hover" data-placement="top" data-content=" '.$engines_data->type.' <br> '.$engines_data->cc.'CC | '.$engines_data->kw.'KW | '.$engines_data->ps.'PS | '.$engines_data->hp.'HP | '.$engines_data->nm.'NM | '.$engines_data->cylinders.'CYL | '.$engines_data->fuel.' <br> '.$engines_data->engine_code.'" data-original-title="Engine Details">' .$engines_data->type .' '.$engines_data->fuel.'</span>'. '<a href="'.site_url('admin/vehicles/vehicles/'.$customerid.'/'.$aRow['id']).'" class="btn btn-small" target="_blank" style="padding: 6px 8px !important;"><i class="fa fa-pencil-square-o"></i></a>'.'<a href="'.site_url('admin/jobcard/jobcard/'.$aRow['id']).'"class="btn btn-small" target="_blank" style="padding: 6px 8px !important;"><i class="fa fa-plus"></i></a>';
						}else{

								$engine = '-';

							

							}

						

                         $_data = $engine;
						 

                    }         
					
                    $row[] = $_data;
					

                }
				$options ='';

						$jobcards  =  $this->clients_model->get_vehiclejc($aRow['id']);
						$hrlooper = 0;
						$len = count($jobcards);
						
						if(!empty($jobcards)){
				foreach($jobcards as $jobcard_data){
					
					$totalamount=0;
					$outstanding_amount=0;	
					$vat_amount=0;	
						$jobcard_items =  $this->clients_model->get_jobcard_items($jobcard_data->id);
						//print_r($jobcard_items);
						foreach($jobcard_items as $jobcard_items_data){
						$totalamount+=  $jobcard_items_data->estimate_cost*$jobcard_items_data->qty;
							
						}
							if($jobcard_data->vat>0 )
							{    
							   $vat_amount = ($totalamount*19)/100;
							   $totalamount = $totalamount+$vat_amount;
							}
							
						
						$payment = $this->clients_model->get_jobcard_payments($jobcard_data->id);
						if(!empty($payment)){
						foreach($payment as $payment_data){
						$sum_amount = $payment_data->amount+$payment_data->amount_1+$payment_data->amount_2;
						
						//print_r($outstanding_amount);
						}
						$outstanding_amount += $totalamount - $sum_amount;
						

						}else{
							
							$outstanding_amount += $totalamount;
						}
						
						
						if($outstanding_amount == 0){
							$color = "#45B6AF";
						}elseif($outstanding_amount < $totalamount){
							$color = "#dfba49";
						}elseif($outstanding_amount == $totalamount){
							$color = "#FF0000";
						}
												
				$options .= '<a href="'.site_url('admin/jobcard/show_invoice/'.$jobcard_data->id).'" class="btn btn-icon" target="_blank"><i class="fa fa-print"></i></a>';
				/*icon_btn('admin/jobcard/show_invoice/'.$jobcard_data->id,'print','',array('data-target' => '#sanet-print-jobcard','data-toggle' => 'modal', 'title' =>'Print Invoice'));*/
				$options .= icon_btn('admin/jobcard/jobcard/'.$customerid.'/'.$jobcard_data->id , 'pencil-square-o','',array('data-toggle' => 'tooltip', 'title' =>'Edit Jobcard','target' => '_blank'));
				$options .='<a href="../show_partial_payment/'.$jobcard_data->id.'/'.$jobcard_data->jobcard_number.'/'.$totalamount.'" data-toggle="modal" data-target="#client_partial_payments"  class="btn btn-danger pull-right"><i class="fa fa-money"></i></a>';
				
 $options .= icon_btn('admin/clients/jc_delete/'.$jobcard_data->id.'/'.$customerid,'remove','',array('data-toggle'=>'tooltip','title'=>('Delete jobcard')));
				 if($jobcard['jc_status'] == '5'){

							$status = 'Unconfirmed';	
								$jc_color = '#0087E0';

							}elseif($jobcard_data->jc_status == '10'){

								$status = 'Vehicle in shop';
								$jc_color = '#0087E0';

							}elseif($jobcard_data->jc_status == '20'){

								$status = 'Inspection in progress';
								$jc_color = '#0087E0';

							}elseif($jobcard_data->jc_status == '30'){

								$status = 'Waiting for confirmation';
								$jc_color = '#0087E0';
							}elseif($jobcard_data->jc_status == '40'){

								$status = 'Waiting for parts';
								$jc_color = '#0087E0';

							}elseif($jobcard_data->jc_status == '50'){

								$status = 'Repair and installation';
								$jc_color = '#0087E0';

							}elseif($jobcard_data->jc_status == '60'){

								$status = 'Vehicle ready';
								$jc_color = '#0087E0';

							}elseif($jobcard_data->jc_status == '99'){

								$status = 'Vehicle delivered - outstanding payment';
								$jc_color = '#0087E0';

							}elseif($jobcard_data->jc_status == '100'){
								$jc_color = '#45B6AF';
								$status = 'Vehicle delivered and paid';

							}
							
					 $options .= '<span style="font-size:13px">'.DateTime::createFromFormat("Y-m-d H:i:s", $jobcard_data->appointment_date)->format("d/m/Y").'&nbsp;>>&nbsp;'.$jobcard_data->mileage_out.'&nbsp;>>&nbsp;'.$jobcard_data->description_cust.'</span>';
				
				
				
     if ($hrlooper != $len - 1) {
        $hr = '<hr style="border-color: #ccc !important; margin: 0px 0px 2px 0px; !important;">';
    }else{
		$hr = '';
	}
		
	
				
				 $options .= '<span class="" style=" font-size: 13px!important; border-radius: 12px !important;color: '.$color.'; float:right;width: 70px; margin-left: 5px; margin-right: 10px; margin-top: 5px;">€ '.number_format($outstanding_amount,2) .'</span>&nbsp;<span class="" style=" font-size: 13px!important;border-radius: 12px !important;color: #0760A2;float:right;width: 70px; margin-left: 5px; margin-right: 10px; margin-top: 5px;">€ '.number_format($totalamount,2).'</span>&nbsp;<span onmouseover="tooltipfunc()"  data-container="body" data-placement="top" data-original-title="Status" class="badge badge-primary popovers" data-trigger="hover" data-content="'.$status.'" style="height: 18px;background-color:'.$jc_color.'; border-radius: 100%;display: inline-block;float:right;width: 20px; margin-left: 5px; margin-top: 5px;"></span>'.$hr.'';
			$hrlooper++;	
			}
						}
			$row[]  = $options;
				$output['aaData'][] = $row;

            }


        echo json_encode($output);

            die();

    }

	
   
   	public function show_partial_payment($jobcardid,$jobcardnumber,$totalamount){
		
		$data['jobcardid'] = $jobcardid;
		$data['jobcardnumber'] = $jobcardnumber;
		$data['total'] = $totalamount;
	    $payments = $this->clients_model->get_jobcard_payments($jobcardid);
	    $data['payment']     = $payments;

        $this->load->view('admin/clients/modals/partial_payments', $data);

    }
// function to get all jobcard status and calculate total amount 
	public function get_jobcard_status(){
		// get all jobcard status from table jobcards
	    $jobcard_status = $this->clients_model->get_jobcard_status();
		// if jobcard status is active
		if(!empty($jobcard_status)){
			//get all jobcard data by status 
				foreach($jobcard_status as $jobcard_data){
					$totalamount=0; //set total amont 0 for each jobcard total amount 
					$jobcard_items =  $this->clients_model->get_jobcard_items($jobcard_data->id);
					// get all jobcard item by jobcard id and calculate total amount of each jobcard
				foreach($jobcard_items as $jobcard_items_data){
					//calculate total amount for each jobcard
					$totalamount+=  $jobcard_items_data->estimate_cost*$jobcard_items_data->qty;
						}	//add total amount in payments tables
					$success = $this->clients_model->add_payment_jobcard_status($totalamount,$jobcard_data->id,					 								 					$jobcard_data->jobcard_number);
				}
		}
    }
	
	public function partial(){
		
        if ($this->input->post()) {
            $data = $this->input->post();
			//print_r($data);
            if ($data['id'] == '') {
                $message = '';
                $success = $this->clients_model->add_payment($data);
                if($success) {
                    $message = _l('added_successfuly','Partial Payment');
                }
                echo json_encode(array(
                    'success' => $success,
                    'message'=>$message
                ));
            } else {
                $message = '';
                $success = $this->clients_model->update_payment($this->input->post(), $data['id']);
                if($success){
                    $message = _l('updated_successfuly','Partial Payment');
                }
                echo json_encode(array(
                    'success' => $success,
                    'message'=>$message
                ));
            }
        }
    }

    /* Edit client or add new client */

	 public function view($id = '', $a= '') {
	
		 $this->is_view=true;

		 if ($id == '')

        	check_access("customers","view");

		$client = $this->clients_model->get($id);
		
		if (!$client) {

			blank_page('Client Not Found');

		}

		$data['client'] = $client;

		$title = $client->firstname;
		
		$data['total_vehicles'] = $this->clients_model->countrow($client->id);
		$vehicles = $this->clients_model->get_vehicles_data($client->id);
	
		if(!empty($vehicles)){
		foreach($vehicles as $vehicles_data){
		$jobcards  =  $this->clients_model->get_vehiclejc($vehicles_data->id);
					
						if(!empty($jobcards)){
						foreach($jobcards as $jobcard_data){
						$vat_amount=0;
						$total_outstanding = 0;
						$totalamount=0;	
						$jobcard_items =  $this->clients_model->get_jobcard_items($jobcard_data->id);
						foreach($jobcard_items as $jobcard_items_data){
						$totalamount +=  $jobcard_items_data->estimate_cost*$jobcard_items_data->qty;
						//print_r($totalamount);
						}
						if($jobcard_data->vat>0 )
							{    
							   $vat_amount = ($totalamount*19)/100;
							   $totalamount = $totalamount+$vat_amount;
							}
						$payment = $this->clients_model->get_jobcard_payments($jobcard_data->id);
						if(!empty($payment)){
						foreach($payment as $payment_data){
						$sum_amount += $payment_data->amount+$payment_data->amount_1+$payment_data->amount_2;
						
						}
						
						}
						$total += $totalamount;
						$outstanding_amount = $total-$sum_amount;
						}
						
						$data['total'] = $total;
						
						
						}
						
						//print_r($total_outstanding);							
						$data['total_outstanding'] = $outstanding_amount;
						
					}
				}	

        $data['title'] = $title;
		
        $data['average'] = $data['total']/$data['total_vehicles'];

		$data['is_view'] = $this->is_view;
		
		$data['latest'] = $a;
		
		/*$this->load->model('vehicles_model');

		$data['vehicle_char']=$this->vehicles_model->getvehicles_char();

		$this->load->model('engines_model');

		$data['engines']=$this->engines_model->get();*/

		if( $this->is_view)

			$this->load->view('admin/clients/view', $data);

		else

        	$this->load->view('admin/clients/client', $data);

	 }

	

    public function client($id = '') {

		if ($id == '')

        	check_access("customers","add");

		else

			check_access("customers","edit");

		

        if ($this->input->post() && !$this->input->is_ajax_request()) {

			



           

				 

            if ($id == '') {

                $id = $this->clients_model->add($this->input->post());
				set_alert('success', _l('added_successfuly', _l('client')));
				if (trim($this->input->post('action')) == 'save') {
                           redirect(admin_url('clients/client/'.$id));
							 //redirect(admin_url('make'));

                            exit;
                           }
				if (trim($this->input->post('action')) == 'snew') {
                            redirect(admin_url('clients/client/'.$id));
                            exit;
                        }

                        if (trim($this->input->post('action')) == 'slist') {
                             redirect(admin_url('clients'));
                              exit;
                        }		   
                if ($id) {
                        redirect(admin_url('clients/view'.$id));

                        exit;
                }

            } else {
                
  				if (trim($this->input->post('action')) == 'save') {
                            $success = $this->clients_model->update($this->input->post(), $id);
							
                           }
						   else if (trim($this->input->post('action')) == 'snew') {
                            $success = $this->clients_model->add($this->input->post());
                        }
                if ($success) {
                  
                    set_alert('success', _l('client_updated_successfully', _l('make_updated')));
                    if (trim($this->input->post('action')) == 'save') {
                            redirect(admin_url('clients/client/'.$id));
                            exit;
                           }
                        if (trim($this->input->post('action')) == 'snew') {
							$id = $success;
                            redirect(admin_url('clients/client/'.$id));
                            exit;
                        }

                        if (trim($this->input->post('action')) == 'slist') {
                             redirect(admin_url('clients'));
                              exit;
                        }
                }
                
            }

        

		}



        if ($id == '') {

            $title = _l('add_new', _l('client_lowercase'));

        } else {

			//echo $id;

            $client = $this->clients_model->get($id);

           // $data['prev_client'] = $this->clients_model->get_prev($id);

           // $data['next'] = $this->clients_model->get_next($id);

        

            if (!$client) {

                blank_page('Client Not Found');

            }

           

            $data['client'] = $client;

            $title = $client->first_name;

            

        }

		//print_r($data);

       	

        $data['clients'] = $this->clients_model->get();

        $data['prev'] = $this->clients_model->get_prev_groups2();

        $data['title'] = $title;

		$data['is_view'] = $this->is_view;

		

		

		if( $this->is_view)

			$this->load->view('admin/clients/views', $data);

		else

        	$this->load->view('admin/clients/client', $data);

    }



    public function get_warehouse_item($id,$suppliersku)

    {

        $item = $this->clients_model->get_warehouse_item($id,$suppliersku);

        echo $item->qty;

        

    }



    public function get_attachments($id) {

        $data['clientid'] = $id;

        $data['attachments'] = $this->clients_model->get_all_customer_attachments($id);

        $this->load->view('admin/clients/attachments_template', $data);

    }

    public function filldata(){

      echo json_encode($this->clients_model->filldata($this->input->post('id')));

    }



    /* Since version 1.0.2 add client reminder */



    public function add_client_reminder($id) {

         



        if ($this->input->post()) {

            $success = $this->clients_model->add_reminder($this->input->post(), $id);

            if ($success) {

                set_alert('success', _l('client_reminder_added_successfuly'));

            }

        }



        redirect(admin_url('clients/client/' . $id));

    }



    public function upload_attachment($id) {

        handle_client_attachments_upload($id);

    }



    public function delete_attachment($id) {

        echo json_encode(array('success' => $this->clients_model->delete_attachment($id)));

    }



    /* Delete Contact */



    function deletecontact() {

        $id = $_REQUEST['id'];

        $res = $this->clients_model->DeleteContacts($id);

        if ($res == '1') {

            set_alert('success', _l('client_contact_delete_success_action', _l('client')));

        } else {

            set_alert('success', _l('client_contact_delete_error_action', _l('client')));

        }

        echo $res;

    }



    /* Delete client */



    public function delete($id) {



        check_access("customers","delete");



        if (!$id) {

            redirect(admin_url('clients'));

        }



        $response = $this->clients_model->delete($id);



        if (is_array($response) && isset($response['referenced'])) {

            set_alert('warning', _l('is_referenced', _l('client_lowercase')));

        } else if ($response == true) {

            set_alert('success', _l('deleted', _l('client')));

        } else {

            set_alert('warning', _l('problem_deleting', _l('client_lowercase')));

        }



        redirect(admin_url('clients'));

    }

	
	public function jc_delete($id,$clientid)

    {

		$this->load->model('jobcard_model');
        $success = $this->jobcard_model->delete($id);

        if ($success) {

           set_alert('success', _l('deleted',_l('jobcard')));

        } else {

            set_alert('warning', _l('problem_deleting',_l('jobcard_lowercase')));

        }



        redirect(admin_url('clients/view/'.$clientid));

    }

    /* Staff can login as client */

public function getclass(){

   

   echo  json_encode($this->clients_model->getclass());

}

    public function login_as_client($id) {

        $this->clients_model->login_as_client($id);

    }



    public function get_customer_default_currency($id) {

        echo json_encode($this->clients_model->get_customer_default_currency($id));

    }



    public function get_customer_billing_and_shipping_details($id) {

        echo json_encode($this->clients_model->get_customer_billing_and_shipping_details($id));

    }



    public function get_customer_shipping_details($id) {

        echo json_encode($this->clients_model->get_customer_shipping_details($id));

    }



    /* Change client status / active / inactive */



    public function change_client_status($id, $status) {



         



        if ($this->input->is_ajax_request()) {

            $this->clients_model->change_client_status($id, $status);

        }

    }



    /* Get client by id - used in ajax request */



    public function get_client_by_id_ajax($id) {

        if ($this->input->is_ajax_request()) {

            if (!$id) {

                redirect(admin_url('clients'));

            }

            if ($this->input->is_ajax_request()) {

                echo json_encode($this->clients_model->get($id));

            }

        }

    }



    /* Since version 1.0.2 zip client invoices */



    public function zip_invoices($id) {

        if (!has_permission('manageClients') || !has_permission('manageSales')) {

            access_denied('manageClients');

        }

        if ($this->input->post()) {





            $status = $this->input->post('invoice_zip_status');

            $zip_file_name = $this->input->post('file_name');



            if ($this->input->post('zip-to') && $this->input->post('zip-from')) {

                $from_date = to_sql_date($this->input->post('zip-from'));

                $to_date = to_sql_date($this->input->post('zip-to'));



                if ($from_date == $to_date) {

                    $this->db->where('date', $from_date);

                } else {

                    $this->db->where('date BETWEEN "' . $from_date . '" AND "' . $to_date . '"');

                }

            }



            $this->db->select('id');

            $this->db->from('tblinvoices');

            if ($status != 'all') {

                $this->db->where('status', $status);

            }

            $this->db->where('clientid', $id);

            $this->db->order_by('date', 'desc');

            $invoices = $this->db->get()->result_array();



            $this->load->model('invoices_model');

            $this->load->helper('file');



            if (!is_really_writable(TEMP_FOLDER)) {

                show_error('/temp folder is not writable. You need to change the permissions to 777');

            }



            $dir = TEMP_FOLDER . $zip_file_name;

            if (is_dir($dir)) {

                delete_dir($dir);

            }



            if (count($invoices) == 0) {

                set_alert('warning', _l('client_zip_no_data_found', _l('invoices')));

                redirect(admin_url('clients/client/' . $id));

            }



            mkdir($dir, 0777);



            foreach ($invoices as $invoice) {

                $invoice_data = $this->invoices_model->get($invoice['id']);

                $this->pdf_zip = invoice_pdf($invoice_data);

                $_temp_file_name = slug_it(format_invoice_number($invoice_data->id));

                $file_name = $dir . '/' . strtoupper($_temp_file_name);



                $this->pdf_zip->Output($file_name . '.pdf', 'F');

            }



            $this->load->library('zip');

            // Read the invoices

            $this->zip->read_dir($dir, false);

            // Delete the temp directory for the client

            delete_dir($dir);



            $this->zip->download(slug_it(get_option('companyname')) . '-invoices-' . $zip_file_name . '.zip');

            $this->zip->clear_data();

        }

    }



    /* Since version 1.0.2 zip client invoices */



    public function zip_quotes($id) {

        if (!has_permission('manageClients') || !has_permission('manageSales')) {

            access_denied('manageClients');

        }

        if ($this->input->post()) {



            $status = $this->input->post('quote_zip_status');

            $zip_file_name = $this->input->post('file_name');



            if ($this->input->post('zip-to') && $this->input->post('zip-from')) {

                $from_date = to_sql_date($this->input->post('zip-from'));

                $to_date = to_sql_date($this->input->post('zip-to'));



                if ($from_date == $to_date) {

                    $this->db->where('date', $from_date);

                } else {

                    $this->db->where('date BETWEEN "' . $from_date . '" AND "' . $to_date . '"');

                }

            }



            $this->db->select('id');

            $this->db->from('tblquotes');



            if ($status != 'all') {

                $this->db->where('status', $status);

            }

            $this->db->where('clientid', $id);

            $this->db->order_by('date', 'desc');

            $quotes = $this->db->get()->result_array();



            $this->load->helper('file');



            if (!is_really_writable(TEMP_FOLDER)) {

                show_error('/temp folder is not writable. You need to change the permissions to 777');

            }



            $this->load->model('quotes_model');

            $dir = TEMP_FOLDER . $zip_file_name;



            if (is_dir($dir)) {

                delete_dir($dir);

            }



            if (count($quotes) == 0) {

                set_alert('warning', _l('client_zip_no_data_found', _l('quotes')));

                redirect(admin_url('clients/client/' . $id));

            }



            mkdir($dir, 0777);



            foreach ($quotes as $quote) {

                $quote_data = $this->quotes_model->get($quote['id']);

                $this->pdf_zip = quote_pdf($quote_data);

                $_temp_file_name = slug_it(format_quote_number($quote_data->id));

                $file_name = $dir . '/' . strtoupper($_temp_file_name);

                $this->pdf_zip->Output($file_name . '.pdf', 'F');

            }



            $this->load->library('zip');

            // Read the invoices

            $this->zip->read_dir($dir, false);

            // Delete the temp directory for the client

            delete_dir($dir);

            $this->zip->download(slug_it(get_option('companyname')) . '-quotes-' . $zip_file_name . '.zip');

            $this->zip->clear_data();

        }

    }



    public function zip_payments($id) {



        if (!$id) {

            die('No user id');

        }



        if (!has_permission('manageClients') || !has_permission('manageSales')) {

            access_denied('manageClients');

        }



        if ($this->input->post('zip-to') && $this->input->post('zip-from')) {

            $from_date = to_sql_date($this->input->post('zip-from'));

            $to_date = to_sql_date($this->input->post('zip-to'));



            if ($from_date == $to_date) {

                $this->db->where('date', $from_date);

            } else {

                $this->db->where('date BETWEEN "' . $from_date . '" AND "' . $to_date . '"');

            }

        }



        $this->db->select('tblinvoicepaymentrecords.id as paymentid');

        $this->db->from('tblinvoicepaymentrecords');

        $this->db->where('tblclients.userid', $id);

        $this->db->join('tblinvoices', 'tblinvoices.id = tblinvoicepaymentrecords.invoiceid', 'left');

        $this->db->join('tblclients', 'tblclients.userid = tblinvoices.clientid', 'left');



        if ($this->input->post('paymentmode')) {

            $this->db->where('paymentmode', $this->input->post('paymentmode'));

        }

        $payments = $this->db->get()->result_array();



        $zip_file_name = $this->input->post('file_name');



        $this->load->helper('file');



        if (!is_really_writable(TEMP_FOLDER)) {

            show_error('/temp folder is not writable. You need to change the permissions to 777');

        }



        $dir = TEMP_FOLDER . $zip_file_name;

        if (is_dir($dir)) {

            delete_dir($dir);

        }

        if (count($payments) == 0) {

            set_alert('warning', _l('client_zip_no_data_found', _l('payments')));

            redirect(admin_url('clients/client/' . $id));

        }



        mkdir($dir, 0777);



        $this->load->model('payments_model');

        $this->load->model('invoices_model');

        foreach ($payments as $payment) {

            $payment_data = $this->payments_model->get($payment['paymentid']);

            $payment_data->invoice_data = $this->invoices_model->get($payment_data->invoiceid);

            $this->pdf_zip = payment_pdf($payment_data);

            $file_name = $dir;

            $file_name .= '/' . strtoupper(_l('payment'));

            $file_name .= '-' . strtoupper($payment_data->paymentid) . '.pdf';

            $this->pdf_zip->Output($file_name, 'F');

        }



        $this->load->library('zip');

        // Read the invoices

        $this->zip->read_dir($dir, false);

        // Delete the temp directory for the client

        delete_dir($dir);

        $this->zip->download(slug_it(get_option('companyname')) . '-payments-' . $zip_file_name . '.zip');

        $this->zip->clear_data();

    }



    public function import() {



        $simulate_data = array();

        $total_imported = 0;

        if ($this->input->post()) {

            if (isset($_FILES['file_csv']['name']) && $_FILES['file_csv']['name'] != '') {

                // Get the temp file path

                $tmpFilePath = $_FILES['file_csv']['tmp_name'];

                // Make sure we have a filepath

                if (!empty($tmpFilePath) && $tmpFilePath != '') {

                    // Setup our new file path

                    $newFilePath = TEMP_FOLDER . $_FILES['file_csv']['name'];

                    if (!file_exists(TEMP_FOLDER)) {

                        mkdir(TEMP_FOLDER, 777);

                    }

                    if (move_uploaded_file($tmpFilePath, $newFilePath)) {



                        $import_result = true;

                        $fd = fopen($newFilePath, 'r');

                        $rows = array();

                        while ($row = fgetcsv($fd)) {

                            $rows[] = $row;

                        }



                        fclose($fd);

                        if (count($rows) <= 1) {

                            set_alert('warning', 'Not enought rows for importing');

                            redirect(admin_url('clients/import'));

                        }

                        unset($rows[0]);

                        if ($this->input->post('simulate')) {

                            if (count($rows) > 500) {

                                set_alert('warning', 'Recommended splitting the CSV file into smaller files. Our recomendation is 500 row, your CSV file has ' . count($rows));

                            }

                        }

                        $db_temp_fields = $this->db->list_fields('tblclients');

                        $db_fields = array();

                        foreach ($db_temp_fields as $field) {

                            if (in_array($field, $this->not_importable_clients_fields)) {

                                continue;

                            }

                            $db_fields[] = $field;

                        }



                        $custom_fields = get_custom_fields('customers');

                        $_row_simulate = 0;



                        $required = array('firstname', 'lastname', 'email');



                        foreach ($rows as $row) {

                            // do for db fields

                            $insert = array();

                            $duplicate = false;

                            for ($i = 0; $i < count($db_fields); $i++) {

                                if (!isset($row[$i])) {

                                    continue;

                                }



                                if ($db_fields[$i] == 'email') {

                                    $email_exists = total_rows('tblclients', array('email' => $row[$i]));

                                    // dont insert duplicate emails

                                    if ($email_exists > 0) {

                                        $duplicate = true;

                                    }

                                }

                                // Avoid errors on required fields;

                                if (in_array($db_fields[$i], $required) && $row[$i] == '') {

                                    $row[$i] = '/';

                                } else if ($db_fields[$i] == 'country') {

                                    if ($row[$i] != '') {

                                        $this->db->where('iso2', $row[$i]);

                                        $this->db->or_where('short_name', $row[$i]);

                                        $this->db->or_where('long_name', $row[$i]);

                                        $country = $this->db->get('tblcountries')->row();

                                        if ($country) {

                                            $row[$i] = $country->country_id;

                                        } else {

                                            $row[$i] = 0;

                                        }

                                    } else {

                                        $row[$i] = 0;

                                    }

                                }



                                $insert[$db_fields[$i]] = $row[$i];

                            }

                            if ($duplicate == true) {

                                continue;

                            }

                            if (count($insert) > 0) {

                                $total_imported++;

                                $insert['datecreated'] = date('Y-m-d H:i:s');

                                if ($this->input->post('default_pass_all')) {

                                    $this->load->helper('phpass');

                                    $hasher = new PasswordHash(PHPASS_HASH_STRENGTH, PHPASS_HASH_PORTABLE);

                                    $data['password'] = $hasher->HashPassword($this->input->post('default_pass_all'));

                                }



                                if (!$this->input->post('simulate')) {

                                    $this->db->insert('tblclients', $insert);

                                    $clientid = $this->db->insert_id();

                                    if ($clientid) {

                                        if ($this->input->post('groups_in[]')) {

                                            $groups_in = $this->input->post('groups_in[]');

                                            foreach ($groups_in as $group) {

                                                $this->db->insert('tblcustomergroups_in', array(

                                                    'customer_id' => $clientid,

                                                    'groupid' => $group

                                                ));

                                            }

                                        }

                                    }

                                } else {

                                    $simulate_data[$_row_simulate] = $insert;

                                    $clientid = true;

                                }

                                if ($clientid) {

                                    $insert = array();

                                    foreach ($custom_fields as $field) {

                                        if (!$this->input->post('simulate')) {

                                            if ($row[$i] == '') {

                                                continue;

                                            }

                                            $this->db->insert('tblcustomfieldsvalues', array(

                                                'relid' => $clientid,

                                                'fieldid' => $field['id'],

                                                'value' => $row[$i],

                                                'fieldto' => 'customers'

                                            ));

                                        } else {

                                            $simulate_data[$_row_simulate][$field['name']] = $row[$i];

                                        }

                                        $i++;

                                    }

                                }

                            }

                            $_row_simulate++;

                            if ($this->input->post('simulate') && $_row_simulate >= 100) {

                                break;

                            }

                        }

                        unlink($newFilePath);

                    }

                } else {

                    set_alert('warning', _l('import_upload_failed'));

                }

            }

        }

        if (count($simulate_data) > 0) {

            $data['simulate'] = $simulate_data;

        }

        if (isset($import_result)) {

            set_alert('success', _l('import_total_imported', $total_imported));

        }



        $data['groups'] = $this->clients_model->get_groups();

        $data['not_importable'] = $this->not_importable_clients_fields;

        $data['title'] = 'Import';

        $this->load->view('admin/clients/import', $data);

    }



    public function groups() {

        if ($this->input->is_ajax_request()) {

            $aColumns = array('name','class_is_active');



            $sIndexColumn = "id";

            $sTable = 'tblcustomersgroups';



            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, array(), array(), array('id'));

            $output = $result['output'];

            $rResult = $result['rResult'];



            foreach ($rResult as $aRow) {

                $row = array();

                for ($i = 0; $i < count($aColumns); $i++) {

                    $_data = $aRow[$aColumns[$i]];

                    if ($aColumns[$i] == 'class_is_active') {

                        if ($aRow['class_is_active'] == '0') {

                            $_data = '<input class="ischeckbox"  data-rowid="' . $aRow['id'] . '" value="' . $aRow['class_is_active'] . '" type="checkbox"/>';

                        } else {

                            $_data = '<input class="ischeckbox"  data-rowid="' . $aRow['id'] . '" checked="checked" value="' . $aRow['class_is_active'] . '" type="checkbox"/>';

                        }

                    }

                    $row[] = $_data;

                }

                $options = icon_btn('#', 'pencil-square-o', 'btn-default', array('data-toggle' => 'modal', 'data-target' => '#customer_group_modal', 'data-id' => $aRow['id']));

                $row[] = $options .= icon_btn('admin/clients/delete_group/' . $aRow['id'], 'remove', '');



                $output['aaData'][] = $row;

            }



            echo json_encode($output);

            die();

        }



        $this->load->model('settings_model');

        $default_options = $this->settings_model->getOptions();

        // $data['default_options'] = $default_options;

        

        $data['option'] = $default_options['account_receivable'];





         $this->load->model('staff_model');

         $data['clients'] = $this->clients_model->get();

         $data['staff'] = $this->staff_model->get('', 1);

         $data['prev'] = $this->clients_model->get_prev_groups2();



        





         $data['ledgers'] = $this->clients_model->get_ledgers();

         $this->load->model('currencies_model');

         $data['currencies'] = $this->currencies_model->get();



        // $this->load->model('settings_model');

        // $default_options = $this->settings_model->getOptions();

        // $data['default_options'] = $default_options;





        

         $data['title'] = _l('customer_groups');

         $this->load->view('admin/clients/groups_manage', $data);

    }

    public function changestatus() {

        echo $this->clients_model->changestatus();

    }

    public function group() {

        // if ($this->input->is_ajax_request()) {

            $data = $this->input->post();

			// print_r($data);

   //          die;

            if ($data['id'] == '') {

                $success = $this->clients_model->add_group($data);

                $message = '';

                if ($success == true) {

                    $message = _l('added_successfuly', _l('customer_group'));

                    set_alert('success', _l('added_successfuly', _l('customer_group')));

                }

                // echo json_encode(array('success' => $success, 'message' => $message));

            } else {

				

                $success = $this->clients_model->edit_group($data);

                $message = '';

                if ($success == true) {

                    $message = _l('updated_successfuly', _l('customer_group'));

                    set_alert('success', _l('updated_successfuly', _l('customer_group')));

                }

                // echo json_encode(array('success' => $success, 'message' => $message));

            }



            redirect(admin_url('clients/groups'));

        // }

    }



     public function add_update_group() {

        if ($this->input->is_ajax_request()) {

            $data = $this->input->post();

            

            if ($data['id'] == '') {

                $success = $this->clients_model->add_group($data);

                $message = '';

                if ($success == true) {

                    $message = _l('added_successfuly', _l('customer_group'));

                }

                echo json_encode(array('success' => $success, 'message' => $message));

            } else {

                

                $success = $this->clients_model->edit_group($data);

                $message = '';

                if ($success == true) {

                    $message = _l('updated_successfuly', _l('customer_group'));

                }

                echo json_encode(array('success' => $success, 'message' => $message));

            }

        }

    }



    public function delete_group($id) {



        if (!$id) {

            redirect(admin_url('clients/groups'));

        }



        $response = $this->clients_model->delete_group($id);

        if (is_array($response) && isset($response['referenced'])) {

            set_alert('warning', _l('is_referenced', _l('customer_group_lowercase')));

        } else if ($response == true) {

            set_alert('success', _l('deleted', _l('customer_group')));

        } else {

            set_alert('warning', _l('problem_deleting', _l('customer_group_lowercase')));

        }



        redirect(admin_url('clients/groups'));

    }



    public function get_client_reminders($id) {

        if ($this->input->is_ajax_request()) {



            $aColumns = array('description', 'date', 'staff', 'isnotified');

            $sIndexColumn = "id";

            $sTable = 'tbladminclientreminders';



            $where = array('AND clientid=' . $id);

            $join = array(

                'JOIN tblstaff ON tblstaff.staffid = tbladminclientreminders.staff'

            );

            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array('firstname', 'lastname', 'id', 'creator'));

            $output = $result['output'];

            $rResult = $result['rResult'];



            foreach ($rResult as $aRow) {

                $row = array();

                for ($i = 0; $i < count($aColumns); $i++) {

                    $_data = $aRow[$aColumns[$i]];

                    if ($aColumns[$i] == 'staff') {

                        $_data = '<a href="' . admin_url('staff/profile/' . $aRow['staff']) . '">' . staff_profile_image($aRow['staff'], array(

                                    'staff-profile-image-small'

                                )) . ' ' . $aRow['firstname'] . ' ' . $aRow['lastname'] . '</a>';

                    } else if ($aColumns[$i] == 'staff') {

                        $_data = _d($_data);

                    } else if ($aColumns[$i] == 'isnotified') {

                        if ($_data == 1) {

                            $_data = _l('client_reminder_is_notified_boolean_yes');

                        } else {

                            $_data = _l('client_reminder_is_notified_boolean_no');

                        }

                    }

                    $row[] = $_data;

                }



                if ($aRow['creator'] == get_staff_user_id()) {

                    $row[] = icon_btn('admin/clients/delete_reminder/' . $id . '/' . $aRow['id'], 'remove', '');

                } else {

                    $row[] = '';

                }





                $output['aaData'][] = $row;

            }



            echo json_encode($output);

            die();

        }

    }

        public function notes($id) {

        if ($this->input->is_ajax_request()) {



            $aColumns = array('description', 'staff','dateadded');

            $sIndexColumn = "usernoteid";

            $sTable = 'tbluseradminnotes';



            $where = array('AND userid=' . $id);

            $join = array(

                'JOIN tblstaff ON tblstaff.staffid = tbluseradminnotes.addedfrom'

            );

            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array('firstname','lastname','usernoteid'));

            $output = $result['output'];

            $rResult = $result['rResult'];



            foreach ($rResult as $aRow) {

                $row = array();

                for ($i = 0; $i < count($aColumns); $i++) {

                    $_data = $aRow[$aColumns[$i]];

                    if ($aColumns[$i]== 'staff') {

                          $_data = '<a href="'.admin_url( 'profile/'.$aRow[ 'addedfrom']). '">'.$aRow[ 'firstname'] . ' ' . $aRow[ 'lastname'] . '</a>';

                    }

                    $row[] = $_data;

                }

                

                    $row[] = icon_btn('admin/misc/remove_user_note/'. $aRow['usernoteid'] . '/' . $id .'/0', 'remove', '');



                $output['aaData'][] = $row;

            }



            echo json_encode($output);

            die();

        }

    }

    



    /* Since version 1.0.2 delete client reminder */



    public function delete_reminder($clientid, $id) {

        if (!$id && !$clientid) {

            die('No reminder found');

        }

        $success = $this->clients_model->delete_reminder($id);



        if ($success) {

            set_alert('success', _l('client_reminder_deleted'));

        } else {

            set_alert('warning', _l('client_reminder_failed_to_delete'));

        }



        redirect(admin_url('clients/client/' . $clientid));

    }

    

    public function getcontact(){

       echo json_encode($this->clients_model->getcontact($this->input->post('id')));

    }

    public function get($id){

       echo json_encode($this->clients_model->get_client($id));   

    }

	public function get_search(){
		$vehicles =	$this->clients_model->get_search_value($this->input->post('searcvalue'));
			$vehicles_json = array();
	    	$customer_vehicles_count = array();   	
	    	$current_customer = '';

	    	if( 0 < count( $vehicles ) )
	    	foreach($vehicles as $vehicle) {
	    		if( $current_customer != $vehicle['users_id']) {
	    			$current_customer = $vehicle['users_id'];
	    			$customer_vehicles_count[$current_customer] = 0;
	    		}
	    		$customer_vehicles_count[$current_customer]++;
	    	}

	    	$current_customer = '';
	    	if( 0 < count( $vehicles ) )
	    	foreach($vehicles as $vehicle) {

	    		if( $current_customer != $vehicle['users_id'] ) {
	    			$current_customer = $vehicle['users_id'];
	    			$vehicles_json[] = array( 	    			
	    			'querystring' =>  $this->input->post('searcvalue'),
	    			'user_name' =>  $vehicle['first_name'].' '.$vehicle['last_name'].' ',
	    			'type' => 'customer',	    			
	    			'user_phone_mobile' =>  $vehicle['phone_mobile'],
	    			'user_city' =>  $vehicle['city'],
	    			'user_vehicle_count' => $customer_vehicles_count[$current_customer],
	    			'url' => admin_url('clients/view/'.$vehicle['users_id'])
	    			);
	    		}
	    		$vehicles_json[] = array( 
	    			'id' => $vehicle['id'], 
	    			'querystring' =>  $this->input->post('searcvalue'),
	    			'text' =>  $vehicle['make'].' '.$vehicle['model'].' '.$vehicle['year'].' '.$vehicle['type'].' ('.$vehicle['registration_number'].')',
	    			'make' => $vehicle['make'],
	    			'make_logo' => $vehicle['image_make'],
	    			'model' => $vehicle['model'],
	    			'year' => $vehicle['year'],
	    			'engine_type' => $vehicle['type'],
	    			'registration_number' => $vehicle['registration_number'],
	    			'type' => 'vehicle',
	    			// 'user_id' =>  $vehicle['{'u.id'},
	    			// 'user_name' =>  $vehicle['{'u.last_name'}.' '.$vehicle['{'u.first_name'},
	    			// 'user_phone_mobile' =>  $vehicle['{'u.phone_mobile'},
	    			// 'user_city' =>  $vehicle['{'u.city'},
	    			'url' => '/customer/view/id/'.$vehicle['users_id'].'#'.$vehicle['id'],
	    			'hash_id' =>  $vehicle['id']
	    		);
	    	}
	    		
		
       echo json_encode(array_merge( $vehicles_json ));
	   exit;
    }

}

