<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Categories extends Admin_controller {

    function __construct() {
        parent::__construct();
        
        $this->load->model('categories_model');
    }

    public function index() {
       

        $data['categories'] = $this->categories_model->get();
        // $get_invoices_category = $this->categories_model->get_invoices_category();
        // $inv_cate = array();
        // foreach ($get_invoices_category as $key => $invoice_category) {
        //     $inv_cate[] = $invoice_category->category;
        // }
        // $data['inv_cate'] =  $inv_cate;
        
        $this->load->model('settings_model');
        $default_options = $this->settings_model->getOptions();
        $data['default_options'] = $default_options;
        // print_r($default_options);die;
        $this->load->model('invoice_items_model');
        $data['prev'] = $this->categories_model->get_prev_groups2();
        $data['ledgers'] = $this->categories_model->get_ledgers();
        $data['title'] = _l('categories');
        $this->load->view('admin/categories/manage', $data);
    }

    public function delete($id) {
        if (!$id) {
            redirect(admin_url('categories'));
        }
        $response = $this->categories_model->delete($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('category_lowercase')));
        } else if ($response == true) {
            set_alert('success', _l('deleted', _l('category_lowercase')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('category_lowercase')));
        }
        
        redirect(admin_url('categories'));
    }

    public function change_category_status($id, $status) {
        if ($this->input->is_ajax_request()) {
            $this->categories_model->change_category_status($id, $status);
        }
    }
    
    public function get_category(){
        $id     = $this->input->post('id');
        $result = $this->categories_model->get_category_details($id);
        echo json_encode($result);
        
    }
    public function update_category(){
        $this->categories_model->update_category_details();
         redirect(admin_url('categories'));
    }
    public function add_category(){ 
        $id = $this->categories_model->add_category_details(); 
        redirect(admin_url().'categories', 'refresh');

        // redirect(admin_url('categories'));
    }

    public function addcategory($value='')
    {
        $id = $this->categories_model->add_category_details(); 
        echo $id;
        // print_r($this->input->post());
        // die;
    }
    public function updatecategory($value='')
    {
        // print_r($this->input->post());
        // die;
        $id = $this->categories_model->update_category_details();
        echo $id;
    }
    
    public function changestatus(){
    echo $this->categories_model->changestatus();
    }

    public function changeeview(){
    echo $this->categories_model->changeeview();
    }
	

    public function index111() {
        if ($this->input->is_ajax_request()) {
            $aColumns = array('category_name', 'Description', 'category_id','active');
            $sIndexColumn = "category_id";
            $sTable = 'tblcategories';
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, array(), array(), array('category_name', 'category_id',  'active'));
            $output = $result['output'];
            $rResult = $result['rResult'];
            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];
                   if ($aColumns[$i] == 'active') {
                        if ($aRow['active'] == '0') {
                                $_data = '<input  class="ischeckbox" data-rowid="'.$aRow['category_id'].'" value="' . $aRow['active'] . '" type="checkbox"/>';
                            } else {
                                $_data = '<input  class="ischeckbox" data-rowid="'.$aRow['category_id'].'" checked="checked" value="' . $aRow['active'] . '" type="checkbox"/>';
                            }
                        }
                        else if ($aColumns[$i] == 'category_id') {
                            $_data =0;
                        }
                   
                      
                    $row[] = $_data;
                }
                
                $options = icon_btn('#','pencil-square-o','edit-category',array('data-id'=>$aRow['category_id']));
                 $row[]  = $options .= icon_btn('admin/categories/delete/' . $aRow['category_id'], 'remove', '', array('data-toggle' => 'tooltip', 'title' => _l('category_delete_tooltip')));
                    
                $output['aaData'][] = $row;
            }
            echo json_encode($output);
            die();
        }
        
        $this->load->model('settings_model');
        $default_options = $this->settings_model->getOptions();
        $data['default_options'] = $default_options;
        // print_r($default_options);die;
        $this->load->model('invoice_items_model');
        $data['prev'] = $this->categories_model->get_prev_groups2();
        $data['ledgers'] = $this->categories_model->get_ledgers();
        $data['title'] = _l('categories');
        $this->load->view('admin/categories/manage', $data);
    }

}
