<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Bins extends Admin_controller {

    function __construct() {
        parent::__construct();
         $this->load->model('bins_model');
    }

    public function index() {
        if ($this->input->is_ajax_request()) {
            $aColumns = array('bin_name', 'tblwarehouse.warehouse_name', 'tbllocations.location_name','aisle','row','level','label');
            $sIndexColumn = "bin_id";
            $sTable = 'tblbins';
            $join = array(
                'LEFT JOIN tblwarehouse ON tblwarehouse.ware_id = tblbins.ware_id',
                'LEFT JOIN tbllocations ON tbllocations.location_id = tblbins.location_id'
            );
            $where= array('where tblbins.active = 1');
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join ,$where, array('bin_name', 'bin_id', 'tblbins.active'));
            $output = $result['output'];
            $rResult = $result['rResult'];
            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];
                    $row[] = $_data;
                }                
                $options = icon_btn('#','pencil-square-o','edit-bins',array('data-id'=>$aRow['bin_id']));
                $row[]  = $options .= icon_btn('admin/bins/delete/' . $aRow['bin_id'], 'remove', '', array('data-toggle' => 'tooltip','onClick' => 'return deleteconf();','title' => _l('bin_delete_tooltip')));
                    
                $output['aaData'][] = $row;
            }
            echo json_encode($output);
            die();
        }
        $data['warehouse']=  $this->bins_model->get_warehouse();
        $data['locations']=  $this->bins_model->get_location();
        $data['title'] = _l('bins');
        $this->load->view('admin/bins/manage', $data);
    }
    
    public function list_bins($id = false, $ware_id = false, $active = false) 
    {
       $has_permission = has_permission('manageSales');

        if (!$has_permission && !$this->input->is_ajax_request()) {
            access_denied('manageSales');
        }
        if ($this->input->is_ajax_request()) {
            if (is_numeric($ware_id)) {
                if (!$has_permission) {
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }
            $aColumns = array('bin_name', 'tblwarehouse.warehouse_name', 'tbllocations.location_name','aisle','row','level','label');
            $sIndexColumn = "bin_id";
            $sTable = 'tblbins';
            $join = array(
                'LEFT JOIN tblwarehouse ON tblwarehouse.ware_id = tblbins.ware_id',
                'LEFT JOIN tbllocations ON tbllocations.location_id = tblbins.location_id'
            );
            
            if($active=='1') { $where= array('where tblbins.ware_id=' . $ware_id .''); }
            else if($active=='0') { $where= array('where tblbins.ware_id=' . $ware_id .' and tblbins.active = 1');}
            else { $where= array('where tblbins.ware_id=' . $ware_id .' and tblbins.active = 1'); }
            
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join ,$where, array('bin_name', 'bin_id', 'tblbins.active'));
            $output = $result['output'];
            $rResult = $result['rResult'];
           
            
            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];
                    $row[] = $_data;
                }                
                $options = icon_btn('#','pencil-square-o','edit-bins',array('data-id'=>$aRow['bin_id']));
                $row[]  = $options .= icon_btn('#', 'remove', ' delete-bins', array('data-id'=>$aRow['bin_id']));
                    
                $output['aaData'][] = $row;
            }
            echo json_encode($output);
            die();
        }   
    }

    public function get_locations_warehouse(){
        if ($this->input->is_ajax_request()) {
          $res = $this->bins_model->get_locations_warehouse();
          $options ='<option value=""></option>';
          if(isset($res)){
              foreach ($res as $value) {
               $options .='<option value="'.$value->location_id.'">'.$value->location_name.'</option>';   
              }
          }
          echo json_encode(array('options'=>$options));
        }
    }
    
    public function getAll($active) {
        if ($this->input->is_ajax_request()) {
            if($active=='1') { $where=array(); }
            if($active=='0') { $where=array('where tblbins.active = 1'); }
            $aColumns = array('bin_name', 'tblwarehouse.warehouse_name', 'tbllocations.location_name','aisle','row','level','label');
            $sIndexColumn = "bin_id";
            $sTable = 'tblbins';
            $join = array(
                'LEFT JOIN tblwarehouse ON tblwarehouse.ware_id = tblbins.ware_id',
                'LEFT JOIN tbllocations ON tbllocations.location_id = tblbins.location_id'
            );
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join ,$where, array('bin_name', 'bin_id', 'tblbins.active'));
            $output = $result['output'];
            $rResult = $result['rResult'];
            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];
                    $row[] = $_data;
                }                
                $options = icon_btn('#','pencil-square-o','edit-bins',array('data-id'=>$aRow['bin_id']));
                $row[]  = $options .= icon_btn('admin/bins/delete/' . $aRow['bin_id'], 'remove', '', array('data-toggle' => 'tooltip', 'title' => _l('bin_delete_tooltip')));
                    
                $output['aaData'][] = $row;
            }
            echo json_encode($output);
            die();
        }
        $data['title'] = _l('locations');
        $this->load->view('admin/locations/manage', $data);
    }
    
    public function add_bin(){
        $this->bins_model->add_bin_details();  
           redirect(admin_url('bins'));
    }

    public function addbin(){
        $id = $this->bins_model->add_bin_details();  
        echo $id;
    }

    public function updatebin(){
        $id = $this->bins_model->update_bin_details();  
        echo $id;
    }
    
     public function get_bins(){
        $id     = $this->input->post('id');
        $result = $this->bins_model->get_bins_details($id);
        echo json_encode($result);
        
    }
    
     public function update_bin(){
        $this->bins_model->update_bin_details();  
           redirect(admin_url('bins'));
    }
    
    public function delete($id) {
        if (!$id) {
            redirect(admin_url('bins'));
        }
        $response = $this->bins_model->delete($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('bin_lowercase')));
        } else if ($response == true) {
            set_alert('success', _l('deleted', _l('bin_lowercase')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('bin_lowercase')));
        }
        redirect(admin_url('bins'));
    }
    
    public function delete_bins()
    {
        $id=  $this->input->post('id');
        $response = $this->bins_model->delete($id);
       echo $response;     
    }
    
    public function changestatus(){
    echo $this->bins_model->changestatus();
    }

}
