<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Banksaccounts extends Admin_controller {

    function __construct() {
        parent::__construct();
        $this->load->model('banksaccounts_model');
    }

    /* List all available items */

    public function index() {
        if ($this->input->is_ajax_request()) {
            $aColumns = array(                
                'account_number',
                'tblbanks.bank',
                'tblbankbranches.branchname',
                'account_type',
                'tblcurrencies.name',
                'available',
              
            );
            $sIndexColumn = "id";
            $sTable = 'tblbanksaccount';
      
            $join = array(
                'LEFT JOIN tblbanks ON tblbanks.bankid = tblbanksaccount.bank',
                'LEFT JOIN tblbankbranches ON tblbankbranches.bankbranchid = tblbanksaccount.branch',
                'LEFT JOIN tblcurrencies ON tblcurrencies.id = tblbanksaccount.currency',

            );
            $additionalSelect = array(
                'tblbanksaccount.id',
                'tblcurrencies.name',
                'symbol',
            );
            $this->load->model('currencies_model');
             $base_currency_symbol = $this->currencies_model->get_base_currency()->symbol;
        
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable,$join, array(), $additionalSelect);
            $output = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                     $_data = $aRow[$aColumns[$i]];
                    if ($aColumns[$i] == 'tblcurrencies.name') {
                         $_data = $aRow['symbol'].$aRow['tblcurrencies.name'];
                    }                    
                    if ($aColumns[$i] == 'account_number') {
                           $_data ='<a href="'.admin_url('banksaccounts/bankaccount/'. $aRow['id']).'">'.$_data.'</a>';
                  
                    }     
                    if ($aColumns[$i] == 'available') {
                           $_data = format_money($aRow['available'], $base_currency_symbol);
                  
                    }     
                   
                    $row[] = $_data;
                }
                $options = icon_btn('admin/banksaccounts/bankaccount/' . $aRow['id'], 'pencil-square-o', 'edit-locations', array('data-toggle' => 'tooltip', 'title' => 'Edit Bank Account'));
                
                
                $row[] = $options .= icon_btn('admin/banksaccounts/delete/' . $aRow['id'], 'remove', '');

                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        $data['title'] = _l('banksaccounts');
        $this->load->view('admin/banksaccounts/manage', $data);
    }

    public function bankaccount($id = '') {
        if ($this->input->post() && !$this->input->is_ajax_request()) {
            if ($id == '') {
                    $id = $this->banksaccounts_model->add($this->input->post());
                    if ($id) {
                          set_alert('success', _l('account_added_successfully'));
                         if (trim($this->input->post('action')) == 'save') {
                                redirect(admin_url('banksaccounts/bankaccount/'.$id));
                              exit;
                          }
                          if (trim($this->input->post('action')) == 'snew') {
                              redirect(admin_url('banksaccounts/bankaccount'));
                              exit;
                          }
                         if (trim($this->input->post('action')) == 'slist') {
                               redirect(admin_url('banksaccounts'));

                          }
                          if (trim($this->input->post('action')) == 'cancel') {
                              redirect(admin_url());
                              exit;
                             }
                    }
            } else {
                $success = $this->banksaccounts_model->update($this->input->post(), $id);
  
                if ($success) {
                  
                    set_alert('success', _l('account_updated_successfully'));
                }
                if (trim($this->input->post('action')) == 'save') {
                                redirect(admin_url('banksaccounts/bankaccount/'.$id));
                              exit;
                          }
                          if (trim($this->input->post('action')) == 'snew') {
                              redirect(admin_url('banksaccounts/bankaccount'));
                              exit;
                          }
                         if (trim($this->input->post('action')) == 'slist') {
                               redirect(admin_url('banksaccounts'));

                          }
                          if (trim($this->input->post('action')) == 'cancel') {
                              redirect(admin_url());
                              exit;
                             }
            }
        }

        if ($id == '') {
            $title = _l('add_new', _l('bank_account'));
        } else {     
           
            $baksaccount = $this->banksaccounts_model->get_where_single_tbl('tblbanksaccount','id',$id);

            $data['branches'] = $this->banksaccounts_model->branches_by_bank($baksaccount->bank);

            $data['baksaccount'] = $baksaccount;
            $bake_name = $this->banksaccounts_model->get_bank_name($data['baksaccount']->bank);
            // echo "<pre>";
            // print_r($bake_name);
            // die;
            $title = $bake_name->bank ." (Acc: ".$data['baksaccount']->account_number.")"; 
        }
   
        $data['banks'] = $this->banksaccounts_model->get_banks();
        $data['prev'] = $this->banksaccounts_model->get_prev_groups2();
        $data['ledgers'] = $this->banksaccounts_model->get_ledgers();
        $this->load->model('currencies_model');
        $data['currencies'] = $this->currencies_model->get();
        $data['title'] = $title;
        $this->load->view('admin/banksaccounts/bankaccount', $data);
    }

   

    /* Delete item */

    public function delete($id) {
        if (!$id) {
            redirect(admin_url('warehouse'));
        }

        $response = $this->banksaccounts_model->delete($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('bank_account')));
        } else if ($response == true) {
            set_alert('success', _l('deleted', _l('bank_account')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('bank_account')));
        }
        redirect(admin_url('banksaccounts'));
    }
    public function changeformat(){
       
        $balance = $this->input->post('balance');
        $overdraft = $this->input->post('overdraft');
       if($balance && $overdraft==''){
           echo json_encode(array('available'=>$balance));
       }else{
          
           $overdue =  str_replace(',','',$balance) + str_replace(',','',$overdraft);
           echo json_encode(array('available'=>number_format($overdue,2)));
       }
       die();
    }

    
    public function delete_items()
    {
        $id=  $this->input->post('id');
        $response = $this->banksaccounts_model->deleteitems($id);
        echo $response;
    }


    /* Get item by id / ajax */

    public function get_item_by_id($id) {
        if ($this->input->is_ajax_request()) {
            echo json_encode($this->banksaccounts_model->get($id));
        }
    }

    /* Get all items */

    public function get_all_items_ajax() {
        if ($this->input->is_ajax_request()) {
            echo json_encode($this->banksaccounts_model->get_all_items_ajax());
        }
    }
    
   
       public function get_branches(){
        if ($this->input->is_ajax_request()) {
          $res = $this->banksaccounts_model->get_branches();
          $options ='<option value=""></option>';
          if(isset($res)){
              foreach ($res as $value) {
               $options .='<option value="'.$value->bankbranchid.'">'.$value->branchname.'</option>';   
              }
          }
          echo json_encode(array('options'=>$options));
        }
    }
}
