<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Main_clients_controller extends Clients_controller
{

    function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        if (!is_client_logged_in()) {
            redirect(site_url('clients/login'));
        }

        $data['title'] = get_option('companyname');
        $this->data    = $data;
        $this->view    = 'home';
        $this->layout();
    }
    public function tickets($status = false)
    {
        if (!is_client_logged_in()) {
            redirect(site_url('clients/login'));
        }
        if ($this->input->is_ajax_request()) {
            ClientTicketsTable(array(
                'status' => $status,
                'userid' => get_client_user_id()
            ));
        }

        $data['title'] = _l('clients_tickets_heading');
        $this->data    = $data;
        $this->view    = 'tickets';
        $this->layout();

    }

    public function open_ticket()
    {

        if (!is_client_logged_in()) {
            redirect(site_url('clients/login'));
        }

        if ($this->input->post()) {
            $id = $this->tickets_model->add($this->input->post());
            if ($id) {
                $this->load->helper('polaris_upload');
                $attachments = handle_ticket_attachments($id);

                if ($attachments) {
                    $this->tickets_model->insert_ticket_attachments_to_database($attachments, $id);
                }

                set_alert('success', 'Ticket #' . $id . ' added successfuly');
                redirect(site_url('clients/ticket/' . $id));
            }
        }
        $data                   = array();
        $data['latest_tickets'] = $this->tickets_model->get_client_latests_ticket();
        $data['title']          = _l('new_ticket');
        $this->data             = $data;
        $this->view             = 'open_ticket';
        $this->layout();
    }

    public function ticket($id)
    {

        if (!is_client_logged_in()) {
            redirect(site_url('clients/login'));
        }
        if (!$id) {
            redirect(site_url());
        }

        if ($this->input->post()) {
            $replyid = $this->tickets_model->add_reply($this->input->post(), $id, NULL);
            $this->load->helper('polaris_upload');
            $attachments = handle_ticket_attachments($id);

            if ($attachments) {
                $this->tickets_model->insert_ticket_attachments_to_database($attachments, $id, $replyid);
            }
            if ($replyid) {
                set_alert('success', 'Replied to ticket #' . $id . ' successfuly');
                redirect(site_url('clients/ticket/' . $id));
            }
        }

        $data['ticket'] = $this->tickets_model->get_ticket_by_id($id, get_client_user_id());

        if ($data['ticket']->userid != get_client_user_id()) {
            redirect(site_url());
        }
        $data['ticket_replies'] = $this->tickets_model->get_ticket_replies($id, get_client_user_id());
        $data['title']          = '';
        $this->data             = $data;
        $this->view             = 'single_ticket';
        $this->layout();
    }



    public function contracts()
    {

        if (!is_client_logged_in()) {
            redirect(site_url('clients/login'));
        }
        $this->load->model('contracts_model');
        if ($this->input->is_ajax_request()) {
            $aColumns         = array(
                'subject',
                'contract_type',
                'datestart',
                'dateend'
            );
            $sIndexColumn     = "id";
            $sTable           = 'tblcontracts';
            $additionalSelect = array(
                'tblcontracts.id',
                'tblcontracttypes.name'
            );
            $join             = array(
                'LEFT JOIN tblclients ON tblclients.userid = tblcontracts.client',
                'LEFT JOIN tblcontracttypes ON tblcontracttypes.id = tblcontracts.contract_type'
            );


            $where = array(
                'WHERE client=' . get_client_user_id(),
                'AND trash = 0',
                'AND not_visible_to_client = 0' // dont output contracts check hide from customer
            );

            $result  = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, $additionalSelect);
            $output  = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];
                    if ($aColumns[$i] == 'dateend' || $aColumns[$i] == 'datestart') {
                        $_data = _d($_data);
                    } else if ($aColumns[$i] == 'subject') {
                        if ($attachment = $this->contracts_model->get_contract_attachments($aRow['id'])) {
                            $_data = '<a href="' . site_url('download/file/contract/' . $attachment->id) . '">' . $_data . '</a>';
                        }
                    } else if ($aColumns[$i] == 'contract_type') {
                        $_data = $aRow['name'];
                    }

                    $row[] = $_data;
                }

                if (!empty($aRow['dateend'])) {
                    $_date_end = date('Y-m-d', strtotime($aRow['dateend']));
                    if ($_date_end < date('Y-m-d')) {
                        $row['DT_RowClass'] = 'alert-danger';
                    }
                }

                $attachments_modal = '';
                $attachments_array = $this->contracts_model->get_contract_attachments('', $aRow['id']);
                if(file_exists(APPPATH . 'views/themes/' . active_clients_theme() . '/template_parts/contract_attachments.php')){
                    include(APPPATH . 'views/themes/' . active_clients_theme() . '/template_parts/contract_attachments.php');
                }

                $row[]              = $attachments_modal;
                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        $data['title'] = _l('clients_contracts');
        $this->data    = $data;
        $this->view    = 'contracts';
        $this->layout();
    }
    public function invoices($status = false)
    {

        if (!is_client_logged_in()) {
            redirect(site_url('clients/login'));
        }

        if ($this->input->is_ajax_request()) {
            $aColumns = array(
                'number',
                'date',
                'duedate',
                'total',
                'status'
            );

            $join = array(
                'LEFT JOIN tblclients ON tblclients.userid = tblinvoices.clientid',
                'LEFT JOIN tblcurrencies ON tblcurrencies.id = tblinvoices.currency'
            );

            $where = array(
                'AND clientid=' . get_client_user_id()
            );

            if (is_numeric($status)) {
                array_push($where, 'AND status=' . $status);
            }

            $sIndexColumn = "id";
            $sTable       = 'tblinvoices';
            $result       = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array(
                'tblinvoices.id',
                'firstname',
                'lastname',
                'clientid',
                'symbol',
                'total',
                'hash',
                'tblinvoices.datecreated',
                'status'
            ));
            $output       = $result['output'];
            $rResult      = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];

                    if ($aColumns[$i] == 'number') {
                        $__data = '<a href="' . site_url('viewinvoice/' . $aRow['id'] . '/' . $aRow['hash']) . '">' . format_invoice_number($aRow['id']) . '</a><br />';
                    } else if ($aColumns[$i] == 'date') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'duedate') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'total') {
                        $__data = format_money($_data, $aRow['symbol']);
                    } else {
                        $__data = format_invoice_status($aRow['status'], 'pull-left', true);
                    }
                    $row[] = $__data;
                }
                $output['aaData'][] = $row;
            }
            echo json_encode($output);
            die();
        }


        $data['title'] = _l('clients_my_invoices');
        $this->data    = $data;
        $this->view    = 'invoices';
        $this->layout();
    }

    public function viewinvoice($id = '', $hash = '')
    {
        check_invoice_restrictions($id, $hash);

        $invoice = $this->invoices_model->get($id);

        // Init the client language in case is accesed directly without login
        $language = get_client_default_language($invoice->clientid);

        if (!empty($language)) {
            $this->lang->load($language . '_lang', $language);
        }

        // Handle Invoice PDF generator
        if ($this->input->post('invoicepdf')) {
            $pdf            = invoice_pdf($invoice);
            $invoice_number = format_invoice_number($invoice->id);

            $companyname = get_option('invoice_company_name');
            if ($companyname != '') {
                $invoice_number .= '-' . strtoupper(slug_it($companyname));
            }
            $pdf->Output($invoice_number . '.pdf', 'D');
            die();
        }


        // Handle $_POST payment
        if ($this->input->post('make_payment')) {
            $this->load->model('payments_model');

            if (!$this->input->post('paymentmode')) {
                set_alert('warning', _l('invoice_html_payment_modes_not_selected'));
                redirect(site_url('viewinvoice/' . $id . '/' . $hash));
            } else if ((!$this->input->post('amount') || $this->input->post('amount') == 0) && get_option('allow_payment_amount_to_be_modified') == 1) {
                set_alert('warning', _l('invoice_html_amount_blank'));
                redirect(site_url('viewinvoice/' . $id . '/' . $hash));
            }
            $this->payments_model->process_payment($this->input->post(), $id);
        }

        if ($this->input->post('paymentpdf')) {
            $id      = $this->input->post('paymentpdf');
            $payment = $this->payments_model->get($id);

            $payment->invoice_data = $this->invoices_model->get($payment->invoiceid);
            $paymentpdf            = payment_pdf($payment);
            $paymentpdf->Output(_l('payment') . '-' . $payment->paymentid . '.pdf', 'D');
            die;
        }

        $this->load->model('payment_modes_model');
        $this->load->model('payments_model');
        $data['payments']      = $this->payments_model->get_invoice_payments($id);
        $data['payment_modes'] = $this->payment_modes_model->get();
        $data['title']         = format_invoice_number($invoice->id);
        $this->use_navigation  = false;
        $data['hash']          = $hash;
        $data['invoice']       = $invoice;
        $data['bodyclass']     = 'viewinvoice';
        $this->data            = $data;
        $this->view            = 'invoicehtml';
        $this->layout();
    }

    public function quotes($status = false)
    {

        if (!is_client_logged_in()) {
            redirect(site_url('clients/login'));
        }

        if ($this->input->post('quote_action')) {
            $action = $this->input->post('quote_action');
            // Only decline and accept allowed
            if ($action == 4 || $action == 3) {
                $success = $this->quotes_model->client_quote_action($action, $this->input->post('id'));
                if (is_array($success) && $success['invoiced'] == true) {
                    $invoice = $this->invoices_model->get($success['invoiceid']);
                    set_alert('success', _l('clients_quote_invoiced_successfuly'));
                    redirect(site_url('viewinvoice/' . $invoice->id . '/' . $invoice->hash));
                } else if (is_array($success) && $success['invoiced'] == false) {
                    if ($action == 4) {
                        set_alert('success', _l('clients_quote_accepted_not_invoiced'));
                    } else {
                        set_alert('success', _l('clients_quote_declined'));
                    }
                } else {
                    set_alert('success', _l('clients_quote_failed_action'));
                }
            }

            redirect(site_url('clients/quotes'));
        }

        if ($this->input->is_ajax_request()) {
            $aColumns = array(
                'number',
                'date',
                'reference_no',
                'expirydate',
                'total',
                'status'
            );

            $join = array(
                'LEFT JOIN tblclients ON tblclients.userid = tblquotes.clientid',
                'LEFT JOIN tblcurrencies ON tblcurrencies.id = tblquotes.currency'
            );

            $where = array(
                'AND clientid=' . get_client_user_id()
            );

            if (is_numeric($status)) {
                array_push($where, 'AND status=' . $status);
            }

            // Check if exclude draft quotes from client area is checked
            if (get_option('exclude_quote_from_client_area_with_draft_status') == 1) {
                array_push($where, 'AND status != 1');
            }

            $sIndexColumn = "id";
            $sTable       = 'tblquotes';
            $result       = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array(
                'tblquotes.id',
                'symbol',
                'invoiceid',
                'status'
            ));

            $output  = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];

                    if ($aColumns[$i] == 'number') {
                        $__data = '<a href="' . site_url('clients/quote_pdf/' . $aRow['id']) . '">' . format_quote_number($aRow['id']) . '</a><br />';
                        if ($aRow['invoiceid'] !== NULL) {
                            $invoice = $this->invoices_model->get($aRow['invoiceid']);
                            $__data .= '<br /><a href="' . site_url('viewinvoice/' . $invoice->id . '/' . $invoice->hash) . '">' . format_invoice_number($invoice->id) . '</a>';
                        }

                    } else if ($aColumns[$i] == 'date') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'expirydate') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'total') {
                        $__data = format_money($_data, $aRow['symbol']);
                    } else if ($aColumns[$i] == 'status') {
                        $__data = format_quote_status($aRow['status'], 'pull-right');
                    } else {
                        $__data = $_data;
                    }

                    $row[] = $__data;
                }

                $quote_actions = false;
                $actions          = form_open($this->uri->uri_string());
                $actions .= form_hidden('id', $aRow['id']);
                $actions .= '<div class="btn-group dropup">';
                $actions .= '<button type="button" class="btn btn-default btn-icon btn-quote-action dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fa fa-cog"></i>
                            </button>';
                $actions .= '<ul class="dropdown-menu dropdown-menu-right">';
                $actions .= form_hidden('quote_action');
                if ($aRow['status'] != 4 && $aRow['status'] != 3) {
                    $quote_actions = true;
                    $actions .= '<li><a href="#" onclick="take_quote_action(this,4);" data-action="4">' . _l('clients_accept_quote') . '</a></li>';
                    $actions .= '<li><a href="#" onclick="take_quote_action(this,3);" data-action="3">' . _l('clients_decline_quote') . '</a></li>';
                } else if ($aRow['status'] == 3) {
                    if ($aRow['expirydate'] <= date('Y-m-d') && $aRow['status'] != 5) {
                        $quote_actions = true;
                        $actions .= '<li><a href="#" onclick="take_quote_action(this,4);" data-action="4">' . _l('clients_accept_quote') . '</a></li>';
                    }
                }

                $actions .= '</ul>';
                $actions .= '</div>';
                // Disable the button if no actions found
                if (!$quote_actions) {
                    $actions = str_replace('btn-quote-action', 'disabled', $actions);
                }
                $actions .= form_close();
                $row[]              = $actions;
                $output['aaData'][] = $row;
            }
            echo json_encode($output);
            die();
        }

        $data['title'] = _l('clients_my_quotes');
        $this->data    = $data;
        $this->view    = 'quotes';
        $this->layout();
    }

    public function quote_pdf($id)
    {
        if (!is_client_logged_in()) {
            redirect(site_url('clients/login'));
        }

        $quote        = $this->quotes_model->get($id);
        $quote_number = format_quote_number($quote->id);
        $pdf             = quote_pdf($quote);
        $pdf->Output($quote_number . '.pdf', 'D');
    }

    public function survey($id, $hash)
    {
        if (!$hash || !$id) {
            die('No survey specified');
        }

        $this->load->model('surveys_model');
        $survey = $this->surveys_model->get($id);

        if (!$survey) {
            die('Survey not found');
        }

        if ($survey->hash != $hash) {
            die;
        }

        if ($survey->active == 0) {
            // Allow users with permission manage surveys to preview the survey even if is not active
            if (!has_permission('manageSurveys')) {
                die('Survey not active');
            }
        }

        // Check if survey is only for logged in participants / staff / clients
        if ($survey->onlyforloggedin == 1) {
            if (!is_logged_in()) {
                die('This survey is only for logged in users');
            }
        }

        // Ip Restrict check
        if ($survey->iprestrict == 1) {
            $this->db->where('surveyid', $id);
            $this->db->where('ip', $this->input->ip_address());
            $total = $this->db->count_all_results('tblsurveyresultsets');
            if ($total > 0) {
                die('Already participated on this survey. Thanks');
            }
        }

        if ($this->input->post()) {
            $success = $this->surveys_model->add_survey_result($id, $this->input->post());
            if ($success) {
                $survey = $this->surveys_model->get($id);
                if ($survey->redirect_url !== '') {
                    redirect($survey->redirect_url);
                }
                set_alert('success', 'Thank you for participating in this survey. Your answers are very important to us.');
                redirect(site_url());

            }
        }

        $this->use_footer     = false;
        $this->use_head       = false;
        $this->add_scripts    = false;
        $this->use_navigation = false;

        $data['survey'] = $survey;
        $data['title']  = $data['survey']->subject;
        $this->data     = $data;
        $this->view     = 'survey_view';
        $this->layout();

    }

    public function profile()
    {
        if (!is_client_logged_in()) {
            redirect(site_url('clients/login'));
        }

        if ($this->input->post()) {
            $success = $this->clients_model->update($this->input->post(), get_client_user_id());
            if ($success == true) {
                set_alert('success', _l('clients_profile_updated'));
            }
            redirect(site_url('clients/profile'));
        }
        $data['title'] = _l('clients_profile_heading');
        $this->data    = $data;
        $this->view    = 'profile';
        $this->layout();
    }

    public function register()
    {
        if (get_option('allow_registration') != 1 || is_client_logged_in()) {
            redirect(site_url());
        }
        if ($this->input->post()) {
            $clientid = $this->clients_model->add($this->input->post());

            if ($clientid) {
                $this->load->model('authentication_model');
                $logged_in = $this->authentication_model->login($this->input->post('email'), $this->input->post('password'), false, false);
                if ($logged_in) {
                    set_alert('success', _l('clients_successfully_registered'));
                } else {
                    set_alert('warning', _l('clients_account_created_but_not_logged_in'));
                    redirect(site_url('clients/login'));
                }

                redirect(site_url());
            }
        }
        $data['title'] = _l('clients_register_heading');
        $this->data    = $data;
        $this->view    = 'register';
        $this->layout();
    }

    public function change_password()
    {
        if (!is_client_logged_in()) {
            redirect(site_url('clients/login'));
        }

        if ($this->input->post()) {
            $success = $this->clients_model->change_client_password($this->input->post());
            if (is_array($success) && isset($success['old_password_not_match'])) {
                set_alert('danger', 'Your old password dont match');
            } else if ($success == true) {
                set_alert('success', 'Password changed successfuly');
            }
            redirect(site_url('clients/profile'));
        }
    }

    public function dismiss_announcement()
    {
        if (!is_client_logged_in()) {
            redirect(site_url('clients/login'));
        }
        if ($this->input->post()) {
            $this->misc_model->dismiss_announcement($this->input->post(), false);
        }
    }


    public function knowledge_base($slug = '')
    {
        if ((get_option('use_knowledge_base') == 1 && !is_client_logged_in() && get_option('knowledge_base_without_registration') == 1) || (get_option('use_knowledge_base') == 1 && is_client_logged_in())) {

            $data = array();
            if ($slug == '' || $this->input->get('groupid')) {
                $data['title'] = _l('clients_knowledge_base');
                $this->view    = 'knowledge_base';
            } else {
                $data['article'] = $this->knowledge_base_model->get(false, $slug);
                if ($data['article']->active_article == 0) {
                    redirect(site_url('knowledge_base'));
                }
                $data['title'] = $data['article']->subject;
                $this->view    = 'knowledge_base_article';
            }

            $this->data = $data;
            $this->layout();
        } else {
            redirect(site_url());
        }
    }

    public function add_article_answer()
    {
        if (($this->input->post() && $this->input->is_ajax_request())) {
            echo json_encode($this->knowledge_base_model->add_article_answer($this->input->post()));
            die();
        }
    }
    public function login()
    {

        if (is_client_logged_in()) {
            redirect(site_url());
        }

        if (get_option('allow_registration') == 1) {
            $data['title'] = _l('clients_login_heading_register');
        } else {
            $data['title'] = _l('clients_login_heading_no_register');
        }

        $this->data = $data;
        $this->view = 'login';
        $this->layout();
    }

    public function logout()
    {
        $this->load->model('authentication_model');
        $this->authentication_model->logout(false);
        redirect(site_url('../'));
    }

    public function client_email_exists()
    {
        if ($this->input->post() && $this->input->is_ajax_request()) {
            $this->db->where('email', $this->input->post('email'));
            $total_rows = $this->db->count_all_results('tblclients');

            if ($total_rows > 0) {
                echo json_encode(false);
            } else {
                echo json_encode(true);
            }
            die();
        }
    }

    /**
     * Client home chart
     * @return mixed
     */
    public function client_home_chart()
    {

        if (is_client_logged_in()) {
            $statuses = array(
                1,
                2,
                4
            );
            $chart    = array(
                'labels' => array(
                    'January',
                    'February',
                    'March',
                    'April',
                    'May',
                    'June',
                    'July',
                    'August',
                    'September',
                    'October',
                    'November',
                    'December'
                ),
                'datasets' => array()
            );
            foreach ($statuses as $status) {

                $months_report = $this->input->post('months_report');
                if ($months_report != '') {
                    $custom_date_select = '';
                    if (is_numeric($months_report)) {
                        $custom_date_select = 'date > DATE_SUB(now(), INTERVAL ' . $months_report . ' MONTH)';
                    } else if ($months_report == 'custom') {

                        $from_date = to_sql_date($this->input->post('report_from'));
                        $to_date   = to_sql_date($this->input->post('report_to'));

                        if ($from_date == $to_date) {
                            $custom_date_select = 'date ="' . $from_date . '"';
                        } else {
                            $custom_date_select = '(date BETWEEN "' . $from_date . '" AND "' . $to_date . '")';
                        }
                    }
                    $this->db->where($custom_date_select);
                }

                $this->db->select('total as amount, date');
                $this->db->from('tblinvoices');
                $this->db->where('clientid', get_client_user_id());
                $this->db->where('status', $status);

                $by_currency = $this->input->post('report_currency');
                if ($by_currency) {
                    $this->db->where('currency', $by_currency);
                }

                $payments = $this->db->get()->result_array();

                $data          = array();
                $data['temp']  = $chart['labels'];
                $data['total'] = array();

                $i = 0;
                foreach ($chart['labels'] as $month) {
                    $data['temp'][$i] = array();
                    foreach ($payments as $payment) {
                        $_month = date('F', strtotime($payment['date']));
                        if ($_month == $month) {
                            $data['temp'][$i][] = $payment['amount'];
                        }
                    }
                    $data['total'][] = array_sum($data['temp'][$i]);
                    $i++;
                }

                if ($status == 1) {
                    $strokeColor = '#fc142b';
                    $borderColor = '#fc2d42';
                } else if ($status == 2) {
                    $strokeColor = '#259b24';
                    $borderColor = '#20861f';
                } else if ($status == 4) {
                    $strokeColor = '#ff6f00';
                    $borderColor = '#e66400';
                }

                array_push($chart['datasets'], array(
                    'label' => format_invoice_status($status, '', false, true),
                    'fillColor' => 'rgba(151,187,205,0.2)',
                    'strokeColor' => $strokeColor,
                    'pointColor' => $strokeColor,
                    'pointStrokeColor' => '#fff',
                    'pointHighlightFill' => '#fff',
                    'pointHighlightStroke' => $strokeColor,
                    'data' => $data['total']
                ));
            }

            echo json_encode($chart);
        }
    }
}
