<?php

/*											/*

	###################################
	#	     Created by rajawi        #
	#	    rajawi9999@yahoo.fr       #		
	#     Freelancer ID:rajawi9999    #
	#         Morocco 2012            #
    ###################################
	
/*											*/								


class imageClass extends fileUpload
{
	// *** Class variables
	public $image;
	public $width;
	public $height;
	public $imageResized;
	public $extension;
	function __construct($fileName,$title="",$path_to="",$ext)
	{
		$this->extension=$ext;
		
		parent::__construct($fileName,$title,$path_to,$ext,array("jpg", "jpeg", "gif", "png"));
		
	}

	## --------------------------------------------------------
	public function loadImage()
	{
		
		// *** Open up the file
		$this->image = $this->openImage($this->folder.$this->file_name);

		// *** Get width and height
		$this->width  = imagesx($this->image);
		$this->height = imagesy($this->image);
	}
	private function openImage($file)
	{
		
		switch($this->ext)
		{
			case 'jpg':
			case 'jpeg':
				$img = @imagecreatefromjpeg($file);
				break;
			case 'gif':
				$img = @imagecreatefromgif($file);
				break;
			case 'png':
				$img = @imagecreatefrompng($file);
				break;
			default:
				$img = false;
				break;
		}
		return $img;
	}

	## --------------------------------------------------------

	public function resizeImage($newWidth, $newHeight, $option="auto")
	{
		// *** Get optimal width and height - based on $option
		$optionArray = $this->getDimensions($newWidth, $newHeight, $option);

		$optimalWidth  = $optionArray['optimalWidth'];
		$optimalHeight = $optionArray['optimalHeight'];


		// *** Resample - create image canvas of x, y size
		$this->imageResized = imagecreatetruecolor($optimalWidth, $optimalHeight);
		$black = imagecolorallocate($this->imageResized, 0, 0, 0);
		imagecolortransparent($this->imageResized, $black);
		imagecopyresampled($this->imageResized, $this->image, 0, 0, 0, 0, $optimalWidth, $optimalHeight, $this->width, $this->height);


		// *** if option is 'crop', then crop too
		if ($option == 'crop') {
			$this->crop($optimalWidth, $optimalHeight, $newWidth, $newHeight);
		}
	}

	## --------------------------------------------------------
	
	private function getDimensions($newWidth, $newHeight, $option)
	{

	   switch ($option)
		{
			case 'exact':
				$optimalWidth = $newWidth;
				$optimalHeight= $newHeight;
				break;
			case 'portrait':
				$optimalWidth = $this->getSizeByFixedHeight($newHeight);
				$optimalHeight= $newHeight;
				break;
			case 'landscape':
				$optimalWidth = $newWidth;
				$optimalHeight= $this->getSizeByFixedWidth($newWidth);
				break;
			case 'auto':
				$optionArray = $this->getSizeByAuto($newWidth, $newHeight);
				$optimalWidth = $optionArray['optimalWidth'];
				$optimalHeight = $optionArray['optimalHeight'];
				break;
			case 'crop':
				$optionArray = $this->getOptimalCrop($newWidth, $newHeight);
				$optimalWidth = $optionArray['optimalWidth'];
				$optimalHeight = $optionArray['optimalHeight'];
				break;
		}
		return array('optimalWidth' => $optimalWidth, 'optimalHeight' => $optimalHeight);
	}

	## --------------------------------------------------------

	private function getSizeByFixedHeight($newHeight)
	{
		$ratio = $this->width / $this->height;
		$newWidth = $newHeight * $ratio;
		return $newWidth;
	}

	private function getSizeByFixedWidth($newWidth)
	{
		$ratio = $this->height / $this->width;
		$newHeight = $newWidth * $ratio;
		return $newHeight;
	}

	private function getSizeByAuto($newWidth, $newHeight)
	{
		if ($this->height < $this->width)
		// *** Image to be resized is wider (landscape)
		{
			$optimalWidth = $newWidth;
			$optimalHeight= $this->getSizeByFixedWidth($newWidth);
		}
		elseif ($this->height > $this->width)
		// *** Image to be resized is taller (portrait)
		{
			$optimalWidth = $this->getSizeByFixedHeight($newHeight);
			$optimalHeight= $newHeight;
		}
		else
		// *** Image to be resizerd is a square
		{
			if ($newHeight < $newWidth) {
				$optimalWidth = $newWidth;
				$optimalHeight= $this->getSizeByFixedWidth($newWidth);
			} else if ($newHeight > $newWidth) {
				$optimalWidth = $this->getSizeByFixedHeight($newHeight);
				$optimalHeight= $newHeight;
			} else {
				// *** Sqaure being resized to a square
				$optimalWidth = $newWidth;
				$optimalHeight= $newHeight;
			}
		}

		return array('optimalWidth' => $optimalWidth, 'optimalHeight' => $optimalHeight);
	}

	## --------------------------------------------------------

	private function getOptimalCrop($newWidth, $newHeight)
	{

		$heightRatio = $this->height / $newHeight;
		$widthRatio  = $this->width /  $newWidth;

		if ($heightRatio < $widthRatio) {
			$optimalRatio = $heightRatio;
		} else {
			$optimalRatio = $widthRatio;
		}

		$optimalHeight = $this->height / $optimalRatio;
		$optimalWidth  = $this->width  / $optimalRatio;

		return array('optimalWidth' => $optimalWidth, 'optimalHeight' => $optimalHeight);
	}

	## --------------------------------------------------------
	
	private function crop($optimalWidth, $optimalHeight, $newWidth, $newHeight)
	{
		// *** Find center - this will be used for the crop
		$cropStartX = ( $optimalWidth / 2) - ( $newWidth /2 );
		$cropStartY = ( $optimalHeight/ 2) - ( $newHeight/2 );

		$crop = $this->imageResized;
		//imagedestroy($this->imageResized);

		// *** Now crop from center to exact requested size
		$this->imageResized = imagecreatetruecolor($newWidth , $newHeight);
		$black = imagecolorallocate($this->imageResized, 0, 0, 0);
		imagecolortransparent($this->imageResized, $black);
		//imagesavealpha($this->imageResized, true);
		
		/*$alpha_channel = imagecolorallocatealpha($this->imageResized, 0, 0, 0, 127); 
        imagecolortransparent($this->imageResized, $alpha_channel); 
        // Fill image
        imagefill($this->imageResized, 0, 0, $alpha_channel); */
		
		
		


		//imagesavealpha($this->imageResized, true);
		imagecopyresampled($this->imageResized, $crop , 0, 0, $cropStartX, $cropStartY, $newWidth, $newHeight , $newWidth, $newHeight);
		
	}

	## --------------------------------------------------------

	public function saveImage($sufixe, $imageQuality="100")
	{
		/*if(convert_image_to!=0)
		$extension=convert_image_to;
		else	*/	
		$extension = $this->extension;
		if($sufixe!="")
			$sufixe="_".$sufixe;
		$this->file_name=$this->file_title.$sufixe.".".$extension;		
		$i=1;
		while (file_exists($this->folder.$this->file_name))
		{
			$i++;
			$this->file_name=$this->file_title.$i.$sufixe.".".$extension;
		}
		$this->createdFileRelativePath=$this->relative_folder."/".$this->file_name;	;	
		$savePath=$this->folder.$this->file_name;
		switch($extension)
		{
			case 'jpg':
			case 'jpeg':
				if (imagetypes() & IMG_JPG) {
					imagejpeg($this->imageResized, $savePath, $imageQuality);
				}
				break;

			case 'gif':
				if (imagetypes() & IMG_GIF) {
					imagegif($this->imageResized, $savePath);
				}
				break;

			case 'png':
				// *** Scale quality from 0-100 to 0-9
				$scaleQuality = round(($imageQuality/100) * 9);

				// *** Invert quality setting as 0 is best, not 9
				$invertScaleQuality = 9 - $scaleQuality;

				if (imagetypes() & IMG_PNG) {
					 imagepng($this->imageResized, $savePath, $invertScaleQuality);
				}
				break;

			// ... etc

			default:
				// *** No extension - No save.
				break;
		}

		imagedestroy($this->imageResized);
	}


	## --------------------------------------------------------

}
?>
