<?php

define('Installed','YES');
$system=new systemClass();

define('URL',$system->baseurl."admin/"); // url to the directory , with "/" in the end
define('DASHBOARD',URL."dashboard/");


define('PATH',$system->absolutePath); //absolute path 


define('SEP',$system->separator); //separator char

define('AJAX',$system->absolutePath."ajax".SEP);
define("includesDirectory",AJAX."includes".SEP);
define("libDirectory",AJAX."lib".SEP); 
define('CONTENTS',AJAX."contents".SEP);
define('uploadDirectory',PATH."uploads".SEP);
define("uploadURL",URL."uploads".SEP);
define("BASEPATH",PATH);
define("FCPATH",PATH);
define('max_filesize_upload',4); 
require_once("application/config/database.php");

require_once("application/helpers/polaris_constants_helper.php");
require_once("application/helpers/phpass_helper.php");


// database settings
define('DB_SERVER_USERNAME',$db['default']['username']);
define('DB_SERVER_PASSWORD',$db['default']['password']);
define('DB_DATABASE',$db['default']['database']);
define('DB_SERVER',$db['default']['hostname']);
if(!defined('DB_PREFIX'))
define('DB_PREFIX',$db['default']['dbprefix']);
define('DB_DRIVER',$db['default']['dbdriver']);








class systemClass
{
	public $absolutePath;
	public $separator;
	
	public $isWindows;
	public $con;
	public $protocol;
    public $site;
    public $thisfile;
    public $real_directories;
    public $num_of_real_directories;
    public $virtual_directories = array();
    public $num_of_virtual_directories = array();
    public $baseurl;
    public $url;

	public function __construct()
	{
		$this->absolutePath=dirname(__FILE__);
		$this->separator=$this->getSeparator();
		$this->absolutePath.=$this->separator;
		$this->VirtualDirectory();
		global $connection;	
		$this->con=$connection;
	}
	
	public function getSeparator()
	{
		if (substr(php_uname(), 0, 7) == "Windows")
		 {
		 	$this->isWindows=true;
			return "\\";
		}
		else {		 
		 	$this->isWindows=false;
			return "/";
		}
	}
	
	function executeBackScript($file,$arg="")
	{
		//$path=$this->absultePath.$file;
		$cmd=$this->phpPath.' "'.$file.'" '.$arg;
		//$cmd=str_replace("\\","\\\\",$cmd);
		//die($cmd);
		
		if($this->isWindows)
		{
			$WshShell = new COM("WScript.Shell") or die("Unable to instantiate Mappoint COM object");;
			$WshShell->Run($cmd, 0, false);
			
		}
		else
			exec($cmd . " > /dev/null &"); 
	}
	function executProgram($comand)
	{
		if (system($comand, $ret_value))
			return $ret_value;
		return false;
	}
	function VirtualDirectory()
    {
        $this->protocol =((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') || $_SERVER['SERVER_PORT'] == 443) ? "https" : "http";	
        $this->site =  $_SERVER['HTTP_HOST'];
        $this->thisfile = basename($_SERVER['SCRIPT_FILENAME']);
        $this->real_directories = $this->cleanUp(explode("/", str_replace($this->thisfile, "", $_SERVER['PHP_SELF'])));
        $this->num_of_real_directories = count($this->real_directories);
        $this->virtual_directories = array_diff($this->cleanUp(explode("/", str_replace($this->thisfile, "", $_SERVER['REQUEST_URI']))),$this->real_directories);
        $this->num_of_virtual_directories = count($this->virtual_directories);
        $this->baseurl = $this->site . "/" . implode("/", $this->real_directories) . "/";
        $this->url = $this->baseurl . implode("/", $this->virtual_directories) . "/";
		
		$this->baseurl=$this->protocol . '://'.str_replace("//","/",$this->baseurl);
		 $this->url=$this->protocol . '://' .str_replace("//","/", $this->url);
		
    }
    function cleanUp($array)
    {
        $cleaned_array = array();
        foreach($array as $key => $value)
        {
            $qpos = strpos($value, "?");
            if($qpos !== false)
            {
                break;
            }
            if($key != "" && $value != "")
            {
                $cleaned_array[] = $value;
            }
        }
        return $cleaned_array;
    }
}
?>