<?php

class Zend_View_Helper_MoveCheckboxDecorator
{

	public function moveCheckboxDecorator( Zend_Form $_form )
	{
		foreach ( $_form->getElements() as $element ) {
			if ( $element instanceof Zend_Form_Element_Checkbox ) {
				$class = $element->getAttrib( 'class' );
				if ( stripos( $class, 'prepend' ) === false ) {				
					$element->setDecorators( array(
						'ViewHelper',
						'Description',
						'Errors',
						array( 'Label', array( 'placement' => 'APPEND' ) ),
						array( 'HtmlTag', array( 'tag' => 'dd' ) ) )
					);
				}
			}
		}

		return $_form;
	}

}