<?php
/**
 * FlashMessages view helper
 * application/modules/admin/views/helpers/FlashMessages.php
 *
 * This helper creates an easy method to return groupings of
 * flash messages by status.
 *
 * @author Aaron Bach <bachya1208[at]googlemail.com
 * @license Free to use - no strings. 
 */
class Zend_View_Helper_FlashMessages
{
    /**
     * flashMessages function.
     *
     * Takes a specially formatted array of flash messages and prepares them
     * for output.
     *
     * SAMPLE INPUT (in, say, a controller):
     *    $this->_flashMessenger->addMessage(array('message' => 'Success message #1', 'status' => 'success'));
     *    $this->_flashMessenger->addMessage(array('message' => 'Error message #1', 'status' => 'error'));
     *    $this->_flashMessenger->addMessage(array('message' => 'Warning message #1', 'status' => 'warning'));
     *    $this->_flashMessenger->addMessage(array('message' => 'Success message #2', 'status' => 'success'));
     *
     * SAMPLE OUTPUT (in a view):
     *    <div class="success">
     *        <ul>
     *            <li>Success message #1</li>
     *            <li>Success message #2</li>
     *        </ul>
     *    </div>
     *    <div class="error">Error message #1</div>
     *    <div class="warning">Warning message #2</div>
     *
     * @access public
     * @param $translator An optional instance of Zend_Translate
     * @return string HTML of output messages
     */
	public function flashMessages($translator = NULL, $disable_style = false)
	{
		// Set up some variables, including the retrieval of all flash messages.
		if($translator == null) $translator = Zend_Registry::get('Zend_Translate');
		
		$messages = Zend_Controller_Action_HelperBroker::getStaticHelper('FlashMessenger')->getCurrentMessages();
		$statMessages = array();
		$output = '';
	
		// If there are no messages, don't bother with this whole process.
		if (count($messages) > 0)
		{
			// This chunk of code takes the messages (formatted as in the above sample
			// input) and puts them into an array of the form:
			//    Array(
			//        [status1] => Array(
			//            [0] => "Message 1"
			//            [1] => "Message 2"
			//        ),
			//        [status2] => Array(
			//            [0] => "Message 1"
			//            [1] => "Message 2"
			//        )
			//        ....
			//    )
			
			
			foreach ($messages as $message)
			{
				if (!array_key_exists($message['status'], $statMessages))
					$statMessages[$message['status']] = array();

				
				if( empty($message['buttons']) ) $message['buttons'] = array();
				
				if ($translator != NULL && $translator instanceof Zend_Translate)
					array_push($statMessages[$message['status']], array($translator->translate($message['message']), $translator->translate($message['title']), $message['buttons'] ));
				else
					array_push($statMessages[$message['status']], array($message['message'], $message['title'], $message['buttons']) );
					
					
			}
			
			// This chunk of code formats messages for HTML output (per
			// the example in the class comments).
			$output .= '<!-- Notification Message -->';
			foreach ($statMessages as $status => $messages)
			{
				// If there is only one message to look at, we don't need to deal with
				// ul or li - just output the message into the div.
				if (count($messages) == 1) {
					
					if( true != $disable_style ) {

						$output .= '<div class="alert alert-'.$status.'">';
						// $output .= '<a href="#" class="close-notification tooltip" title="Hide Notification">x</a>';
						
						
						// $output .= '<h4>'.$messages[0][1].'</h4>';
						$output .= '<i class="fa-fw fa fa-'.$status.'"></i> '.$messages[0][0];

						if(count( $messages[0][2] ) >= 1){
							$output .= '<div class="alert-actions">';
							foreach( $messages[0][2] as $btn_link => $btn_name )
								$output .= '<a href="'.$btn_link.'" class="btn small">'.$translator->translate($btn_name).'</a> ';
							$output .= '</div>';
						}
						
						$output .= '</div>';
						$output .= '<!-- /Notification -->';
					} else {
						$output .= $messages[0][0];
					}
				
					
				}
				// If there are more than one message, format it in the fashion of the
				// sample output above.
				else
				{	
					
					foreach ($messages as $message) {						
						//echo "<pre>".print_r($message,true)."</pre>";
						//if(  )

						$output .= '<div class="alert alert-'.$status.'">';
						// $output .= '<a href="#" class="close-notification tooltip" title="Hide Notification">x</a>';
						
						
						// $output .= '<h4>'.$message[1].'</h4>';						
						$output .= '<i class="fa-fw fa fa-'.$status.'"></i> '.$message[0];

						if(count( $message[2] ) >= 1){
							$output .= '<div class="alert-actions">';
							foreach( $message[2] as $btn_link => $btn_name )
								$output .= '<a href="'.$btn_link.'" class="btn small">'.$translator->translate($btn_name).'</a> ';
							$output .= '</div>';
						}
						
						
						$output .= '</div>';
						
						
					}
				}
			}
			$output .= '<!-- /Notification Message -->';
			// Return the final HTML string to use.
			return $output;
		}
		
	}
}
